/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.alomax.animator.Animator;
import net.alomax.animator.AnimatorClient;
import net.alomax.awt.AJLColor;
import net.alomax.awt.AJLStroke;
import net.alomax.awt.HelpFrame;
import net.alomax.geog.GeogConstants;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.Grid3D;
import net.alomax.geog.Grid3DGlobal;
import net.alomax.geog.Grid3DRectangular;
import net.alomax.geog.MapLines;
import net.alomax.geog.MapObjects;
import net.alomax.geog.MapPolygons;
import net.alomax.geog.MapShapefile;
import net.alomax.geog.MapSymbols;
import net.alomax.graphics3d.Axes3D;
import net.alomax.graphics3d.Image2D;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Sample4DSet;
import net.alomax.graphics3d.StringVectorizer;
import net.alomax.graphics3d.Symbol3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.io.GeneralInputStream;
import net.alomax.io.GeneralOutputStream;
import net.alomax.math.RangeDouble;
import net.alomax.net.Browser;
import net.alomax.net.GeneralURLConnection;
import net.alomax.seismicity.FocalMechanism;
import net.alomax.seismicity.FocalSphereFrame;
import net.alomax.seismicity.Grid2GMTDialog;
import net.alomax.seismicity.HypocenterAssociation;
import net.alomax.seismicity.InfoFrame;
import net.alomax.seismicity.Panel3D;
import net.alomax.seismicity.SeisEvent;
import net.alomax.seismicity.SeisEventFilter;
import net.alomax.seismicity.SeisEventList;
import net.alomax.seismicity.SeisPhase;
import net.alomax.seismicity.SeisStation;
import net.alomax.seismicity.SeismicityColorMap;
import net.alomax.seismicity.SeismicityColors;
import net.alomax.seismicity.SeismicityStrokes;
import net.alomax.seismicity.SeismicityText;
import net.alomax.seismicity.Text3D;
import net.alomax.swing.AJLFileFilter;
import net.alomax.swing.AJLFileView;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.ApplicationJComp;
import net.alomax.swing.EditorEntry;
import net.alomax.swing.JCompParent;
import net.alomax.swing.JMenuItemText;
import net.alomax.swing.NavigationPanel;
import net.alomax.swing.SwingExt;
import net.alomax.swing.SwingText;
import net.alomax.swing.URLChooser;
import net.alomax.swing.seis.EventSearchDialog;
import net.alomax.swing.seis.EventSearchException;
import net.alomax.swing.seis.EventSearchParameters;
import net.alomax.swing.seis.SeisText;
import net.alomax.text.GeneralText;
import net.alomax.util.ApplicationProperties;
import net.alomax.util.NumberFormat;
import net.alomax.util.StringExt;
import sdsu.io.ASCIIInputStream;

public class SeismicityFrame
extends JFrame
implements ApplicationJComp,
AnimatorClient,
ImageObserver,
Runnable,
ActionListener,
KeyListener,
ItemListener,
PropertyChangeListener {
    public static int DEBUG_LEVEL = 0;
    public static boolean PRINT_IGNORED_EXCEPTIONS = false;
    public static boolean PRINT_STACK_TRACES = false;
    public static boolean VERBOSE = false;
    protected JCompParent parent;
    public static final String NEWLINE = System.getProperty("line.separator");
    public static final String VERSION = "5.0.0X27";
    public static final String VERSION_YEAR = "2024";
    public static final String VERSION_DATE = "28May2024";
    public static final String VERSION_CHAR = "50";
    public static final String COPYRIGHT_YEAR = "2000-2024";
    public static final String PROGRAM_NAME = "SeismicityViewer v5.0.0X27";
    public static final String[] BANNER = new String[]{"SeismicityViewer v5.0.0X27 (28May2024)", "Copyright (C) 2000-2024 Anthony Lomax (www.alomax.net)", "SeismicityViewer comes with ABSOLUTELY NO WARRANTY"};
    public static final String COPYRIGHT = "This program is part of the Anthony Lomax Java Library." + NEWLINE + NEWLINE + "This program is free software; you can redistribute it and/or modify" + NEWLINE + "it under the terms of the GNU General Public License as published by" + NEWLINE + "the Free Software Foundation; either version 2 of the License, or" + NEWLINE + "(at your option) any later version." + NEWLINE + NEWLINE + "This program is distributed in the hope that it will be useful," + NEWLINE + "but WITHOUT ANY WARRANTY; without even the implied warranty of" + NEWLINE + "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the" + NEWLINE + "GNU General Public License for more details." + NEWLINE + NEWLINE + "You should have received a copy of the GNU General Public License" + NEWLINE + "along with this program; if not, write to the Free Software" + NEWLINE + "Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.";
    public static final String[] HELP_ABOUT = new String[5];
    protected static final String MESSAGE_PREFIX_PROG_NAME = "SeismicityViewer: ";
    public String messagePrefix = "SeismicityViewer: ";
    public String titleString;
    public String alternateTitleString = null;
    public Image iconImage = null;
    protected Image iconImageSmall = null;
    protected AJLFileFilter[] fileFilters = new AJLFileFilter[]{new AJLFileFilter("hyp", "hyp", "NonLinLoc Hypocenter Files (*.hyp)", true), new AJLFileFilter("hdr", "hdr", "NonLinLoc Header Files (*.hdr)", true)};
    protected SeisEventFilter seisEventFilter = new SeisEventFilter(this);
    protected String imageIOFileName = null;
    protected boolean errorFlag = false;
    protected boolean dataRead = false;
    protected boolean fullyInitialized = false;
    protected int transformationIndex = 0;
    protected double worldWidthMax;
    protected double globalWorldWidthMax = Double.MAX_VALUE;
    protected double xtheta;
    protected double ytheta;
    protected double viewScale;
    protected double viewScaleFactor;
    protected double pix2WorldScale;
    protected double secToKmScale;
    protected double mechSize;
    protected double xrotAng;
    protected double yrotAng;
    protected double zrotAng;
    protected double xrotAngInit;
    protected double yrotAngInit;
    protected double zrotAngInit;
    protected Vect3D worldCenterPointInit = null;
    protected Vect3D worldCenterPoint;
    protected double perspDist;
    protected Matrix3D rotMat = new Matrix3D();
    protected Matrix3D worldTransMat = new Matrix3D();
    protected double initalZoom = 0.0;
    protected boolean isGlobal = false;
    protected String grid3DName = null;
    protected boolean lock2DFlag = false;
    protected JCheckBoxMenuItem menuItemLock2D;
    protected boolean allowDrawImage2D = true;
    protected JCheckBox allowDrawImage2DCkBox;
    protected String allowDrawImage2DCkBoxStr = "Image 2D";
    protected Image2D image2D = null;
    protected String image2Dstr = null;
    protected static final int numGraphicLinesBasic = 13;
    protected static final int numGraphicLines = 15;
    protected static String globalCoastlineNameDefault;
    protected static String globalCoastlineName;
    protected static String globalPlateBoundaryNameDefault;
    protected static String globalPlateBoundaryName;
    protected Vect3D globalCenter = null;
    protected String[] graphicLineParamStr = new String[]{"lines.black", "lines.blue", "lines.cyan", "lines.darkGray", "lines.gray", "lines.lightGray", "lines.green", "lines.magenta", "lines.orange", "lines.pink", "lines.red", "lines.white", "lines.yellow", "lines.coast", "lines.plates"};
    protected Color backgroundColor = Color.black;
    protected Color[] graphicLineColor = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.lightGray, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow, Color.lightGray, Color.magenta};
    protected String[] graphicLineURL = new String[15];
    protected MapLines[] graphicLine = new MapLines[15];
    protected boolean[] graphicLineDraw = new boolean[15];
    protected String[] graphicLineCkBoxStr = new String[]{"BlackLines", "BlueLines", "CyanLines", "DkGrayLines", "GrayLines", "LtGrayLines", "GreenLines", "MagentaLines", "OrangeLines", "PinkLines", "RedLines", "WhiteLines", "YellowLines", "CoastLines", "PlateBoundaries"};
    protected JCheckBox[] graphicLineCkBox = new JCheckBox[15];
    protected String[] graphicPolylineURL = null;
    protected JCheckBox[] graphicPolylineCkBox = null;
    protected String[] graphicPolylineCkBoxStr = null;
    protected MapLines[] graphicPolyline = null;
    protected boolean[] graphicPolylineDraw = null;
    protected Line3D clipShapefileBoundingBox3D = null;
    protected String[] graphicShapefileURL = null;
    protected JCheckBox[] graphicShapefileCkBox = null;
    protected String[] graphicShapefileCkBoxStr = null;
    protected MapShapefile[] graphicShapefile = null;
    protected boolean[] graphicShapefileDraw = null;
    protected String[] graphicPolygonURL = null;
    protected JCheckBox[] graphicPolygonCkBox = null;
    protected String[] graphicPolygonCkBoxStr = null;
    protected MapPolygons[] graphicPolygon = null;
    protected boolean[] graphicPolygonDraw = null;
    protected String[] sampleSetURL = null;
    protected JCheckBox[] sampleSetCkBox = null;
    protected String[] sampleSetCkBoxStr = null;
    protected Sample4DSet[] sampleSet = null;
    protected boolean[] sampleSetDraw = null;
    protected String[] graphicSymbolURL = null;
    protected JCheckBox[] graphicSymbolCkBox = null;
    protected String[] graphicSymbolCkBoxStr = null;
    protected MapSymbols[] graphicSymbol = null;
    protected boolean[] graphicSymbolDraw = null;
    protected String graphicTextParamStr = "text";
    protected String graphicTextURL;
    protected boolean graphicTextDraw;
    protected String graphicTextCkBoxStr = "Text";
    protected JCheckBox graphicTextCkBox;
    protected Vector<Text3D> graphicText3D = new Vector();
    protected JCheckBox gridVisibleCkBox;
    protected String gridVisibleCkBoxStr = "Reference Grid";
    protected JCheckBox scalebarVisibleCkBox;
    protected String scalebarVisibleCkBoxStr = "Scale Bar";
    protected JCheckBox latlonVisibleCkBox;
    protected String latlonVisibleCkBoxStr = "Lat/Lon Grid";
    protected String[] eventFileNames = null;
    protected static final String NULL_EVENT_FILETYPE = "_NULL";
    protected String eventFileType = null;
    protected Grid3D grid3D;
    protected Grid3D grid3DGlobal = null;
    protected Axes3D axes3D = null;
    protected boolean axes3DVisible = true;
    protected JCheckBox axes3DVisibleCkBox;
    protected String axes3DVisibleCkBoxStr = "3D Axes";
    public GeogCoords geogCoords;
    public SeisEventList seisEventList = null;
    protected boolean writeSeismicityBinaryFlag = false;
    protected boolean initPlotFirstFlag = false;
    public int eventPlotFirst = 0;
    public int eventPlotLast = 0;
    protected boolean haveFocalMechanisms = false;
    protected Vector<SeisStation> stationList = new Vector();
    protected HypocenterAssociation hypocenterAssociation = null;
    protected JComboBox<String> urlChooserComboBox = null;
    protected JPanel navigationPanel = null;
    protected JPanel viewingPanel = null;
    protected JPanel panelViewAz = null;
    protected JPanel panelViewInc = null;
    protected JMenuBar menuBar = new JMenuBar();
    protected JMenuItem menuItemFileOpen;
    protected JMenuItem menuItemURLOpen;
    protected JMenuItem menuItemEventSearch;
    protected JMenuItem menuItemFilePrint;
    protected JMenuItem menuItemFileSnapshot;
    protected JMenuItem menuItemFileExit;
    protected JMenuItem menuItemHelpHelp = null;
    protected JMenuItemText menuItemHelpAbout = null;
    protected JCheckBoxMenuItem menuItemFileRecordSnapshots;
    protected boolean recordSnapshots = false;
    protected String snapshotDirectory = ".";
    protected String snapshotFormat = "jpg";
    protected int snapshotIndex = 0;
    protected HelpFrame helpFrame = null;
    protected JLabel messageLabel = null;
    protected static final Color MESSAGE_FOREGROUND;
    protected static final Color MESSAGE_BACKGROUND;
    protected static final Color MESSAGE_BACKGROUND_EMPHASIS;
    protected Color messageForeground = MESSAGE_FOREGROUND;
    protected Color messageBackground = MESSAGE_BACKGROUND;
    protected Panel3D panel3D;
    protected JCheckBoxMenuItem menuItemCkBoxViewViewingToolbar;
    protected AJLJButton buttonCloseViewingToolbar;
    protected boolean showViewingToolbar = true;
    protected JPanel toolPanelViewing = null;
    protected AJLJButton buttonProject;
    protected AJLJButton buttonReset;
    protected boolean projectFlag = true;
    protected JCheckBoxMenuItem menuItemCkBoxViewSeismicityToolbar;
    protected AJLJButton buttonCloseSeismicityToolbar;
    protected boolean showSeismicityToolbar = true;
    protected JPanel toolPanelSeismicity = null;
    protected AJLJButton buttonSeismicitySelectAll;
    protected AJLJButton buttonSeismicityClearAll;
    protected AJLJButton buttonSeismicityDrawItemsSelectAll;
    protected AJLJButton buttonSeismicityDrawItemsClearAll;
    protected JPanel subMenuMechanisms;
    protected JCheckBox menuItemMagnitude;
    protected JCheckBox menuItemProbDen;
    protected JCheckBox menuItemMaxLike;
    protected JCheckBox menuItemExpect;
    protected JCheckBox menuItemEllipse;
    protected JCheckBox menuItemPresidual;
    protected JCheckBox menuItemSresidual;
    protected JCheckBox menuItemWeightsAll;
    protected JCheckBox menuItemFaultPlanes;
    protected JCheckBox menuItemPressureAxis;
    protected JCheckBox menuItemTensionAxis;
    protected JCheckBox menuItemNodalAxis;
    protected JCheckBox menuItemSlipAxes;
    protected JCheckBox menuItemThrustOnly;
    protected JCheckBox menuItemNormalOnly;
    protected JCheckBox menuItemStrikeSlipOnly;
    protected JCheckBox menuItemStationName;
    protected JCheckBox menuItemFirstMotion;
    protected JCheckBox menuItemRay;
    protected JCheckBox menuItemStationSym;
    protected boolean magnitudeFlag = false;
    protected boolean maxLikeFlag = true;
    protected boolean expectFlag = false;
    protected boolean ellipseFlag = false;
    protected boolean probDenFlag = false;
    protected boolean ellipseReadFlag = true;
    protected boolean stationReadFlag = true;
    protected boolean phaseReadFlag = true;
    protected boolean focalMechReadFlag = true;
    protected boolean probabilityReadFlag = true;
    protected boolean PresidualFlag = false;
    protected boolean SresidualFlag = false;
    protected boolean faultPlanesFlag = false;
    protected boolean pressureAxisFlag = false;
    protected boolean nodalAxisFlag = false;
    protected boolean slipAxesFlag = false;
    protected boolean tensionAxisFlag = false;
    protected boolean thrustOnlyFlag = false;
    protected boolean normalOnlyFlag = false;
    protected boolean strikeSlipOnlyFlag = false;
    protected boolean weightsAllFlag = false;
    protected boolean stationNameFlag = true;
    protected boolean stationSymFlag = false;
    protected boolean firstMotionFlag = false;
    protected boolean rayFlag = true;
    protected boolean residualLabelFlag = false;
    protected InfoFrame eventInfoFrame = null;
    protected FocalSphereFrame focalSphereFrame = null;
    protected JMenuItem menuItemViewEventInfo;
    protected JMenuItem menuItemViewFocalSphere;
    protected JCheckBoxMenuItem menuItemViewGlobalTransparent;
    protected boolean globalTransparent = false;
    protected JCheckBoxMenuItem menuItemViewBuffer;
    protected boolean bufferFlag = true;
    protected JCheckBoxMenuItem menuItemViewInvertCol;
    protected boolean invertColorFlag = false;
    protected boolean colorsInverted = false;
    protected JCheckBoxMenuItem menuItemViewQuickDraw;
    protected boolean quickDrawFlag = true;
    protected AJLJButton buttonAbove;
    protected AJLJButton buttonBelow;
    protected AJLJButton buttonSouth;
    protected AJLJButton buttonNorth;
    protected AJLJButton buttonEast;
    protected AJLJButton buttonWest;
    protected EditorEntry textFieldAzimuth = null;
    protected EditorEntry textFieldInclination = null;
    protected AJLJButton buttonEvent;
    protected AJLJButton buttonGrid;
    protected JMenuItem menuItemUtilitiesLanguage_en_US;
    protected JMenuItem menuItemUtilitiesLanguage_fr_FR;
    protected JMenuItem menuItemUtilitiesLanguage_it_IT;
    protected JCheckBoxMenuItem menuItemHypAssoc;
    protected JMenuItem menuItemGrid2GMTDialog;
    protected double magSymbolScaleFactor = 1.0;
    protected double magSymbolSizeExponent = 0.5;
    protected double magSymbolMaximumMag = 0.0;
    protected double magSymbolMinimumMag = 0.0;
    protected double horizOnlyCutoffDip = 45.0;
    protected double mechMisfitMax = Double.MAX_VALUE;
    protected int mechNobsMin = 0;
    protected boolean paintPTNaxesBowtie = false;
    protected Vect3D targetSlipAxis = null;
    protected AJLJButton buttonPlotFirst;
    protected AJLJButton buttonPlotLast;
    protected AJLJButton buttonPlotNext;
    protected AJLJButton buttonPlotPrev;
    protected AJLJButton buttonPlotAll;
    protected AJLJButton buttonPlotAuto;
    protected JCheckBox centerOnEvent;
    protected String runButtonLabel = "";
    protected String pauseButtonLabel = "";
    protected JTextField textFieldPlotNum;
    protected int eventPlotCurrent = 0;
    protected boolean shiftKeyDown = false;
    protected Animator animatorThread;
    protected boolean animatorThreadSuspended = true;
    protected AJLJButton buttonRecordSnapshot;
    protected double globalTextSizeFactor = 1.0;
    protected double colormapTextSizeFactor = 2.5;
    protected double textDensity = 1.5;
    protected boolean latlonClipEvents = false;
    private boolean displayingFrame = false;
    protected JFileChooser fileDialog = null;
    protected EventSearchParameters currentEventSearchParams = new EventSearchParameters(0, 0, 0, 120, "5.0", "9.9");
    protected Grid2GMTDialog grid2GMTInterface = null;
    protected boolean givenGlobalLineCredits = false;
    protected boolean reinitializeAll = true;
    protected Vect3D axis3DworldCenterPoint = null;
    protected double axis3DviewScaleFactor = -1.0;
    String[] formatsTryAll = new String[]{"NLLOC_GEOG", "BASIC", "BASIC_CSV", "CSV_COMPACT", "EARLY_EST_CSV", "HYPO_ELL", "HYPO_INV", "HYPO", "SPYDER", "EQ_MON_CSV", "GSE", "EPI", "SEISAN", "MONFRET", "CELINE", "GOT", "SEARCH_NEIC_PDE", "SEARCH_NEIC_SWE", "FVGN", "EQDD", "INGV_DB", "GEONET_CSV", "FDSN_WS_EVENT", "OV_INGV_EVENT", "NCEDC_CSV", "GEONET_CSV", "USGS_CSV", "SCEC_GROWCLUST", "TEXNET_GROWCLUST", "TEXNET_CSV", "MUNCH_DD", "TRUG_2020", "RUHL_2021", "LIN_COMBLOC", "SHENG2022,", "ALBERTO_TOMO", "GEIN_NOA_EPI"};
    String[] formatsOther = new String[]{"MONFRET", "CELINE", "GOT"};
    protected JobAttributes jobAttributes = null;
    protected PageAttributes pageAttributes = null;
    private int lastEventInfoEventPlotFirst = -1;
    private int lastEventInfoEventPlotLast = -1;

    @Override
    public String[][] getParameterInfo() {
        String[][] stringArray = new String[][]{{"axes3d.pos.abs", "Floats", "3D reference axes position in absolute space (x pos in km, y pos in km, depth in km (default is axes3d.pos.plot)"}, {"axes3d.pos.plot", "Floats", "3D reference axes position relative to view center (x pos in fraction of view width (0.0*), y pos in fraction of view height (0.0*)"}, {"axes3d.font", "Floats", "3D reference axes font (relative font size (1.0*), relative font density (1.0*)"}, {"axes3d.lengthfactor", "Float", "3D reference axes length (relative length (1.0*) "}, {"color.axes3d.x", "Integers", "3D reference axes X color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.axes3d.y", "Integers", "3D reference axes Y color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.axes3d.z", "Integers", "3D reference axes Z color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.axis.t", "Integers", "Mechanism T axis color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.axis.p", "Integers", "Mechanism P axis color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.axis.n", "Integers", "Mechanism N axis color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.axis.slip", "Integers", "Mechanism slip axes color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.background", "Integers", "Background color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.expectation", "Integers", "Expectation color in RGB color (0-255,0-255,0-255) or Color Name (used if no event.colormap)"}, {"color.faultplane", "Integers", "Mechanism fault planes color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.grid", "Integers", "Grid box and scalebar color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.maxlikelihood", "Integers", "Maxlikelihood color in RGB color (0-255,0-255,0-255) or Color Name (used if no event.colormap)"}, {"color.station.label", "Integers", "Station label color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.station.symbol", "Integers", "Station symbol color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.phase.residual.p.up", "Integers", "Positive P residual color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.phase.residual.p.down", "Integers", "Negative P residual color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.phase.residual.s.up", "Integers", "Positive S residual color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.phase.residual.s.down", "Integers", "Negative S residual color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.phase.fm.up", "Integers", "Upwards first motion color in RGB color (0-255,0-255,0-255) or Color Name"}, {"color.phase.fm.down", "Integers", "Dwonwards first motion color in RGB color (0-255,0-255,0-255) or Color Name"}, {"display.position", "String", "Main window, upper left corner position at startup as horizontal, vertical fraction of screen size (left-center*)"}, {"display.size", "String", "Main window size at startup as horizontal, vertical fraction of screen size (0.75,0.95*)"}, {"display.seismicitytoolbar", "Flag", "Show seismicity toolbar at startup (YES* | NO)"}, {"display.station.label.shifted", "Flag", "Shift station label away from station position (YES | NO*)"}, {"display.station.label.removetext", "String", "Substring in station label to remove"}, {"display.viewingtoolbar", "Flag", "Show viewing toolbar at startup (YES* | NO)"}, {"hypoassoc.color.alpha", "Integer", "Hypocenter Association color alpha opacity (0-255) (-1*)"}, {"hypoassoc.distminmean.factor", "Float", "Hypocenter Association factor to scale distance min mean cutoff for association (1.0*)"}, {"hypoassoc.listfractaldists", "Flag", "List distances, counts of 2-point correlation for estimating fractal dimension following Wyss et al. 2004 (YES | NO*)"}, {"dump.events.csv", "String", "Dump events to file in csv format (YES|NO*)"}, {"dump.events.csv.compact", "String", "Dump events to file in compact csv format (YES|NO*)"}, {"dump.events.xyz", "String", "Dump events to file in xyz format (YES|NO*)"}, {"dump.events.otlonlatdepmag", "String", "Dump evemts to file in simple ot lon lat dep mag format (YES|NO*)"}, {"dump.latlon", "String", "Dump geographic elements (grid, lines, etc.) to file in ASCII lat/lon/depth format (YES|NO*)"}, {"dump.samples.latlon", "String", "Dump sample set in binary file to file in ASCII lat/lon/depth format (YES|NO*)"}, {"dump.stats.totcorr", "String", "Dump station correction statistics (after application of event.filter.*) in NLL stats.totcorr format ASCII file (YES|NO*)"}, {"ellipsoid.applycolormap", "Flag", "Apply event.colormap as color for NLL ellipsod (YES|NO*)"}, {"event", "String", "Event file URL (FileURL)"}, {"event.colormap", "String/Floats/Integers", "Value/color map for hypocenter statistic in COLOR = RGB color (0-255,0-255,0-255) or Color Name, or color table (statistic (DEPTH|OTIME|MONTH|RMS|ERRH|ERRZ|NPHS|GAP|DIST|MAMP|MDUR|EVT_NUM); [[value1,COLOR1;value2,COLOR2;...] | [TURBO|BATLOW*|BATLOW_NO_RED|RAINBOW|FIRE|INFERNO|VIRIDIS|BLACK_BODY|GREYSCALE|HOT|COOL|GREEN|PSYCHEDELIC|BINARY]])"}, {"event.colormap.reverse", "Flag", "Reverse sense of colormap (YES | NO*)"}, {"event.colormap.saturate", "Flag", "Set maximum saturation each color (YES* | NO)"}, {"event.colormap.text.sizefactor", "Float", "Colormap legend font size factor (2.5*)"}, {"event.filetype", "String", "event file type (NLLOC*|NLLOC_GEOG|EARLY_EST_CSV|BASIC|BASIC_CSV|CSV_COMPACT|HYPO|HYPO_INV|HYPO_ELL|EQ_MON_CSV|SPYDER|GSE|EPI|SEISAN|STRING|SEARCH_NEIC_PDE|SEARCH_NEIC_PDEQ|SEARCH_NEIC_SWE|EQDD|INGV_DB|FDSN_WS_EVENT|OV_INGV_EVENT|NCEDC_CSV|GEONET_CSV|USGS_CSV|SCEC_GROWCLUST|TEXNET_GROWCLUST|TEXNET_CSV|MUNCH_DD|TRUG_2020|RUHL_2021|LIN_COMBLOC|SHENG2022|SHENG2022|ALBERTO_TOMO|GEIN_NOA_EPI)"}, {"event.filter.ellipsoid.se3", "Floats", "ellipsoid se3 filter (se3 min; se3 max)"}, {"event.filter.otime", "Integers/Float", "origin time filter (YYYY,MM,DD,[HH,MM,SS] min; YYYY,MM,DD,[HH,MM,SS] max | YYYYMMDD[[.]HHMMSS] min]; YYYYMMDD[[.]HHMMSS] max])"}, {"event.filter.hypo", "Floats", "hypo filter (lat, long, depth(km) min; lat, long, depth(km) max)"}, {"event.filter.depth", "Floats", "hypo depth filter (depth(km) min; depth(km) max)"}, {"event.filter.gap", "Floats", "gap filter (gap min; gap max)"}, {"event.filter.dist", "Floats", "dist filter (dist min; dist max)"}, {"event.filter.grid", "Flag", "use grid filter  (YES* | NO)"}, {"event.filter.nphs", "Integers", "num phase filter (nphs min; nphs max)"}, {"event.filter.rms", "Floats", "rms filter (rms min; rms max)"}, {"event.filter.errh", "Floats", "errH filter (errH min; errH max)"}, {"event.filter.errz", "Floats", "errZ filter (errZ min; errZ max)"}, {"event.filter.mamp", "Floats", "Mamp filter (Mamp min; Mamp max)"}, {"event.filter.mdur", "Floats", "Mdur filter (Mdur min; Mdur max)"}, {"event.filter.mag", "Floats", "Event mag filter (mag min; mag max)"}, {"event.filter.index", "Integers", "Event index filter (0; number events -1)"}, {"event.display.reverse", "Flag", "reverse event plotting order (YES | NO*)"}, {"event.size", "Float", "event symbol size factor (1.0*)"}, {"event.magSizeExponent", "Float", "magnitude symbol size scaling exponent (0.5*)"}, {"event.randomize", "Float", "Distance in km to randomize maximum likelihood hypocenter x, y, z (0.0*)"}, {"global.coastline", "String", "coastline file for global mode (FileURL | NONE)"}, {"global.plateboundary", "String", "plate boundary file for global mode (FileURL | NONE)"}, {"grid", "String", "3D grid header file URL, not required for global mode (FileURL)"}, {"grid.global.latlonstep", "Float", "Step in degrees for Lat-Long lines for global grid (10.0*) "}, {"grid.global.latlontext", "Floats", "Lat-Long box to label for global grid (lat min, lat max, lon min, lon max, relative font size (1.0*), relative font density (1.0*) "}, {"grid.latlonstep", "Float", "Step in degrees for Lat-Long lines for rectangular grid (1.0*) "}, {"grid.latlontext", "Floats", "Lat-Long box to draw and label for rectangular grid (lat min, lat max, lon min, lon max, relative font size (1.0*), relative font density (1.0*) [,labels to plot (LRTB*)] "}, {"grid.latlon.clip", "Flag", "Clip graphics outside of Lat-Lon box (YES|NO*) "}, {"grid.latlon.clip.events", "Flag", "Clip events outside of Lat-Lon box (YES* if grid.latlon.clip=YES) "}, {"grid.latlon.clip.depth", "Flag", "Clip in depth below or above Lat-Lon box (YES*|NO) "}, {"grid.latlon.depth", "Floats", "Lat-Lon box depth limits (min (0.0*)[, max(0.0*)] "}, {"grid.latlon.ticsonly", "Flag", "Draw Lat-Long tics instead of lines (YES|NO*) "}, {"grid.scale.pos", "Floats", "Scalebar specifications (x pos relative to grid width (0.9*), y pos relative to grid height (0.05*), relative font size (1.0*), relative font density (3.0*) [, azimuth E of N (90.0*) [, z pos relative to grid height (0.0)]]"}, {"grid.azscale.pos", "Floats", "Azimuth oriented scalebar specifications (x pos relative to grid width (0.9*), y pos relative to grid height (0.05*), z pos relative to grid depth (0.05*), relative font size (1.0*), relative font density (3.0*) , azimuth CW from Y pos (90.0*) "}, {"grid.zlimits.east", "Flag", "Draw min and max depth on east side of grid (YES*|NO)"}, {"grid.zlimits.south", "Flag", "Draw min and max depth on south side of grid (YES*|NO)"}, {"grid.zlimits.spaced", "String", "If present, draw evenly spaced depths on specified side of grid (SW|SE|NE|NW|NONE) or at general position (x, y, azimuth E of N)"}, {"horizontalscale", "Floats", "vector oriented, horizontal scale with positioned zero point (zero x pos, zero y pos, zero z pos, min value, max value, step value, relative font size (1.0*), relative font density (3.0*) , azimuth azimuth CW from Y pos (90.0*) "}, {"image2D", "String", "2D background image (FileURL; lat,long lower left; lat,long upper rightt; [depth (km)] | lat,long upper left; lat,long upper right; lat,long lower right; lat,long lower left; [depth (km)] | For Vertical: lat,lon,depth upper left; lat,lon,depth lower right [; name]])"}, {"info.limit.residual", "Float", "Residual limit for phase highlight in Info Window (0.2*)"}, {"info.limit.residual.P", "Float", "Residual limit for P phase highlight in Info Window (0.1*)"}, {"init.plotfirst", "Flag", "Plot first event only on initial plot (YES|NO*)"}, {"init.rotation", "Integers", "Initial coordinate rotations in deg ccw (z-rot,y-rot,x-rot)"}, {"init.viewpoint", "Integers", "Initial viewpoint (azimuth,inclination)"}, {"init.zoom", "Float", "Initial zoom factor (+/-factor)"}, {"interface.grid2gmt", "Flag", "Activate interface to run platform dependent, NonLinLoc program Grid2GMT (YES|NO*)"}, {"interface.grid2gmt.controlfile", "String", "Path/name of NonLinLoc control file with generic and Grid2GMT control statements"}, {"interface.grid2gmt.outroot", "String", "Path/root-name for output files"}, {"interface.grid2gmt.mode", "String", "Grid2GMT mode (L*|H)"}, {"interface.grid2gmt.plottype", "String", "Grid2GMT plot type (S000*|S100|S011|S111|E100|E011|E111|M|RP|RS)"}, {"interface.grid2gmt.psviewer", "String", "command name for postscript viewer"}, {"lines.<color>", "String", "Graphic line file name and menu label for specified color (FileURL#label)"}, {"lines.<N>", "String", "<Graphic lines specification (FileURL; type (SOLID|DASHED|DOTTED|DASHDOT); RGB color (0-255,0-255,0-255) or Color Name; width (1.0+); label"}, {"mechanism.axis.slip.target", "Floats", "azimuth E of N and dip of target axis for selecting which fault plane and slip axis to plot (NONE*)"}, {"mechanism.horizonlycutoffdip", "Float", "Cutoff maximum dip angle for determining extensional/thrust/strike-slip mechanisms (45.0*)"}, {"mechanism.misift.max", "Float", "Maximum focal mechansim misfit to plot mechanisms (0.0*)"}, {"mechanism.nobs.min", "Integer", "Minimum number mechanism first-motion observations to plot mechanisms (0*)"}, {"mechanism.size", "Float", "Relative size for plotting mechanisms and axes (1.0*)"}, {"paint.events.last", "Flag", "Paint events last (set to YES only if events are obscured by other plot elements) (YES|NO*)"}, {"paint.lines.last", "Flag", "Paint lines last (set to NO if lines obscure other elements needed in plot, e.g. for publication) (YES*|NO)"}, {"paint.polygons.last", "Flag", "Paint polygons last (set to YES if polygons obscured by other elements needed in plot, e.g. for publication) (YES|NO*)"}, {"polygons.<N>", "String", "Graphic polygons specification (FileURL; border (NO_BORDER|SOLID_BORDER*|SOLID_BORDER_TOP_THICKER|SOLID_BORDER_TOP_THICKER2; fill (NO_FILL*|SOLID_FILL|TRANSPARENT_FILL|MESH_FILL)); RGB color (0-255,0-255,0-255) or Color Name; line width (1.0+); label [;USE_FOR_XY_CLIP|[USE_FOR_PLANE_CLIP;clipDistancePlane]|NO])"}, {"print.resolution", "Integer", "Printer resolution in dots per inch (150*)"}, {"print.font.size", "Integer", "Printer font size (12*)"}, {"print.titles", "Flag", "Print titles (YES*|NO)"}, {"properties", "String", "Properties file URL (FileURL)"}, {"read.ellipsoids", "Flag", "Read ellipsoids from event file (YES*|NO)"}, {"read.mechanisms", "Flag", "Read mechanisms from event file (YES*|NO)"}, {"read.phases", "Flag", "Read phases from event file (YES*|NO)"}, {"read.probability", "Flag", "Read probability scatter cloud samples (YES*|NO)"}, {"read.stations", "Flag", "Read station names and cumulative residuals (YES*|NO)"}, {"residual.size", "Float", "residual symbol size factor (1.0*)"}, {"scattersamples", "String", "NLL scatter samples (PDF) parameters (RGB color (0-255,0-255,0-255) or Color Name; idiameter; idecimation)"}, {"scattersamples.applycolormap", "Flag", "Apply event.colormap as color for NLL scatter samples (YES|NO*)"}, {"search", "String", "Event Search (NEIC|NEIC_PDE|NEIC_PDEQ|NEIC_SWE#<ndays>)"}, {"show.axis.n", "Flag", "Display N axes on initial plot (YES|NO*)"}, {"show.axis.p", "Flag", "Display P axes on initial plot (YES|NO*)"}, {"show.axis.t", "Flag", "Display T axes on initial plot (YES|NO*)"}, {"show.axis.slip  ", "Flag", "Display slip axes on initial plot (YES|NO*)"}, {"show.axis.thrust", "Flag", "Display only horizontal, thrust mechanism axes on initial plot (YES|NO*)"}, {"show.axis.normal", "Flag", "Display only horizontal, normal mechanism axes on initial plot (YES|NO*)"}, {"show.axis.strikeslip", "Flag", "Display only horizontal, strike-slip mechanism axis on initial plot (YES|NO*)"}, {"show.axis.t", "Flag", "Display T axes on initial plot (YES|NO*)"}, {"show.axes3d", "Flag", "Display 3D reference axes on initial plot (YES|NO*)"}, {"show.ellipsoid", "Flag", "Display ellipsoids on initial plot (YES|NO*)"}, {"show.expectation", "Flag", "Display expectations on initial plot (YES|NO*)"}, {"show.faultplane", "Flag", "Display faultplanes on initial plot (YES|NO*)"}, {"show.firstmotion", "Flag", "Display firstmotions on initial plot (YES|NO*)"}, {"show.grid", "Flag", "Display 3D grid on initial plot (YES*|NO)"}, {"show.grid.scale", "Flag", "Display grid scale on initial plot (YES*|NO)"}, {"show.grid.latlon", "Flag", "Display latlon grid on initial plot (YES*|NO)"}, {"show.magnitude", "Flag", "Display magnitudes on initial plot (YES|NO*)"}, {"show.maxlikelihood", "Flag", "Display maxlikelihoods on initial plot (YES*|NO)"}, {"show.probability", "Flag", "Display probability scatter clouds on initial plot (YES|NO*)"}, {"show.rays", "Flag", "Display take-off rays at source on initial plot (YES|NO*)"}, {"show.residual.p", "Flag", "Display P residuals on initial plot (YES|NO*)"}, {"show.residual.s", "Flag", "Display S residuals on initial plot (YES|NO*)"}, {"show.residual.label", "Flag", "Display residual value labels on initial plot (YES|NO*)"}, {"show.station", "Flag", "Display station names on initial plot (YES*|NO)"}, {"show.stationsymbol", "Flag", "Display station symbols on initial plot (YES|NO*)"}, {"show.weights.all", "Flag", "Display station/phase info for all phase weights on initial plot (YES|NO*)"}, {"show.stats.mean_residuals.weights.all", "Flag", "Accumulate and display mean residual info for all phase weights (YES|NO*)"}, {"shapefiles.<N>", "String", "Shapefile specifications (FileURL; RGB color (0-255,0-255,0-255) or Color Name; polygon border (NO_BORDER|SOLID_BORDER*; polygon fill (NO_FILL*|SOLID_FILL|TRANSPARENT_FILL|MESH_FILL)); symbol type (CROSS|TETRAHEDRON|INVERTED_TETRAHEDRON|DIAMOND|SPHERE|CUBE|PENTAGON|HEXAGON|OCTAGON|FILLED_SPHERE_NO_OUTLINE|FILLED_SPHERE*); symbol size or line width (1.0*); [force depth (km) | X [; label]])"}, {"shapefiles.filter.latlondepth", "Floats", "Lat-Long-Depth box to draw shapefile elements (lat min, lon imin, depth min # lat max, lon max, depth max "}, {"samples.<N>", "String", "Sample set in binary file (FileURL; RGB color (0-255,0-255,0-255) or Color Name; label; diameter; isGeographic; valueIsAlpha)"}, {"snapshot.autoexit", "Flag", "Do snapshot after display and exit (YES|NO*)"}, {"snapshot.size", "Integers", "Snapshot width and height in pixels (<current display size> *)"}, {"snapshot.directory", "String", "Directory for saving single and recorded snapshots (<current directory> *)"}, {"snapshot.format", "String", "Image format for saving single and recorded snapshots (bmp,jpg*)"}, {"station.symbol.size", "Float", "station symbol size factor (1.0*)"}, {"stroke.axis", "Float", "Mechanism all axes line stroke width (1.0*)"}, {"stroke.axis.t", "Float", "Mechanism T axis line stroke width (1.0*)"}, {"stroke.axis.p", "Float", "Mechanism P axis line stroke width (1.0*)"}, {"stroke.axis.n", "Float", "Mechanism N axis line stroke width (1.0*)"}, {"stroke.axis.ptn.bowtie", "Flag", "Draw P, T, N axes as bowtie shape of stroke width (YES|NO*)"}, {"stroke.axis.slip", "Float", "Mechanism slip axes line stroke width (1.0*)"}, {"stroke.faultplane", "Float", "Mechanism fault planes line stroke width (1.0*)"}, {"stroke.phase.residual.p.up", "Float", "P residuals up/positve line stroke width (1.0*)"}, {"stroke.phase.residual.p.down", "Float", "P residuals down/negative line stroke width (1.0*)"}, {"stroke.phase.residual.s.up", "Float", "S residuals up/positve line stroke width (1.0*)"}, {"stroke.phase.residual.s.down", "Float", "S residuals down/negative line stroke width (1.0*)"}, {"symbols.<N>", "String", "Graphic symbols specification (FileURL; type (CROSS|TETRAHEDRON|INVERTED_TETRAHEDRON|DIAMOND|SPHERE|CUBE|PENTAGON|HEXAGON|OCTAGON|FILLED_SPHERE_NO_OUTLINE|FILLED_SPHERE); RGB color (0-255,0-255,0-255) or Color Name; line width (1.0+); symbol size factor (1.0*); label [; POLYGON_CLIP])"}, {"symbols.circle.numsides", "Integer", "Number of segments to use for circular and spherical symbols (64*)"}, {"text", "String", "Graphic text file name (FileURL)"}, {"text.density", "Float", "Graphic text font density (1.0*)"}, {"text.sizefactor", "Float", "Graphic text global font size factor (1.0*)"}, {"title", "String", "Window title (title)"}, {"view.drawbuffer", "Flag", "Set buffered drawing view mode on initial plot (YES*|NO)"}, {"view.globaltransparent", "Flag", "Set global transparent view mode on initial plot (YES|NO*)"}, {"view.invertcolors", "Flag", "Set inverted colors view mode on initial plot (YES|NO*)"}, {"view.lock2D", "Flag", "Sets locked 2D view mode on initial plot (YES|NO*)"}, {"view.persp", "Flag", "Set perspective view mode on initial plot (YES*|NO)"}, {"view.quickdraw", "Flag", "Set quick drawing view mode on initial plot (YES|NO*)"}};
        return stringArray;
    }

    public SeismicityFrame(JCompParent jCompParent) {
        super(PROGRAM_NAME);
        this.parent = jCompParent;
        this.seisEventList = new SeisEventList(this);
    }

    @Override
    public void run() {
        if (!this.dataRead) {
            this.writeMessage("Reading data files...");
            this.getData();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!SeismicityFrame.this.dataRead) {
                    SeismicityFrame.this.displayFrame();
                    SeismicityFrame.this.dataRead = true;
                    if (SeismicityFrame.this.seisEventList.size() < 1) {
                        SeismicityFrame.this.writeMessage("INFO: No events read.");
                    }
                }
                if (SeismicityFrame.this.eventInfoFrame != null && SeismicityFrame.this.eventInfoFrame.isShowing()) {
                    SeismicityFrame.this.displayEventInfo(true);
                }
            }
        });
    }

    @Override
    public void init() {
        String string = this.getParameter("debug");
        int n = DEBUG_LEVEL;
        if (string != null) {
            try {
                DEBUG_LEVEL = n = Integer.valueOf(string).intValue();
            }
            catch (Exception exception) {
                n = DEBUG_LEVEL;
            }
            if (DEBUG_LEVEL > 0) {
                System.out.println("DEBUG_LEVEL: " + DEBUG_LEVEL);
            }
        }
        if (DEBUG_LEVEL > 0) {
            PRINT_IGNORED_EXCEPTIONS = true;
        }
        if (DEBUG_LEVEL > 1) {
            PRINT_STACK_TRACES = true;
        }
        if (DEBUG_LEVEL > 0) {
            VERBOSE = true;
        }
        this.alternateTitleString = null;
        SeismicityText.setLocale("en_US");
        SeisText.setLocale("en_US");
        SwingText.setLocale("en_US");
        SeismicityColors.setColors(this);
        SeismicityStrokes.setStrokes(this);
        try {
            this.globalTextSizeFactor = Double.parseDouble(this.getParameter("text.sizefactor"));
        }
        catch (Exception exception) {
            this.globalTextSizeFactor = 1.0;
        }
        StringVectorizer.setTextSizeFactor(this.globalTextSizeFactor);
        SeisStation.setShiftStationLabelText(this.getTrueFalseParameter(false, "display.station.label.shifted"));
        SeisStation.setStationLabelRemoveText(this.getParameter("display.station.label.removetext"));
        this.initSeismicity();
        if (this.eventFileNames != null) {
            for (int i = 0; i < this.eventFileNames.length; ++i) {
                this.eventFileNames[i] = this.generateFileNames(this.eventFileNames[i]);
            }
        }
        this.initFrame();
        this.toFront();
        this.loadDataFiles();
        if (this.getTrueFalseParameter(false, "snapshot.autoexit")) {
            try {
                while (this.displayingFrame || !this.panel3D.painted || !this.fullyInitialized) {
                    Thread.sleep(1000L);
                }
                Thread.sleep(1000L);
                this.autoSnapShotExit();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void displayFrame() {
        if (this.displayingFrame) {
            return;
        }
        this.displayingFrame = true;
        this.setupFrame();
        this.displayingFrame = false;
        this.redisplayFrame();
    }

    public void redisplayFrame() {
        if (this.displayingFrame) {
            return;
        }
        this.displayingFrame = true;
        this.setJMenuBar(this.menuBar);
        if (this.showViewingToolbar) {
            this.setViewToolbarStates();
            this.toolPanelViewing.setVisible(true);
        } else {
            this.toolPanelViewing.setVisible(false);
        }
        if (this.showSeismicityToolbar) {
            this.setSeismicityToolbarStates();
            this.toolPanelSeismicity.setVisible(true);
        } else {
            this.toolPanelSeismicity.setVisible(false);
        }
        this.setVisible(true);
        this.requestFocus(this);
        this.displayingFrame = false;
    }

    public void initFrame() {
        String[] stringArray;
        double d;
        double d2;
        double d3 = 0.0;
        double d4 = 0.0;
        String string = this.getParameter("display.position");
        if (string != null) {
            d2 = d3;
            d = d4;
            try {
                stringArray = StringExt.parse(string, ",");
                d2 = Double.valueOf(stringArray[0]);
                d = Double.valueOf(stringArray[1]);
                d3 = d2;
                d4 = 1.0 - d;
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: parsing parameter display.position");
            }
        }
        d2 = 0.75;
        d = 0.95;
        stringArray = this.getParameter("display.size");
        if (stringArray != null) {
            double d5 = d2;
            double d6 = d;
            try {
                String[] stringArray2 = StringExt.parse((String)stringArray, ",");
                d5 = Double.valueOf(stringArray2[0]);
                d6 = Double.valueOf(stringArray2[1]);
                d2 = d5;
                d = d6;
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: parsing parameter display.size");
            }
        }
        SwingExt.setProportionalSize(this, d2, d);
        if (string != null) {
            SwingExt.setLocationOnScreen(this, d3, d4);
        } else {
            SwingExt.setLocationToCenterOfScreen(this);
        }
        try {
            this.iconImage = SwingExt.getImageResource(this, "Seismicity_64_64.gif");
            if (this.iconImage != null) {
                this.setIconImage(this.iconImage);
                this.iconImageSmall = this.iconImage.getScaledInstance(16, 16, 4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < BANNER.length; ++i) {
            System.out.println(BANNER[i]);
        }
        System.out.println("You are using Java version " + System.getProperty("java.version") + " (" + System.getProperty("java.class.version") + ", " + System.getProperty("java.vendor") + ")");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                SeismicityFrame.this.cleanUp();
                SeismicityFrame.this.parent.closeFrame();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ++SeismicityFrame.this.transformationIndex;
            }
        });
        this.urlChooserComboBox = new JComboBox();
        this.panel3D = new Panel3D(this);
        this.panel3D.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                ++SeismicityFrame.this.transformationIndex;
            }
        });
        this.navigationPanel = new NavigationPanel(this.panel3D, this);
        this.toolPanelViewing = new JPanel();
        this.toolPanelViewing.setLayout(new BorderLayout());
        this.viewingPanel = new JPanel();
        this.viewingPanel.setLayout(new GridLayout(0, 1, 0, 0));
        this.panelViewAz = new JPanel();
        this.panelViewInc = new JPanel();
        this.messageLabel = new JLabel();
        this.messageLabel.setBorder(new EmptyBorder(4, 8, 4, 8));
        this.messageLabel.setOpaque(true);
        this.textFieldAzimuth = new EditorEntry("AZ", "Az: ", 0.0, 7, this);
        this.textFieldInclination = new EditorEntry("Inc", "Inc: ", 0.0, 7, this);
        this.buttonAbove = new AJLJButton(this, null, "-");
        this.buttonBelow = new AJLJButton(this, null, "-");
        this.buttonSouth = new AJLJButton(this, null, "-");
        this.buttonNorth = new AJLJButton(this, null, "-");
        this.buttonEast = new AJLJButton(this, null, "-");
        this.buttonWest = new AJLJButton(this, null, "-");
        this.buttonEvent = new AJLJButton(this, null, "-");
        this.buttonGrid = new AJLJButton(this, null, "-");
        this.buttonReset = new AJLJButton(this, null, SeismicityText.RESET);
        this.buttonProject = new AJLJButton(this, null, SeismicityText.PERSP_ORTH);
        this.buttonPlotFirst = new AJLJButton(this, null, SeismicityText.FIRST + "    |<");
        this.buttonPlotNext = new AJLJButton(this, null, SeismicityText.NEXT + "     > ", true);
        this.buttonPlotPrev = new AJLJButton(this, null, SeismicityText.PREV + "     < ", true);
        this.buttonPlotLast = new AJLJButton(this, null, SeismicityText.LAST + "     >|");
        this.buttonPlotAll = new AJLJButton(this, null, SeismicityText.ALL + "     |---|");
        this.centerOnEvent = SwingExt.newJCheckBox(this, SeismicityText.VIEW_CENTER + " " + SeismicityText.EVENT);
        this.textFieldPlotNum = SwingExt.newJTextField(this, null, "", 5);
        this.buttonPlotAuto = new AJLJButton(this, null, this.runButtonLabel);
        this.buttonRecordSnapshot = new AJLJButton(this, null, SeismicityText.RECORD_SNAPSHOT);
        this.buttonRecordSnapshot.setBackground(MESSAGE_BACKGROUND_EMPHASIS);
        this.buttonSeismicitySelectAll = new AJLJButton(this, null, SeismicityText.SHOW_ALL);
        this.buttonSeismicityClearAll = new AJLJButton(this, null, SeismicityText.SHOW_NONE);
        this.menuItemMagnitude = SwingExt.newJCheckBox(this, "Magnitudes");
        this.menuItemProbDen = SwingExt.newJCheckBox(this, "ProbDensity");
        this.menuItemMaxLike = SwingExt.newJCheckBox(this, "MaxLikelihood");
        this.menuItemExpect = SwingExt.newJCheckBox(this, "Expectation");
        this.menuItemEllipse = SwingExt.newJCheckBox(this, "ConfEllipsoid");
        this.menuItemWeightsAll = SwingExt.newJCheckBox(this, "AllWeights");
        this.menuItemPresidual = SwingExt.newJCheckBox(this, "P Residuals");
        this.menuItemSresidual = SwingExt.newJCheckBox(this, "S Residuals");
        this.menuItemFirstMotion = SwingExt.newJCheckBox(this, "FirstMotions");
        this.menuItemRay = SwingExt.newJCheckBox(this, "Rays");
        this.menuItemStationName = SwingExt.newJCheckBox(this, "StationID");
        this.menuItemStationSym = SwingExt.newJCheckBox(this, "StationSym");
        this.menuItemFaultPlanes = SwingExt.newJCheckBox(this, "Fault Planes");
        this.menuItemPressureAxis = SwingExt.newJCheckBox(this, "Pressure Axes");
        this.menuItemTensionAxis = SwingExt.newJCheckBox(this, "Tension Axes");
        this.menuItemNodalAxis = SwingExt.newJCheckBox(this, "Nodal Axes");
        this.menuItemSlipAxes = SwingExt.newJCheckBox(this, "Slip Axes");
        this.menuItemThrustOnly = SwingExt.newJCheckBox(this, "Thrust");
        this.menuItemNormalOnly = SwingExt.newJCheckBox(this, "Normal");
        this.menuItemStrikeSlipOnly = SwingExt.newJCheckBox(this, "Strike-slip");
        this.buttonSeismicityDrawItemsSelectAll = new AJLJButton(this, null, SeismicityText.SHOW_ALL);
        this.buttonSeismicityDrawItemsClearAll = new AJLJButton(this, null, SeismicityText.SHOW_NONE);
        this.graphicTextCkBox = SwingExt.newJCheckBox(this, this.graphicTextCkBoxStr);
        this.axes3DVisibleCkBox = SwingExt.newJCheckBox(this, this.axes3DVisibleCkBoxStr);
        this.gridVisibleCkBox = SwingExt.newJCheckBox(this, this.gridVisibleCkBoxStr);
        this.scalebarVisibleCkBox = SwingExt.newJCheckBox(this, this.scalebarVisibleCkBoxStr);
        this.latlonVisibleCkBox = SwingExt.newJCheckBox(this, this.latlonVisibleCkBoxStr);
        this.allowDrawImage2DCkBox = SwingExt.newJCheckBox(this, this.allowDrawImage2DCkBoxStr);
        this.menuItemFileRecordSnapshots = SwingExt.newJCheckBoxMenuItem(this, SeismicityText.RECORD_SNAPSHOTS);
        this.menuItemHypAssoc = SwingExt.newJCheckBoxMenuItem(this, SeismicityText.HYPO_ASSOC);
        this.menuItemViewGlobalTransparent = SwingExt.newJCheckBoxMenuItem(this, "GlobalTransparent");
        this.menuItemViewBuffer = SwingExt.newJCheckBoxMenuItem(this, "DrawBuffer");
        this.menuItemViewQuickDraw = SwingExt.newJCheckBoxMenuItem(this, "QuickDraw");
        this.menuItemViewInvertCol = SwingExt.newJCheckBoxMenuItem(this, "InvertColors");
        this.menuItemLock2D = SwingExt.newJCheckBoxMenuItem(this, "Lock2D");
        this.menuItemCkBoxViewViewingToolbar = SwingExt.newJCheckBoxMenuItem(this, "Viewing Toolbar");
        this.buttonCloseViewingToolbar = new AJLJButton(this, null, "X");
        this.menuItemCkBoxViewSeismicityToolbar = SwingExt.newJCheckBoxMenuItem(this, "Seismicity Toolbar");
        this.buttonCloseSeismicityToolbar = new AJLJButton(this, null, "X");
        this.enableEvents(8L);
        this.addKeyListener(this);
    }

    public void requestFocus(Component component) {
        if (this.helpFrame != null && this.helpFrame.isVisible()) {
            return;
        }
        if (this.menuItemHelpAbout != null && this.menuItemHelpAbout.isVisible()) {
            return;
        }
        component.requestFocus();
    }

    public int getTransformationIndex() {
        return this.transformationIndex;
    }

    public boolean getTrueFalseParameter(boolean bl, String string) {
        return ApplicationProperties.getTrueFalseParameter(this, bl, string);
    }

    public void initSeismicity() {
        Object object;
        Object object2;
        Object object3;
        String string;
        double d;
        String[] stringArray;
        String string2;
        int n;
        int n2;
        int n3;
        int n4;
        String string3;
        String string4;
        int n5;
        int n6;
        this.fullyInitialized = false;
        this.showViewingToolbar = this.getTrueFalseParameter(true, "display.viewingtoolbar");
        this.showSeismicityToolbar = this.getTrueFalseParameter(true, "display.seismicitytoolbar");
        if (this.grid3DName == null) {
            this.grid3DName = this.getParameter("grid");
        }
        Vector<String> vector = new Vector<String>();
        String string5 = null;
        for (n6 = 0; n6 < 15; ++n6) {
            this.graphicLineURL[n6] = this.getParameter(this.graphicLineParamStr[n6]);
            if (this.graphicLineURL[n6] == null) continue;
            n5 = -1;
            n5 = this.graphicLineURL[n6].indexOf(35);
            if (n5 <= 0) continue;
            if (this.graphicLineURL[n6].length() > n5 + 1) {
                this.graphicLineCkBoxStr[n6] = this.graphicLineURL[n6].substring(n5 + 1);
            }
            this.graphicLineURL[n6] = this.graphicLineURL[n6].substring(0, n5);
        }
        if (this.graphicLineURL[3] == null) {
            this.graphicLineURL[3] = this.getParameter("coastlines");
        }
        if (this.graphicLineURL[1] == null) {
            this.graphicLineURL[1] = this.getParameter("riverlines");
        }
        if (this.graphicLineURL[7] == null) {
            this.graphicLineURL[7] = this.getParameter("faultlines");
        }
        if (this.graphicLineURL[8] == null) {
            this.graphicLineURL[8] = this.getParameter("geologiclines");
        }
        if (this.graphicLineURL[2] == null) {
            this.graphicLineURL[2] = this.getParameter("politicallines");
        }
        for (n6 = 0; n6 < 15; ++n6) {
            if (this.graphicLineURL[n6] == null || this.graphicLineURL[n6].length() > 0) continue;
            this.graphicLineURL[n6] = null;
        }
        vector = new Vector();
        string5 = null;
        n6 = 0;
        while ((string5 = this.getParameter("lines." + n6++)) != null || n6 < 10) {
            if (string5 == null || string5.trim().length() <= 0) continue;
            vector.add(string5);
        }
        this.graphicPolylineURL = new String[vector.size()];
        vector.copyInto(this.graphicPolylineURL);
        this.graphicPolyline = new MapLines[this.graphicPolylineURL.length];
        this.graphicPolylineDraw = new boolean[this.graphicPolylineURL.length];
        this.graphicPolylineCkBox = new JCheckBox[this.graphicPolylineURL.length];
        this.graphicPolylineCkBoxStr = new String[this.graphicPolylineURL.length];
        for (n5 = 0; n5 < this.graphicPolylineURL.length; ++n5) {
            this.graphicPolylineCkBoxStr[n5] = "lines." + n5;
        }
        String string6 = this.getParameter("global.coastline");
        if (string6 != null) {
            globalCoastlineName = string6;
        }
        if ((string4 = this.getParameter("global.plateboundary")) != null) {
            globalPlateBoundaryName = string4;
        }
        if ((string3 = this.getParameter("shapefiles.filter.latlondepth")) != null) {
            float[] fArray = new float[2];
            float[] fArray2 = new float[2];
            float[] fArray3 = new float[2];
            try {
                String[] stringArray2 = string3.split("[;#]");
                for (n4 = 0; n4 < stringArray2.length && n4 < 2; ++n4) {
                    String[] stringArray3 = StringExt.parse(stringArray2[n4], ",");
                    if (stringArray3.length < 1) continue;
                    fArray2[n4] = Float.parseFloat(stringArray3[0]);
                    if (stringArray3.length < 2) continue;
                    fArray[n4] = Float.parseFloat(stringArray3[1]);
                    if (stringArray3.length < 3) continue;
                    fArray3[n4] = Float.parseFloat(stringArray3[2]);
                }
            }
            catch (Exception exception) {
                System.out.println("ERROR: reading filter parameters: " + string3 + " : " + exception);
            }
            this.clipShapefileBoundingBox3D = new Line3D(fArray, fArray2, fArray3);
        }
        vector = new Vector();
        int n7 = 0;
        string5 = null;
        while ((string5 = this.getParameter("shapefiles." + n7)) != null && string5.trim().length() > 0) {
            vector.add(string5);
            ++n7;
        }
        this.graphicShapefileURL = new String[vector.size()];
        vector.copyInto(this.graphicShapefileURL);
        this.graphicShapefile = new MapShapefile[this.graphicShapefileURL.length];
        this.graphicShapefileDraw = new boolean[this.graphicShapefileURL.length];
        this.graphicShapefileCkBox = new JCheckBox[this.graphicShapefileURL.length];
        this.graphicShapefileCkBoxStr = new String[this.graphicShapefileURL.length];
        for (n3 = 0; n3 < this.graphicShapefileURL.length; ++n3) {
            this.graphicShapefileCkBoxStr[n3] = "shapefiles." + n3;
        }
        vector = new Vector();
        n3 = 0;
        string5 = null;
        while ((string5 = this.getParameter("polygons." + n3)) != null && string5.trim().length() > 0) {
            vector.add(string5);
            ++n3;
        }
        this.graphicPolygonURL = new String[vector.size()];
        vector.copyInto(this.graphicPolygonURL);
        this.graphicPolygon = new MapPolygons[this.graphicPolygonURL.length];
        this.graphicPolygonDraw = new boolean[this.graphicPolygonURL.length];
        this.graphicPolygonCkBox = new JCheckBox[this.graphicPolygonURL.length];
        this.graphicPolygonCkBoxStr = new String[this.graphicPolygonURL.length];
        for (n2 = 0; n2 < this.graphicPolygonURL.length; ++n2) {
            this.graphicPolygonCkBoxStr[n2] = "polygons." + n2;
        }
        vector = new Vector();
        n2 = 0;
        string5 = null;
        while ((string5 = this.getParameter("symbols." + n2)) != null && string5.trim().length() > 0) {
            vector.add(string5);
            ++n2;
        }
        this.graphicSymbolURL = new String[vector.size()];
        vector.copyInto(this.graphicSymbolURL);
        this.graphicSymbol = new MapSymbols[this.graphicSymbolURL.length];
        this.graphicSymbolDraw = new boolean[this.graphicSymbolURL.length];
        this.graphicSymbolCkBox = new JCheckBox[this.graphicSymbolURL.length];
        this.graphicSymbolCkBoxStr = new String[this.graphicSymbolURL.length];
        for (n = 0; n < this.graphicSymbolURL.length; ++n) {
            this.graphicSymbolCkBoxStr[n] = "symbols." + n;
        }
        vector = new Vector();
        n = 0;
        string5 = null;
        while ((string5 = this.getParameter("samples." + n)) != null && string5.trim().length() > 0) {
            vector.add(string5);
            ++n;
        }
        this.sampleSetURL = new String[vector.size()];
        vector.copyInto(this.sampleSetURL);
        this.sampleSet = new Sample4DSet[this.sampleSetURL.length];
        this.sampleSetDraw = new boolean[this.sampleSetURL.length];
        this.sampleSetCkBox = new JCheckBox[this.sampleSetURL.length];
        this.sampleSetCkBoxStr = new String[this.sampleSetURL.length];
        for (n4 = 0; n4 < this.sampleSetURL.length; ++n4) {
            this.sampleSetCkBoxStr[n4] = "samples." + n4;
        }
        this.graphicTextURL = this.getParameter(this.graphicTextParamStr);
        if (this.graphicTextURL != null && this.graphicTextURL.length() <= 0) {
            this.graphicTextURL = null;
        }
        this.image2Dstr = this.getParameter("image2D");
        if (this.image2Dstr == null) {
            this.image2Dstr = this.getParameter("image2d");
        }
        this.projectFlag = this.getTrueFalseParameter(this.projectFlag, "view.persp");
        this.globalTransparent = this.getTrueFalseParameter(this.globalTransparent, "view.globaltransparent");
        this.bufferFlag = this.getTrueFalseParameter(this.bufferFlag, "view.drawbuffer");
        this.quickDrawFlag = this.getTrueFalseParameter(this.quickDrawFlag, "view.quickdraw");
        this.invertColorFlag = this.getTrueFalseParameter(this.invertColorFlag, "view.invertcolors");
        this.lock2DFlag = this.getTrueFalseParameter(this.lock2DFlag, "view.lock2D");
        this.stationReadFlag = this.getTrueFalseParameter(this.stationReadFlag, "read.stations");
        this.ellipseReadFlag = this.getTrueFalseParameter(this.ellipseReadFlag, "read.ellipsoids");
        this.phaseReadFlag = this.getTrueFalseParameter(this.phaseReadFlag, "read.phases");
        this.focalMechReadFlag = this.getTrueFalseParameter(this.focalMechReadFlag, "read.mechanisms");
        this.probabilityReadFlag = this.getTrueFalseParameter(this.probabilityReadFlag, "read.probability");
        this.writeSeismicityBinaryFlag = this.getTrueFalseParameter(this.writeSeismicityBinaryFlag, "binaryout");
        this.initPlotFirstFlag = this.getTrueFalseParameter(this.initPlotFirstFlag, "init.plotfirst");
        this.magnitudeFlag = this.getTrueFalseParameter(this.magnitudeFlag, "show.magnitude");
        this.probDenFlag = this.getTrueFalseParameter(this.probDenFlag, "show.probability");
        this.maxLikeFlag = this.getTrueFalseParameter(this.maxLikeFlag, "show.maxlikelihood");
        this.expectFlag = this.getTrueFalseParameter(this.expectFlag, "show.expectation");
        this.ellipseFlag = this.getTrueFalseParameter(this.ellipseFlag, "show.ellipsoid");
        this.PresidualFlag = this.getTrueFalseParameter(this.PresidualFlag, "show.residual.p");
        this.SresidualFlag = this.getTrueFalseParameter(this.SresidualFlag, "show.residual.s");
        this.weightsAllFlag = this.getTrueFalseParameter(this.weightsAllFlag, "show.weights.all");
        this.weightsAllFlag = this.getTrueFalseParameter(this.weightsAllFlag, "show.residual.all");
        this.residualLabelFlag = this.getTrueFalseParameter(this.residualLabelFlag, "show.residual.label");
        this.firstMotionFlag = this.getTrueFalseParameter(this.firstMotionFlag, "show.firstmotion");
        this.rayFlag = this.getTrueFalseParameter(this.firstMotionFlag, "show.rays");
        this.stationNameFlag = this.getTrueFalseParameter(this.stationNameFlag, "show.station");
        this.stationSymFlag = this.getTrueFalseParameter(this.stationSymFlag, "show.stationsymbol");
        this.faultPlanesFlag = this.getTrueFalseParameter(this.faultPlanesFlag, "show.faultplane");
        this.pressureAxisFlag = this.getTrueFalseParameter(this.pressureAxisFlag, "show.axis.p");
        this.nodalAxisFlag = this.getTrueFalseParameter(this.nodalAxisFlag, "show.axis.n");
        this.slipAxesFlag = this.getTrueFalseParameter(this.slipAxesFlag, "show.axis.slip");
        this.tensionAxisFlag = this.getTrueFalseParameter(this.tensionAxisFlag, "show.axis.t");
        this.thrustOnlyFlag = this.getTrueFalseParameter(this.thrustOnlyFlag, "show.axis.thrust");
        this.normalOnlyFlag = this.getTrueFalseParameter(this.normalOnlyFlag, "show.axis.normal");
        this.strikeSlipOnlyFlag = this.getTrueFalseParameter(this.strikeSlipOnlyFlag, "show.axis.strikeslip");
        String string7 = this.getParameter("mechanism.horizonlycutoffdip");
        if (string7 != null) {
            double d2 = this.horizOnlyCutoffDip;
            try {
                this.horizOnlyCutoffDip = Double.parseDouble(string7);
            }
            catch (Exception exception) {
                this.horizOnlyCutoffDip = d2;
            }
        }
        if ((string2 = this.getParameter("mechanism.axis.slip.target")) != null) {
            try {
                stringArray = StringExt.parse(string2, ",");
                double d3 = Double.parseDouble(stringArray[0]);
                d3 = 90.0 - d3;
                d = Double.parseDouble(stringArray[1]);
                double d4 = (float)Math.cos(0.01745329238474369 * d);
                this.targetSlipAxis = new Vect3D(Math.cos(0.01745329238474369 * d3) * d4, Math.sin(0.01745329238474369 * d3) * d4, Math.sin(0.01745329238474369 * d));
            }
            catch (Exception exception) {
                this.targetSlipAxis = null;
            }
        }
        if ((stringArray = this.getParameter("mechanism.misift.max")) != null) {
            double d5 = this.mechMisfitMax;
            try {
                this.mechMisfitMax = Double.parseDouble((String)stringArray);
            }
            catch (Exception exception) {
                this.mechMisfitMax = d5;
            }
        }
        if ((string = this.getParameter("mechanism.nobs.min")) != null) {
            int n8 = this.mechNobsMin;
            try {
                this.mechNobsMin = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.mechNobsMin = n8;
            }
        }
        this.paintPTNaxesBowtie = this.getTrueFalseParameter(this.paintPTNaxesBowtie, "stroke.axis.ptn.bowtie");
        if (this.eventFileNames == null && !this.setSearchFileNames()) {
            String string8 = this.getParameter("event");
            if (string8 == null) {
                string8 = this.getParameter("app_default_param");
            }
            if (string8 != null) {
                this.eventFileNames = StringExt.parse(string8, ";");
            }
        }
        if (this.eventFileNames == null || this.eventFileNames.length == 0) {
            System.out.println("SeismicityViewer: INFO: no event file specified.");
            this.eventFileNames = null;
        }
        if (this.eventFileNames != null && this.eventFileNames.length == 1) {
            String[] stringArray4 = this.eventFileNames;
            String string9 = this.eventFileNames[0];
            if (string9.indexOf(42) >= 0 || string9.indexOf(42) >= 0) {
                try {
                    String string10 = System.getProperty("user.dir");
                    int n9 = string9.lastIndexOf(System.getProperty("file.separator"));
                    if (n9 >= 0 && string9.length() > n9 + 1) {
                        string10 = string9.substring(0, n9 + 1);
                        string9 = string9.substring(n9 + 1);
                    }
                    object3 = FileSystems.getDefault().getPath(string10, new String[0]);
                    object2 = Files.newDirectoryStream((Path)object3, string9);
                    object = new ArrayList();
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        Path path = (Path)iterator.next();
                        ((ArrayList)object).add(string10 + path.getFileName().toString());
                    }
                    object2.close();
                    stringArray4 = ((ArrayList)object).toArray(new String[0]);
                }
                catch (IOException iOException) {
                    System.out.println("SeismicityViewer: ERROR: " + iOException + ": evaluating filename wildards: " + this.eventFileNames);
                }
                this.eventFileNames = stringArray4;
            }
        }
        if (this.eventFileType == null) {
            this.eventFileType = this.getParameter("event.filetype");
        }
        if (this.eventFileType == null) {
            this.eventFileType = this.getParameter("eventfiletype");
        }
        this.eventFileType = this.eventFileType != null ? this.eventFileType.toUpperCase() : NULL_EVENT_FILETYPE;
        String string11 = this.getParameter("station.symbol.size");
        if (string11 != null) {
            d = 1.0;
            try {
                d = Double.valueOf(string11);
                SeisPhase.setStationSymbolSizeFactor(d);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        d = 1.0;
        String string12 = this.getParameter("event.size");
        if (string12 != null) {
            double d6 = d;
            try {
                d = Double.valueOf(string12);
            }
            catch (Exception exception) {
                d = d6;
            }
        }
        this.magSymbolScaleFactor = d;
        object3 = this.getParameter("event.magSizeExponent");
        if (object3 != null) {
            double d7 = this.magSymbolSizeExponent;
            try {
                this.magSymbolSizeExponent = Double.parseDouble((String)object3);
            }
            catch (Exception exception) {
                this.magSymbolSizeExponent = d7;
            }
        }
        if ((object2 = this.getParameter("event.depthcolormap")) != null) {
            try {
                object = new SeismicityColorMap(SeismicityColorMap.Type.DEPTH, (String)object2);
                SeisEvent.setColorMap((SeismicityColorMap)object);
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: initializing event depth colormap: " + exception);
                exception.printStackTrace();
            }
        }
        if ((object2 = this.getParameter("event.otimecolormap")) != null) {
            try {
                object = new SeismicityColorMap(SeismicityColorMap.Type.OTIME, (String)object2);
                SeisEvent.setColorMap((SeismicityColorMap)object);
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: initializing event otime colormap: " + exception);
                exception.printStackTrace();
            }
        }
        if ((object2 = this.getParameter("event.colormap")) != null && !((String)object2).equalsIgnoreCase("NONE")) {
            try {
                object = SeismicityColorMap.createSeismicityColorMap((String)object2);
                SeisEvent.setColorMap((SeismicityColorMap)object);
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: initializing event colormap: " + exception);
                exception.printStackTrace();
            }
        }
        try {
            this.colormapTextSizeFactor = Double.parseDouble(this.getParameter("event.colormap.text.sizefactor"));
        }
        catch (Exception exception) {
            this.colormapTextSizeFactor = 2.5;
        }
        StringVectorizer.setTextSizeFactor(this.globalTextSizeFactor);
        this.snapshotDirectory = this.getParameter("snapshot.directory");
        if (this.snapshotDirectory == null) {
            this.snapshotDirectory = this.getParameter("snapshot.record.dir");
            if (this.snapshotDirectory == null) {
                this.snapshotDirectory = ".";
            }
        }
        this.snapshotFormat = this.getParameter("snapshot.format");
        if (this.snapshotFormat == null) {
            this.snapshotFormat = this.getParameter("snapshot.record.format");
            if (this.snapshotFormat == null) {
                this.snapshotFormat = "jpg";
            }
        }
    }

    protected void setupFrame() {
        for (int i = this.menuBar.getMenuCount() - 1; i >= 0; --i) {
            this.menuBar.remove(i);
        }
        JMenu jMenu = new JMenu(SeismicityText.FILE);
        if (!this.parent.isApplet()) {
            this.menuItemFileOpen = SwingExt.newJMenuItem(this, SeismicityText.OPEN + " " + SeismicityText.FILE + "...");
            jMenu.add(this.menuItemFileOpen);
            this.menuItemURLOpen = SwingExt.newJMenuItem(this, SeismicityText.OPEN + " URL...");
            jMenu.add(this.menuItemURLOpen);
            this.menuItemEventSearch = SwingExt.newJMenuItem(this, SeismicityText.OPEN + " " + SeisText.EVENT_SEARCH + "...");
            jMenu.add(this.menuItemEventSearch);
        }
        jMenu.addSeparator();
        this.menuItemFilePrint = SwingExt.newJMenuItem(this, SeismicityText.PRINT);
        jMenu.add(this.menuItemFilePrint);
        this.menuItemFileSnapshot = SwingExt.newJMenuItem(this, SeismicityText.SNAPSHOT + "...");
        jMenu.add(this.menuItemFileSnapshot);
        this.menuItemFileRecordSnapshots.setSelected(this.recordSnapshots);
        jMenu.add(this.menuItemFileRecordSnapshots);
        jMenu.addSeparator();
        this.menuItemFileExit = SwingExt.newJMenuItem(this, SeismicityText.EXIT);
        jMenu.add(this.menuItemFileExit);
        this.menuBar.add(jMenu);
        JMenu jMenu2 = new JMenu(SeismicityText.VIEW);
        this.setViewMenu(jMenu2);
        this.menuBar.add(jMenu2);
        JMenu jMenu3 = new JMenu(SeismicityText.UTILITIES);
        JMenu jMenu4 = new JMenu(SeismicityText.LANGUAGE);
        this.menuItemUtilitiesLanguage_en_US = SwingExt.newJMenuItem(this, GeneralText.en_US);
        jMenu4.add(this.menuItemUtilitiesLanguage_en_US);
        this.menuItemUtilitiesLanguage_fr_FR = SwingExt.newJMenuItem(this, GeneralText.fr_FR);
        jMenu4.add(this.menuItemUtilitiesLanguage_fr_FR);
        this.menuItemUtilitiesLanguage_it_IT = SwingExt.newJMenuItem(this, GeneralText.it_IT);
        jMenu4.add(this.menuItemUtilitiesLanguage_it_IT);
        jMenu3.add(jMenu4);
        jMenu3.addSeparator();
        jMenu3.add(this.menuItemHypAssoc);
        this.menuItemGrid2GMTDialog = SwingExt.newJMenuItem(this, SeismicityText.GRID2GMT_INTERFACE);
        if (!this.isApplet() && this.getTrueFalseParameter(true, "interface.grid2gmt")) {
            jMenu3.add(this.menuItemGrid2GMTDialog);
        }
        this.menuBar.add(jMenu3);
        JMenu jMenu5 = new JMenu(SeismicityText.HELP);
        this.menuItemHelpHelp = SwingExt.newJMenuItem(this, SeismicityText.HELP);
        jMenu5.add(this.menuItemHelpHelp);
        this.menuItemHelpAbout = new JMenuItemText((Component)this, this.iconImage, this.iconImage, SeismicityText.ABOUT, SeismicityText.ABOUT_TITLE, PROGRAM_NAME, HELP_ABOUT, SeismicityText.CLOSE);
        jMenu5.add(this.menuItemHelpAbout);
        this.menuBar.add(jMenu5);
        if (this.showSeismicityToolbar) {
            this.layoutSeismicityToolbar();
        }
        if (this.showViewingToolbar) {
            this.layoutViewToolbar();
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)this.panel3D, "Center");
        jPanel.add((Component)this.toolPanelSeismicity, "Before");
        jPanel.add((Component)this.toolPanelViewing, "After");
        jPanel.add((Component)this.messageLabel, "Last");
        this.getContentPane().removeAll();
        this.getContentPane().add(jPanel);
        this.getContentPane().validate();
        this.requestFocus(this);
    }

    @Override
    public void stop() {
        this.writeMessage("Stopped...");
    }

    @Override
    public void start() {
        this.toFront();
    }

    @Override
    public void cleanUp() {
    }

    protected synchronized void updateEventViews() {
        if (!this.fullyInitialized) {
            return;
        }
        this.panel3D.repaint();
        this.updateTitle();
        this.updateEventMessage();
        if (this.eventInfoFrame != null && this.eventInfoFrame.isShowing()) {
            this.displayEventInfo(true);
        }
        if (this.focalSphereFrame != null && this.focalSphereFrame.isShowing()) {
            this.displayFocalSphere();
        }
        if (this.recordSnapshots) {
            this.recordSnapshot();
        }
    }

    protected void recordSnapshot() {
        String string = this.snapshotDirectory + "/snapshot." + NumberFormat.intString(this.snapshotIndex, 4) + "." + this.snapshotFormat;
        if (this.doSnapshot(string)) {
            ++this.snapshotIndex;
        }
    }

    @Override
    public String getAppletInfo() {
        String string = new String();
        for (int i = 0; i < BANNER.length; ++i) {
            string = string + BANNER[i];
        }
        return string;
    }

    public URL getDocumentBase() {
        return this.parent.getDocumentBase();
    }

    public URL getCodeBase() {
        return this.parent.getCodeBase();
    }

    @Override
    public String getTitleString() {
        if (this.titleString != null) {
            return this.titleString;
        }
        return " ";
    }

    @Override
    public String getProgramName() {
        return PROGRAM_NAME;
    }

    @Override
    public JCompParent getJCompParent() {
        return this.parent;
    }

    @Override
    public String getParameter(String string) {
        String string2 = this.parent.getParameter(string);
        if (string2 == null) {
            string2 = this.parent.getParameter(StringExt.replace(string, ".", ""));
        }
        if (string2 != null) {
            string2 = string2.trim();
        }
        return string2;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftKeyDown = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 16) {
            this.shiftKeyDown = false;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
    }

    public boolean shiftKeyIsDown() {
        return this.shiftKeyDown;
    }

    protected void setViewToolbarStates() {
        this.buttonAbove.setText(this.isGlobal ? SeismicityText.NORTH : SeismicityText.ABOVE);
        this.buttonBelow.setText(this.isGlobal ? SeismicityText.SOUTH : SeismicityText.BELOW);
        this.buttonSouth.setText(this.isGlobal ? "90W" : SeismicityText.SOUTH);
        this.buttonNorth.setText(this.isGlobal ? "90E" : SeismicityText.NORTH);
        this.buttonEast.setText(this.isGlobal ? "0" : SeismicityText.EAST);
        this.buttonWest.setText(this.isGlobal ? "180" : SeismicityText.WEST);
        this.buttonEvent.setText(SeismicityText.EVENT);
        this.buttonGrid.setText(this.isGlobal ? SeismicityText.EARTH_CENTER : SeismicityText.GRID_CENTER);
        this.toolPanelViewing.validate();
        this.toolPanelViewing.repaint();
    }

    protected void layoutViewToolbar() {
        this.toolPanelViewing.removeAll();
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.buttonCloseViewingToolbar, "East");
        jPanel.add((Component)new JLabel(SeismicityText.VIEWING.toUpperCase()), "West");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)new JLabel(SeismicityText.NAVIGATION.toUpperCase() + ":"), "Center");
        jPanel2.add((Component)this.navigationPanel, "South");
        this.toolPanelViewing.add((Component)jPanel2, "North");
        this.createViewingPanel();
        this.toolPanelViewing.add((Component)this.viewingPanel, "Center");
    }

    protected void createViewingPanel() {
        this.panelViewAz.removeAll();
        this.panelViewAz.add(new JLabel("Az: ", 4));
        this.panelViewAz.add(this.textFieldAzimuth.getTextField());
        this.panelViewInc.removeAll();
        this.panelViewInc.add(new JLabel("Inc: ", 4));
        this.panelViewInc.add(this.textFieldInclination.getTextField());
        this.setTextFields(this.zrotAng, this.yrotAng, this.xrotAng);
        this.viewingPanel.removeAll();
        this.viewingPanel.add(this.buttonReset);
        if (!this.lock2DFlag) {
            this.viewingPanel.add(new JLabel(SeismicityText.VIEW_FROM.toUpperCase() + ":"));
            this.viewingPanel.add(this.buttonAbove);
            this.viewingPanel.add(this.buttonBelow);
            this.viewingPanel.add(this.buttonSouth);
            this.viewingPanel.add(this.buttonNorth);
            this.viewingPanel.add(this.buttonEast);
            this.viewingPanel.add(this.buttonWest);
            this.viewingPanel.add(this.panelViewAz);
            this.viewingPanel.add(this.panelViewInc);
        }
        this.viewingPanel.add(new JLabel(SeismicityText.VIEW_CENTER.toUpperCase() + ":"));
        this.viewingPanel.add(this.buttonEvent);
        this.viewingPanel.add(this.buttonGrid);
        this.viewingPanel.add(new JLabel(SeismicityText.PROJECTION.toUpperCase() + ":"));
        if (!this.lock2DFlag) {
            this.viewingPanel.add(this.buttonProject);
        }
        this.viewingPanel.add(new JLabel(SeismicityText.EVENT.toUpperCase() + ":"));
        this.viewingPanel.add(this.centerOnEvent);
        this.viewingPanel.add(this.buttonPlotFirst);
        this.viewingPanel.add(this.buttonPlotNext);
        this.viewingPanel.add(this.buttonPlotPrev);
        this.viewingPanel.add(this.buttonPlotLast);
        this.viewingPanel.add(this.buttonPlotAll);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 0, 0));
        jPanel.add(new JLabel("Num: ", 4));
        this.textFieldPlotNum.setText(String.valueOf(this.eventPlotCurrent + 1));
        jPanel.add(this.textFieldPlotNum);
        this.viewingPanel.add(jPanel);
        this.runButtonLabel = SeismicityText.RUN + "     >>";
        this.pauseButtonLabel = SeismicityText.PAUSE + "   ||";
        this.buttonPlotAuto.setText(this.runButtonLabel);
        this.viewingPanel.add(this.buttonPlotAuto);
        this.viewingPanel.add(new JLabel(" "));
        this.viewingPanel.add(this.buttonRecordSnapshot);
    }

    protected void layoutSeismicityToolbar() {
        int n;
        this.toolPanelSeismicity = new JPanel();
        this.toolPanelSeismicity.setLayout(new GridLayout(0, 1, 0, 0));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)this.buttonCloseSeismicityToolbar, "East");
        jPanel.add((Component)new JLabel(SeismicityText.SEISMICITY.toUpperCase()), "West");
        this.toolPanelSeismicity.add(jPanel);
        this.toolPanelSeismicity.add(new JLabel(" "));
        this.toolPanelSeismicity.add(this.buttonSeismicitySelectAll);
        this.toolPanelSeismicity.add(this.buttonSeismicityClearAll);
        this.toolPanelSeismicity.add(this.menuItemMagnitude);
        this.toolPanelSeismicity.add(this.menuItemProbDen);
        this.toolPanelSeismicity.add(this.menuItemMaxLike);
        this.toolPanelSeismicity.add(this.menuItemExpect);
        this.toolPanelSeismicity.add(this.menuItemEllipse);
        if (this.phaseReadFlag) {
            this.toolPanelSeismicity.add(this.menuItemPresidual);
            this.toolPanelSeismicity.add(this.menuItemSresidual);
            this.toolPanelSeismicity.add(this.menuItemWeightsAll);
            this.toolPanelSeismicity.add(this.menuItemFirstMotion);
            this.toolPanelSeismicity.add(this.menuItemRay);
            this.toolPanelSeismicity.add(this.menuItemStationName);
            this.toolPanelSeismicity.add(this.menuItemStationSym);
        }
        if (this.haveFocalMechanisms) {
            JPanel jPanel2 = this.toolPanelSeismicity;
            jPanel2.add(new JLabel("Focal Mechanisms:"));
            jPanel2.add(this.menuItemFaultPlanes);
            jPanel2.add(this.menuItemPressureAxis);
            jPanel2.add(this.menuItemTensionAxis);
            jPanel2.add(this.menuItemNodalAxis);
            jPanel2.add(this.menuItemSlipAxes);
            jPanel2.add(new JLabel("Show Horiz P/T axes for:"));
            jPanel2.add(this.menuItemThrustOnly);
            jPanel2.add(this.menuItemNormalOnly);
            jPanel2.add(this.menuItemStrikeSlipOnly);
        }
        this.toolPanelSeismicity.add(new JLabel(" "));
        this.toolPanelSeismicity.add(this.buttonSeismicityDrawItemsSelectAll);
        this.toolPanelSeismicity.add(this.buttonSeismicityDrawItemsClearAll);
        if (this.graphicTextURL != null) {
            this.graphicTextCkBox.setSelected(true);
            this.toolPanelSeismicity.add(this.graphicTextCkBox);
        }
        this.axes3DVisibleCkBox.setSelected(this.getTrueFalseParameter(true, "show.axes3d"));
        this.axes3DVisible = this.axes3DVisibleCkBox.isSelected();
        this.toolPanelSeismicity.add(this.axes3DVisibleCkBox);
        this.gridVisibleCkBox.setSelected(this.getTrueFalseParameter(true, "show.grid"));
        this.toolPanelSeismicity.add(this.gridVisibleCkBox);
        this.scalebarVisibleCkBox.setSelected(this.getTrueFalseParameter(true, "show.grid.scale"));
        this.toolPanelSeismicity.add(this.scalebarVisibleCkBox);
        this.latlonVisibleCkBox.setSelected(this.getTrueFalseParameter(true, "show.grid.latlon"));
        this.toolPanelSeismicity.add(this.latlonVisibleCkBox);
        for (n = 0; n < 15; ++n) {
            if (this.graphicLineURL[n] == null) continue;
            if (this.graphicLineCkBox[n] == null) {
                this.graphicLineCkBox[n] = SwingExt.newJCheckBox(this, this.graphicLineCkBoxStr[n]);
            }
            this.graphicLineCkBox[n].setSelected(true);
            this.toolPanelSeismicity.add(this.graphicLineCkBox[n]);
        }
        for (n = 0; n < this.graphicPolylineURL.length; ++n) {
            if (this.graphicPolylineURL[n] == null) continue;
            if (this.graphicPolylineCkBox[n] == null) {
                this.graphicPolylineCkBox[n] = SwingExt.newJCheckBox(this, this.graphicPolylineCkBoxStr[n]);
            }
            this.graphicPolylineCkBox[n].setSelected(true);
            this.toolPanelSeismicity.add(this.graphicPolylineCkBox[n]);
        }
        for (n = 0; n < this.graphicShapefileURL.length; ++n) {
            if (this.graphicShapefileURL[n] == null) continue;
            if (this.graphicShapefileCkBox[n] == null) {
                this.graphicShapefileCkBox[n] = SwingExt.newJCheckBox(this, this.graphicShapefileCkBoxStr[n]);
            }
            this.graphicShapefileCkBox[n].setSelected(true);
            this.toolPanelSeismicity.add(this.graphicShapefileCkBox[n]);
        }
        for (n = 0; n < this.graphicPolygonURL.length; ++n) {
            if (this.graphicPolygonURL[n] == null) continue;
            if (this.graphicPolygonCkBox[n] == null) {
                this.graphicPolygonCkBox[n] = SwingExt.newJCheckBox(this, this.graphicPolygonCkBoxStr[n]);
            }
            this.graphicPolygonCkBox[n].setSelected(true);
            this.toolPanelSeismicity.add(this.graphicPolygonCkBox[n]);
        }
        for (n = 0; n < this.graphicSymbolURL.length; ++n) {
            if (this.graphicSymbolURL[n] == null) continue;
            if (this.graphicSymbolCkBox[n] == null) {
                this.graphicSymbolCkBox[n] = SwingExt.newJCheckBox(this, this.graphicSymbolCkBoxStr[n]);
            }
            this.graphicSymbolCkBox[n].setSelected(true);
            this.toolPanelSeismicity.add(this.graphicSymbolCkBox[n]);
        }
        for (n = 0; n < this.sampleSetURL.length; ++n) {
            if (this.sampleSetURL[n] == null) continue;
            if (this.sampleSetCkBox[n] == null) {
                this.sampleSetCkBox[n] = SwingExt.newJCheckBox(this, this.sampleSetCkBoxStr[n]);
            }
            this.sampleSetCkBox[n].setSelected(true);
            this.toolPanelSeismicity.add(this.sampleSetCkBox[n]);
        }
        if (this.image2Dstr != null) {
            this.allowDrawImage2DCkBox.setSelected(true);
            this.toolPanelSeismicity.add(this.allowDrawImage2DCkBox);
        }
        this.toolPanelSeismicity.add(new JLabel(" "));
    }

    protected void updateTitle() {
        this.titleString = this.getParameter("title");
        if (this.titleString == null) {
            if (this.alternateTitleString != null) {
                this.titleString = this.alternateTitleString;
            } else if (this.seisEventList.size() > 0) {
                this.titleString = ((SeisEvent)this.seisEventList.get((int)this.eventPlotFirst)).comment;
                if ((this.titleString == null || this.titleString.trim().equals("")) && this.eventFileNames.length > 0) {
                    this.titleString = this.eventFileNames[0];
                }
            } else {
                this.titleString = "";
            }
        }
        this.setTitle("SeismicityViewer v5.0.0X27 - " + this.titleString);
    }

    protected void updateEventMessage() {
        this.writeMessage(this.getEventMessage());
    }

    public String getEventMessage() {
        String string = "" + this.seisEventList.size();
        if (this.panel3D.numEventsPassedFilter != this.seisEventList.size()) {
            string = "" + this.panel3D.numEventsPassedFilter + " [" + this.seisEventList.size() + "]";
        }
        if (this.seisEventList.size() > 0 && this.eventPlotFirst == this.eventPlotLast) {
            return "Event " + (this.eventPlotFirst + 1) + "/" + string + ": " + this.seisEventList.elementAt(this.eventPlotFirst).toString();
        }
        return string + " events. " + this.getTitleString();
    }

    protected void setSeismicityToolbarStates() {
        int n;
        this.updateTitle();
        if (this.isGlobal) {
            this.menuItemViewGlobalTransparent.setSelected(this.globalTransparent);
            this.menuItemViewGlobalTransparent.setEnabled(true);
        } else {
            this.menuItemViewGlobalTransparent.setEnabled(false);
        }
        this.menuItemMagnitude.setSelected(this.magnitudeFlag);
        this.menuItemProbDen.setSelected(this.probDenFlag);
        this.menuItemMaxLike.setSelected(this.maxLikeFlag);
        this.menuItemExpect.setSelected(this.expectFlag);
        if (this.ellipseReadFlag && !this.isGlobal) {
            this.menuItemEllipse.setSelected(this.ellipseFlag);
            this.menuItemEllipse.setEnabled(true);
        } else {
            this.menuItemEllipse.setEnabled(false);
        }
        if (this.phaseReadFlag) {
            this.menuItemPresidual.setSelected(this.PresidualFlag);
            this.menuItemSresidual.setSelected(this.SresidualFlag);
            this.menuItemWeightsAll.setSelected(this.weightsAllFlag);
            this.menuItemFirstMotion.setSelected(this.firstMotionFlag);
            this.menuItemRay.setSelected(this.rayFlag);
            if (this.stationReadFlag) {
                this.menuItemStationName.setSelected(this.stationNameFlag);
            } else {
                this.menuItemStationName.setEnabled(false);
            }
            this.menuItemStationSym.setSelected(this.stationSymFlag);
        } else {
            this.menuItemPresidual.setEnabled(false);
            this.menuItemSresidual.setEnabled(false);
            this.menuItemWeightsAll.setEnabled(false);
            this.menuItemFirstMotion.setEnabled(false);
            this.menuItemStationName.setEnabled(false);
            this.menuItemStationSym.setEnabled(false);
        }
        if (this.haveFocalMechanisms) {
            this.menuItemFaultPlanes.setSelected(this.faultPlanesFlag);
            this.menuItemPressureAxis.setSelected(this.pressureAxisFlag);
            this.menuItemTensionAxis.setSelected(this.tensionAxisFlag);
            this.menuItemNodalAxis.setSelected(this.nodalAxisFlag);
            this.menuItemSlipAxes.setSelected(this.slipAxesFlag);
            this.menuItemThrustOnly.setSelected(this.thrustOnlyFlag);
            this.menuItemNormalOnly.setSelected(this.normalOnlyFlag);
            this.menuItemStrikeSlipOnly.setSelected(this.strikeSlipOnlyFlag);
        }
        for (n = 0; n < this.graphicShapefileCkBox.length; ++n) {
            this.graphicShapefileCkBox[n].setText(this.graphicShapefileCkBoxStr[n]);
        }
        for (n = 0; n < this.graphicPolygonCkBox.length; ++n) {
            this.graphicPolygonCkBox[n].setText(this.graphicPolygonCkBoxStr[n]);
        }
        for (n = 0; n < this.graphicSymbolCkBox.length; ++n) {
            this.graphicSymbolCkBox[n].setText(this.graphicSymbolCkBoxStr[n]);
        }
        for (n = 0; n < this.sampleSetCkBox.length; ++n) {
            this.sampleSetCkBox[n].setText(this.sampleSetCkBoxStr[n]);
        }
        this.menuItemHypAssoc.setEnabled(this.seisEventList.size() > 0);
    }

    protected void setViewMenu(JMenu jMenu) {
        jMenu.removeAll();
        this.menuItemViewEventInfo = SwingExt.newJMenuItem(this, SeismicityText.EVENT_INFO);
        jMenu.add(this.menuItemViewEventInfo);
        this.menuItemViewFocalSphere = SwingExt.newJMenuItem(this, SeismicityText.FOCAL_SPHERE);
        jMenu.add(this.menuItemViewFocalSphere);
        jMenu.addSeparator();
        this.menuItemViewGlobalTransparent.setSelected(this.globalTransparent);
        jMenu.add(this.menuItemViewGlobalTransparent);
        this.menuItemViewBuffer.setSelected(this.bufferFlag);
        jMenu.add(this.menuItemViewBuffer);
        this.menuItemViewQuickDraw.setSelected(this.quickDrawFlag);
        jMenu.add(this.menuItemViewQuickDraw);
        this.menuItemViewInvertCol.setSelected(this.invertColorFlag);
        jMenu.add(this.menuItemViewInvertCol);
        this.menuItemLock2D.setSelected(this.lock2DFlag);
        jMenu.add(this.menuItemLock2D);
        jMenu.addSeparator();
        this.menuItemCkBoxViewSeismicityToolbar.setSelected(this.showSeismicityToolbar);
        jMenu.add(this.menuItemCkBoxViewSeismicityToolbar);
        this.menuItemCkBoxViewViewingToolbar.setSelected(this.showViewingToolbar);
        jMenu.add(this.menuItemCkBoxViewViewingToolbar);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = true;
        if (actionEvent.getSource().equals(this.menuItemFileOpen)) {
            this.openFile();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemURLOpen)) {
            this.openURL();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemEventSearch)) {
            this.openSearch();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFilePrint)) {
            this.doPrintJob();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileSnapshot)) {
            this.doSnapshot();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemFileExit)) {
            this.cleanUp();
            this.parent.closeFrame();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemViewEventInfo)) {
            this.displayEventInfo(true);
            if (this.eventInfoFrame != null) {
                this.eventInfoFrame.toFront();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemViewFocalSphere)) {
            this.displayFocalSphere();
            if (this.focalSphereFrame != null) {
                this.focalSphereFrame.toFront();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemUtilitiesLanguage_en_US)) {
            SeismicityText.setLocale("en_US");
            SeisText.setLocale("en_US");
            SwingText.setLocale("en_US");
            if (!this.displayingFrame) {
                this.redisplayFrame();
            }
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemUtilitiesLanguage_fr_FR)) {
            SeismicityText.setLocale("fr_FR");
            SeisText.setLocale("fr_FR");
            SwingText.setLocale("fr_FR");
            this.redisplayFrame();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemUtilitiesLanguage_it_IT)) {
            SeismicityText.setLocale("it_IT");
            SeisText.setLocale("it_IT");
            SwingText.setLocale("it_IT");
            this.redisplayFrame();
            return;
        }
        if (actionEvent.getSource().equals(this.menuItemGrid2GMTDialog)) {
            try {
                this.openGrid2GMTDialog();
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: opening Grid2GMT interface: " + exception);
                exception.printStackTrace();
            }
        } else {
            if (actionEvent.getSource().equals(this.menuItemHelpHelp)) {
                this.doHelp();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonCloseViewingToolbar)) {
                this.showViewingToolbar = false;
                this.menuItemCkBoxViewViewingToolbar.setSelected(this.showSeismicityToolbar);
                this.redisplayFrame();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonCloseSeismicityToolbar)) {
                this.showSeismicityToolbar = false;
                this.menuItemCkBoxViewSeismicityToolbar.setSelected(this.showSeismicityToolbar);
                this.redisplayFrame();
                return;
            }
            if (actionEvent.getSource().equals(this.buttonSeismicitySelectAll) || actionEvent.getSource().equals(this.buttonSeismicityClearAll)) {
                boolean bl2;
                this.magnitudeFlag = bl2 = actionEvent.getSource().equals(this.buttonSeismicitySelectAll);
                this.probDenFlag = bl2;
                this.maxLikeFlag = bl2;
                this.expectFlag = bl2;
                this.ellipseFlag = this.isGlobal ? false : bl2;
                this.PresidualFlag = bl2;
                this.SresidualFlag = bl2;
                this.weightsAllFlag = bl2;
                this.firstMotionFlag = bl2;
                this.rayFlag = bl2;
                this.stationNameFlag = bl2;
                this.stationSymFlag = bl2;
                this.faultPlanesFlag = bl2;
                this.pressureAxisFlag = bl2;
                this.tensionAxisFlag = bl2;
                this.nodalAxisFlag = bl2;
                this.slipAxesFlag = bl2;
                this.thrustOnlyFlag = false;
                this.normalOnlyFlag = false;
                this.strikeSlipOnlyFlag = false;
                this.setSeismicityToolbarStates();
            } else if (actionEvent.getSource().equals(this.buttonSeismicityDrawItemsSelectAll) || actionEvent.getSource().equals(this.buttonSeismicityDrawItemsClearAll)) {
                int n;
                boolean bl3;
                boolean bl4 = bl3 = actionEvent.getSource().equals(this.buttonSeismicityDrawItemsSelectAll);
                if (this.graphicTextURL != null) {
                    this.graphicTextCkBox.setSelected(bl3);
                }
                this.axes3DVisibleCkBox.setSelected(bl3);
                this.gridVisibleCkBox.setSelected(bl3);
                this.scalebarVisibleCkBox.setSelected(bl3);
                this.latlonVisibleCkBox.setSelected(bl3);
                for (n = 0; n < 15; ++n) {
                    if (this.graphicLineCkBox[n] == null) continue;
                    this.graphicLineCkBox[n].setSelected(bl3);
                }
                for (n = 0; n < this.graphicPolylineURL.length; ++n) {
                    if (this.graphicPolylineCkBox[n] == null) continue;
                    this.graphicPolylineCkBox[n].setSelected(bl3);
                }
                for (n = 0; n < this.graphicShapefileURL.length; ++n) {
                    if (this.graphicShapefileCkBox[n] == null) continue;
                    this.graphicShapefileCkBox[n].setSelected(bl3);
                }
                for (n = 0; n < this.graphicPolygonURL.length; ++n) {
                    if (this.graphicPolygonCkBox[n] == null) continue;
                    this.graphicPolygonCkBox[n].setSelected(bl3);
                }
                for (n = 0; n < this.graphicSymbolURL.length; ++n) {
                    if (this.graphicSymbolCkBox[n] == null) continue;
                    this.graphicSymbolCkBox[n].setSelected(bl3);
                }
                for (n = 0; n < this.sampleSetURL.length; ++n) {
                    if (this.sampleSetCkBox[n] == null) continue;
                    this.sampleSetCkBox[n].setSelected(bl3);
                }
                if (this.allowDrawImage2DCkBox != null) {
                    this.allowDrawImage2DCkBox.setSelected(bl3);
                }
                this.setSeismicityToolbarStates();
            } else if (actionEvent.getSource().equals(this.buttonProject)) {
                this.projectFlag = !this.projectFlag;
                ++this.transformationIndex;
            } else if (actionEvent.getSource().equals(this.buttonReset)) {
                this.initializeView();
                ++this.transformationIndex;
            } else if (actionEvent.getSource().equals(this.buttonAbove)) {
                this.setViewFromAbove();
            } else if (actionEvent.getSource().equals(this.buttonBelow)) {
                this.setViewFrom(0.0 + this.geogCoords.getRotationAngle(), 0.0, 180.0);
            } else if (actionEvent.getSource().equals(this.buttonSouth)) {
                this.setViewFrom(0.0 + this.geogCoords.getRotationAngle(), 0.0, -90.0);
            } else if (actionEvent.getSource().equals(this.buttonNorth)) {
                this.setViewFrom(180.0 + this.geogCoords.getRotationAngle(), 0.0, -90.0);
            } else if (actionEvent.getSource().equals(this.buttonEast)) {
                this.setViewFrom(-90.0 + this.geogCoords.getRotationAngle(), 0.0, -90.0);
            } else if (actionEvent.getSource().equals(this.buttonWest)) {
                this.setViewFrom(90.0 + this.geogCoords.getRotationAngle(), 0.0, -90.0);
            } else if (actionEvent.getSource().equals(this.buttonEvent)) {
                this.setEventWorldCenter();
                ++this.transformationIndex;
            } else if (actionEvent.getSource().equals(this.buttonGrid)) {
                this.setDefaultGridWorldCenter();
                ++this.transformationIndex;
            } else if (actionEvent.getSource().equals(this.buttonPlotFirst)) {
                this.killAnimatorThread();
                this.eventPlotLast = 0;
                this.eventPlotFirst = 0;
                if (this.centerOnEvent.isSelected()) {
                    this.setEventWorldCenter();
                }
            } else if (actionEvent.getSource().equals(this.buttonPlotLast)) {
                this.killAnimatorThread();
                this.eventPlotFirst = this.eventPlotLast = this.seisEventList.size() - 1;
                if (this.centerOnEvent.isSelected()) {
                    this.setEventWorldCenter();
                }
            } else if (actionEvent.getSource().equals(this.buttonPlotNext)) {
                this.killAnimatorThread();
                if (!this.panel3D.painted) {
                    return;
                }
                this.incrementSample();
                if (this.centerOnEvent.isSelected()) {
                    this.setEventWorldCenter();
                }
            } else if (actionEvent.getSource().equals(this.buttonPlotPrev)) {
                this.killAnimatorThread();
                if (!this.panel3D.painted) {
                    return;
                }
                this.decrementSample();
                if (this.centerOnEvent.isSelected()) {
                    this.setEventWorldCenter();
                }
            } else if (actionEvent.getSource().equals(this.buttonPlotAll)) {
                this.killAnimatorThread();
                this.eventPlotFirst = 0;
                this.eventPlotLast = this.seisEventList.size() - 1;
            } else if (actionEvent.getSource().equals(this.textFieldPlotNum)) {
                int n;
                this.killAnimatorThread();
                try {
                    n = Integer.parseInt(String.valueOf(this.textFieldPlotNum.getText()));
                }
                catch (NumberFormatException numberFormatException) {
                    n = -1;
                }
                if (n < 1 || n > this.seisEventList.size()) {
                    if (this.textFieldPlotNum != null) {
                        this.textFieldPlotNum.setText(String.valueOf(this.eventPlotCurrent + 1));
                    }
                    return;
                }
                this.eventPlotFirst = this.eventPlotCurrent = n - 1;
                this.eventPlotLast = this.eventPlotCurrent;
            } else if (actionEvent.getSource().equals(this.buttonPlotAuto)) {
                if (this.animatorThread != null && this.animatorThread.isAlive()) {
                    this.suspendAnimatorThread();
                } else {
                    this.startAnimatorThread(0, this.eventPlotCurrent);
                }
            } else {
                if (actionEvent.getSource().equals(this.buttonRecordSnapshot)) {
                    this.recordSnapshot();
                    return;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        this.updateEventViews();
    }

    protected void zoom(double d) {
        if (!this.panel3D.painted) {
            return;
        }
        this.applyZoomFactor(d);
        ++this.transformationIndex;
        this.updateEventViews();
    }

    protected void applyZoomFactor(double d) {
        double d2 = Math.pow(1.1, d);
        this.viewScaleFactor *= d2;
        this.perspDist /= d2;
    }

    protected void setViewFromAbove() {
        this.setViewFrom(0.0 + this.geogCoords.getRotationAngle(), 0.0, 0.0);
    }

    protected void incrementViewAzimuth(double d) {
        this.setViewFrom(this.zrotAng + d, this.yrotAng, this.xrotAng);
    }

    protected void incrementViewInclination(double d) {
        this.setViewFrom(this.zrotAng, this.yrotAng, this.xrotAng + d);
    }

    protected void setViewFrom(double d, double d2, double d3) {
        this.rotMat.unit();
        this.rotMat.zrot((float)d);
        this.rotMat.yrot((float)d2);
        this.rotMat.xrot((float)d3);
        ++this.transformationIndex;
        this.setRotationAngles(d, d2, d3);
    }

    protected void setInitialRotationAngles(double d, double d2, double d3) {
        this.zrotAngInit = d;
        this.yrotAngInit = d2;
        this.xrotAngInit = d3;
        this.setRotationAngles(d, d2, d3);
    }

    protected void setRotationAngles(double d, double d2, double d3) {
        if (d >= 360.0) {
            d -= 360.0;
        }
        this.zrotAng = d;
        this.yrotAng = d2;
        this.xrotAng = d3;
        if (this.getTrueFalseParameter(false, "dump.rotang")) {
            System.out.println("Rot: zrotAng " + this.zrotAng + ", yrotAng " + this.yrotAng + ", xrotAng " + this.xrotAng);
        }
        this.setTextFields(this.zrotAng, this.yrotAng, this.xrotAng);
    }

    protected void setTextFields(double d, double d2, double d3) {
        if (this.textFieldAzimuth != null) {
            if (this.geogCoords != null) {
                d = -d - 90.0 + this.geogCoords.getRotationAngle();
            }
            if (!this.isGlobal) {
                d = -d + 90.0;
            }
            while (d > 360.0) {
                d -= 360.0;
            }
            while (d < -360.0) {
                d += 360.0;
            }
            this.textFieldAzimuth.setValue(d);
        }
        if (Math.abs(d2) < (double)1.4E-45f) {
            if (this.textFieldInclination != null) {
                d3 += 90.0;
                while (d3 > 180.0) {
                    d3 -= 360.0;
                }
                while (d3 < -180.0) {
                    d3 += 360.0;
                }
                this.textFieldInclination.setValue(d3);
            }
        } else if (this.textFieldInclination != null) {
            this.textFieldInclination.setValue(Double.NaN);
        }
    }

    protected double geogAz2rotAz(double d) {
        double d2 = 180.0;
        if (this.isGlobal) {
            d2 = 90.0;
        }
        double d3 = 0.0;
        if (this.geogCoords != null) {
            d3 = this.geogCoords.getRotationAngle();
        }
        double d4 = -(d + d2 + d3);
        if (!this.isGlobal) {
            d4 = -d4;
        }
        return d4;
    }

    protected double geogInc2rotInc(double d) {
        return d - 90.0;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n;
        boolean bl = true;
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewViewingToolbar)) {
            this.showViewingToolbar = this.menuItemCkBoxViewViewingToolbar.getState();
            this.redisplayFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemCkBoxViewSeismicityToolbar)) {
            this.showSeismicityToolbar = this.menuItemCkBoxViewSeismicityToolbar.getState();
            this.redisplayFrame();
            return;
        }
        if (itemEvent.getSource().equals(this.menuItemMagnitude)) {
            this.magnitudeFlag = this.menuItemMagnitude.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemProbDen)) {
            this.probDenFlag = this.menuItemProbDen.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemMaxLike)) {
            this.maxLikeFlag = this.menuItemMaxLike.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemExpect)) {
            this.expectFlag = this.menuItemExpect.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemEllipse)) {
            this.ellipseFlag = this.menuItemEllipse.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemFirstMotion)) {
            this.firstMotionFlag = this.menuItemFirstMotion.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemRay)) {
            this.rayFlag = this.menuItemRay.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemPresidual)) {
            this.PresidualFlag = this.menuItemPresidual.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemSresidual)) {
            this.SresidualFlag = this.menuItemSresidual.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemWeightsAll)) {
            this.weightsAllFlag = this.menuItemWeightsAll.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemStationName)) {
            this.stationNameFlag = this.menuItemStationName.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemStationSym)) {
            this.stationSymFlag = this.menuItemStationSym.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemFaultPlanes)) {
            this.faultPlanesFlag = this.menuItemFaultPlanes.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemPressureAxis)) {
            this.pressureAxisFlag = this.menuItemPressureAxis.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemNodalAxis)) {
            this.nodalAxisFlag = this.menuItemNodalAxis.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemSlipAxes)) {
            this.slipAxesFlag = this.menuItemSlipAxes.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemTensionAxis)) {
            this.tensionAxisFlag = this.menuItemTensionAxis.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemThrustOnly)) {
            this.thrustOnlyFlag = this.menuItemThrustOnly.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemNormalOnly)) {
            this.normalOnlyFlag = this.menuItemNormalOnly.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemStrikeSlipOnly)) {
            this.strikeSlipOnlyFlag = this.menuItemStrikeSlipOnly.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemViewGlobalTransparent)) {
            this.globalTransparent = this.menuItemViewGlobalTransparent.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemViewBuffer)) {
            this.bufferFlag = this.menuItemViewBuffer.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemViewQuickDraw)) {
            this.quickDrawFlag = this.menuItemViewQuickDraw.isSelected();
        } else if (itemEvent.getSource().equals(this.menuItemViewInvertCol)) {
            this.invertColorFlag = this.menuItemViewInvertCol.isSelected();
            if (this.invertColorFlag && !this.colorsInverted || !this.invertColorFlag && this.colorsInverted) {
                this.invertColors();
            }
        } else if (itemEvent.getSource().equals(this.menuItemLock2D)) {
            this.lock2DFlag = this.menuItemLock2D.isSelected();
            if (this.lock2DFlag) {
                this.setViewFromAbove();
            }
            this.layoutViewToolbar();
            this.setViewToolbarStates();
        } else {
            if (itemEvent.getSource().equals(this.menuItemFileRecordSnapshots)) {
                this.recordSnapshots = this.menuItemFileRecordSnapshots.isSelected();
                this.messageBackground = this.recordSnapshots ? MESSAGE_BACKGROUND_EMPHASIS : MESSAGE_BACKGROUND;
                this.messagePrefix = this.recordSnapshots ? SeismicityText.RECORDING_SNAPSHOTS + " - " + MESSAGE_PREFIX_PROG_NAME : MESSAGE_PREFIX_PROG_NAME;
                this.updateEventMessage();
                return;
            }
            bl = false;
        }
        for (n = 0; n < 15; ++n) {
            if (this.graphicLine[n] == null || !itemEvent.getSource().equals(this.graphicLineCkBox[n])) continue;
            this.graphicLineDraw[n] = this.graphicLineCkBox[n].isSelected();
            bl = true;
        }
        for (n = 0; n < this.graphicPolylineCkBox.length; ++n) {
            if (this.graphicPolyline[n] == null || !itemEvent.getSource().equals(this.graphicPolylineCkBox[n])) continue;
            this.graphicPolylineDraw[n] = this.graphicPolylineCkBox[n].isSelected();
            bl = true;
        }
        for (n = 0; n < this.graphicShapefileCkBox.length; ++n) {
            if (this.graphicShapefile[n] == null || !itemEvent.getSource().equals(this.graphicShapefileCkBox[n])) continue;
            this.graphicShapefileDraw[n] = this.graphicShapefileCkBox[n].isSelected();
            bl = true;
        }
        for (n = 0; n < this.graphicPolygonCkBox.length; ++n) {
            if (this.graphicPolygon[n] == null || !itemEvent.getSource().equals(this.graphicPolygonCkBox[n])) continue;
            this.graphicPolygonDraw[n] = this.graphicPolygonCkBox[n].isSelected();
            bl = true;
        }
        for (n = 0; n < this.graphicSymbolCkBox.length; ++n) {
            if (this.graphicSymbol[n] == null || !itemEvent.getSource().equals(this.graphicSymbolCkBox[n])) continue;
            this.graphicSymbolDraw[n] = this.graphicSymbolCkBox[n].isSelected();
            bl = true;
        }
        for (n = 0; n < this.sampleSetCkBox.length; ++n) {
            if (this.sampleSet[n] == null || !itemEvent.getSource().equals(this.sampleSetCkBox[n])) continue;
            this.sampleSetDraw[n] = this.sampleSetCkBox[n].isSelected();
            bl = true;
        }
        if (this.graphicTextURL != null && itemEvent.getSource().equals(this.graphicTextCkBox)) {
            this.graphicTextDraw = this.graphicTextCkBox.isSelected();
            bl = true;
        }
        if (itemEvent.getSource().equals(this.axes3DVisibleCkBox)) {
            this.axes3DVisible = this.axes3DVisibleCkBox.isSelected();
            bl = true;
        }
        if (itemEvent.getSource().equals(this.gridVisibleCkBox)) {
            if (this.grid3D != null) {
                this.grid3D.setVisible(this.gridVisibleCkBox.isSelected());
            }
            if (this.grid3DGlobal != null) {
                this.grid3DGlobal.setVisible(this.gridVisibleCkBox.isSelected());
            }
            bl = true;
        }
        if (itemEvent.getSource().equals(this.scalebarVisibleCkBox)) {
            if (this.grid3D != null) {
                this.grid3D.setScalebarVisible(this.scalebarVisibleCkBox.isSelected());
            }
            if (this.grid3DGlobal != null) {
                this.grid3DGlobal.setScalebarVisible(this.scalebarVisibleCkBox.isSelected());
            }
            bl = true;
        }
        if (itemEvent.getSource().equals(this.latlonVisibleCkBox)) {
            if (this.grid3D != null) {
                this.grid3D.setLatLonVisible(this.latlonVisibleCkBox.isSelected());
            }
            if (this.grid3DGlobal != null) {
                this.grid3DGlobal.setLatLonVisible(this.latlonVisibleCkBox.isSelected());
            }
            bl = true;
        }
        if (this.image2D != null && itemEvent.getSource().equals(this.allowDrawImage2DCkBox)) {
            this.allowDrawImage2D = this.allowDrawImage2DCkBox.isSelected();
            bl = true;
        }
        if (itemEvent.getSource().equals(this.menuItemHypAssoc)) {
            if (this.menuItemHypAssoc.isSelected()) {
                this.initHypocenterAssociation();
            }
            bl = true;
        }
        if (!bl) {
            return;
        }
        ++this.transformationIndex;
        this.updateEventViews();
    }

    protected void paintImage2D(Graphics graphics) {
        if (this.allowDrawImage2D && this.image2D != null) {
            if (this.image2D.type == Image2D.Type.VERTICAL) {
                this.image2D.paint(graphics, -this.zrotAng, this);
            } else if (Math.abs(this.yrotAng - 0.0) < 1.0E-4 && Math.abs(this.xrotAng - 0.0) < 1.0E-4 || !this.projectFlag && this.xrotAng > -90.0 && Math.abs(this.yrotAng - 0.0) < 1.0E-4 && Math.abs(this.zrotAng - 0.0) < 1.0E-4 || !this.projectFlag && this.yrotAng < 90.0 && Math.abs(this.xrotAng - 0.0) < 1.0E-4 && Math.abs(this.zrotAng - 0.0) < 1.0E-4) {
                this.image2D.paint(graphics, -this.zrotAng, this);
            }
        }
    }

    @Override
    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x20) != 0) {
            this.updateEventViews();
            return false;
        }
        return true;
    }

    protected void invertColors() {
        AJLColor.setInvertGreyScaleOnly(true);
        this.backgroundColor = AJLColor.invert(this.backgroundColor);
        Grid3D.invertColor();
        AJLColor.setInvertGreyScaleOnly(false);
        SeisEvent.invertColor(!this.colorsInverted);
        this.colorsInverted = !this.colorsInverted;
    }

    protected void openFile() {
        String[] stringArray;
        String string = null;
        if (this.eventFileNames != null && this.eventFileNames.length > 0) {
            string = this.eventFileNames[0];
        }
        if ((stringArray = URLChooser.doFileChooser(this, SeismicityText.OPEN_FILE_TOOLTIP, this.fileFilters, new AJLFileView(new ImageIcon(this.iconImageSmall), this.fileFilters), string, false, true, true)) != null && stringArray.length > 0) {
            this.eventFileNames = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.eventFileNames[i] = this.generateFileNames(stringArray[i]);
            }
            this.alternateTitleString = null;
            this.loadDataFiles();
        }
    }

    protected void openURL() {
        String string = null;
        if (this.eventFileNames != null && this.eventFileNames.length > 0) {
            string = this.eventFileNames[0];
        }
        URLChooser uRLChooser = new URLChooser(this.urlChooserComboBox, string, SeismicityText.OPEN_URL_TOOLTIP, SeismicityText.ENTER_DB_URL, SeismicityText.CHOOSE_FILE + "...", SeismicityText.OPEN, SeismicityText.CANCEL, true, false);
        uRLChooser.setFileFilters(this.fileFilters);
        int n = uRLChooser.showURLDialog(this);
        if (n != 0) {
            return;
        }
        String string2 = uRLChooser.getSelectedURL();
        if (string2 != null) {
            this.grid3DName = null;
            this.eventFileNames = new String[1];
            this.eventFileNames[0] = this.generateFileNames(string2);
            this.alternateTitleString = null;
            this.loadDataFiles();
        }
    }

    protected boolean setSearchFileNames() {
        String string = this.getParameter("search");
        if (string == null) {
            return false;
        }
        try {
            String[] stringArray = StringExt.parse(string, "#");
            EventSearchParameters eventSearchParameters = new EventSearchParameters(stringArray);
            this.grid3DName = null;
            this.eventFileNames = new String[1];
            this.eventFileNames[0] = eventSearchParameters.generateURLRequestString();
            this.eventFileType = EventSearchParameters.searchTypeName[eventSearchParameters.searchTypeIndex];
            System.out.println("Search URL request:");
            System.out.println(this.eventFileNames[0]);
            this.alternateTitleString = "Events from: \"" + EventSearchParameters.searchDescription[eventSearchParameters.searchTypeIndex] + "\" search";
            this.currentEventSearchParams = eventSearchParameters;
        }
        catch (Exception exception) {
            System.out.println("ERROR: reading search parameters: " + exception);
            if (PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected void openSearch() {
        EventSearchParameters eventSearchParameters;
        block3: {
            EventSearchDialog eventSearchDialog = new EventSearchDialog(this, new EventSearchParameters(this.currentEventSearchParams), SeismicityText.getLocaleString());
            SwingExt.setLocationToCenter(eventSearchDialog, this, this.getLocationOnScreen(), 0.1);
            eventSearchDialog.setVisible(true);
            eventSearchParameters = eventSearchDialog.getSearchParameters();
            eventSearchDialog.dispose();
            if (eventSearchParameters == null) {
                return;
            }
            this.grid3DName = null;
            this.eventFileNames = new String[1];
            try {
                this.eventFileNames[0] = eventSearchParameters.generateURLRequestString();
                this.eventFileType = EventSearchParameters.searchTypeName[eventSearchParameters.searchTypeIndex];
                System.out.println("Search URL request:");
                System.out.println(this.eventFileNames[0]);
            }
            catch (Exception exception) {
                System.out.println(exception);
                if (!PRINT_STACK_TRACES) break block3;
                exception.printStackTrace();
            }
        }
        this.alternateTitleString = "Events from: \"" + EventSearchParameters.searchDescription[eventSearchParameters.searchTypeIndex] + "\" search";
        this.reinitializeAll = false;
        this.loadDataFiles(false);
        this.currentEventSearchParams = eventSearchParameters;
    }

    protected void openGrid2GMTDialog() {
        if (this.grid2GMTInterface != null) {
            this.grid2GMTInterface.setVisible(true);
            this.grid2GMTInterface.toFront();
            return;
        }
        this.grid2GMTInterface = new Grid2GMTDialog(this, Grid2GMTDialog.staticGrid2GMTParams, SeismicityText.getLocaleString());
        SwingExt.setLocationToCenter(this.grid2GMTInterface, this, this.getLocationOnScreen(), -0.1);
        this.grid2GMTInterface.setVisible(true);
        this.grid2GMTInterface.toFront();
    }

    protected void doHelp() {
        if (this.helpFrame == null) {
            this.helpFrame = new HelpFrame(SeismicityText.HELP + " - Seismicity Viewer v" + VERSION, 2 * this.getSize().width / 3, 2 * this.getSize().height / 3, this.getClass(), this.getCodeBase(), "Seismicity_" + VERSION_CHAR, SeismicityText.getLocale(), this.iconImage);
            SwingExt.setLocationToCenter(this.helpFrame, this, this.getLocationOnScreen());
            this.helpFrame.setVisible(true);
        } else {
            this.helpFrame.setVisible(true);
        }
    }

    protected void loadDataFiles() {
        this.loadDataFiles(true);
    }

    protected void loadDataFiles(boolean bl) {
        if (bl) {
            this.setWorldCenterPoint(null);
            this.setInitialRotationAngles(this.geogAz2rotAz(200.0), 0.0, this.geogInc2rotInc(30.0));
            this.setGlobalWorldWidthMax(Double.MAX_VALUE);
            try {
                double d;
                this.initalZoom = d = Double.parseDouble(this.getParameter("init.zoom"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.dataRead = false;
        this.displayFrame();
        if (!this.errorFlag) {
            new Thread(this).start();
            this.writeMessage("Started...");
        }
    }

    protected String generateFileNames(String string) {
        String string2 = string;
        this.grid3DName = this.getParameter("grid");
        if (string != null) {
            String string3 = null;
            if (string.endsWith(".hdr")) {
                string3 = string.substring(0, string.lastIndexOf(".hdr"));
                string2 = string3 + ".hyp";
            } else if (string.endsWith(".hyp")) {
                string3 = string.substring(0, string.lastIndexOf(".hyp"));
                string2 = string;
            } else if (string.endsWith(".jbin")) {
                string3 = string.substring(0, string.lastIndexOf(".jbin"));
                string2 = string;
            }
            if (this.grid3DName == null && string3 != null && this.grid3DName == null) {
                this.grid3DName = string3 + ".hdr";
            }
        }
        return string2;
    }

    @Override
    public boolean paintNextFrame(int n, long l) {
        boolean bl = false;
        if (!this.panel3D.painted) {
            return false;
        }
        bl = n == 0 ? this.incrementSample() : this.decrementSample();
        this.updateEventViews();
        return bl;
    }

    protected boolean incrementSample() {
        if (this.eventPlotLast < this.seisEventList.size() - 1) {
            this.eventPlotFirst = ++this.eventPlotLast;
            return false;
        }
        this.eventPlotLast = 0;
        this.eventPlotFirst = 0;
        return true;
    }

    protected boolean decrementSample() {
        if (this.eventPlotFirst > 0) {
            this.eventPlotFirst = this.eventPlotLast = this.eventPlotFirst - 1;
            return false;
        }
        this.eventPlotFirst = this.eventPlotLast = this.seisEventList.size() - 1;
        return true;
    }

    protected void startAnimatorThread(int n, int n2) {
        if (this.seisEventList.size() < 2) {
            return;
        }
        this.eventPlotFirst = this.eventPlotLast = n2;
        this.buttonPlotAuto.setText(this.pauseButtonLabel);
        if (this.animatorThread != null && this.animatorThread.isAlive()) {
            this.animatorThread.setDirection(n);
            this.animatorThread.pause(false);
            this.animatorThreadSuspended = false;
            return;
        }
        int n3 = 10000 / this.seisEventList.size();
        if (n3 < 1) {
            n3 = 1;
        }
        if (n3 > 500) {
            n3 = 500;
        }
        this.animatorThread = new Animator(this, n, n3, 1000);
        this.animatorThread.setPriority(1);
        this.animatorThread.start();
        this.animatorThreadSuspended = false;
    }

    protected void suspendAnimatorThread() {
        if (this.animatorThread != null && this.animatorThread.isAlive()) {
            if (this.animatorThreadSuspended) {
                this.animatorThread.pause(false);
                this.buttonPlotAuto.setText(this.pauseButtonLabel);
            } else {
                this.animatorThread.pause(true);
                this.buttonPlotAuto.setText(this.runButtonLabel);
            }
        }
        this.animatorThreadSuspended = !this.animatorThreadSuspended;
    }

    protected void killAnimatorThread() {
        this.animatorThreadSuspended = true;
        this.buttonPlotAuto.setText("Run     >>");
        if (this.animatorThread == null) {
            return;
        }
        this.animatorThread.stopRunning();
        this.updateEventViews();
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    protected Grid3D getGrid3D() {
        return this.grid3D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData() {
        InputStream inputStream;
        block413: {
            this.fullyInitialized = false;
            this.errorFlag = false;
            this.haveFocalMechanisms = false;
            this.grid3DGlobal = null;
            this.hypocenterAssociation = null;
            inputStream = null;
            try {
                Object object;
                ASCIIInputStream aSCIIInputStream;
                double d;
                block414: {
                    int n;
                    int n2;
                    double d2;
                    double d3;
                    double d4;
                    Object object2;
                    Object object3;
                    Object object4;
                    Color color;
                    Object object5;
                    block400: {
                        Object object6;
                        int n3;
                        int n4;
                        String string;
                        OutputStream outputStream;
                        int n5;
                        String string2;
                        Thread.currentThread().setPriority(1);
                        this.textDensity = 1.5;
                        if (this.getParameter("text.density") != null) {
                            try {
                                this.textDensity = Double.parseDouble(this.getParameter("text.density"));
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: : " + exception);
                                if (PRINT_STACK_TRACES) {
                                    exception.printStackTrace();
                                }
                                this.textDensity = 1.5;
                            }
                        }
                        try {
                            string2 = this.getParameter("color.background");
                            if (string2 != null) {
                                this.backgroundColor = SeismicityColors.createColor(string2);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: : " + exception);
                            if (PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                            this.backgroundColor = Color.black;
                        }
                        if (this.reinitializeAll) {
                            this.grid3D = null;
                            this.globalCenter = null;
                            if (this.grid3DName != null && this.grid3DName.length() > 0) {
                                try {
                                    block392: {
                                        try {
                                            inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), this.grid3DName, true);
                                            this.grid3D = new Grid3DRectangular(inputStream, this, this.globalCenter);
                                        }
                                        catch (Exception exception) {
                                            if (this.eventFileNames == null || this.eventFileNames.length <= 0) break block392;
                                            try {
                                                inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), this.eventFileNames[0], true);
                                                this.grid3D = new Grid3DRectangular(inputStream, this, this.globalCenter, true);
                                            }
                                            catch (Exception exception2) {
                                                throw exception;
                                            }
                                        }
                                    }
                                    string2 = this.getParameter("grid.zlimits.spaced");
                                    ((Grid3DRectangular)this.grid3D).setDrawZCoords(this.getTrueFalseParameter(true, "grid.zlimits.south"), this.getTrueFalseParameter(true, "grid.zlimits.east"), string2 != null, string2);
                                    if (this.grid3D.geogCoords != null) {
                                        this.geogCoords = this.grid3D.geogCoords;
                                    }
                                    this.globalTransparent = true;
                                    this.graphicLineURL[13] = null;
                                    this.graphicLineURL[14] = null;
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: ERROR: reading grid file: " + this.grid3DName);
                                    System.out.println(exception);
                                    if (PRINT_STACK_TRACES) {
                                        exception.printStackTrace();
                                    }
                                }
                                finally {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            if (this.grid3D == null || this.geogCoords != null && this.geogCoords.transformType == 1) {
                                if (this.grid3D != null && !this.grid3D.getIsWholeEarth()) {
                                    this.grid3DGlobal = this.grid3D;
                                }
                                this.isGlobal = true;
                                this.globalCenter = new Vect3D(0.0, 0.0, 0.0);
                                this.globalTransparent = false;
                                this.geogCoords = new GeogCoords();
                                this.grid3D = new Grid3DGlobal(this, this.geogCoords);
                                if (globalCoastlineName != null) {
                                    if (!globalCoastlineName.equalsIgnoreCase("NONE")) {
                                        this.graphicLineURL[13] = globalCoastlineName;
                                    }
                                } else {
                                    try {
                                        this.graphicLineURL[13] = this.getClass().getResource(globalCoastlineNameDefault).toString();
                                        if (!this.givenGlobalLineCredits) {
                                            System.out.println("Coastlines from:");
                                        }
                                        System.out.println("   Paul Wessel and Walter H. F. Smith, GMT - The Generic Mapping Tool");
                                        System.out.println("   http://gmt.soest.hawaii.edu/");
                                    }
                                    catch (Exception exception) {
                                        this.graphicLineURL[13] = null;
                                    }
                                }
                                if (globalPlateBoundaryName != null) {
                                    if (!globalPlateBoundaryName.equalsIgnoreCase("NONE")) {
                                        this.graphicLineURL[14] = globalPlateBoundaryName;
                                    }
                                } else {
                                    try {
                                        this.graphicLineURL[14] = this.getClass().getResource(globalPlateBoundaryNameDefault).toString();
                                        if (!this.givenGlobalLineCredits) {
                                            System.out.println("Plate boundaries from:" + NEWLINE + "   Coffin, M.F., Gahagan, L.M., and Lawver, L.A., 1998," + NEWLINE + "   Present-day Plate Boundary Digital Data Compilation. " + NEWLINE + "   University of Texas Institute for Geophysics Technical Report No. 174, pp. 5.");
                                        }
                                    }
                                    catch (Exception exception) {
                                        this.graphicLineURL[14] = null;
                                    }
                                }
                                this.givenGlobalLineCredits = true;
                            } else {
                                this.isGlobal = false;
                            }
                            if (this.grid3D != null) {
                                this.grid3D.setVisible(this.gridVisibleCkBox.isSelected());
                                this.grid3D.setScalebarVisible(this.scalebarVisibleCkBox.isSelected());
                                this.grid3D.setLatLonVisible(this.latlonVisibleCkBox.isSelected());
                                if (this.getTrueFalseParameter(false, "dump.latlon")) {
                                    string2 = "sv_dump_grid.latlon";
                                    FilterOutputStream filterOutputStream = null;
                                    try {
                                        OutputStream outputStream2 = GeneralOutputStream.openStream(null, string2);
                                        filterOutputStream = new ASCIIOutputStream(outputStream2);
                                        int n6 = this.grid3D.printLatLong((ASCIIOutputStream)filterOutputStream, this.geogCoords);
                                        ((BufferedOutputStream)filterOutputStream).flush();
                                        filterOutputStream.close();
                                        System.out.println("SeismicityViewer: INFO: " + n6 + " lat/lon/depth segments written to " + string2);
                                    }
                                    catch (Exception exception) {
                                        System.out.println("SeismicityViewer: ERROR: opening or writing dump.latlon file: " + string2);
                                        if (PRINT_STACK_TRACES) {
                                            exception.printStackTrace();
                                        }
                                    }
                                    finally {
                                        try {
                                            filterOutputStream.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                            if (this.grid3DGlobal != null) {
                                this.grid3DGlobal.setVisible(this.gridVisibleCkBox.isSelected());
                                this.grid3DGlobal.setScalebarVisible(this.scalebarVisibleCkBox.isSelected());
                            }
                            this.setViewToolbarStates();
                            this.initializeView();
                            this.setPlotingScale(this.panel3D.getSize());
                            this.seisEventFilter.setLimits();
                        }
                        if (this.reinitializeAll) {
                            this.stationList = new Vector();
                            this.seisEventList = new SeisEventList(this);
                        }
                        SeisEvent.reseedRansom();
                        if (this.eventFileNames != null) {
                            for (int i = 0; i < this.eventFileNames.length; ++i) {
                                int n7;
                                block395: {
                                    this.writeMessage("Reading event location file: " + this.eventFileNames[i] + "...");
                                    try {
                                        this.getEvents(this.eventFileNames[i]);
                                    }
                                    catch (Exception exception) {
                                        this.writeMessage(exception.getMessage());
                                        if (!PRINT_STACK_TRACES) break block395;
                                        exception.printStackTrace();
                                    }
                                }
                                if (this.eventFileNames[i] != null && (n7 = URLChooser.getIndexInComboBox(this.urlChooserComboBox, this.eventFileNames[i])) < 0) {
                                    this.urlChooserComboBox.insertItemAt(this.eventFileNames[i], 0);
                                }
                                if (this.seisEventList.size() <= 0 || !this.eventFileNames[i].contains(".hyp")) continue;
                                this.getNLLStations(this.eventFileNames[i].replace(".hyp", ".stations"), this.seisEventList.lastElement().eventGeogCoords);
                            }
                        }
                        double d5 = 0.0;
                        double d6 = 3.4028234663852886E38;
                        double d7 = -3.4028234663852886E38;
                        for (n5 = 0; n5 < this.seisEventList.size(); ++n5) {
                            double d8;
                            SeisEvent seisEvent = (SeisEvent)this.seisEventList.get(n5);
                            if (seisEvent.focalMech != null) {
                                this.haveFocalMechanisms = true;
                            }
                            if (seisEvent.hypocenter == null || !((d8 = seisEvent.hypocenter.getValue()) > -9.0)) continue;
                            d5 += d8;
                            d6 = d8 < d6 ? d8 : d6;
                            d7 = d8 > d7 ? d8 : d7;
                        }
                        if (this.seisEventList.size() > 0) {
                            d5 /= (double)this.seisEventList.size();
                            this.magSymbolMinimumMag = d6;
                            this.magSymbolMaximumMag = d7;
                        }
                        this.eventPlotFirst = 0;
                        this.eventPlotLast = this.initPlotFirstFlag ? 0 : this.seisEventList.size() - 1;
                        n5 = this.getTrueFalseParameter(false, "dump.events.csv") ? 1 : 0;
                        boolean bl = this.getTrueFalseParameter(false, "dump.events.csv.compact");
                        if (n5 != 0 || bl) {
                            String string3 = n5 != 0 ? "events.csv" : "events.compact.csv";
                            object5 = null;
                            try {
                                outputStream = GeneralOutputStream.openStream(null, string3);
                                object5 = new ASCIIOutputStream(outputStream);
                                string = System.getProperty("line.separator");
                                if (n5 != 0) {
                                    ((ASCIIOutputStream)object5).writeWord(SeisEvent.toStringCsvHeader() + string);
                                } else {
                                    ((ASCIIOutputStream)object5).writeWord(SeisEvent.toStringCsvCompactHeader() + string);
                                }
                                n4 = 0;
                                for (n3 = this.eventPlotFirst; n3 < this.eventPlotLast + 1; ++n3) {
                                    object6 = (SeisEvent)this.seisEventList.get(n3);
                                    if (n5 != 0) {
                                        ((ASCIIOutputStream)object5).writeWord(((SeisEvent)object6).toStringCsv() + string);
                                        continue;
                                    }
                                    ((ASCIIOutputStream)object5).writeWord(((SeisEvent)object6).toStringCsvCompact() + string);
                                }
                                ((BufferedOutputStream)object5).flush();
                                ((FilterOutputStream)object5).close();
                                System.out.println("SeismicityViewer: INFO: csv event listing written to " + string3);
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: ERROR: opening or writing dump.events.csv file: " + string3);
                                if (PRINT_STACK_TRACES) {
                                    exception.printStackTrace();
                                }
                            }
                            finally {
                                try {
                                    ((FilterOutputStream)object5).close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (this.getTrueFalseParameter(false, "dump.events.xyz")) {
                            String string4 = "events.xyz";
                            object5 = null;
                            try {
                                outputStream = GeneralOutputStream.openStream(null, string4);
                                object5 = new ASCIIOutputStream(outputStream);
                                string = System.getProperty("line.separator");
                                n4 = 0;
                                for (n3 = this.eventPlotFirst; n3 < this.eventPlotLast + 1; ++n3) {
                                    object6 = (SeisEvent)this.seisEventList.get(n3);
                                    ((ASCIIOutputStream)object5).writeWord(((SeisEvent)object6).toStringXYZ() + string);
                                }
                                ((BufferedOutputStream)object5).flush();
                                ((FilterOutputStream)object5).close();
                                System.out.println("SeismicityViewer: INFO: xyz event listing written to " + string4);
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: ERROR: opening or writing dump.events.xyz file: " + string4);
                                if (PRINT_STACK_TRACES) {
                                    exception.printStackTrace();
                                }
                            }
                            finally {
                                try {
                                    ((FilterOutputStream)object5).close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (this.getTrueFalseParameter(false, "dump.events.otlonlatdepmag")) {
                            String string5 = "events.otlonlatdepmag.txt";
                            object5 = null;
                            try {
                                outputStream = GeneralOutputStream.openStream(null, string5);
                                object5 = new ASCIIOutputStream(outputStream);
                                string = System.getProperty("line.separator");
                                n4 = 0;
                                for (n3 = this.eventPlotFirst; n3 < this.eventPlotLast + 1; ++n3) {
                                    object6 = (SeisEvent)this.seisEventList.get(n3);
                                    ((ASCIIOutputStream)object5).writeWord(((SeisEvent)object6).toStringSimpleLonLatTimeDepthMagnitude() + string);
                                }
                                ((BufferedOutputStream)object5).flush();
                                ((FilterOutputStream)object5).close();
                                System.out.println("SeismicityViewer: INFO: otlonlatdepmag event listing written to " + string5);
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: ERROR: opening or writing dump.events.otlonlatdepmag file: " + string5);
                                if (PRINT_STACK_TRACES) {
                                    exception.printStackTrace();
                                }
                            }
                            finally {
                                try {
                                    ((FilterOutputStream)object5).close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (this.getTrueFalseParameter(false, "dump.stats.totcorr")) {
                            String string6 = "events.stat_totcorr";
                            object5 = null;
                            try {
                                outputStream = GeneralOutputStream.openStream(null, string6);
                                object5 = new ASCIIOutputStream(outputStream);
                                string = System.getProperty("line.separator");
                                String string7 = "#Total Phase Corrections (CalcResidual + InputDelay)  RMS_Max: " + (this.seisEventFilter.rmsLimits == null ? 1000000.0 : (double)((float)this.seisEventFilter.rmsLimits[1])) + "  NRdgs_Min: " + (this.seisEventFilter.nPhsLimits == null ? 1000000.0 : (double)this.seisEventFilter.nPhsLimits[0]) + "  Gap_Max: " + (this.seisEventFilter.gapLimits == null ? 1000000.0 : (double)((float)this.seisEventFilter.gapLimits[1])) + "  P_Res_Max: 1e6  S_Res_Max: 1e6  Ell_Len3_Max: " + (this.seisEventFilter.ellSe3Limits == null ? 1000000.0 : (double)((float)this.seisEventFilter.ellSe3Limits[1])) + "  Hypo_Depth_Min: " + (this.seisEventFilter.hypoLimits == null ? 1000000.0 : (double)((float)this.seisEventFilter.hypoLimits[0].z)) + "  Hypo_Depth_Max: " + (this.seisEventFilter.hypoLimits == null ? 1000000.0 : (double)((float)this.seisEventFilter.hypoLimits[1].z)) + "  Hypo_Dist_Max: " + (this.seisEventFilter.distLimits == null ? 1000000.0 : (double)((float)this.seisEventFilter.distLimits[1])) + "";
                                ((ASCIIOutputStream)object5).writeWord(string7 + string);
                                ((ASCIIOutputStream)object5).writeWord("#         ID      Phase   Nres      TotCorr      StdDev" + string);
                                for (n4 = 0; n4 < this.stationList.size(); ++n4) {
                                    object6 = this.stationList.get(n4);
                                    if (((SeisStation)object6).residualStatsP.getN() > 0) {
                                        ((ASCIIOutputStream)object5).writeWord("LOCDELAY  " + ((SeisStation)object6).label + " P  " + ((SeisStation)object6).residualStatsP.getN() + "  " + (float)((SeisStation)object6).residualStatsP.getMean() + "  " + (float)((SeisStation)object6).residualStatsP.getStdDev() + string);
                                    }
                                    if (((SeisStation)object6).residualStatsS.getN() <= 0) continue;
                                    ((ASCIIOutputStream)object5).writeWord("LOCDELAY  " + ((SeisStation)object6).label + " S  " + ((SeisStation)object6).residualStatsS.getN() + "  " + (float)((SeisStation)object6).residualStatsS.getMean() + "  " + (float)((SeisStation)object6).residualStatsS.getStdDev() + string);
                                }
                                ((BufferedOutputStream)object5).flush();
                                ((FilterOutputStream)object5).close();
                                System.out.println("SeismicityViewer: INFO: dump.stats.totcorr listing written to " + string6);
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: ERROR: opening or writing dump.stats.totcorr file: " + string6);
                                if (PRINT_STACK_TRACES) {
                                    exception.printStackTrace();
                                }
                            }
                            finally {
                                try {
                                    ((FilterOutputStream)object5).close();
                                }
                                catch (Exception exception) {}
                            }
                        }
                        if (!this.reinitializeAll) {
                            this.fullyInitialized = true;
                            this.reinitializeAll = true;
                            return;
                        }
                        color = Color.gray;
                        try {
                            object5 = this.getParameter("color.grid");
                            if (object5 != null) {
                                color = SeismicityColors.createColor((String)object5);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: : " + exception);
                            if (!PRINT_STACK_TRACES) break block400;
                            exception.printStackTrace();
                        }
                    }
                    object5 = null;
                    double d9 = Double.NaN;
                    double d10 = Double.NaN;
                    double d11 = 0.0;
                    double d12 = 1.0;
                    double d13 = 3.0;
                    double d14 = 90.0;
                    String string = this.getParameter("grid.scale.pos");
                    if (string != null) {
                        try {
                            String[] stringArray = StringExt.parse(string, ",");
                            d9 = Double.valueOf(stringArray[0]);
                            d10 = Double.valueOf(stringArray[1]);
                            d12 = Double.valueOf(stringArray[2]);
                            d13 = Double.valueOf(stringArray[3]);
                            if (stringArray.length > 4) {
                                d14 = Double.valueOf(stringArray[4]);
                            }
                            if (stringArray.length > 5) {
                                d11 = Double.valueOf(stringArray[5]);
                            }
                            object5 = new Vect3D(d9, d10, d11);
                        }
                        catch (Exception exception) {
                            d9 = 0.9;
                            d10 = 0.05;
                        }
                    }
                    double d15 = this.isGlobal ? 10.0 : 1.0;
                    try {
                        d15 = Double.parseDouble(this.getParameter("grid.latlonstep"));
                    }
                    catch (Exception exception) {
                        try {
                            d15 = Double.parseDouble(this.getParameter("grid.global.latlonstep"));
                        }
                        catch (Exception exception3) {
                            d15 = this.isGlobal ? 10.0 : 1.0;
                        }
                    }
                    String string8 = null;
                    string8 = this.getParameter("grid.latlontext");
                    if (string8 == null) {
                        string8 = this.getParameter("grid.global.latlontext");
                    }
                    String string9 = null;
                    string9 = this.getParameter("grid.latlon.depth");
                    boolean bl = this.getTrueFalseParameter(false, "grid.latlon.ticsonly");
                    boolean bl2 = this.getTrueFalseParameter(false, "grid.latlon.clip");
                    this.latlonClipEvents = this.getTrueFalseParameter(false, "grid.latlon.clip.events");
                    boolean bl3 = this.getTrueFalseParameter(false, "grid.latlon.clip.depth");
                    MapObjects.setClipLatLonBoundsLine3D(this.grid3D.getClipLatLonBoundsLine3D(), bl3);
                    String string10 = this.getParameter("horizontalscale");
                    if (string10 != null) {
                        object4 = new Vect3D(0.0, 0.0, 1.0);
                        try {
                            object3 = StringExt.parse(string10, ",");
                            double d16 = Double.valueOf(object3[0]);
                            double d17 = Double.valueOf(object3[1]);
                            double d18 = Double.valueOf(object3[2]);
                            object2 = new Vect3D(d16, d17, d18);
                            d4 = Double.valueOf(object3[3]);
                            d3 = Double.valueOf(object3[4]);
                            d2 = Double.valueOf(object3[5]);
                            double d19 = Double.valueOf(object3[6]);
                            double d20 = Double.valueOf(object3[7]);
                            double d21 = Double.valueOf(object3[8]);
                            boolean bl4 = !object3[3].contains(".") && !object3[4].contains(".") && !object3[5].contains(".");
                            this.grid3D.createHorizontalScale((Vect3D)object2, d4, d3, d2, d19, d20, d21, (Vect3D)object4, bl4);
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: parsing parameter horizontalscale");
                        }
                    }
                    if ((object4 = this.getParameter("grid.azscale.pos")) != null) {
                        object3 = new Vect3D(0.0, 0.0, 1.0);
                        try {
                            String[] stringArray = StringExt.parse((String)object4, ",");
                            double d22 = Double.valueOf(stringArray[0]);
                            double d23 = Double.valueOf(stringArray[1]);
                            double d24 = Double.valueOf(stringArray[2]);
                            d4 = Double.valueOf(stringArray[3]);
                            d3 = Double.valueOf(stringArray[4]);
                            d2 = Double.valueOf(stringArray[5]);
                            Vect3D vect3D = new Vect3D(d22, d23, d24);
                            this.grid3D.createVectScaleBar(this.pix2WorldScale, vect3D, d4, d3, d2, (Vect3D)object3);
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: parsing parameter grid.azscale.pos");
                        }
                    }
                    this.grid3D.initialize(this.pix2WorldScale, this.globalCenter, (Vect3D)object5, color, d12, d13, d14, string8, string9, d15, bl, bl2);
                    if (this.grid3DGlobal != null) {
                        this.grid3DGlobal.initialize(this.pix2WorldScale, this.globalCenter, (Vect3D)object5, color, d12, d13, d14, string8, string9, d15, bl, bl2);
                    }
                    boolean bl5 = true;
                    bl5 = true;
                    for (n2 = 0; n2 < 15; ++n2) {
                        this.graphicLine[n2] = null;
                        this.graphicLineDraw[n2] = false;
                        if (this.graphicLineURL[n2] == null) continue;
                        this.writeMessage("Reading graphic line file: " + this.graphicLineURL[n2] + "...");
                        if (n2 >= 13) {
                            bl5 = true;
                        }
                        try {
                            inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), this.graphicLineURL[n2], true);
                            this.graphicLine[n2] = new MapLines(inputStream, this.graphicLineURL[n2], this.graphicLineCkBoxStr[n2], this.geogCoords, this.graphicLineColor[n2], AJLStroke.defaultStroke, this.globalCenter, bl5);
                            this.graphicLineDraw[n2] = true;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: opening or reading file: " + this.graphicLineURL[n2]);
                            if (PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                            this.graphicLineURL[n2] = null;
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (!this.getTrueFalseParameter(false, "dump.latlon")) continue;
                        String string11 = this.graphicLineURL[n2] + ".latlon";
                        FilterOutputStream filterOutputStream = null;
                        try {
                            OutputStream outputStream = GeneralOutputStream.openStream(null, string11);
                            filterOutputStream = new ASCIIOutputStream(outputStream);
                            int n8 = this.graphicLine[n2].printLatLong((ASCIIOutputStream)filterOutputStream, this.geogCoords);
                            ((BufferedOutputStream)filterOutputStream).flush();
                            filterOutputStream.close();
                            System.out.println("SeismicityViewer: INFO: " + n8 + " lat/lon/depth segments written to " + string11);
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: opening or writing dump.latlon file: " + string11);
                            if (!PRINT_STACK_TRACES) continue;
                            exception.printStackTrace();
                            continue;
                        }
                        finally {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    bl5 = true;
                    for (n2 = 0; n2 < this.graphicPolylineURL.length; ++n2) {
                        Object object7;
                        this.graphicPolyline[n2] = null;
                        this.graphicPolylineDraw[n2] = false;
                        if (this.graphicPolylineURL[n2] == null) continue;
                        this.writeMessage("Reading graphic polyline file: " + this.graphicPolylineURL[n2] + "...");
                        String string12 = null;
                        try {
                            Color color2;
                            String string13;
                            block402: {
                                object7 = StringExt.parse(this.graphicPolylineURL[n2], ";");
                                if (object7 == null || ((String[])object7).length < 1) {
                                    System.out.println("SeismicityViewer: WARNING: empty line.N parameter string: lines." + n2 + ": " + this.graphicPolylineURL[n2]);
                                    continue;
                                }
                                string12 = object7[0];
                                string13 = "SOLID";
                                if (((String[])object7).length > 1) {
                                    string13 = object7[1];
                                }
                                color2 = Color.white;
                                try {
                                    if (((String[])object7).length > 2) {
                                        color2 = SeismicityColors.createColor(object7[2]);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: : " + exception);
                                    if (!PRINT_STACK_TRACES) break block402;
                                    exception.printStackTrace();
                                }
                            }
                            String string14 = "1.0";
                            if (((String[])object7).length > 3) {
                                string14 = object7[3];
                            }
                            object2 = AJLStroke.defaultStroke;
                            try {
                                int n9 = 1;
                                int n10 = 1;
                                float f = 10.0f;
                                object2 = SeismicityStrokes.createStroke(string14, string13, n9, n10, f);
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: : " + exception);
                            }
                            this.graphicPolylineCkBoxStr[n2] = ((String[])object7).length > 4 ? object7[4] : "Polylines (" + object7[1] + ";" + object7[2] + ";" + object7[3] + ")";
                            try {
                                this.graphicPolylineCkBox[n2].setText(this.graphicPolylineCkBoxStr[n2]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string12, true);
                            this.graphicPolyline[n2] = new MapLines(inputStream, this.graphicPolylineURL[n2], this.graphicPolylineCkBoxStr[n2], this.geogCoords, color2, (BasicStroke)object2, this.globalCenter, bl5);
                            this.graphicPolylineDraw[n2] = true;
                        }
                        catch (IOException iOException) {
                            System.out.println("SeismicityViewer: ERROR: opening or reading file: " + string12);
                            System.out.println(iOException);
                            if (PRINT_STACK_TRACES) {
                                iOException.printStackTrace();
                            }
                            this.graphicPolylineURL[n2] = null;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: parsing line.N parameter string: line." + n2 + ": " + this.graphicPolylineURL[n2]);
                            System.out.println(exception);
                            if (PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                            this.graphicPolylineURL[n2] = null;
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (!this.getTrueFalseParameter(false, "dump.latlon")) continue;
                        object7 = string12 + ".latlon";
                        FilterOutputStream filterOutputStream = null;
                        try {
                            OutputStream outputStream = GeneralOutputStream.openStream(null, (String)object7);
                            filterOutputStream = new ASCIIOutputStream(outputStream);
                            int n11 = this.graphicPolyline[n2].printLatLong((ASCIIOutputStream)filterOutputStream, this.geogCoords);
                            ((BufferedOutputStream)filterOutputStream).flush();
                            System.out.println("SeismicityViewer: INFO: " + n11 + " lat/lon/depth segments written to " + (String)object7);
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: opening or writing dump.latlon file: " + (String)object7);
                            if (!PRINT_STACK_TRACES) continue;
                            exception.printStackTrace();
                            continue;
                        }
                        finally {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    bl5 = true;
                    for (n2 = 0; n2 < this.graphicShapefileURL.length; ++n2) {
                        this.graphicShapefile[n2] = null;
                        this.graphicShapefileDraw[n2] = false;
                        if (this.graphicShapefileURL[n2] == null) continue;
                        this.writeMessage("Reading shapefile: " + this.graphicShapefileURL[n2] + "...");
                        String string15 = null;
                        try {
                            Color color3;
                            String[] stringArray;
                            block404: {
                                stringArray = StringExt.parse(this.graphicShapefileURL[n2], ";");
                                string15 = stringArray[0];
                                color3 = Color.white;
                                try {
                                    if (stringArray.length > 1) {
                                        color3 = SeismicityColors.createColor(stringArray[1]);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: : " + exception);
                                    if (!PRINT_STACK_TRACES) break block404;
                                    exception.printStackTrace();
                                }
                            }
                            String string16 = "SOLID_BORDER";
                            if (stringArray.length > 2) {
                                string16 = stringArray[2];
                            }
                            String string17 = "NO_FILL";
                            if (stringArray.length > 3) {
                                string17 = stringArray[3];
                            }
                            object2 = "FILLED_SPHERE";
                            if (stringArray.length > 4) {
                                object2 = stringArray[4];
                            }
                            d4 = 1.0;
                            if (stringArray.length > 5) {
                                try {
                                    d4 = Double.valueOf(stringArray[5]);
                                }
                                catch (Exception exception) {
                                    d4 = 10.0;
                                }
                            }
                            int n12 = 6;
                            double d25 = Double.NaN;
                            if (stringArray.length > n12) {
                                try {
                                    d25 = -Double.valueOf(stringArray[n12]).doubleValue();
                                    ++n12;
                                }
                                catch (Exception exception) {
                                    d25 = Double.NaN;
                                }
                            }
                            this.graphicShapefileCkBoxStr[n2] = stringArray.length > n12 ? stringArray[n12] : "Polygons (" + stringArray[1] + ";" + stringArray[2] + ")";
                            try {
                                this.graphicShapefileCkBox[n2].setText(this.graphicShapefileCkBoxStr[n2]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            URL uRL = GeneralURLConnection.createURL(this.getDocumentBase(), string15);
                            try {
                                this.graphicShapefile[n2] = new MapShapefile(uRL, this.graphicShapefileCkBoxStr[n2], this.geogCoords, color3, string17, string16, (String)object2, d4, d4, this.globalCenter, bl5, d25, this.clipShapefileBoundingBox3D);
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                System.out.println(noClassDefFoundError);
                            }
                            this.graphicShapefileDraw[n2] = true;
                            continue;
                        }
                        catch (IOException iOException) {
                            System.out.println("SeismicityViewer: ERROR: opening or reading shapefile: " + string15 + ": " + iOException);
                            System.out.println(iOException);
                            if (PRINT_STACK_TRACES) {
                                iOException.printStackTrace();
                            }
                            this.graphicShapefileURL[n2] = null;
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: parsing shapefile parameter: " + this.graphicShapefileURL[n2] + ": " + exception);
                            System.out.println(exception);
                            if (PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                            this.graphicShapefileURL[n2] = null;
                        }
                    }
                    bl5 = true;
                    try {
                        Symbol3D.setCiclePolygonNumSides(Integer.parseInt(this.getParameter("symbols.circle.numsides")));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    for (n = 0; n < this.graphicPolygonURL.length; ++n) {
                        Object object8;
                        this.graphicPolygon[n] = null;
                        this.graphicPolygonDraw[n] = false;
                        if (this.graphicPolygonURL[n] == null) continue;
                        this.writeMessage("Reading graphic polygon file: " + this.graphicPolygonURL[n] + "...");
                        String string18 = null;
                        int n13 = 0;
                        try {
                            String string19;
                            String string20;
                            block405: {
                                object8 = StringExt.parse(this.graphicPolygonURL[n], ";");
                                string18 = object8[n13];
                                string20 = "SOLID_BORDER";
                                if (((String[])object8).length > ++n13) {
                                    string20 = object8[n13];
                                }
                                string19 = "NO_FILL";
                                if (((String[])object8).length > ++n13) {
                                    string19 = object8[n13];
                                }
                                ++n13;
                                object2 = Color.white;
                                try {
                                    if (((String[])object8).length > n13) {
                                        object2 = SeismicityColors.createColor(object8[n13]);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: : " + exception);
                                    if (!PRINT_STACK_TRACES) break block405;
                                    exception.printStackTrace();
                                }
                            }
                            ++n13;
                            BasicStroke basicStroke = AJLStroke.defaultStroke;
                            String string21 = "1.0";
                            try {
                                string21 = object8[n13];
                                d3 = Double.valueOf(string21);
                                try {
                                    int n14 = 2;
                                    int n15 = 0;
                                    float f = 10.0f;
                                    basicStroke = SeismicityStrokes.createStroke(string21, "SOLID", n14, n15, f);
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: : " + exception);
                                }
                                ++n13;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.graphicPolygonCkBoxStr[n] = ((String[])object8).length > n13 ? object8[n13] : "Polygons (" + object8[1] + ";" + object8[2] + ")";
                            try {
                                this.graphicPolygonCkBox[n].setText(this.graphicPolygonCkBoxStr[n]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n13;
                            boolean bl6 = false;
                            try {
                                bl6 = ((String[])object8).length > n13 ? object8[n13].equalsIgnoreCase("USE_FOR_XY_CLIP") : false;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            boolean bl7 = false;
                            try {
                                bl7 = ((String[])object8).length > n13 ? object8[n13].equalsIgnoreCase("USE_FOR_PLANE_CLIP") : false;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n13;
                            d2 = -1.0;
                            try {
                                d2 = ((String[])object8).length > n13 ? Double.parseDouble(object8[n13]) : -1.0;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string18, true);
                            this.graphicPolygon[n] = new MapPolygons(inputStream, string18, this.graphicPolygonCkBoxStr[n], this.geogCoords, (Color)object2, basicStroke, string19, string20, this.globalCenter, bl5);
                            this.graphicPolygonDraw[n] = true;
                            if (bl6) {
                                this.seisEventFilter.addPolygonFilter(this.graphicPolygon[n]);
                            } else if (bl7 && d2 > 0.0) {
                                this.seisEventFilter.addPolygonPlaneFilter(this.graphicPolygon[n], d2);
                                MapObjects.addPolygonPlaneFilter(this.graphicPolygon[n], d2);
                            }
                        }
                        catch (IOException iOException) {
                            System.out.println("SeismicityViewer: ERROR: opening or reading file: " + string18);
                            System.out.println(iOException);
                            if (PRINT_STACK_TRACES) {
                                iOException.printStackTrace();
                            }
                            this.graphicPolygonURL[n] = null;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: parsing graphic polygon parameter: " + this.graphicPolygonURL[n]);
                            System.out.println(exception);
                            if (PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                            this.graphicPolygonURL[n] = null;
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (!this.getTrueFalseParameter(false, "dump.latlon")) continue;
                        object8 = string18 + ".latlon";
                        FilterOutputStream filterOutputStream = null;
                        try {
                            OutputStream outputStream = GeneralOutputStream.openStream(null, (String)object8);
                            filterOutputStream = new ASCIIOutputStream(outputStream);
                            int n16 = this.graphicPolygon[n].printLatLong((ASCIIOutputStream)filterOutputStream, this.geogCoords);
                            ((BufferedOutputStream)filterOutputStream).flush();
                            filterOutputStream.close();
                            System.out.println("SeismicityViewer: INFO: " + n16 + " lat/lon/depth segments written to " + (String)object8);
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: opening or writing dump.latlon file: " + (String)object8);
                            if (!PRINT_STACK_TRACES) continue;
                            exception.printStackTrace();
                            continue;
                        }
                        finally {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    bl5 = true;
                    for (n = 0; n < this.graphicSymbolURL.length; ++n) {
                        this.graphicSymbol[n] = null;
                        this.graphicSymbolDraw[n] = false;
                        if (this.graphicSymbolURL[n] == null) continue;
                        this.writeMessage("Reading graphic symbol file: " + this.graphicSymbolURL[n] + "...");
                        String string22 = null;
                        try {
                            Color color4;
                            String string23;
                            String[] stringArray;
                            block407: {
                                stringArray = StringExt.parse(this.graphicSymbolURL[n], ";");
                                string22 = stringArray[0];
                                string23 = "CUBE";
                                if (stringArray.length > 1) {
                                    string23 = stringArray[1];
                                }
                                color4 = Color.white;
                                try {
                                    if (stringArray.length > 2) {
                                        color4 = SeismicityColors.createColor(stringArray[2]);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: : " + exception);
                                    if (!PRINT_STACK_TRACES) break block407;
                                    exception.printStackTrace();
                                }
                            }
                            int n17 = 3;
                            object2 = "1.0";
                            if (stringArray.length > 4) {
                                object2 = stringArray[3];
                                ++n17;
                            }
                            BasicStroke basicStroke = AJLStroke.defaultStroke;
                            try {
                                int n18 = 2;
                                int n19 = 0;
                                float f = 10.0f;
                                basicStroke = SeismicityStrokes.createStroke((String)object2, "SOLID", n18, n19, f);
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: : " + exception);
                            }
                            double d26 = 1.0;
                            try {
                                d26 = Double.valueOf(stringArray[n17]);
                                ++n17;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.graphicSymbolCkBoxStr[n] = stringArray.length > n17 ? stringArray[n17] : "Symbols (" + stringArray[1] + ";" + stringArray[2] + ")";
                            try {
                                this.graphicSymbolCkBox[n].setText(this.graphicSymbolCkBoxStr[n]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            ++n17;
                            boolean bl8 = false;
                            try {
                                bl8 = stringArray[n17].equalsIgnoreCase("POLYGON_CLIP");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string22, true);
                            this.graphicSymbol[n] = new MapSymbols(inputStream, string22, this.graphicSymbolCkBoxStr[n], string23, color4, basicStroke, this.geogCoords, this.globalCenter, bl5, bl8, d26);
                            this.graphicSymbolDraw[n] = true;
                            continue;
                        }
                        catch (IOException iOException) {
                            System.out.println("SeismicityViewer: ERROR: opening or reading file: " + string22);
                            System.out.println(iOException);
                            if (PRINT_STACK_TRACES) {
                                iOException.printStackTrace();
                            }
                            this.graphicSymbolURL[n] = null;
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: parsing symbol parameter: " + this.graphicSymbolURL[n]);
                            System.out.println(exception);
                            exception.printStackTrace();
                            this.graphicSymbolURL[n] = null;
                            continue;
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    for (n = 0; n < this.sampleSetURL.length; ++n) {
                        Object object9;
                        this.sampleSet[n] = null;
                        this.sampleSetDraw[n] = false;
                        if (this.sampleSetURL[n] == null) continue;
                        this.writeMessage("Reading sample set file: " + this.sampleSetURL[n] + "...");
                        String string24 = null;
                        try {
                            boolean bl9;
                            boolean bl10;
                            int n20;
                            Color color5;
                            block411: {
                                block410: {
                                    block409: {
                                        block408: {
                                            object9 = StringExt.parse(this.sampleSetURL[n], ";");
                                            string24 = object9[0];
                                            color5 = Color.white;
                                            try {
                                                if (((String[])object9).length > 1) {
                                                    color5 = SeismicityColors.createColor(object9[1]);
                                                }
                                            }
                                            catch (Exception exception) {
                                                System.out.println("SeismicityViewer: : " + exception);
                                                if (!PRINT_STACK_TRACES) break block408;
                                                exception.printStackTrace();
                                            }
                                        }
                                        n20 = 1;
                                        try {
                                            if (((String[])object9).length > 3) {
                                                n20 = Integer.parseInt(object9[3]);
                                            }
                                        }
                                        catch (Exception exception) {
                                            System.out.println("SeismicityViewer: : " + exception);
                                            if (!PRINT_STACK_TRACES) break block409;
                                            exception.printStackTrace();
                                        }
                                    }
                                    bl10 = true;
                                    try {
                                        if (((String[])object9).length > 4) {
                                            bl10 = ApplicationProperties.evaluateTrueFalseParameter(object9[4], true);
                                        }
                                    }
                                    catch (Exception exception) {
                                        System.out.println("SeismicityViewer: : " + exception);
                                        if (!PRINT_STACK_TRACES) break block410;
                                        exception.printStackTrace();
                                    }
                                }
                                bl9 = false;
                                try {
                                    if (((String[])object9).length > 5) {
                                        bl9 = ApplicationProperties.evaluateTrueFalseParameter(object9[5], true);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: : " + exception);
                                    if (!PRINT_STACK_TRACES) break block411;
                                    exception.printStackTrace();
                                }
                            }
                            inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string24, true);
                            this.sampleSet[n] = new Sample4DSet(inputStream, color5, n20, this.geogCoords, bl10, bl9);
                            this.sampleSetDraw[n] = true;
                            this.sampleSetCkBoxStr[n] = ((String[])object9).length > 2 ? object9[2] : "Samples (" + object9[1] + ")";
                            try {
                                this.sampleSetCkBox[n].setText(this.sampleSetCkBoxStr[n]);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        catch (IOException iOException) {
                            System.out.println("SeismicityViewer: ERROR: opening or reading file: " + string24);
                            System.out.println(iOException);
                            if (PRINT_STACK_TRACES) {
                                iOException.printStackTrace();
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: parsing sample set parameter: " + this.sampleSetURL[n]);
                            System.out.println(exception);
                            if (PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                        }
                        finally {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                        if (!this.getTrueFalseParameter(false, "dump.samples.latlon")) continue;
                        object9 = string24 + ".asc";
                        FilterOutputStream filterOutputStream = null;
                        try {
                            OutputStream outputStream = GeneralOutputStream.openStream(null, (String)object9);
                            filterOutputStream = new ASCIIOutputStream(outputStream);
                            int n21 = this.sampleSet[n].printLatLong((ASCIIOutputStream)filterOutputStream, this.geogCoords);
                            ((BufferedOutputStream)filterOutputStream).flush();
                            System.out.println("SeismicityViewer: INFO: " + n21 + " lat/lon/depth segments written to " + (String)object9);
                            continue;
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: opening or writing dump.latlon file: " + (String)object9);
                            if (!PRINT_STACK_TRACES) continue;
                            exception.printStackTrace();
                            continue;
                        }
                        finally {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (this.image2Dstr != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    SeismicityFrame.this.image2D = new Image2D(SeismicityFrame.this.image2Dstr, SeismicityFrame.this.getToolkit(), SeismicityFrame.this.getDocumentBase(), SeismicityFrame.this.geogCoords);
                                    SeismicityFrame.this.allowDrawImage2DCkBoxStr = SeismicityFrame.this.image2D.getName();
                                    SeismicityFrame.this.allowDrawImage2DCkBox.setText(SeismicityFrame.this.allowDrawImage2DCkBoxStr);
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: ERROR: initializing image2D: " + exception);
                                    if (PRINT_STACK_TRACES) {
                                        exception.printStackTrace();
                                    }
                                    SeismicityFrame.this.image2D = null;
                                }
                            }
                        });
                    }
                    d = 1.0;
                    this.graphicTextDraw = false;
                    this.graphicText3D = new Vector();
                    if (this.graphicTextURL == null) break block413;
                    aSCIIInputStream = null;
                    try {
                        object = new BufferedInputStream(GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), this.graphicTextURL, true));
                        aSCIIInputStream = new ASCIIInputStream((InputStream)object);
                    }
                    catch (IOException iOException) {
                        System.out.println("SeismicityViewer: ERROR: opening file: " + this.graphicTextURL);
                        if (!PRINT_STACK_TRACES) break block414;
                        iOException.printStackTrace();
                    }
                }
                try {
                    while (!aSCIIInputStream.eof()) {
                        try {
                            object = new Text3D(aSCIIInputStream, this, this.textDensity, this.pix2WorldScale, this.isGlobal, d);
                            this.graphicText3D.add((Text3D)object);
                        }
                        catch (Exception exception) {
                            if (!PRINT_STACK_TRACES) continue;
                            System.out.println("SeismicityViewer: ERROR: " + exception + ": reading file: " + this.graphicTextURL);
                            exception.printStackTrace();
                        }
                    }
                    aSCIIInputStream.close();
                    this.graphicTextDraw = true;
                }
                catch (IOException iOException) {
                    System.out.println("SeismicityViewer: ERROR: " + iOException + ": reading file: " + this.graphicTextURL);
                    if (PRINT_STACK_TRACES) {
                        iOException.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                if (PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
                this.writeMessageToConsole(exception.toString());
                this.errorFlag = true;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getTrueFalseParameter(false, "dump.latlon")) {
            String string = "stations.latlon";
            FilterOutputStream filterOutputStream = null;
            try {
                OutputStream outputStream = GeneralOutputStream.openStream(null, string);
                filterOutputStream = new ASCIIOutputStream(outputStream);
                String string25 = System.getProperty("line.separator");
                for (int i = 0; i < this.stationList.size(); ++i) {
                    ((ASCIIOutputStream)filterOutputStream).writeWord(this.stationList.get(i).toLatLonString() + string25);
                }
                ((BufferedOutputStream)filterOutputStream).flush();
                filterOutputStream.close();
                System.out.println("SeismicityViewer: INFO: " + this.stationList.size() + " stations written to " + string);
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: opening or writing dump.latlon file: " + string);
                if (PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
            }
            finally {
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        if (this.invertColorFlag && !this.colorsInverted) {
            this.invertColors();
        }
        this.initializeView();
        if (this.showSeismicityToolbar) {
            this.layoutSeismicityToolbar();
        }
        if (this.showViewingToolbar) {
            this.layoutViewToolbar();
        }
        this.requestFocus(this);
        this.fullyInitialized = true;
    }

    public void updateAxes3D() {
        if (this.isGlobal) {
            this.axes3D = null;
        } else {
            if (this.axes3D == null || this.worldCenterPoint != this.axis3DworldCenterPoint || this.viewScaleFactor != this.axis3DviewScaleFactor) {
                Color[] colorArray;
                Object object;
                Object object2;
                double d;
                double d2;
                Object object3;
                String string;
                Vect3D vect3D;
                block28: {
                    block27: {
                        block26: {
                            String[] stringArray;
                            vect3D = new Vect3D(this.worldCenterPoint);
                            string = this.getParameter("axes3d.pos.abs");
                            if (string != null) {
                                try {
                                    stringArray = StringExt.parse(string, ",");
                                    double d3 = Double.parseDouble(stringArray[0]);
                                    double d4 = Double.parseDouble(stringArray[1]);
                                    double d5 = Double.parseDouble(stringArray[2]);
                                    vect3D = new Vect3D(d3, d4, d5);
                                }
                                catch (Exception exception) {
                                    vect3D = new Vect3D(this.worldCenterPoint);
                                }
                            } else {
                                string = this.getParameter("axes3d.pos.plot");
                                if (string != null) {
                                    try {
                                        stringArray = StringExt.parse(string, ",");
                                        double d6 = Double.parseDouble(stringArray[0]);
                                        double d7 = Double.parseDouble(stringArray[1]);
                                        Dimension dimension = this.panel3D.getSize();
                                        object3 = this.getOrthogonalInverse(dimension);
                                        vect3D = new Vect3D((double)dimension.width * 0.5 * (1.0 + d6), (double)dimension.height * 0.5 * (1.0 - d7), 0.0);
                                        vect3D = vect3D.mult((Matrix3D)object3);
                                        vect3D.z = this.worldCenterPoint.z;
                                    }
                                    catch (Exception exception) {
                                        vect3D = new Vect3D(this.worldCenterPoint);
                                    }
                                }
                            }
                            d2 = 1.0;
                            d = 1.0;
                            string = this.getParameter("axes3d.font");
                            if (string != null) {
                                try {
                                    object2 = StringExt.parse(string, ",");
                                    d2 = Double.parseDouble(object2[0]);
                                    d = Double.parseDouble(object2[1]);
                                }
                                catch (Exception exception) {
                                    d2 = 1.0;
                                    d = 1.0;
                                }
                            }
                            d2 /= this.viewScaleFactor;
                            d *= this.viewScaleFactor;
                            object2 = Color.GREEN;
                            try {
                                object = this.getParameter("color.axes3d.x");
                                if (object != null) {
                                    object2 = SeismicityColors.createColor((String)object);
                                }
                            }
                            catch (Exception exception) {
                                System.out.println("SeismicityViewer: : " + exception);
                                if (!PRINT_STACK_TRACES) break block26;
                                exception.printStackTrace();
                            }
                        }
                        object = Color.MAGENTA;
                        try {
                            object3 = this.getParameter("color.axes3d.y");
                            if (object3 != null) {
                                object = SeismicityColors.createColor((String)object3);
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: : " + exception);
                            if (!PRINT_STACK_TRACES) break block27;
                            exception.printStackTrace();
                        }
                    }
                    object3 = Color.CYAN;
                    try {
                        colorArray = this.getParameter("color.axes3d.z");
                        if (colorArray != null) {
                            object3 = SeismicityColors.createColor((String)colorArray);
                        }
                    }
                    catch (Exception exception) {
                        System.out.println("SeismicityViewer: : " + exception);
                        if (!PRINT_STACK_TRACES) break block28;
                        exception.printStackTrace();
                    }
                }
                colorArray = new Color[]{object3, object, object2};
                double d8 = 1.0;
                string = this.getParameter("axes3d.lengthfactor");
                if (string != null) {
                    try {
                        d8 = Double.parseDouble(string);
                    }
                    catch (Exception exception) {
                        d8 = 1.0;
                    }
                }
                double d9 = d8 * (this.grid3D.xmax - this.grid3D.xmin) / (7.5 * this.viewScaleFactor);
                d9 = NumberFormat.niceValue(d9);
                String string2 = "km";
                this.axes3D = new Axes3D(vect3D.x, vect3D.x + d9, vect3D.y, vect3D.y + d9, -vect3D.z, -(vect3D.z + d9), 0.0, this, null, 2);
                this.axes3D.setFontDensity(d);
                double d10 = (double)this.getFont().getSize() * d2;
                this.axes3D.setFontSize(d10);
                if (string2 != null) {
                    this.axes3D.setAllAxisLabelToValue(string2, true);
                }
                this.axes3D.createLabels(this.pix2WorldScale);
                this.axes3D.setPositiveOnly(true);
                this.axes3D.setPositiveArrowheads(true);
                this.axes3D.setColor(colorArray);
            }
            this.axes3D.transform(this.transformationIndex);
            this.axis3DworldCenterPoint = this.worldCenterPoint;
            this.axis3DviewScaleFactor = this.viewScaleFactor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getEvents(String string) throws Exception {
        boolean bl;
        InputStream inputStream = null;
        Exception exception = null;
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = bl = this.eventFileType.equalsIgnoreCase(NULL_EVENT_FILETYPE);
        do {
            if (string.endsWith(".jbin")) {
                try {
                    System.out.println("DEBUG: TP 1");
                    inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string, true);
                    System.out.println("DEBUG: TP 2");
                }
                catch (Exception exception2) {
                    bl2 = true;
                    if (bl) break;
                }
                try {
                    System.out.println("DEBUG: TP 3");
                    n = this.ReadSeismicityBinary(inputStream, string);
                    System.out.println("DEBUG: TP 4 nEventsRead:" + n);
                    if (n > 0) {
                        break;
                    }
                }
                catch (Exception exception3) {
                    exception = exception3;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception4) {}
                }
            }
            if (bl || this.eventFileType.equalsIgnoreCase("STRING")) {
                bl3 = true;
                try {
                    n = this.ReadEventsString(string.replace(',', ' '));
                    if (n > 0) {
                        break;
                    }
                }
                catch (Exception exception5) {
                    exception = exception5;
                }
            }
            if (bl || this.eventFileType == null || this.eventFileType.equalsIgnoreCase("NLLOC")) {
                bl3 = true;
                try {
                    inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string, true);
                }
                catch (Exception exception6) {
                    bl2 = true;
                    if (bl) break;
                }
                try {
                    n = this.ReadEventsNLLoc(inputStream, string);
                    if (n > 0) {
                        break;
                    }
                }
                catch (Exception exception7) {
                    exception = exception7;
                    if (PRINT_STACK_TRACES) {
                        exception7.printStackTrace();
                    }
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception8) {}
                }
            }
            if (bl || this.eventFileType.equalsIgnoreCase("STRING_FILE")) {
                bl3 = true;
                try {
                    inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string, true);
                }
                catch (Exception exception9) {
                    bl2 = true;
                    if (bl) break;
                }
                try {
                    n = this.ReadEventsString(inputStream);
                    if (n > 0) {
                        break;
                    }
                }
                catch (Exception exception10) {
                    exception = exception10;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception11) {}
                }
            }
            for (String string2 : this.formatsTryAll) {
                if (!bl && !this.eventFileType.toUpperCase().equals(string2)) continue;
                bl3 = true;
                try {
                    inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string, true);
                }
                catch (Exception exception12) {
                    bl2 = true;
                    if (bl) break;
                }
                try {
                    n = this.ReadEventsHypo(inputStream, string2, string);
                    if (n <= 0) continue;
                    break;
                }
                catch (EventSearchException eventSearchException) {
                    exception = eventSearchException;
                    System.out.println(exception);
                    if (!PRINT_STACK_TRACES) continue;
                    exception.printStackTrace();
                }
                catch (Exception exception13) {
                    exception = exception13;
                    if (!PRINT_STACK_TRACES) continue;
                    exception.printStackTrace();
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception14) {}
                }
            }
            for (String string2 : this.formatsOther) {
                if (!this.eventFileType.toUpperCase().equals(string2)) continue;
                bl3 = true;
                try {
                    inputStream = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), string, true);
                }
                catch (Exception exception15) {
                    bl2 = true;
                    if (bl) break;
                }
                try {
                    n = this.ReadEventsHypo(inputStream, string2, string);
                    if (n <= 0) continue;
                    break;
                }
                catch (EventSearchException eventSearchException) {
                    exception = eventSearchException;
                    System.out.println(exception);
                }
                catch (Exception exception16) {
                    exception = exception16;
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception17) {}
                }
            }
            if (exception != null && n > 0) {
                System.out.println("SeismicityViewer: ERROR: reading events from file: " + string);
                System.out.println("Last Exception: " + exception);
                if (!PRINT_STACK_TRACES) break;
                exception.printStackTrace();
                break;
            }
            if (!bl) continue;
            System.out.println("SeismicityViewer: ERROR: unrecognized format or error reading events file: " + string);
            System.out.println("Last Exception: " + exception);
            if (!PRINT_STACK_TRACES) break;
            exception.printStackTrace();
            break;
        } while (bl);
        if (exception != null && n <= 0) {
            throw exception;
        }
        if (!bl3) {
            System.out.println("SeismicityViewer: ERROR: filetype not recognized: " + this.eventFileType);
            return 0;
        }
        if (bl2 && n <= 0) {
            System.out.println("SeismicityViewer: ERROR: file not found: " + string);
            return 0;
        }
        int n2 = this.seisEventList.size();
        if (n2 > 0 && this.writeSeismicityBinaryFlag) {
            this.WriteSeismicityBinary(string);
        }
        return n2;
    }

    protected void setPlotingScale(Dimension dimension) {
        double d;
        double d2;
        double d3 = 1.0;
        String string = this.getParameter("residual.size");
        if (string != null) {
            try {
                d3 = Double.valueOf(string);
            }
            catch (Exception exception) {
                System.out.println("SeismicityViewer: ERROR: reading residual.size parameter: " + string);
                d3 = 1.0;
            }
        }
        this.pix2WorldScale = 0.8 / (this.viewScaleFactor * ((d2 = (double)dimension.width / this.worldWidthMax) < (d = (double)dimension.height / this.worldWidthMax) ? d2 : d));
        this.secToKmScale = d3 * this.worldWidthMax / 5.0;
        if (this.isGlobal) {
            this.pix2WorldScale = Math.min(this.pix2WorldScale / 2.0, 2.0);
            this.secToKmScale = Math.min(this.secToKmScale, 250.0);
        }
        this.mechSize = this.secToKmScale / 20.0;
        String string2 = "mechanism.size";
        try {
            String string3 = null;
            string3 = this.getParameter(string2);
            if (string3 != null) {
                this.mechSize *= Double.parseDouble(string3);
            }
        }
        catch (Exception exception) {
            this.writeMessage(exception.getMessage() + ": " + string2);
        }
    }

    protected void setGlobalWorldWidthMax(double d) {
        this.globalWorldWidthMax = d;
    }

    protected void setWorldCenterPoint(Vect3D vect3D) {
        this.worldCenterPointInit = vect3D;
    }

    protected Vect3D getDefaultGridWorldCenter() {
        if (this.isGlobal) {
            return new Vect3D(0.0, 0.0, 0.0);
        }
        return new Vect3D((this.grid3D.xmin + this.grid3D.xmax) / 2.0, (this.grid3D.ymin + this.grid3D.ymax) / 2.0, (this.grid3D.zmin + this.grid3D.zmax) / 2.0);
    }

    protected void setDefaultGridWorldCenter() {
        if (this.isGlobal) {
            this.initializeView(this.getDefaultGridWorldCenter(), 2.0 * GeogConstants.PLANET_RADIUS);
        } else {
            this.initializeView(this.getDefaultGridWorldCenter(), -1.0);
        }
    }

    protected void setEventWorldCenter() {
        SeisEvent seisEvent;
        if (this.seisEventList != null && this.seisEventList.size() > 0 && (seisEvent = (SeisEvent)this.seisEventList.get(this.eventPlotFirst)) != null) {
            Vect3D vect3D = seisEvent.getRotationAngles();
            if (vect3D != null) {
                this.setRotationAngles(vect3D.z, vect3D.y, vect3D.x);
                this.setInitialRotationAngles(vect3D.z, vect3D.y, vect3D.x);
            }
            this.initializeView(seisEvent.getWorldCenter(), -1.0);
        }
    }

    protected void initializeView() {
        Vect3D vect3D = this.worldCenterPointInit == null || this.seisEventList.size() > 1 ? (this.grid3DGlobal != null && !this.isGlobal ? new Vect3D((this.grid3DGlobal.xmin + this.grid3DGlobal.xmax) / 2.0, (this.grid3DGlobal.ymin + this.grid3DGlobal.ymax) / 2.0, (this.grid3DGlobal.zmin + this.grid3DGlobal.zmax) / 2.0) : this.getDefaultGridWorldCenter()) : this.worldCenterPointInit;
        if (this.isGlobal && this.seisEventList.size() > 1) {
            this.initializeView(vect3D, 1.0 * GeogConstants.PLANET_RADIUS);
        } else {
            this.initializeView(vect3D, -1.0);
        }
    }

    protected void initializeView(Vect3D vect3D, double d) {
        this.worldCenterPoint = vect3D;
        this.worldTransMat.unit();
        this.worldTransMat.translate(-this.worldCenterPoint.x, -this.worldCenterPoint.y, -this.worldCenterPoint.z);
        this.zrotAng = this.zrotAngInit;
        if (this.geogCoords != null) {
            this.zrotAng -= this.geogCoords.getRotationAngle();
        }
        this.yrotAng = this.yrotAngInit;
        this.xrotAng = this.xrotAngInit;
        if (this.lock2DFlag) {
            this.zrotAng = 0.0;
            this.yrotAng = 0.0;
            this.xrotAng = 0.0;
            this.projectFlag = false;
        } else {
            StringTokenizer stringTokenizer;
            String string = this.getParameter("init.rotation");
            if (string != null) {
                try {
                    stringTokenizer = new StringTokenizer(string, ",");
                    this.zrotAng = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                    this.yrotAng = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                    this.xrotAng = Float.valueOf(stringTokenizer.nextToken()).floatValue();
                }
                catch (Exception exception) {
                    System.out.println("SeismicityViewer: ERROR: reading init.rotation parameter: " + string);
                }
            }
            if ((string = this.getParameter("init.viewpoint")) != null) {
                try {
                    stringTokenizer = new StringTokenizer(string, ",");
                    this.zrotAng = this.geogAz2rotAz(Float.valueOf(stringTokenizer.nextToken()).floatValue());
                    this.xrotAng = this.geogInc2rotInc(Float.valueOf(stringTokenizer.nextToken()).floatValue());
                }
                catch (Exception exception) {
                    System.out.println("SeismicityViewer: ERROR: reading init.viewpoint parameter: " + string);
                }
            }
        }
        this.setInitialRotationAngles(this.zrotAng, this.yrotAng, this.xrotAng);
        this.setViewFrom(this.zrotAng, this.yrotAng, this.xrotAng);
        if (d < 0.0) {
            d = this.grid3D.xmax - this.grid3D.xmin;
            double d2 = this.grid3D.ymax - this.grid3D.ymin;
            double d3 = this.grid3D.zmax - this.grid3D.zmin;
            if (d2 > d) {
                d = d2;
            }
            if (d3 > d) {
                d = d3;
            }
            if (this.isGlobal) {
                d = Math.min(d, this.globalWorldWidthMax);
            }
        }
        this.worldWidthMax = d > 0.0 ? d : GeogConstants.PLANET_RADIUS;
        this.perspDist = 2.0 * d;
        this.viewScaleFactor = 0.85;
        this.applyZoomFactor(this.initalZoom);
        ++this.transformationIndex;
    }

    protected boolean rotate(Matrix3D matrix3D) {
        if (this.lock2DFlag) {
            return false;
        }
        this.rotMat.mult(matrix3D);
        ++this.transformationIndex;
        return true;
    }

    protected Matrix3D getOrthogonalInverse(Dimension dimension) {
        Matrix3D matrix3D = new Matrix3D(this.worldTransMat);
        matrix3D.transInvert();
        Matrix3D matrix3D2 = new Matrix3D(this.rotMat);
        matrix3D2.rotInvert();
        Matrix3D matrix3D3 = new Matrix3D();
        matrix3D3.unit();
        matrix3D3.translate(-dimension.width / 2, -dimension.height / 2, 0.0);
        matrix3D3.scale(1.0 / this.viewScale, -1.0 / this.viewScale, -1.0 / this.viewScale);
        matrix3D3.mult(matrix3D2);
        matrix3D3.mult(matrix3D);
        return matrix3D3;
    }

    protected void newWorldCenter(int n, int n2, Dimension dimension) {
        Matrix3D matrix3D = this.getOrthogonalInverse(dimension);
        Vect3D vect3D = new Vect3D(n, n2, 0.0f);
        this.worldCenterPoint = vect3D.mult(matrix3D);
        this.worldTransMat.unit();
        this.worldTransMat.translate(-this.worldCenterPoint.x, -this.worldCenterPoint.y, -this.worldCenterPoint.z);
        ++this.transformationIndex;
    }

    public void writeMessageToConsole(String string) {
        System.out.println(MESSAGE_PREFIX_PROG_NAME + string);
    }

    @Override
    public void writeMessage(String string) {
        this.writeMessage(string, this.messageForeground, this.messageBackground);
    }

    public void writeMessage(String string, Color color, Color color2) {
        final Color color3 = color;
        final Color color4 = color2;
        final String string2 = this.messagePrefix + string;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SeismicityFrame.this.messageLabel.setForeground(color3);
                SeismicityFrame.this.messageLabel.setBackground(color4);
                SeismicityFrame.this.messageLabel.setText(string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ReadEventsNLLoc(InputStream inputStream, String string) throws Exception {
        ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(new BufferedInputStream(inputStream));
        int n = 0;
        int n2 = 1;
        while (true) {
            SeisEvent seisEvent;
            block47: {
                String string2;
                if (!(aSCIIInputStream.eof() || (string2 = aSCIIInputStream.readWord()).equalsIgnoreCase("NLLOC") || string2.equalsIgnoreCase("RIDLOC"))) {
                    aSCIIInputStream.flushLine();
                    continue;
                }
                if (aSCIIInputStream.eof()) break;
                seisEvent = null;
                try {
                    seisEvent = new SeisEvent(this, string, aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, this.ellipseReadFlag, this.phaseReadFlag, this.focalMechReadFlag, this.probabilityReadFlag, this.mechSize);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                if (this.probabilityReadFlag && n == 0 && seisEvent.getNumberOfSamples() <= 0) {
                    InputStream inputStream2 = null;
                    try {
                        Object object;
                        int n3;
                        int n4;
                        block46: {
                            n4 = 1;
                            n3 = 1;
                            String string3 = null;
                            string3 = this.getParameter("scattersamples");
                            if (string3 != null) {
                                block45: {
                                    block44: {
                                        object = string3.split("[;#]");
                                        try {
                                            if (((String[])object).length > 0) {
                                                SeisEvent.sampleCol = SeisEvent.sampleColDefault = SeismicityColors.createColor(object[0]);
                                            }
                                        }
                                        catch (Exception exception) {
                                            System.out.println("SeismicityViewer: : " + exception);
                                            if (!PRINT_STACK_TRACES) break block44;
                                            exception.printStackTrace();
                                        }
                                    }
                                    try {
                                        if (((String[])object).length > 1) {
                                            n4 = Integer.parseInt(object[1]);
                                        }
                                    }
                                    catch (Exception exception) {
                                        System.out.println("SeismicityViewer: : " + exception);
                                        if (!PRINT_STACK_TRACES) break block45;
                                        exception.printStackTrace();
                                    }
                                }
                                try {
                                    if (((String[])object).length > 2) {
                                        n3 = Integer.parseInt(object[2]);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println("SeismicityViewer: : " + exception);
                                    if (!PRINT_STACK_TRACES) break block46;
                                    exception.printStackTrace();
                                }
                            }
                        }
                        object = string.substring(0, string.lastIndexOf(".")) + ".scat";
                        inputStream2 = GeneralInputStream.openStreamCheckCompress(this.getDocumentBase(), (String)object, true);
                        seisEvent.readSamplesBinary(new BufferedInputStream(inputStream2), n4, n3);
                        if (!this.getTrueFalseParameter(false, "dump.samples.latlon")) break block47;
                        String string4 = (String)object + ".asc";
                        FilterOutputStream filterOutputStream = null;
                        try {
                            OutputStream outputStream = GeneralOutputStream.openStream(null, string4);
                            filterOutputStream = new ASCIIOutputStream(outputStream);
                            Sample4DSet sample4DSet = new Sample4DSet(seisEvent.samples);
                            int n5 = sample4DSet.printLatLong((ASCIIOutputStream)filterOutputStream, this.geogCoords);
                            ((BufferedOutputStream)filterOutputStream).flush();
                            System.out.println("SeismicityViewer: INFO: " + n5 + " lat/lon/depth segments written to " + string4);
                        }
                        catch (Exception exception) {
                            System.out.println("SeismicityViewer: ERROR: opening or writing dump.latlon file: " + string4);
                            if (PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                        }
                        finally {
                            try {
                                filterOutputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    catch (Exception exception) {
                        if (PRINT_STACK_TRACES) {
                            exception.printStackTrace();
                        }
                    }
                    finally {
                        try {
                            inputStream2.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (n % n2 == 0) {
                this.writeMessage("Reading: " + seisEvent.toString());
            }
            this.seisEventList.addEvent(seisEvent, n);
            if (++n > 1000) {
                n2 = 100;
                continue;
            }
            if (n > 500) {
                n2 = 50;
                continue;
            }
            if (n > 100) {
                n2 = 10;
                continue;
            }
            if (n > 50) {
                n2 = 5;
                continue;
            }
            if (n <= 20) continue;
            n2 = 2;
        }
        return n;
    }

    public int ReadEventsHypo(InputStream inputStream, String string, String string2) throws Exception {
        ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(new BufferedInputStream(inputStream));
        int n = 0;
        int n2 = 1;
        double d = 1.0;
        double d2 = 1.0;
        while (!aSCIIInputStream.eof()) {
            SeisEvent seisEvent = new SeisEvent(this, string2);
            if (string.equalsIgnoreCase("NLLOC_GEOG")) {
                if (seisEvent.readNllGeog(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("CSV_COMPACT")) {
                if (seisEvent.readCsvCompact(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, this.mechSize, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("BASIC_CSV")) {
                if (seisEvent.readBasicCsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("BASIC")) {
                if (seisEvent.readBasic(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("EARLY_EST_CSV")) {
                if (seisEvent.readEarlyEstCsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("HYPO")) {
                if (seisEvent.readHypo(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("SEISAN")) {
                if (n == 0) {
                    String string3;
                    aSCIIInputStream.readWord();
                    aSCIIInputStream.readWord();
                    String string4 = aSCIIInputStream.readWord();
                    if (string4.endsWith("_S")) {
                        d = -1.0;
                    }
                    if ((string3 = aSCIIInputStream.readWord()).endsWith("_W")) {
                        d2 = -1.0;
                    }
                    aSCIIInputStream.flushLine();
                }
                if (seisEvent.readSeisan(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2, d, d2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("EQ_MON_CSV")) {
                if (seisEvent.readEqMonCsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("SPYDER")) {
                if (seisEvent.readSpyder(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("GSE")) {
                if (seisEvent.readGSE(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("EPI")) {
                if (seisEvent.readEpi(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("FVGN")) {
                if (seisEvent.readFriuliVeneziaGiuliaNetwork(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("MONFRET")) {
                if (seisEvent.readMonfret(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("CELINE")) {
                if (seisEvent.readCeline(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("GOT")) {
                if (seisEvent.readGot(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("SEARCH_NEIC_SWE")) {
                if (seisEvent.readNEICSearch4(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("SEARCH_NEIC_PDE") || string.equalsIgnoreCase("SEARCH_NEIC_PDEQ")) {
                if (seisEvent.readNEICSearch6(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("HYPO_INV")) {
                if (seisEvent.readHypoInv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("HYPO_ELL")) {
                if (seisEvent.readHypoellise(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("EQDD")) {
                if (seisEvent.readEqDD(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("INGV_DB")) {
                if (seisEvent.readIngvDbText(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("GEONET_CSV")) {
                if (seisEvent.readGeoNetCsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("FDSN_WS_EVENT")) {
                if (seisEvent.readFdsnEventText(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("OV_INGV_EVENT")) {
                if (seisEvent.readOVINGVEventText(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("NCEDC_CSV")) {
                if (seisEvent.readNCEDCCsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("USGS_CSV")) {
                if (seisEvent.readUSGSCsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("SCEC_GROWCLUST")) {
                if (seisEvent.readSCECGrowClust(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("TEXNET_GROWCLUST")) {
                if (seisEvent.readTexNetGrowClust(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("TEXNET_CSV")) {
                if (seisEvent.readTexNetCsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("MUNCH_DD")) {
                if (seisEvent.readMunchmeyerHypoDD(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("TRUG_2020")) {
                if (seisEvent.readTrugman2020(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("RUHL_2021")) {
                if (seisEvent.readRuhl2021(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("LIN_COMBLOC")) {
                if (seisEvent.readLinCombloc(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("SHENG2022")) {
                if (seisEvent.readSheng2022(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("ALBERTO_TOMO")) {
                if (seisEvent.readAlbertoTomo(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else if (string.equalsIgnoreCase("GEIN_NOA_EPI")) {
                if (seisEvent.readGEIN_NOA_EPICsv(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale, string2) < 0) {
                    break;
                }
            } else {
                return -1;
            }
            if (n % n2 == 0) {
                this.writeMessage("Reading: " + seisEvent.toString());
            }
            seisEvent.oTimeMillisec = seisEvent.calcOTimeInMillis(SeisEvent.DEFAULT_CALANDER);
            this.seisEventList.addEvent(seisEvent, n);
            if (++n > 1000) {
                n2 = 100;
                continue;
            }
            if (n > 500) {
                n2 = 50;
                continue;
            }
            if (n > 100) {
                n2 = 10;
                continue;
            }
            if (n > 50) {
                n2 = 5;
                continue;
            }
            if (n <= 20) continue;
            n2 = 2;
        }
        return n;
    }

    public int ReadEventsString(String string) throws Exception {
        ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(new StringBufferInputStream(string));
        return this.ReadEventsString(aSCIIInputStream, false);
    }

    public int ReadEventsString(InputStream inputStream) throws Exception {
        ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(inputStream);
        return this.ReadEventsString(aSCIIInputStream, true);
    }

    public int ReadEventsString(ASCIIInputStream aSCIIInputStream, boolean bl) throws Exception {
        SeisEvent seisEvent;
        int n = 0;
        int n2 = 1;
        block0: while (!aSCIIInputStream.eof() && (seisEvent = new SeisEvent(this, "STRING")).readString(aSCIIInputStream, this.pix2WorldScale, this.secToKmScale) >= 0) {
            if (n % n2 == 0) {
                this.writeMessage("Reading: " + seisEvent.toString());
            }
            this.seisEventList.addEvent(seisEvent, n);
            if (++n > 1000) {
                n2 = 100;
            } else if (n > 500) {
                n2 = 50;
            } else if (n > 100) {
                n2 = 10;
            } else if (n > 50) {
                n2 = 5;
            } else if (n > 20) {
                n2 = 2;
            }
            if (!bl) {
                int n3 = 32;
                while (!aSCIIInputStream.eof()) {
                    byte by = aSCIIInputStream.readByte();
                    n3 = by;
                    if (by == 59) continue block0;
                }
                continue;
            }
            aSCIIInputStream.flushLine();
        }
        return n;
    }

    public int WriteSeismicityBinary(String string) {
        if (string.endsWith(".jbin")) {
            return -1;
        }
        String string2 = "";
        string2 = string.endsWith(".hyp") ? string.substring(0, string.lastIndexOf(".hyp")) + ".jbin" : new String(string + ".jbin");
        this.writeMessage("Writing binary event location file: " + string2 + "...");
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(string2)));
            this.geogCoords.writeBinary(dataOutputStream);
            dataOutputStream.writeInt(this.seisEventList.size());
            for (int i = 0; i < this.seisEventList.size(); ++i) {
                ((SeisEvent)this.seisEventList.get(i)).writeBinary(dataOutputStream);
            }
            dataOutputStream.close();
        }
        catch (Exception exception) {
            this.writeMessage("ERROR: writing binary event location file: " + string2 + "...");
        }
        return 0;
    }

    public int ReadSeismicityBinary(InputStream inputStream, String string) {
        try {
            SeisEvent seisEvent;
            int n;
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
            this.geogCoords = new GeogCoords();
            this.geogCoords.readBinary(dataInputStream);
            int n2 = dataInputStream.readInt();
            int n3 = 1;
            if (n2 > 1000) {
                n3 = 100;
            } else if (n2 > 500) {
                n3 = 50;
            } else if (n2 > 100) {
                n3 = 10;
            } else if (n2 > 50) {
                n3 = 5;
            } else if (n2 > 20) {
                n3 = 2;
            }
            for (n = 0; n < n2 && (seisEvent = new SeisEvent(this, string)).readBinary(dataInputStream, this.pix2WorldScale, this.secToKmScale) >= 0; ++n) {
                this.seisEventList.addEvent(seisEvent, n);
                if (n % n3 != 0) continue;
                this.writeMessage("Reading: " + seisEvent.toString());
            }
            return n;
        }
        catch (Exception exception) {
            this.writeMessage("ERROR: reading binary event location file: " + string + ": " + exception.getMessage());
            return -1;
        }
    }

    protected void addStation(SeisPhase seisPhase) {
        SeisStation seisStation;
        if (!this.stationReadFlag) {
            return;
        }
        if (seisPhase.dist <= 0.0) {
            return;
        }
        int n = 0;
        for (n = 0; n < this.stationList.size() && !this.stationList.get((int)n).label.equals(seisPhase.label); ++n) {
        }
        if (n == this.stationList.size()) {
            seisStation = new SeisStation(seisPhase.label, this, seisPhase, this.pix2WorldScale, this.secToKmScale, this.isGlobal, this.geogCoords);
            this.stationList.add(seisStation);
        } else {
            seisStation = this.stationList.get(n);
        }
        if (!this.getTrueFalseParameter(false, "show.stats.mean_residuals.weights.all") && seisPhase.weight < (double)1.4E-45f) {
            return;
        }
        seisStation.addResidual(seisPhase);
    }

    protected void getNLLStations(String string, GeogCoords geogCoords) {
        if (!this.stationReadFlag) {
            return;
        }
        this.stationList = SeisStation.getNLLStations(this, this.getDocumentBase(), string, this.pix2WorldScale, this.secToKmScale, this.isGlobal, this.geogCoords, geogCoords, this.stationList);
    }

    public void doPrintJob() {
        PrintJob printJob;
        if (!this.fullyInitialized) {
            String string = "ERROR: No data to print.";
            System.out.println(string);
            this.writeMessage(string);
            return;
        }
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (this.jobAttributes == null) {
            this.jobAttributes = new JobAttributes();
        }
        if (this.pageAttributes == null) {
            this.pageAttributes = new PageAttributes();
            int n = 150;
            try {
                n = Integer.valueOf(this.getParameter("print.resolution"));
            }
            catch (Exception exception) {
                n = 150;
            }
            this.pageAttributes.setPrinterResolution(n);
        }
        try {
            printJob = this.getToolkit().getPrintJob(this, PROGRAM_NAME, this.jobAttributes, this.pageAttributes);
        }
        catch (InternalError internalError) {
            System.out.println(" Java printing internal error: " + internalError);
            this.setCursor(cursor);
            return;
        }
        catch (Exception exception) {
            System.out.println(" Print: " + exception);
            String string = "ERROR: Printing: " + exception;
            System.out.println(string);
            this.writeMessage(string);
            if (this.parent.isApplet()) {
                string = "  The applet security setting on your browser for this host (" + this.getDocumentBase().getHost() + ") may be preventing the initiation of a print job.";
                System.out.println(string);
                this.writeMessage(string);
            }
            this.setCursor(cursor);
            return;
        }
        if (printJob == null) {
            this.setCursor(cursor);
            return;
        }
        this.writeMessage("Printing...");
        Graphics graphics = printJob.getGraphics();
        this.print(graphics);
        graphics.dispose();
        printJob.end();
        this.setCursor(cursor);
        this.writeMessage("_READY");
    }

    @Override
    public void print(Graphics graphics) {
        Graphics graphics2;
        PrintGraphics printGraphics = null;
        Dimension dimension = null;
        int n = 150;
        try {
            printGraphics = (PrintGraphics)((Object)graphics);
            PrintJob printJob = printGraphics.getPrintJob();
            dimension = printJob.getPageDimension();
            n = printJob.getPageResolution();
            System.out.println("Printing: pageSize=" + dimension.width + "wX" + dimension.height + "h, pageRes=" + n);
        }
        catch (ClassCastException classCastException) {
            String string = "ERROR: Cannot get PrintGraphics object: " + classCastException;
            System.out.println(string);
            this.writeMessage(string);
            return;
        }
        int n2 = 12;
        try {
            n2 = Integer.valueOf(this.getParameter("print.font.size"));
        }
        catch (Exception exception) {
            n2 = 12;
        }
        graphics.setFont(new Font("SansSerif", 0, n2));
        int n3 = 20;
        Dimension dimension2 = new Dimension(dimension.width - 2 * dimension.width / n3, dimension.height - 4 * dimension.height / n3);
        int n4 = (dimension.width - dimension2.width) / 2;
        int n5 = (dimension.height - dimension2.height) / 2;
        if (this.getTrueFalseParameter(true, "print.titles")) {
            graphics2 = graphics.create();
            this.drawPrintText(graphics, dimension, n4, n5, n4 + dimension2.width, n5 + dimension2.height);
            graphics2.dispose();
        }
        graphics.translate(n4, n5);
        graphics2 = graphics.create();
        graphics2.setClip(0, 0, dimension2.width, dimension2.height);
        if (!this.invertColorFlag) {
            this.invertColors();
        }
        ++this.transformationIndex;
        this.panel3D.print(graphics2, dimension2);
        ++this.transformationIndex;
        if (!this.invertColorFlag) {
            this.invertColors();
        }
        graphics2.dispose();
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, dimension2.width, dimension2.height);
    }

    public void drawPrintText(Graphics graphics, Dimension dimension, int n, int n2, int n3, int n4) {
        Font font = graphics.getFont();
        Font font2 = new Font(font.getName(), 1, font.getSize() * 2);
        graphics.setFont(font2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = (n3 + n - fontMetrics.stringWidth(this.titleString)) / 2;
        int n6 = n2 / 2;
        graphics.drawString(this.titleString, n5, n6);
        String string = "";
        if (this.seisEventList.size() >= 1) {
            string = this.seisEventList.size() == 1 ? ((SeisEvent)this.seisEventList.get(0)).toString() : this.seisEventList.size() + " events:   " + ((SeisEvent)this.seisEventList.get(0)).dateString() + "  ->  " + ((SeisEvent)this.seisEventList.get(this.seisEventList.size() - 1)).dateString();
        }
        font2 = new Font(font.getName(), font.getStyle(), font.getSize() * 2);
        graphics.setFont(font2);
        fontMetrics = graphics.getFontMetrics();
        n5 = (n3 + n - fontMetrics.stringWidth(string)) / 2;
        graphics.drawString(string, n5, n6 += 4 * fontMetrics.getHeight() / 3);
        String string2 = "";
        if (this.eventFileNames != null && this.eventFileNames.length > 0) {
            string2 = string2 + "Event file: " + this.eventFileNames[0] + "    ";
        }
        string2 = string2 + "Printed: " + new Date().toString();
        font2 = new Font(font.getName(), font.getStyle(), 3 * font.getSize() / 2);
        graphics.setFont(font2);
        fontMetrics = graphics.getFontMetrics();
        n5 = n;
        n6 = (dimension.height + n4) / 2;
        graphics.drawString(string2, n5, n6);
    }

    public void doSnapshot() {
        Object object;
        block9: {
            if (this.imageIOFileName == null) {
                this.snapshotDirectory = this.getParameter("snapshot.directory");
                if (this.snapshotDirectory == null) {
                    this.snapshotDirectory = ".";
                }
                this.snapshotDirectory = this.snapshotDirectory + System.getProperty("file.separator");
                this.snapshotFormat = this.getParameter("snapshot.format");
                if (this.snapshotFormat == null) {
                    this.snapshotFormat = "jpg";
                }
                object = "snapshot";
                if (this.titleString != null && this.titleString.trim().length() > 0) {
                    System.out.println("titleString: |" + this.titleString + "|");
                    object = this.titleString.trim().replace("\"", "").replaceAll("[^a-zA-Z0-9-_\\.]", "_");
                    if (((String)object).length() > 50) {
                        object = ((String)object).substring(0, 50);
                    }
                    System.out.println("filename: |" + (String)object + "|");
                }
                this.imageIOFileName = this.snapshotDirectory + (String)object + "." + this.snapshotFormat;
            }
            object = null;
            try {
                boolean bl = true;
                object = URLChooser.doFileChooser(this, SeismicityText.SAVE_SNAPSHOT_AS, AJLFileFilter.getImageIOFileFilters(), new AJLFileView(null, AJLFileFilter.getImageIOFileFilters()), this.imageIOFileName, false, false, false, bl, AJLFileFilter.getImageIOFileFilters()[0]);
            }
            catch (Exception exception) {
                String string = "ERROR: Snapshot: " + exception;
                System.out.println(string);
                if (PRINT_STACK_TRACES) {
                    exception.printStackTrace();
                }
                this.writeMessage(string);
                if (!this.parent.isApplet()) break block9;
                string = "  The applet security setting on your browser for this host (" + this.getDocumentBase().getHost() + ") may be preventing acess to your system properties and the writing of files to your disk.";
                System.out.println(string);
                this.writeMessage(string);
            }
        }
        if (object == null || object[0] == null) {
            return;
        }
        this.imageIOFileName = object[0];
        this.doSnapshot(this.imageIOFileName);
    }

    public boolean doSnapshot(String string) {
        String string2;
        Object object;
        this.writeMessage("Writing snapshot image file: " + string, MESSAGE_FOREGROUND, MESSAGE_BACKGROUND_EMPHASIS);
        File file = new File(string);
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageIO.createImageOutputStream(file);
        }
        catch (Throwable throwable) {
            this.writeMessage("_READY");
            String string3 = "ERROR: Opening snapshot image file: " + string;
            System.out.println(string3);
            this.writeMessage(string3);
            return false;
        }
        Dimension dimension = this.panel3D.getSize();
        String string4 = this.getParameter("snapshot.size");
        if (string4 != null) {
            try {
                object = new StringTokenizer(string4, ",");
                dimension = new Dimension(Integer.parseInt(((StringTokenizer)object).nextToken()), Integer.parseInt(((StringTokenizer)object).nextToken()));
            }
            catch (Exception exception) {
                this.writeMessage("_READY");
                string2 = "ERROR: Parsing snapshot.size parameter: " + string4 + ": " + exception;
                System.out.println(string2);
                this.writeMessage(string2);
            }
        }
        object = null;
        try {
            ++this.transformationIndex;
            object = this.panel3D.paintSnapshot(2, dimension);
            ++this.transformationIndex;
            string2 = string.substring(string.lastIndexOf(46) + 1);
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName(string2);
            if (!iterator.hasNext()) {
                throw new Exception("Image type \"" + string2 + "\" not supported");
            }
            ImageWriter imageWriter = iterator.next();
            imageWriter.setOutput(imageOutputStream);
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            try {
                String string5 = null;
                string5 = this.getParameter("snapshot.param.compression.quality");
                if (string5 != null) {
                    float f = Float.parseFloat(string5);
                    imageWriteParam.setCompressionMode(2);
                    imageWriteParam.setCompressionQuality(f);
                }
            }
            catch (Exception exception) {
                this.writeMessage("_READY");
                String string6 = "ERROR: Setting snapshot image parameters: " + string + ": " + exception;
                System.out.println(string6);
                this.writeMessage(string6);
            }
            imageWriter.write(null, new IIOImage((RenderedImage)object, null, null), imageWriteParam);
            imageWriter.dispose();
            imageOutputStream.flush();
            imageOutputStream.close();
        }
        catch (Exception exception) {
            this.writeMessage("_READY");
            String string7 = "ERROR: Writing snapshot image file: " + string + ": " + exception;
            System.out.println(string7);
            this.writeMessage(string7);
            if (PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            return false;
        }
        this.writeMessage("Saved snapshot image file: " + string);
        return true;
    }

    public void startOfPaint() {
        SeisEvent.Number_quality_RMS = 0;
        SeisEvent.Sum_quality_RMS = 0.0;
        SeisEvent.Sum_quality_RMS_2 = 0.0;
        SeisEvent.Number_ellipsoid_se3 = 0;
        SeisEvent.Sum_ellipsoid_se3 = 0.0;
        SeisEvent.Sum_ellipsoid_se3_2 = 0.0;
        FocalMechanism.NumberPainted = 0;
    }

    public void endOfPaint() {
        if (this.getTrueFalseParameter(false, "verbose")) {
            double d;
            double d2;
            System.out.println("\nSeismicity Viewer verbose output:");
            if (SeisEvent.Number_quality_RMS > 0) {
                d2 = SeisEvent.Sum_quality_RMS / (double)SeisEvent.Number_quality_RMS;
                d = Math.sqrt(SeisEvent.Sum_quality_RMS_2 / (double)SeisEvent.Number_quality_RMS - d2 * d2);
                System.out.println("SeisEvent.quality_RMS: " + (float)d2 + " +/- " + (float)d);
            } else {
                System.out.println("SeisEvent.quality_RMS: Undefined +/- Undefined");
            }
            if (SeisEvent.Number_ellipsoid_se3 > 0) {
                d2 = SeisEvent.Sum_ellipsoid_se3 / (double)SeisEvent.Number_ellipsoid_se3;
                d = Math.sqrt(SeisEvent.Sum_ellipsoid_se3_2 / (double)SeisEvent.Number_ellipsoid_se3 - d2 * d2);
                System.out.println("SeisEvent.ellipsoid_se3: " + (float)d2 + " +/- " + (float)d);
            } else {
                System.out.println("SeisEvent.ellipsoid_se3: Undefined +/- Undefined");
            }
            System.out.println("FocalMechanism.NumberPainted: " + FocalMechanism.NumberPainted);
        }
    }

    public void displayEventInfo(boolean bl) {
        if (this.eventInfoFrame != null && this.lastEventInfoEventPlotFirst == this.eventPlotFirst && this.lastEventInfoEventPlotLast == this.eventPlotLast) {
            if (!this.eventInfoFrame.isShowing()) {
                this.eventInfoFrame.setVisible(true);
            }
            return;
        }
        this.lastEventInfoEventPlotFirst = this.eventPlotFirst;
        this.lastEventInfoEventPlotLast = this.eventPlotLast;
        String string = "";
        String string2 = "";
        JLabel[] jLabelArray = null;
        JLabel[][] jLabelArray2 = null;
        String string3 = System.getProperty("line.separator");
        if (this.eventPlotFirst == this.eventPlotLast) {
            double d;
            double d2;
            SeisEvent seisEvent = (SeisEvent)this.seisEventList.get(this.eventPlotFirst);
            string2 = seisEvent.toString();
            string = string.endsWith(string3) ? string.substring(0, string.length() - string3.length()) : seisEvent.toInfoString();
            try {
                d2 = Float.valueOf(this.getParameter("info.limit.residual")).floatValue();
            }
            catch (Exception exception) {
                d2 = -1.0;
            }
            try {
                d = Float.valueOf(this.getParameter("info.limit.residual.P")).floatValue();
            }
            catch (Exception exception) {
                d = -1.0;
            }
            jLabelArray = seisEvent.getPhaseHeadings(d2, d);
            jLabelArray2 = seisEvent.getPhaseData(this.getFont(), d2, d);
        } else {
            int n;
            int n2 = 10000;
            int n3 = this.eventPlotLast + 1 - this.eventPlotFirst;
            string2 = "" + n3 + " events - " + this.getTitleString();
            if (n3 > n2) {
                n3 = n2;
                string2 = string2 + " (only first " + n2 + " listed)";
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            for (n = this.eventPlotFirst; n < this.eventPlotLast + 1 && n4++ < n2; ++n) {
                stringBuffer.append(n + 1 + " ");
                SeisEvent seisEvent = (SeisEvent)this.seisEventList.get(n);
                stringBuffer.append(seisEvent.toString(true)).append(string3);
            }
            if (n < this.eventPlotLast + 1) {
                stringBuffer.append("LIST TRUNCATED AT " + n2 + " EVENTS");
            }
            string = stringBuffer.toString();
            System.out.println(this.seisEventList.getStats());
        }
        if (this.eventInfoFrame == null) {
            this.eventInfoFrame = new InfoFrame(SeismicityText.CLOSE, this.iconImage);
            SwingExt.setProportionalSize((Component)this.eventInfoFrame, this, 0.95, 0.75);
            SwingExt.setLocationToCenter(this.eventInfoFrame, this, this.getLocationOnScreen());
        }
        this.eventInfoFrame.updateContents(SeismicityText.EVENT_INFO_HEADER + " - " + this.getTitleString(), string2, string, jLabelArray, jLabelArray2, this.getFont());
        this.eventInfoFrame.setVisible(true);
    }

    public String[] getPlottedEventsFilenames() {
        Vector<String> vector = new Vector<String>();
        String string = "";
        for (int i = this.eventPlotFirst; i <= this.eventPlotLast; ++i) {
            String string2 = this.seisEventList.elementAt(i).getEventFileName();
            if (string2.equals(string)) continue;
            vector.add(string2);
            string = string2;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void displayFocalSphere() {
        if (!this.fullyInitialized) {
            return;
        }
        if (this.focalSphereFrame == null) {
            int n;
            Dimension dimension = this.getSize();
            int n2 = n = dimension.width < dimension.height ? dimension.width : dimension.height;
            this.focalSphereFrame = new FocalSphereFrame(this, SeismicityText.FOCAL_SPHERE_HEADER, Color.RED, AJLColor.invert(this.backgroundColor), Color.GRAY, this.backgroundColor, n, n2, this.iconImage);
            SwingExt.setLocationToCenter(this.focalSphereFrame, this, this.getLocationOnScreen());
        }
        this.focalSphereFrame.setTitle(SeismicityText.FOCAL_SPHERE_HEADER + " - " + this.getEventMessage());
        this.focalSphereFrame.display();
        if (!this.focalSphereFrame.isVisible()) {
            this.focalSphereFrame.setVisible(true);
        }
    }

    protected void initHypocenterAssociation() {
        if (this.hypocenterAssociation == null) {
            int n;
            double d;
            try {
                d = Double.parseDouble(this.getParameter("hypoassoc.distminmean.factor"));
            }
            catch (Exception exception) {
                d = 1.0;
            }
            try {
                n = Integer.parseInt(this.getParameter("hypoassoc.color.alpha"));
            }
            catch (Exception exception) {
                n = -1;
            }
            this.hypocenterAssociation = new HypocenterAssociation(this.seisEventList, this.geogCoords, Color.blue, n, d, this.getTrueFalseParameter(false, "hypoassoc.listfractaldists"));
        }
    }

    protected void paintExtrasFirst(Graphics graphics, Vect3D vect3D) {
        if (this.menuItemHypAssoc.isSelected() && this.hypocenterAssociation != null && this.hypocenterAssociation.isInitialized()) {
            this.hypocenterAssociation.getMapLines().paint(graphics, this.globalTransparent, vect3D);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        if (object.equals(this.textFieldAzimuth.getTextField())) {
            double d = this.zrotAng;
            try {
                double d2 = ((Number)this.textFieldAzimuth.getValue()).doubleValue();
                d = this.geogAz2rotAz(d2);
            }
            catch (NumberFormatException numberFormatException) {
                d = Double.NaN;
            }
            if (Double.isNaN(d)) {
                this.setTextFields(this.zrotAng, this.yrotAng, this.xrotAng);
                return;
            }
            this.setViewFrom(d, 0.0, this.xrotAng);
            this.updateEventViews();
        } else if (object.equals(this.textFieldInclination.getTextField())) {
            double d = this.xrotAng;
            try {
                double d3 = ((Number)this.textFieldInclination.getValue()).doubleValue();
                d = this.geogInc2rotInc(d3);
            }
            catch (NumberFormatException numberFormatException) {
                d = Double.NaN;
            }
            if (Double.isNaN(d)) {
                this.setTextFields(this.zrotAng, this.yrotAng, this.xrotAng);
                return;
            }
            this.setViewFrom(this.zrotAng, 0.0, d);
            this.updateEventViews();
        }
    }

    @Override
    public void writeAppletSecurityMessage(String string, Throwable throwable) {
        String string2 = "ERROR: " + string + ": " + throwable;
        System.out.println(string2);
        if (PRINT_STACK_TRACES) {
            throwable.printStackTrace();
        }
        this.writeMessage(string2);
        if (this.parent.isApplet()) {
            String string3 = this.getDocumentBase().getHost();
            if (string3 == null || string3.length() < 1) {
                string3 = "localhost";
            }
            string2 = "ERROR: " + SwingText.ERROR_APPLET_SECURITY_1 + ": <" + string3 + "> " + SwingText.ERROR_APPLET_SECURITY_2;
            System.out.println(string2);
            this.writeMessage(string2);
            String string4 = SwingText.ERROR_APPLET_SECURITY_TITLE + " - " + string;
            JOptionPane.showMessageDialog(this, string2, string4, 0);
        }
    }

    protected boolean launchExternalBrowser(String string, boolean bl) {
        if (!bl) {
            this.writeMessage("INFO: Launching external program to display: " + string);
        }
        try {
            if (this.isApplet()) {
                ((Applet)((Object)this.parent)).getAppletContext().showDocument(new URL(string), "SeisGram2K_help");
            } else {
                Browser.open(string);
            }
            return true;
        }
        catch (Exception exception) {
            if (!bl) {
                String string2 = "ERROR: Launching external program to display: " + string;
                this.writeMessage(string2);
                System.out.println(string2 + ": " + exception);
                exception.printStackTrace();
            }
            return false;
        }
    }

    public boolean isApplet() {
        return this.parent.isApplet();
    }

    protected void autoSetColormap(SeismicityColorMap seismicityColorMap) {
        Object object;
        RangeDouble rangeDouble = new RangeDouble(-3.4028234663852886E38, 3.4028234663852886E38);
        RangeDouble rangeDouble2 = null;
        try {
            rangeDouble2 = this.seisEventFilter.limitsForColorMapType(seismicityColorMap.type);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (rangeDouble2 != null) {
            rangeDouble.min = rangeDouble2.min;
            rangeDouble.max = rangeDouble2.max;
        } else {
            for (int i = 0; i < this.seisEventList.size(); ++i) {
                object = this.seisEventList.elementAt(i);
                if (!this.seisEventFilter.accept((SeisEvent)object)) continue;
                double d = ((SeisEvent)object).valueForColorMapType(seismicityColorMap.type);
                if (i == 0) {
                    rangeDouble.max = rangeDouble.min = d;
                    continue;
                }
                if (d > rangeDouble.max) {
                    rangeDouble.max = d;
                    continue;
                }
                if (!(d < rangeDouble.min)) continue;
                rangeDouble.min = d;
            }
        }
        if (seismicityColorMap.type == SeismicityColorMap.Type.OTIME) {
            seismicityColorMap.otimeColorMapRangeDays = (rangeDouble.max - rangeDouble.min) / 8.64E7;
        }
        int n = 6;
        object = new double[n];
        Color[] colorArray = new Color[n];
        for (int i = 0; i < n; ++i) {
            double d = (double)(i + 1) / (double)(n + 1);
            if (this.getTrueFalseParameter(false, "event.colormap.reverse")) {
                d = 1.0 - d;
            }
            float f = 0.65f;
            colorArray[i] = AJLColor.amp2color(Math.sqrt(d), SeismicityColorMap.colorScale, false, f);
            double d2 = (double)i / (double)(n - 1);
            object[i] = rangeDouble.min + (rangeDouble.max - rangeDouble.min) * d2;
        }
        seismicityColorMap.setNodeValuesAndColors((double[])object, colorArray);
        if (this.getTrueFalseParameter(true, "event.colormap.saturate")) {
            seismicityColorMap.saturateColors();
        }
    }

    public void autoSnapShotExit() {
        this.recordSnapshot();
        this.cleanUp();
        this.parent.closeFrame();
    }

    static {
        SeismicityFrame.HELP_ABOUT[0] = BANNER[0];
        SeismicityFrame.HELP_ABOUT[1] = BANNER[1];
        SeismicityFrame.HELP_ABOUT[2] = BANNER[2];
        SeismicityFrame.HELP_ABOUT[3] = NEWLINE + "---------------------------------" + NEWLINE;
        SeismicityFrame.HELP_ABOUT[4] = COPYRIGHT;
        globalCoastlineNameDefault = "world.zip";
        globalCoastlineName = null;
        globalPlateBoundaryNameDefault = "plates.lonlat.zip";
        globalPlateBoundaryName = null;
        MESSAGE_FOREGROUND = Color.BLACK;
        MESSAGE_BACKGROUND = Color.WHITE;
        MESSAGE_BACKGROUND_EMPHASIS = Color.PINK;
    }
}

