/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Graphics;
import java.awt.Graphics2D;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.seismicity.SeismicityColors;
import net.alomax.seismicity.SeismicityStrokes;
import net.alomax.util.NumberFormat;

public class SeisResidual {
    protected static final int idiam = 4;
    protected boolean isPresidual = false;
    protected boolean isSresidual = false;
    protected String phase = "";
    protected double residual = 0.0;
    protected int numRes = 0;

    public SeisResidual(String string, double d) {
        this(string);
        this.residual = d;
        this.numRes = 1;
    }

    public SeisResidual(String string) {
        this.phase = string;
        this.isPresidual = SeisResidual.isPphase(string);
        this.isSresidual = SeisResidual.isSphase(string);
    }

    public static boolean isPphase(String string) {
        return string.toUpperCase().endsWith("P") || string.toUpperCase().startsWith("P") && !string.toUpperCase().endsWith("S");
    }

    public static boolean isSphase(String string) {
        return string.toUpperCase().endsWith("S") || string.toUpperCase().startsWith("S") && !string.toUpperCase().endsWith("P");
    }

    public double getResidual() {
        return this.residual;
    }

    public void paint(Graphics graphics, boolean bl, boolean bl2, Vect3D vect3D, Vect3D vect3D2, double d, double d2, Vect3D vect3D3, boolean bl3, boolean bl4) {
        if (this.numRes > 0 && (bl && this.isPresidual || bl2 && this.isSresidual)) {
            Graphics graphics2 = graphics.create();
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            Vect3D vect3D4 = null;
            if (this.isPresidual) {
                if (this.residual >= 0.0) {
                    graphics2.setColor(SeismicityColors.phaseResidualPup);
                    if (SeismicityStrokes.phaseResidualPup != null) {
                        try {
                            ((Graphics2D)graphics2).setStroke(SeismicityStrokes.phaseResidualPup);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    graphics2.setColor(SeismicityColors.phaseResidualPdown);
                    if (SeismicityStrokes.phaseResidualPdown != null) {
                        try {
                            ((Graphics2D)graphics2).setStroke(SeismicityStrokes.phaseResidualPdown);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                vect3D4 = vect3D2.mult(-0.5f * (float)d);
            } else {
                if (this.residual >= 0.0) {
                    graphics2.setColor(SeismicityColors.phaseResidualSup);
                    if (SeismicityStrokes.phaseResidualSup != null) {
                        try {
                            ((Graphics2D)graphics2).setStroke(SeismicityStrokes.phaseResidualSup);
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    graphics2.setColor(SeismicityColors.phaseResidualSdown);
                    if (SeismicityStrokes.phaseResidualSdown != null) {
                        try {
                            ((Graphics2D)graphics2).setStroke(SeismicityStrokes.phaseResidualSdown);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                vect3D4 = vect3D2.mult(0.5f * (float)d);
            }
            Vect3D vect3D5 = vect3D3.add(vect3D4);
            Matrix3D.applyPerspTrans(vect3D5, nArray);
            vect3D5 = vect3D5.add(vect3D.mult(d2 * this.residual));
            Matrix3D.applyPerspTrans(vect3D5, nArray2);
            Draw3D.drawLine(graphics2, nArray[0], nArray[1], nArray2[0], nArray2[1]);
            if (!bl3) {
                Draw3D.fillOval(graphics2, nArray[0] - 2, nArray[1] - 2, 4, 4);
            }
            if (bl4) {
                graphics2.drawString(NumberFormat.doubleString(this.residual, -1, 2), nArray[0] + 4, nArray[1] + (this.residual >= 0.0 ? 20 : -8));
            }
            graphics2.dispose();
        }
    }
}

