/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.util.ArrayList;
import net.alomax.seismicity.SeisEvent;
import net.alomax.seismicity.SeisPhase;
import net.alomax.seismicity.SeismicityFrame;

public class SeisEventList
extends ArrayList<SeisEvent> {
    protected SeismicityFrame seisApp = null;

    public SeisEventList(SeismicityFrame seismicityFrame) {
        this.seisApp = seismicityFrame;
    }

    public SeisEvent elementAt(int n) {
        return (SeisEvent)this.get(n);
    }

    public SeisEvent lastElement() {
        return (SeisEvent)this.get(this.size() - 1);
    }

    public int addEvent(SeisEvent seisEvent, int n) {
        seisEvent.original_index = n;
        if (!this.seisApp.seisEventFilter.accept(seisEvent)) {
            return 0;
        }
        for (SeisPhase seisPhase : seisEvent.getPhaseList()) {
            this.seisApp.addStation(seisPhase);
        }
        this.add(seisEvent);
        return 1;
    }

    public String getStats() {
        double d = 0.0;
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = 0;
        for (SeisEvent seisEvent : this) {
            d += seisEvent.quality_RMS;
            n += seisEvent.quality_Nphs;
            d2 += (double)seisEvent.quality_Gap;
            d3 += seisEvent.quality_Dist;
            d4 += seisEvent.quality_errH;
            d5 += seisEvent.quality_errZ;
            try {
                d6 += seisEvent.ellipsoid.se3;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        Object object = "Event Stats (nEvents=" + this.size() + ", nStat=" + n2 + "):";
        if (n2 > 0) {
            object = (String)object + " rms=" + (float)(d / (double)n2);
            object = (String)object + ", nphs=" + (float)((double)n / (double)n2);
            object = (String)object + ", gap=" + (float)(d2 / (double)n2);
            object = (String)object + ", dist=" + (float)(d3 / (double)n2);
            object = (String)object + ", errH=" + (float)(d4 / (double)n2);
            object = (String)object + ", errZ=" + (float)(d5 / (double)n2);
            object = (String)object + ", se3=" + (float)(d6 / (double)n2);
        }
        return object;
    }
}

