/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.alomax.awt.AJLColor;
import net.alomax.awt.ColorMapLegend;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.seismicity.SeisEvent;
import net.alomax.seismicity.SeismicityColorMap;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.swing.NavigationActionEvent;
import net.alomax.swing.NavigationListener;
import net.alomax.util.NumberFormat;

public class Panel3D
extends JPanel
implements MouseListener,
MouseMotionListener,
NavigationListener,
MouseWheelListener {
    protected SeismicityFrame seisApp = null;
    protected ColorMapLegend colorMapLegend = null;
    protected Matrix3D rotationMatrix = new Matrix3D();
    protected Matrix3D viewMat = new Matrix3D();
    protected Matrix3D projMat = new Matrix3D();
    protected Timer rotationTimer = null;
    protected boolean eventDisplayReverse = false;
    protected int prevx;
    protected int prevy;
    protected int mouseDownx;
    protected int mouseDowny;
    protected boolean mouseIsDown = false;
    protected boolean painted = true;
    protected int numEventsPassedFilter = 0;
    protected float xtheta = 0.0f;
    protected float ytheta = 0.0f;
    protected boolean rotationPerformed = false;
    protected double aveRotationDx = 0.0;
    protected double aveRotationDy = 0.0;
    protected double aveRotationTimeStep = 0.0;
    protected long lastRotationWhen = -1L;
    protected static final double C1 = 0.7;
    protected static final double C2 = 0.30000000000000004;
    protected double rotateStep = 1.0;
    protected int panStep = 1;
    int icount = 0;

    public Panel3D(SeismicityFrame seismicityFrame) {
        this.seisApp = seismicityFrame;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.setRequestFocusEnabled(true);
        this.addKeyListener(this.seisApp);
        this.enableEvents(8L);
        this.eventDisplayReverse = this.seisApp.getTrueFalseParameter(false, "event.display.reverse");
    }

    public BufferedImage paintSnapshot(int n, Dimension dimension) {
        Dimension dimension2 = this.getSize();
        this.setSize(dimension);
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), n);
        Graphics graphics = bufferedImage.getGraphics();
        try {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            while (!this.painted) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.paint(graphics, this.getSize(), true, this.seisApp.globalTransparent);
        graphics.dispose();
        this.setSize(dimension2);
        return bufferedImage;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void print(Graphics graphics, Dimension dimension) {
        this.paint(graphics, dimension, true, this.seisApp.globalTransparent);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, this.getSize(), false, this.seisApp.globalTransparent);
    }

    protected void paintEvents(Graphics graphics, Shape shape, Polygon polygon, Vect3D vect3D, boolean bl, boolean bl2) {
        this.numEventsPassedFilter = 0;
        if (this.seisApp.eventFileNames != null) {
            int n;
            if (!this.seisApp.latlonClipEvents) {
                graphics.setClip(shape);
            }
            boolean bl3 = this.seisApp.eventPlotFirst == this.seisApp.eventPlotLast;
            for (n = 0; n < this.seisApp.seisEventList.size(); ++n) {
                Vect3D vect3D2;
                Vect3D vect3D3;
                int n2 = n;
                if (this.eventDisplayReverse) {
                    n2 = this.seisApp.seisEventList.size() - n - 1;
                }
                SeisEvent seisEvent = this.seisApp.seisEventList.elementAt(n2);
                if (n2 < this.seisApp.eventPlotFirst || n2 > this.seisApp.eventPlotLast || !this.seisApp.seisEventFilter.accept(seisEvent)) continue;
                ++this.numEventsPassedFilter;
                seisEvent.transform(this.seisApp.transformationIndex, this.seisApp.maxLikeFlag, this.seisApp.expectFlag, this.seisApp.probDenFlag && !bl2);
                boolean bl4 = false;
                if (!bl && seisEvent.hypocenter != null && this.seisApp.eventPlotFirst != this.seisApp.eventPlotLast && vect3D.dot(vect3D3 = (vect3D2 = new Vect3D(seisEvent.hypocenter.x, seisEvent.hypocenter.y, seisEvent.hypocenter.z)).sub(this.seisApp.globalCenter)) > 0.0) {
                    bl4 = true;
                }
                if (bl4) continue;
                seisEvent.paint(graphics, this.seisApp.maxLikeFlag, this.seisApp.expectFlag, this.seisApp.ellipseFlag && !bl2, this.seisApp.probDenFlag && !bl2, this.seisApp.PresidualFlag && bl3, this.seisApp.SresidualFlag && bl3, this.seisApp.weightsAllFlag, this.seisApp.firstMotionFlag && bl3, this.seisApp.rayFlag, this.seisApp.stationSymFlag, this.seisApp.residualLabelFlag, this.seisApp.faultPlanesFlag, this.seisApp.pressureAxisFlag, this.seisApp.tensionAxisFlag, this.seisApp.nodalAxisFlag, this.seisApp.slipAxesFlag, this.seisApp.thrustOnlyFlag, this.seisApp.normalOnlyFlag, this.seisApp.strikeSlipOnlyFlag, this.seisApp.horizOnlyCutoffDip, this.seisApp.targetSlipAxis, this.seisApp.mechMisfitMax, this.seisApp.mechNobsMin, this.seisApp.paintPTNaxesBowtie, this.seisApp.magnitudeFlag, this.seisApp.magSymbolMinimumMag, this.seisApp.magSymbolMaximumMag, this.seisApp.magSymbolScaleFactor, this.seisApp.magSymbolSizeExponent);
            }
            this.seisApp.eventPlotCurrent = this.seisApp.eventPlotFirst;
            this.seisApp.textFieldPlotNum.setText(String.valueOf(this.seisApp.eventPlotCurrent + 1));
            bl3 = this.seisApp.eventPlotFirst == 0 && this.seisApp.eventPlotLast == this.seisApp.seisEventList.size() - 1 && this.seisApp.seisEventList.size() != 1;
            for (n = 0; n < this.seisApp.stationList.size(); ++n) {
                this.seisApp.stationList.elementAt(n).paint(graphics, this.seisApp.stationNameFlag && !bl2, this.seisApp.PresidualFlag && bl3, this.seisApp.SresidualFlag && bl3, this.seisApp.stationSymFlag, this.seisApp.residualLabelFlag);
            }
            if (!this.seisApp.latlonClipEvents && polygon != null) {
                graphics.setClip(polygon);
            }
        }
    }

    public void paint(Graphics graphics, Dimension dimension, boolean bl, boolean bl2) {
        int n;
        boolean bl3;
        int n2;
        if (!this.painted || !this.seisApp.fullyInitialized || this.seisApp.grid3D == null || this.seisApp.seisEventList.size() <= 0 && this.seisApp.eventFileNames != null) {
            return;
        }
        this.seisApp.startOfPaint();
        Graphics graphics2 = graphics.create();
        try {
            if (bl) {
                ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            } else {
                ((Graphics2D)graphics2).setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setPainted(false);
        double d = (double)dimension.width / this.seisApp.worldWidthMax;
        double d2 = (double)dimension.height / this.seisApp.worldWidthMax;
        this.seisApp.viewScale = this.seisApp.viewScaleFactor * (d > d2 ? d : d2);
        this.viewMat.unit();
        this.viewMat.scale(1.0, 1.0, -1.0);
        this.viewMat.mult(this.seisApp.worldTransMat);
        this.viewMat.mult(this.seisApp.rotMat);
        this.projMat.unit();
        this.projMat.scale(this.seisApp.viewScale, -this.seisApp.viewScale, this.seisApp.viewScale);
        this.projMat.translate(dimension.width / 2, dimension.height / 2, 0.0);
        if (this.seisApp.projectFlag) {
            Matrix3D.setPerspTrans(this.viewMat, this.seisApp.perspDist, this.projMat);
        } else {
            Matrix3D.setPerspTrans(this.viewMat, -1.0, this.projMat);
        }
        Vect3D vect3D = null;
        if (!bl2) {
            Matrix3D matrix3D = new Matrix3D(this.seisApp.rotMat);
            matrix3D.rotInvert();
            vect3D = new Vect3D(0.0, 0.0, 1.0);
            vect3D = vect3D.mult(matrix3D);
            vect3D.z *= -1.0;
        }
        graphics2.setColor(this.seisApp.backgroundColor);
        graphics2.fillRect(0, 0, this.getSize().width, this.getSize().height);
        boolean bl4 = false;
        if (this.mouseIsDown && this.seisApp.quickDrawFlag && this.seisApp.eventPlotFirst != this.seisApp.eventPlotLast) {
            bl4 = true;
        }
        Shape shape = graphics2.getClip();
        Polygon polygon = null;
        Line3D line3D = this.seisApp.grid3D.getClipLatLonBoxLine3D();
        if (line3D != null) {
            polygon = line3D.toPolygon();
        }
        if (polygon != null) {
            graphics2.setClip(polygon);
        }
        this.seisApp.paintImage2D(graphics2);
        this.seisApp.paintExtrasFirst(graphics2, vect3D);
        boolean bl5 = this.seisApp.getTrueFalseParameter(true, "paint.lines.last");
        if (!bl5) {
            n2 = 0;
            while (true) {
                if (n2 >= 15) break;
                if (this.seisApp.graphicLineDraw[n2] && this.seisApp.graphicLine[n2] != null) {
                    this.seisApp.graphicLine[n2].paint(graphics2, this.seisApp.globalTransparent, vect3D);
                }
                ++n2;
            }
            for (n2 = 0; n2 < this.seisApp.graphicPolyline.length; ++n2) {
                if (!this.seisApp.graphicPolylineDraw[n2] || this.seisApp.graphicPolyline[n2] == null) continue;
                this.seisApp.graphicPolyline[n2].paint(graphics2, this.seisApp.globalTransparent, vect3D);
            }
            for (n2 = 0; n2 < this.seisApp.graphicShapefile.length; ++n2) {
                if (!this.seisApp.graphicShapefileDraw[n2] || this.seisApp.graphicShapefile[n2] == null) continue;
                this.seisApp.graphicShapefile[n2].transform(this.seisApp.transformationIndex);
                this.seisApp.graphicShapefile[n2].paint(graphics2, this.seisApp.globalTransparent, vect3D);
            }
        }
        for (n2 = 0; n2 < this.seisApp.sampleSet.length; ++n2) {
            if (!this.seisApp.sampleSetDraw[n2] || this.seisApp.sampleSet[n2] == null) continue;
            this.seisApp.sampleSet[n2].transform(this.seisApp.transformationIndex);
            this.seisApp.sampleSet[n2].paint(graphics2);
        }
        n2 = this.seisApp.getTrueFalseParameter(false, "paint.events.last") ? 1 : 0;
        if (n2 == 0) {
            this.paintEvents(graphics2, shape, polygon, vect3D, bl2, bl4);
        }
        if (polygon != null) {
            graphics2.setClip(shape);
        }
        this.seisApp.grid3D.transform(this.seisApp.transformationIndex);
        this.seisApp.grid3D.paint(graphics2, this.seisApp.globalTransparent, vect3D);
        if (this.seisApp.grid3DGlobal != null) {
            this.seisApp.grid3DGlobal.transform(this.seisApp.transformationIndex);
            this.seisApp.grid3DGlobal.paint(graphics2, this.seisApp.globalTransparent, vect3D);
        }
        if (polygon != null) {
            graphics2.setClip(polygon);
        }
        if (this.seisApp.axes3DVisible) {
            this.seisApp.updateAxes3D();
            if (this.seisApp.axes3D != null) {
                this.seisApp.axes3D.paint(graphics2);
            }
        }
        if (!(bl3 = this.seisApp.getTrueFalseParameter(false, "paint.polygons.last"))) {
            for (n = 0; n < this.seisApp.graphicPolygon.length; ++n) {
                if (!this.seisApp.graphicPolygonDraw[n] || this.seisApp.graphicPolygon[n] == null) continue;
                this.seisApp.graphicPolygon[n].paint(graphics2, this.seisApp.globalTransparent, vect3D);
            }
        }
        for (n = 0; n < this.seisApp.graphicSymbol.length; ++n) {
            if (!this.seisApp.graphicSymbolDraw[n] || this.seisApp.graphicSymbol[n] == null) continue;
            this.seisApp.graphicSymbol[n].transform(this.seisApp.transformationIndex);
            this.seisApp.graphicSymbol[n].paint(graphics2, this.seisApp.globalTransparent, vect3D);
        }
        if (bl5) {
            n = 0;
            while (true) {
                if (n >= 15) break;
                if (this.seisApp.graphicLineDraw[n] && this.seisApp.graphicLine[n] != null) {
                    this.seisApp.graphicLine[n].paint(graphics2, this.seisApp.globalTransparent, vect3D);
                }
                ++n;
            }
            for (n = 0; n < this.seisApp.graphicPolyline.length; ++n) {
                if (!this.seisApp.graphicPolylineDraw[n] || this.seisApp.graphicPolyline[n] == null) continue;
                this.seisApp.graphicPolyline[n].paint(graphics2, this.seisApp.globalTransparent, vect3D);
            }
            for (n = 0; n < this.seisApp.graphicShapefile.length; ++n) {
                if (!this.seisApp.graphicShapefileDraw[n] || this.seisApp.graphicShapefile[n] == null) continue;
                this.seisApp.graphicShapefile[n].transform(this.seisApp.transformationIndex);
                this.seisApp.graphicShapefile[n].paint(graphics2, this.seisApp.globalTransparent, vect3D);
            }
        }
        if (bl3) {
            for (n = 0; n < this.seisApp.graphicPolygon.length; ++n) {
                if (!this.seisApp.graphicPolygonDraw[n] || this.seisApp.graphicPolygon[n] == null) continue;
                this.seisApp.graphicPolygon[n].paint(graphics2, this.seisApp.globalTransparent, vect3D);
            }
        }
        if (n2 != 0) {
            this.paintEvents(graphics2, shape, polygon, vect3D, bl2, bl4);
        }
        if (polygon != null) {
            graphics2.setClip(shape);
        }
        if (this.seisApp.graphicTextDraw) {
            for (n = 0; n < this.seisApp.graphicText3D.size(); ++n) {
                this.seisApp.graphicText3D.elementAt(n).paint(graphics2);
            }
        }
        if (this.seisApp.maxLikeFlag || this.seisApp.expectFlag || SeisEvent.samples_applycolormap || SeisEvent.ellipsoid_applycolormap) {
            SeismicityColorMap seismicityColorMap;
            if (this.colorMapLegend == null && (seismicityColorMap = SeisEvent.getColorMap()) != null) {
                this.colorMapLegend = new ColorMapLegend(seismicityColorMap, seismicityColorMap.getName(), seismicityColorMap.getUnits(), this.seisApp.colormapTextSizeFactor * this.seisApp.globalTextSizeFactor, this.seisApp.backgroundColor, AJLColor.invert(this.seisApp.backgroundColor), this);
                if (this.seisApp.seisEventFilter.otimeLimits != null && seismicityColorMap.type == SeismicityColorMap.Type.OTIME) {
                    this.colorMapLegend.setIndicatorBar(this.seisApp.seisEventFilter.otimeLimits[0], this.seisApp.seisEventFilter.otimeLimits[1]);
                }
            }
            if (this.colorMapLegend != null) {
                this.colorMapLegend.setBackground(this.seisApp.backgroundColor);
                Color color = AJLColor.invert(this.seisApp.backgroundColor);
                color = AJLColor.toBlackWhite(color);
                this.colorMapLegend.setForeground(color);
                Rectangle rectangle = graphics2.getClipBounds();
                if (rectangle == null) {
                    rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                }
                int n3 = rectangle.x + rectangle.width / 2;
                int n4 = rectangle.width;
                int n5 = rectangle.y + 99 * rectangle.height / 100;
                this.colorMapLegend.paint(graphics2, n3 - n4 / 2, n5, n4);
            }
        }
        graphics2.dispose();
        this.setPainted(true);
        this.seisApp.requestFocus(this);
        this.seisApp.endOfPaint();
    }

    public boolean rotateView(int n, int n2) {
        this.updateRotationMatrix(n, n2);
        return this.rotateView();
    }

    public boolean rotateView() {
        if (!this.seisApp.rotate(this.rotationMatrix)) {
            return false;
        }
        this.seisApp.setRotationAngles(this.seisApp.zrotAng, this.seisApp.yrotAng - (double)this.ytheta, this.seisApp.xrotAng - (double)this.xtheta);
        this.seisApp.updateEventViews();
        return true;
    }

    public void updateRotationMatrix(int n, int n2) {
        this.rotationMatrix.unit();
        this.xtheta = 0.5f * (float)n2 * (360.0f / (float)this.getSize().width);
        this.ytheta = 0.5f * (float)n * (360.0f / (float)this.getSize().height);
        this.rotationMatrix.xrot(-this.xtheta);
        this.rotationMatrix.yrot(-this.ytheta);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.rotationTimer != null) {
            this.stopRotationTimer();
        }
        if (!this.rotateView(n2 = mouseEvent.getX() - this.prevx, n = this.prevy - mouseEvent.getY())) {
            return;
        }
        this.prevx = mouseEvent.getX();
        this.prevy = mouseEvent.getY();
        this.rotationPerformed = true;
        if (this.lastRotationWhen < 0L) {
            this.lastRotationWhen = mouseEvent.getWhen();
        }
        this.aveRotationTimeStep = 0.7 * this.aveRotationTimeStep + 0.30000000000000004 * (double)(mouseEvent.getWhen() - this.lastRotationWhen);
        this.lastRotationWhen = mouseEvent.getWhen();
        this.aveRotationDx = 0.7 * this.aveRotationDx + 0.30000000000000004 * (double)n2;
        this.aveRotationDy = 0.7 * this.aveRotationDy + 0.30000000000000004 * (double)n;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void displayWorldCoordinates(MouseEvent mouseEvent) {
        Matrix3D matrix3D = this.seisApp.getOrthogonalInverse(this.getSize());
        Vect3D vect3D = new Vect3D(mouseEvent.getX(), mouseEvent.getY(), 0.0f);
        Vect3D vect3D2 = vect3D.mult(matrix3D);
        Vect3D vect3D3 = this.seisApp.geogCoords.xyz2geog(vect3D2);
        String string = "Mouse Location: (" + mouseEvent.getX() + ", " + mouseEvent.getY() + "), world=(" + vect3D2.x + ", " + vect3D2.y + ", " + vect3D2.z + "), geog=" + NumberFormat.doubleString(vect3D3.x, -1, 5, true) + ", " + NumberFormat.doubleString(vect3D3.y, -1, 5, true) + ", " + NumberFormat.doubleString(-vect3D3.z, -1, 5, true) + ")";
        System.out.println(string);
        this.seisApp.writeMessage(string);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() != 1) {
            this.displayWorldCoordinates(mouseEvent);
            return;
        }
        if (this.rotationTimer != null) {
            this.stopRotationTimer();
            return;
        }
        this.mouseIsDown = false;
        if (mouseEvent.getX() == this.mouseDownx && mouseEvent.getY() == this.mouseDowny) {
            this.seisApp.newWorldCenter(mouseEvent.getX(), mouseEvent.getY(), this.getSize());
        }
        this.seisApp.updateEventViews();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.rotationTimer != null) {
            this.stopRotationTimer();
            return;
        }
        this.mouseIsDown = true;
        this.mouseDownx = this.prevx = mouseEvent.getX();
        this.mouseDowny = this.prevy = mouseEvent.getY();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.mouseIsDown = false;
        if (this.rotationPerformed && mouseEvent.getWhen() - this.lastRotationWhen < (long)((int)Math.round(this.aveRotationTimeStep))) {
            this.updateRotationMatrix((int)Math.round(this.aveRotationDx), (int)Math.round(this.aveRotationDy));
            int n = 1;
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (!Panel3D.this.rotateView()) {
                        Panel3D.this.stopRotationTimer();
                    }
                }
            };
            this.rotationTimer = new Timer(n, actionListener);
            this.rotationTimer.start();
            this.rotationPerformed = false;
        }
        this.seisApp.updateEventViews();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void stopRotationTimer() {
        this.rotationTimer.stop();
        this.rotationTimer = null;
        this.aveRotationDx = 0.0;
        this.aveRotationDy = 0.0;
        this.aveRotationTimeStep = 0.0;
        this.lastRotationWhen = -1L;
    }

    protected synchronized void setPainted(boolean bl) {
        this.painted = bl;
        if (this.painted) {
            this.notifyAll();
        }
    }

    @Override
    public boolean navigationPerformed(NavigationActionEvent navigationActionEvent) {
        int n = 1;
        if (this.seisApp.shiftKeyIsDown()) {
            n = 5;
        }
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        if (navigationActionEvent.getID() == NavigationActionEvent.AZIMUTH_CLOCKWISE) {
            bl = true;
            d2 = this.rotateStep;
        } else if (navigationActionEvent.getID() == NavigationActionEvent.AZIMUTH_COUNTERCLOCKWISE) {
            bl = true;
            d2 = -this.rotateStep;
        }
        if (bl) {
            if (d2 != 0.0) {
                this.seisApp.incrementViewAzimuth(d2 * (double)n);
            } else if (d != 0.0) {
                this.seisApp.incrementViewInclination(d * (double)n);
            }
            return true;
        }
        boolean bl2 = false;
        double d3 = 0.0;
        double d4 = 0.0;
        if (navigationActionEvent.getID() == NavigationActionEvent.ROTATE_UP) {
            bl2 = true;
            d3 = -this.rotateStep;
        } else if (navigationActionEvent.getID() == NavigationActionEvent.ROTATE_DOWN) {
            bl2 = true;
            d3 = this.rotateStep;
        } else if (navigationActionEvent.getID() == NavigationActionEvent.ROTATE_LEFT) {
            bl2 = true;
            d4 = this.rotateStep;
        } else if (navigationActionEvent.getID() == NavigationActionEvent.ROTATE_RIGHT) {
            bl2 = true;
            d4 = -this.rotateStep;
        }
        if (bl2) {
            this.rotationMatrix.unit();
            float f = (float)(d3 * (double)n);
            float f2 = (float)(d4 * (double)n);
            this.rotationMatrix.xrot(-f);
            this.rotationMatrix.yrot(-f2);
            if (!this.seisApp.rotate(this.rotationMatrix)) {
                return true;
            }
            this.seisApp.updateEventViews();
            this.seisApp.setRotationAngles(this.seisApp.zrotAng, this.seisApp.yrotAng - (double)f2, this.seisApp.xrotAng - (double)f);
            return true;
        }
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        if (navigationActionEvent.getID() == NavigationActionEvent.PAN_UP) {
            bl3 = true;
            n3 = -1;
        } else if (navigationActionEvent.getID() == NavigationActionEvent.PAN_DOWN) {
            bl3 = true;
            n3 = 1;
        } else if (navigationActionEvent.getID() == NavigationActionEvent.PAN_LEFT) {
            bl3 = true;
            n2 = -1;
        } else if (navigationActionEvent.getID() == NavigationActionEvent.PAN_RIGHT) {
            bl3 = true;
            n2 = 1;
        }
        if (bl3) {
            Dimension dimension = this.getSize();
            this.panStep = dimension.width / 100;
            this.seisApp.newWorldCenter(dimension.width / 2 + n2 * this.panStep * n, dimension.height / 2 + n3 * this.panStep * n, dimension);
            this.seisApp.updateEventViews();
            return true;
        }
        if (navigationActionEvent.getID() == NavigationActionEvent.ZOOM_IN) {
            if (this.seisApp.shiftKeyIsDown()) {
                this.seisApp.zoom(3.0);
            } else {
                this.seisApp.zoom(1.0);
            }
        } else if (navigationActionEvent.getID() == NavigationActionEvent.ZOOM_OUT) {
            if (this.seisApp.shiftKeyIsDown()) {
                this.seisApp.zoom(-3.0);
            } else {
                this.seisApp.zoom(-1.0);
            }
        }
        return false;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (mouseWheelEvent.getScrollType() == 0) {
            int n = mouseWheelEvent.getWheelRotation();
            if (this.seisApp.shiftKeyIsDown()) {
                n *= 3;
            }
            this.seisApp.zoom(-n);
        }
    }
}

