/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import net.alomax.swing.AJLJButton;

public class InfoFrame
extends JFrame {
    protected JPanel headingPanel;
    protected JSplitPane splitPaneMain;
    protected JScrollPane hypoScrollPane;
    protected JScrollPane tableScrollPane;
    protected JPanel closePanel;
    protected JLabel[] columnHeading = null;
    protected JLabel headingLabel = new JLabel();
    protected JTextArea hypoTextArea = new JTextArea("", 0, 0);
    protected boolean updated = true;
    protected boolean scrollPaneAdded = true;

    public InfoFrame(String string, Image image) {
        if (image != null) {
            // empty if block
        }
        this.setIconImage(image);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InfoFrame.this.setVisible(false);
            }
        });
        AJLJButton aJLJButton = new AJLJButton(string);
        aJLJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InfoFrame.this.setVisible(false);
            }
        });
        this.splitPaneMain = new JSplitPane(0);
        this.splitPaneMain.setContinuousLayout(true);
        this.splitPaneMain.setOneTouchExpandable(true);
        this.headingPanel = new JPanel();
        this.headingPanel.setLayout(new GridLayout());
        this.headingPanel.add(this.headingLabel);
        this.hypoTextArea.setEditable(false);
        this.hypoScrollPane = new JScrollPane(this.hypoTextArea);
        this.tableScrollPane = new JScrollPane();
        this.closePanel = new JPanel();
        this.closePanel.setLayout(new FlowLayout(2));
        this.closePanel.add(aJLJButton);
        this.scrollPaneAdded = true;
        this.addComponents(false);
    }

    protected void addComponents(boolean bl) {
        if (!bl && !this.scrollPaneAdded) {
            return;
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.headingPanel, "North");
        this.splitPaneMain.setTopComponent(this.hypoScrollPane);
        if (bl) {
            this.splitPaneMain.setBottomComponent(this.tableScrollPane);
        } else {
            this.splitPaneMain.setBottomComponent(null);
        }
        this.getContentPane().add((Component)this.splitPaneMain, "Center");
        this.getContentPane().add((Component)this.closePanel, "South");
        this.scrollPaneAdded = bl;
    }

    public void updateContents(String string, String string2, String string3, JLabel[] jLabelArray, JLabel[][] jLabelArray2, Font font) {
        this.setTitle(string);
        this.columnHeading = jLabelArray;
        if (string2 != null) {
            this.headingLabel.setText(string2);
            this.headingLabel.setFont(new Font(font.getName(), 3, 4 * font.getSize() / 3));
        }
        this.hypoTextArea.setText(string3);
        this.hypoTextArea.setFont(new Font("Monospaced", 1, font.getSize()));
        if (jLabelArray != null && jLabelArray2 != null) {
            int n;
            JPanel jPanel = new JPanel();
            jPanel.setBackground(Color.white);
            Font font2 = new Font("Monospaced", 3, font.getSize());
            for (n = 0; n < jLabelArray.length; ++n) {
                JPanel jPanel2 = new JPanel(new GridLayout(0, 1));
                jLabelArray[n].setFont(font2);
                jLabelArray[n].setBackground(Color.lightGray);
                jLabelArray[n].setAlignmentX(0.5f);
                jLabelArray[n].setOpaque(true);
                jPanel2.add(jLabelArray[n]);
                for (int i = 0; i < jLabelArray2.length; ++i) {
                    jLabelArray2[i][n].setFont(new Font("Monospaced", 1, font.getSize()));
                    jLabelArray2[i][n].setOpaque(true);
                    jPanel2.add(jLabelArray2[i][n]);
                }
                jPanel2.add(new JLabel());
                jPanel.add(jPanel2);
            }
            this.tableScrollPane = new JScrollPane(jPanel);
            this.addComponents(true);
            n = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            this.tableScrollPane.getVerticalScrollBar().setBlockIncrement(n / 3);
            this.tableScrollPane.getVerticalScrollBar().setUnitIncrement(n / 30);
        } else {
            this.tableScrollPane = new JScrollPane();
            this.addComponents(false);
        }
        this.setEnabled(true);
        this.updated = true;
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.updated) {
            this.splitPaneMain.setDividerLocation(0.3);
            this.updated = false;
        }
        super.paint(graphics);
    }
}

