/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.Color;
import java.util.Vector;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.GlobalLine3D;
import net.alomax.geog.MapLines;
import net.alomax.graphics3d.Sample4D;
import net.alomax.seismicity.SeisEvent;
import net.alomax.seismicity.SeisEventList;

public class HypocenterAssociation {
    protected boolean initialized = false;
    protected double distMinMean;
    protected double distMaxMean;
    protected double distMinGlobal;
    protected double distMaxGlobal;
    protected double distMinMeanFactor = 1.0;
    protected MapLines mapLines = null;
    protected static double FRACTAL_DIST_STEP = 1.15;
    protected static double MIN_DIST_CUTOFF = 0.01;

    public HypocenterAssociation(SeisEventList seisEventList, GeogCoords geogCoords, Color color, int n, double d, boolean bl) {
        if (seisEventList == null || seisEventList.size() < 1) {
            return;
        }
        this.distMinMeanFactor = d;
        this.initializeStatistics(seisEventList);
        this.generateHypoAssocLines(seisEventList, geogCoords, color, n);
        boolean bl2 = this.initialized = this.mapLines != null;
        if (bl) {
            this.doListFractalDists(seisEventList);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public MapLines getMapLines() {
        return this.mapLines;
    }

    protected void initializeStatistics(SeisEventList seisEventList) {
        double d = 0.0;
        double d2 = 0.0;
        this.distMinGlobal = Double.MAX_VALUE;
        this.distMaxGlobal = -1.0;
        int n = 0;
        for (int i = 0; i < seisEventList.size(); ++i) {
            double d3 = Double.MAX_VALUE;
            double d4 = -1.0;
            SeisEvent seisEvent = seisEventList.elementAt(i);
            Sample4D sample4D = seisEvent.hypocenter;
            for (int j = 0; j < seisEventList.size(); ++j) {
                if (i == j) continue;
                SeisEvent seisEvent2 = seisEventList.elementAt(j);
                Sample4D sample4D2 = seisEvent2.hypocenter;
                double d5 = sample4D.x - sample4D2.x;
                double d6 = sample4D.y - sample4D2.y;
                double d7 = sample4D.z - sample4D2.z;
                double d8 = Math.sqrt(d5 * d5 + d6 * d6 + d7 * d7);
                d3 = d8 < d3 ? d8 : d3;
                d4 = d8 > d4 ? d8 : d4;
            }
            d += d3;
            d2 += d4;
            ++n;
            this.distMinGlobal = this.distMinGlobal < d3 ? this.distMinGlobal : d3;
            this.distMaxGlobal = this.distMaxGlobal > d4 ? this.distMaxGlobal : d4;
        }
        this.distMinMean = d / (double)n;
        this.distMaxMean = d2 / (double)n;
        System.out.println("HypocenterAssociation : NumHypo: " + seisEventList.size() + "  Mean distance: min " + (float)this.distMinMean + ", max " + (float)this.distMaxMean + ", nsum " + n);
    }

    protected void generateHypoAssocLines(SeisEventList seisEventList, GeogCoords geogCoords, Color color, int n) {
        Vector<GlobalLine3D> vector = new Vector<GlobalLine3D>();
        double d = this.distMinMean * this.distMinMeanFactor;
        int n2 = 0;
        for (int i = 0; i < seisEventList.size(); ++i) {
            SeisEvent seisEvent = seisEventList.elementAt(i);
            Sample4D sample4D = seisEvent.hypocenter;
            if (SeisEvent.colorMap != null) {
                if (!SeisEvent.colorMap.initialized) {
                    seisEvent.seisApp.autoSetColormap(SeisEvent.colorMap);
                }
                color = SeisEvent.colorMap.colorAt(seisEvent.valueForColorMapType(SeisEvent.colorMap.type));
            }
            if (n > 0) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), n);
            }
            for (int j = i + 1; j < seisEventList.size(); ++j) {
                SeisEvent seisEvent2 = seisEventList.elementAt(j);
                Sample4D sample4D2 = seisEvent2.hypocenter;
                double d2 = sample4D.x - sample4D2.x;
                double d3 = sample4D.y - sample4D2.y;
                double d4 = sample4D.z - sample4D2.z;
                double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
                if (!(d5 <= d)) continue;
                float[] fArray = new float[2];
                float[] fArray2 = new float[2];
                float[] fArray3 = new float[2];
                fArray[0] = (float)sample4D.x;
                fArray2[0] = (float)sample4D.y;
                fArray3[0] = (float)sample4D.z;
                fArray[1] = (float)sample4D2.x;
                fArray2[1] = (float)sample4D2.y;
                fArray3[1] = (float)sample4D2.z;
                vector.addElement(new GlobalLine3D(fArray, fArray2, fArray3, color, null, false));
                ++n2;
            }
        }
        System.out.println("HypocenterAssociation : NumHypo: " + seisEventList.size() + ", NumSeg < Mean distance min " + n2 + ", distMinMeanFactor: " + this.distMinMeanFactor);
        Object[] objectArray = new GlobalLine3D[vector.size()];
        vector.copyInto(objectArray);
        this.mapLines = new MapLines("HypocenterAssociation", "HypocenterAssociation", geogCoords, null, (GlobalLine3D[])objectArray);
    }

    protected void doListFractalDists(SeisEventList seisEventList) {
        double d;
        int n;
        double d2;
        if (seisEventList.size() < 2) {
            return;
        }
        this.distMinGlobal = Math.max(this.distMinGlobal, MIN_DIST_CUTOFF);
        System.out.println("ListFractalDists : NumHypo: " + seisEventList.size() + "  DistMinGlobal: " + (float)this.distMinGlobal + "  DistMaxGlobal: " + (float)this.distMaxGlobal);
        int n2 = 0;
        for (d2 = this.distMaxGlobal; d2 > this.distMinGlobal; d2 /= FRACTAL_DIST_STEP) {
            ++n2;
        }
        System.out.println("DEBUG: ListFractalDists:  nDist: " + n2);
        double[] dArray = new double[n2];
        int[] nArray = new int[n2];
        d2 = this.distMaxGlobal;
        for (n = 0; n < n2; ++n) {
            dArray[n] = d2;
            nArray[n] = 0;
            d2 /= FRACTAL_DIST_STEP;
        }
        System.out.println("DEBUG: ListFractalDists:  min dist: " + d2 * FRACTAL_DIST_STEP);
        for (n = 0; n < seisEventList.size(); ++n) {
            SeisEvent seisEvent = seisEventList.elementAt(n);
            Sample4D sample4D = seisEvent.hypocenter;
            for (int i = n + 1; i < seisEventList.size(); ++i) {
                SeisEvent seisEvent2 = seisEventList.elementAt(i);
                Sample4D sample4D2 = seisEvent2.hypocenter;
                double d3 = sample4D.x - sample4D2.x;
                double d4 = sample4D.y - sample4D2.y;
                double d5 = sample4D.z - sample4D2.z;
                d2 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5);
                int n3 = 0;
                while (n3 < n2 && dArray[n3] >= d2) {
                    int n4 = n3++;
                    nArray[n4] = nArray[n4] + 1;
                }
            }
        }
        System.out.println("ListFractalDists : NumHypo: " + seisEventList.size() + "  nDist: " + n2 + "  DistMinGlobal: " + (float)this.distMinGlobal + "  DistMaxGlobal: " + (float)this.distMaxGlobal);
        System.out.println("Dist CorrInt");
        double d6 = d = (double)(seisEventList.size() * (seisEventList.size() - 1)) / 2.0;
        for (int i = n2 - 1; i > 0; --i) {
            System.out.println((float)dArray[i] + " " + (float)((double)nArray[i] / d6));
        }
    }
}

