/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.alomax.seismicity.Grid2GMTParameters;
import net.alomax.seismicity.SeismicityFrame;
import net.alomax.seismicity.SeismicityText;
import net.alomax.swing.AJLJButton;
import net.alomax.swing.AJLJComboBox;
import net.alomax.swing.AJLJNumberTextField;
import net.alomax.util.ProcessUtil;

public class Grid2GMTDialog
extends JDialog {
    protected static Grid2GMTParameters staticGrid2GMTParams = null;
    protected Grid2GMTParameters grid2GMTParams = null;
    protected SeismicityFrame seismicityFrame = null;
    protected AJLJComboBox choiceMode;
    protected AJLJComboBox choicePlotType;
    protected JLabel messageLabel1;
    protected JTextField outputTextField;
    protected AJLJNumberTextField textField_ix1 = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_ix2 = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_iy1 = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_iy2 = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_ix = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_iy = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_iz = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_lat1 = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_lat2 = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_lon1 = new AJLJNumberTextField();
    protected AJLJNumberTextField textField_lon2 = new AJLJNumberTextField();
    protected String space = "    ";

    Grid2GMTDialog(SeismicityFrame seismicityFrame, Grid2GMTParameters grid2GMTParameters, String string) {
        super(seismicityFrame, SeismicityText.GRID2GMT_INTERFACE_TITLE, false);
        this.seismicityFrame = seismicityFrame;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Grid2GMTDialog.this.setVisible(false);
            }
        });
        if (grid2GMTParameters == null && staticGrid2GMTParams == null) {
            staticGrid2GMTParams = new Grid2GMTParameters(seismicityFrame);
        } else if (grid2GMTParameters != null) {
            staticGrid2GMTParams = new Grid2GMTParameters(grid2GMTParameters);
        }
        this.grid2GMTParams = new Grid2GMTParameters(staticGrid2GMTParams);
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel(this.space + SeismicityText.GRID2GMT_MODE + ": "));
        this.choiceMode = new AJLJComboBox();
        for (int i = 0; i < Grid2GMTParameters.modeNames.length; ++i) {
            this.choiceMode.addItem(Grid2GMTParameters.modeNames[i]);
        }
        jPanel2.add(this.choiceMode);
        jPanel2.add(new JLabel("  "));
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.add(new JLabel(this.space + SeismicityText.GRID2GMT_PLOT_TYPE + ": "));
        this.choicePlotType = new AJLJComboBox();
        for (int i = 0; i < Grid2GMTParameters.plotTypeNames.length; ++i) {
            this.choicePlotType.addItem(Grid2GMTParameters.plotTypeNames[i]);
        }
        jPanel3.add(this.choicePlotType);
        jPanel3.add(new JLabel("  "));
        jPanel.add(jPanel3);
        AJLJButton aJLJButton = new AJLJButton(SeismicityText.APPLY);
        aJLJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2;
                String string3;
                block15: {
                    string3 = null;
                    string2 = null;
                    string = null;
                    Grid2GMTDialog.this.setParameterValues();
                    if (!Grid2GMTDialog.this.checkParameterValues()) {
                        string3 = Grid2GMTDialog.this.space + SeismicityText.ERROR + ": " + Grid2GMTDialog.this.grid2GMTParams.lastErrorString;
                    } else {
                        if (Grid2GMTDialog.this.grid2GMTParams == null) {
                            return;
                        }
                        String string4 = "";
                        try {
                            String string5;
                            string4 = Grid2GMTDialog.this.grid2GMTParams.generateGrid2GMTCommand();
                            System.out.println("Running Grid2GMT:");
                            System.out.println(string4);
                            ProcessUtil processUtil = new ProcessUtil();
                            int n = processUtil.exec(string4);
                            StringBuffer stringBuffer = processUtil.errorStr;
                            StringBuffer stringBuffer2 = processUtil.standardStr;
                            System.out.print(stringBuffer);
                            System.out.print(stringBuffer2);
                            System.out.println("Grid2GMT: exit value = " + n);
                            System.out.flush();
                            if (n != 0) {
                                System.out.println("ERROR: Grid2GMT returned non-zero exit value.");
                                string3 = "ERROR: Grid2GMT returned non-zero exit value (see console).";
                                break block15;
                            }
                            String string6 = Grid2GMTDialog.this.seismicityFrame.getParameter("interface.psviewer");
                            System.out.println("Grid2GMT: INFO: parameter interface.psviewer = " + string6);
                            int n2 = stringBuffer2.indexOf("Output is:") + 11;
                            int n3 = stringBuffer2.indexOf(".ps", n2) + 3;
                            string = string5 = stringBuffer2.substring(n2, n3);
                            if (string6 == null || string6.trim().length() < 1) {
                                System.out.println("Grid2GMT: INFO: no postscript viewer specified (parameterinterface.psviewer)");
                                string2 = "INFO: no postscript viewer specified  (param interface.psviewer, see console).";
                            } else {
                                try {
                                    String string7 = string6 + " " + string5;
                                    System.out.println("Running psviewer:");
                                    System.out.println(string7);
                                    Process process = Runtime.getRuntime().exec(string7, null, null);
                                }
                                catch (Exception exception) {
                                    System.out.println("ERROR: displaying Grid2GMT output in postscript veiwer (interface.psviewer): " + string6);
                                    System.out.println(exception);
                                    string3 = "ERROR: displaying output in postscript veiwer (param interface.psviewer, see console).";
                                }
                            }
                            staticGrid2GMTParams = new Grid2GMTParameters(Grid2GMTDialog.this.grid2GMTParams);
                        }
                        catch (Exception exception) {
                            System.out.println("ERROR: Running Grid2GMT: " + exception);
                            SeismicityFrame cfr_ignored_0 = Grid2GMTDialog.this.seismicityFrame;
                            if (SeismicityFrame.PRINT_STACK_TRACES) {
                                exception.printStackTrace();
                            }
                            string3 = "ERROR: Running Grid2GMT: " + exception;
                        }
                    }
                }
                if (string3 != null) {
                    Grid2GMTDialog.this.messageLabel1.setText(string3);
                    Grid2GMTDialog.this.messageLabel1.setForeground(Color.RED);
                    Grid2GMTDialog.this.getToolkit().beep();
                } else if (string2 != null) {
                    Grid2GMTDialog.this.messageLabel1.setText(string2);
                    Grid2GMTDialog.this.messageLabel1.setForeground(Color.BLUE);
                }
                if (string != null) {
                    Grid2GMTDialog.this.outputTextField.setText(string);
                    Grid2GMTDialog.this.outputTextField.setForeground(Color.BLUE);
                }
            }
        });
        AJLJButton aJLJButton2 = new AJLJButton(SeismicityText.CLOSE);
        aJLJButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Grid2GMTDialog.this.setVisible(false);
            }
        });
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        jPanel4.add(aJLJButton);
        jPanel4.add(aJLJButton2);
        jPanel4.add(new JLabel(" "));
        JPanel jPanel5 = new JPanel(new GridLayout(0, 1));
        jPanel5.add(new JLabel(" "));
        JPanel jPanel6 = new JPanel(new FlowLayout(0));
        JLabel jLabel = new JLabel(SeismicityText.GRID2GMT_INTERFACE_INFO, 0);
        jPanel6.add(jLabel);
        AJLJButton aJLJButton3 = new AJLJButton(SeismicityText.MORE_INFO);
        aJLJButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Grid2GMTDialog.this.seismicityFrame.launchExternalBrowser(SeismicityText.NONLINLOC_INFO_URL, false);
            }
        });
        jPanel6.add(aJLJButton3);
        jPanel6.add(new JLabel(" "));
        jPanel5.add(jPanel6);
        jPanel5.add(new JLabel(" "));
        this.messageLabel1 = new JLabel("          " + SeismicityText.GRID2GMT_INTERFACE_NOTE + "          ", 0);
        this.messageLabel1.setForeground(Color.BLUE);
        JPanel jPanel7 = new JPanel();
        jPanel7.add(new JLabel(SeismicityText.GRID2GMT_OUTPUT_MESSAGE + ":"));
        this.outputTextField = new JTextField(" ");
        this.outputTextField.setEditable(false);
        this.outputTextField.setColumns(40);
        this.outputTextField.setForeground(Color.BLUE);
        jPanel7.add(this.outputTextField);
        this.setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel5, "North");
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel8 = new JPanel(new GridLayout(0, 1));
        jPanel8.add(jPanel4);
        jPanel8.add(this.messageLabel1);
        jPanel8.add(jPanel7);
        this.getContentPane().add((Component)jPanel8, "South");
        this.setFieldValues();
        this.pack();
        this.setEnabled(true);
    }

    protected void setFieldValues() {
        this.choiceMode.setSelectedItem(this.grid2GMTParams.toModeName(this.grid2GMTParams.modeID));
        this.choicePlotType.setSelectedItem(this.grid2GMTParams.toPlotTypeName(this.grid2GMTParams.plotTypeID));
        this.textField_ix1.setValue(this.grid2GMTParams.ix1);
        this.textField_ix2.setValue(this.grid2GMTParams.ix2);
        this.textField_iy1.setValue(this.grid2GMTParams.iy1);
        this.textField_iy2.setValue(this.grid2GMTParams.iy2);
        this.textField_ix.setValue(this.grid2GMTParams.ix);
        this.textField_iy.setValue(this.grid2GMTParams.iy);
        this.textField_iz.setValue(this.grid2GMTParams.iz);
        this.textField_lat1.setValue(this.grid2GMTParams.lat1);
        this.textField_lat2.setValue(this.grid2GMTParams.lat2);
        this.textField_lon1.setValue(this.grid2GMTParams.lon1);
        this.textField_lon2.setValue(this.grid2GMTParams.lon2);
    }

    protected void setParameterValues() {
        this.grid2GMTParams.modeID = this.grid2GMTParams.toModeID(this.choiceMode.getSelectedItem().toString());
        this.grid2GMTParams.plotTypeID = this.grid2GMTParams.toPlotTypeID(this.choicePlotType.getSelectedItem().toString());
        this.grid2GMTParams.ix1 = (int)this.textField_ix1.getValue();
        this.grid2GMTParams.ix2 = (int)this.textField_ix2.getValue();
        this.grid2GMTParams.iy1 = (int)this.textField_iy1.getValue();
        this.grid2GMTParams.iy2 = (int)this.textField_iy2.getValue();
        this.grid2GMTParams.ix = (int)this.textField_ix.getValue();
        this.grid2GMTParams.iy = (int)this.textField_iy.getValue();
        this.grid2GMTParams.iz = (int)this.textField_iz.getValue();
        this.grid2GMTParams.lat1 = this.textField_lat1.getValue();
        this.grid2GMTParams.lat2 = this.textField_lat2.getValue();
        this.grid2GMTParams.lon1 = this.textField_lon1.getValue();
        this.grid2GMTParams.lon2 = this.textField_lon2.getValue();
    }

    public Grid2GMTParameters getGrid2GMTParameters() {
        return this.grid2GMTParams;
    }

    protected boolean checkParameterValues() {
        return this.grid2GMTParams.checkParameterValues();
    }
}

