/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seismicity;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Ellipse3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.seismicity.SeismicityColors;
import net.alomax.seismicity.SeismicityStrokes;

public class FocalMechanism {
    protected static final int NUMPOINTS = 32;
    protected static final double RPD = 0.01745329238474369;
    public static int NumberPainted = 0;
    protected boolean isValid = false;
    protected double x0;
    protected double y0;
    protected double z0;
    protected double dipDir;
    protected double dipAng;
    protected double rake;
    protected double misfit;
    protected int nObs;
    protected double radius;
    protected Vect3D center;
    protected Vect3D rakeAxis;
    protected Vect3D nodalAxis;
    protected Vect3D auxAxis;
    protected Vect3D pressureAxis;
    protected Vect3D tensionAxis;
    protected double pressureAxisDip;
    protected double tensionAxisDip;
    protected double nodalAxisDip;
    protected Ellipse3D ellipseMain;
    protected Ellipse3D ellipseAux;

    public FocalMechanism(double d, double d2, double d3, double d4, double d5, double d6, double d7, int n, double d8) {
        this.x0 = d;
        this.y0 = d2;
        this.z0 = d3;
        this.dipDir = 90.0 - d4;
        this.dipAng = -d5;
        this.rake = d6;
        this.misfit = d7;
        this.nObs = n;
        this.radius = d8;
        this.init();
    }

    void init() {
        this.center = new Vect3D(this.x0, this.y0, this.z0);
        boolean bl = this.isValid = this.misfit >= 0.0 && this.nObs > 0;
        if (!this.isValid) {
            return;
        }
        double d = (float)Math.cos(0.01745329238474369 * this.dipAng);
        Vect3D vect3D = new Vect3D(Math.cos(0.01745329238474369 * this.dipDir) * d, Math.sin(0.01745329238474369 * this.dipDir) * d, Math.sin(0.01745329238474369 * this.dipAng));
        Vect3D vect3D2 = new Vect3D(0.0f, 0.0f, 1.0f);
        Vect3D vect3D3 = vect3D2.cross(vect3D);
        vect3D3.normalize();
        this.rakeAxis = vect3D3.mult(Math.cos(0.01745329238474369 * this.rake)).sub(vect3D.mult(Math.sin(0.01745329238474369 * this.rake)));
        this.auxAxis = vect3D.cross(vect3D3);
        this.nodalAxis = this.rakeAxis.cross(this.auxAxis);
        this.rakeAxis = this.rakeAxis.mult(this.radius);
        this.nodalAxis = this.nodalAxis.mult(this.radius);
        this.nodalAxisDip = this.nodalAxis.getDip();
        this.auxAxis = this.auxAxis.mult(this.radius);
        this.pressureAxis = this.rakeAxis.sub(this.auxAxis);
        this.pressureAxisDip = this.pressureAxis.getDip();
        this.tensionAxis = this.rakeAxis.add(this.auxAxis);
        this.tensionAxisDip = this.tensionAxis.getDip();
    }

    FocalMechanism(DataInputStream dataInputStream) throws IOException {
        this.x0 = dataInputStream.readFloat();
        this.y0 = dataInputStream.readFloat();
        this.z0 = dataInputStream.readFloat();
        this.dipDir = dataInputStream.readFloat();
        this.dipAng = dataInputStream.readFloat();
        this.rake = dataInputStream.readFloat();
        this.misfit = dataInputStream.readFloat();
        this.nObs = dataInputStream.readInt();
        this.init();
    }

    void writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat((float)this.x0);
        dataOutputStream.writeFloat((float)this.y0);
        dataOutputStream.writeFloat((float)this.z0);
        dataOutputStream.writeFloat((float)this.dipDir);
        dataOutputStream.writeFloat((float)this.dipAng);
        dataOutputStream.writeFloat((float)this.rake);
        dataOutputStream.writeFloat((float)this.misfit);
        dataOutputStream.writeInt(this.nObs);
    }

    void calcEllipses() {
        if (!this.isValid) {
            return;
        }
        this.ellipseMain = new Ellipse3D(this.center, this.nodalAxis, this.rakeAxis, 32);
        this.ellipseAux = new Ellipse3D(this.center, this.nodalAxis, this.auxAxis, 32);
    }

    void paint(Graphics graphics, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, double d, Vect3D vect3D, double d2, int n, boolean bl9) {
        if (!this.isValid) {
            return;
        }
        if (this.misfit > d2 || this.nObs < n) {
            return;
        }
        Graphics graphics2 = graphics.create();
        boolean bl10 = true;
        boolean bl11 = true;
        boolean bl12 = true;
        boolean bl13 = true;
        if (bl6 || bl7 || bl8) {
            bl11 = false;
            bl12 = false;
            bl13 = false;
            if (bl6 && this.pressureAxisDip > -d && this.pressureAxisDip < d && (this.tensionAxisDip < -(90.0 - d) || this.tensionAxisDip > 90.0 - d)) {
                bl11 = true;
            }
            if (bl7 && this.tensionAxisDip > -d && this.tensionAxisDip < d && (this.pressureAxisDip < -(90.0 - d) || this.pressureAxisDip > 90.0 - d)) {
                bl12 = true;
            }
            if (bl8 && (this.nodalAxisDip < -(90.0 - d) || this.nodalAxisDip > 90.0 - d)) {
                bl13 = true;
            }
            boolean bl14 = bl10 = bl11 || bl12 || bl13;
        }
        if (!bl10) {
            return;
        }
        boolean bl15 = false;
        boolean bl16 = true;
        boolean bl17 = true;
        if (vect3D != null) {
            if (Math.abs(vect3D.dot(this.rakeAxis)) < Math.abs(vect3D.dot(this.auxAxis))) {
                bl16 = false;
            } else {
                bl17 = false;
            }
        }
        if (bl && bl10) {
            graphics2.setColor(SeismicityColors.colorFaultPlanes);
            if (SeismicityStrokes.strokeFaultPlanes != null) {
                try {
                    ((Graphics2D)graphics2).setStroke(SeismicityStrokes.strokeFaultPlanes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl16) {
                this.ellipseMain.paint(graphics2);
                bl15 = true;
            }
            if (bl17) {
                this.ellipseAux.paint(graphics2);
                bl15 = true;
            }
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (bl2 && (bl11 || bl13)) {
            Matrix3D.applyPerspTrans(this.center.sub(this.pressureAxis), nArray);
            Matrix3D.applyPerspTrans(this.center.add(this.pressureAxis), nArray2);
            graphics2.setColor(SeismicityColors.colorP);
            if (SeismicityStrokes.strokeP != null) {
                try {
                    ((Graphics2D)graphics2).setStroke(SeismicityStrokes.strokeP);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.paintPTNaxis(graphics2, nArray[0], nArray[1], nArray2[0], nArray2[1], bl9);
            bl15 = true;
        }
        if (bl3 && (bl12 || bl13)) {
            Matrix3D.applyPerspTrans(this.center.sub(this.tensionAxis), nArray);
            Matrix3D.applyPerspTrans(this.center.add(this.tensionAxis), nArray2);
            graphics2.setColor(SeismicityColors.colorT);
            if (SeismicityStrokes.strokeT != null) {
                try {
                    ((Graphics2D)graphics2).setStroke(SeismicityStrokes.strokeT);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.paintPTNaxis(graphics2, nArray[0], nArray[1], nArray2[0], nArray2[1], bl9);
            bl15 = true;
        }
        if (bl4) {
            Matrix3D.applyPerspTrans(this.center.sub(this.nodalAxis), nArray);
            Matrix3D.applyPerspTrans(this.center.add(this.nodalAxis), nArray2);
            graphics2.setColor(SeismicityColors.colorN);
            if (SeismicityStrokes.strokeN != null) {
                try {
                    ((Graphics2D)graphics2).setStroke(SeismicityStrokes.strokeN);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.paintPTNaxis(graphics2, nArray[0], nArray[1], nArray2[0], nArray2[1], bl9);
            bl15 = true;
        }
        if (bl5) {
            graphics2.setColor(SeismicityColors.colorSlip);
            if (SeismicityStrokes.strokeSlip != null) {
                try {
                    ((Graphics2D)graphics2).setStroke(SeismicityStrokes.strokeSlip);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (bl16) {
                Matrix3D.applyPerspTrans(this.center.sub(this.rakeAxis), nArray);
                Matrix3D.applyPerspTrans(this.center.add(this.rakeAxis), nArray2);
                Draw3D.drawLine(graphics2, nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
            if (bl17) {
                Matrix3D.applyPerspTrans(this.center.sub(this.auxAxis), nArray);
                Matrix3D.applyPerspTrans(this.center.add(this.auxAxis), nArray2);
                Draw3D.drawLine(graphics2, nArray[0], nArray[1], nArray2[0], nArray2[1]);
            }
            bl15 = true;
        }
        graphics2.dispose();
        if (bl15) {
            ++NumberPainted;
        }
    }

    private void paintPTNaxis(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            try {
                BasicStroke basicStroke = (BasicStroke)((Graphics2D)graphics).getStroke();
                double d = (double)basicStroke.getLineWidth() / 2.0;
                double d2 = n3 - n;
                double d3 = n4 - n2;
                double d4 = Math.sqrt(d2 * d2 + d3 * d3);
                double d5 = d3 / d4 * d;
                double d6 = d2 / d4 * d;
                Polygon polygon = new Polygon();
                int n5 = (int)Math.round((double)n - d5);
                int n6 = (int)Math.round((double)n2 + d6);
                polygon.addPoint(n5, n6);
                n5 = (int)Math.round((double)n + d5);
                n6 = (int)Math.round((double)n2 - d6);
                polygon.addPoint(n5, n6);
                n5 = (int)Math.round((double)n3 - d5);
                n6 = (int)Math.round((double)n4 + d6);
                polygon.addPoint(n5, n6);
                n5 = (int)Math.round((double)n3 + d5);
                n6 = (int)Math.round((double)n4 - d6);
                polygon.addPoint(n5, n6);
                Draw3D.fillPolygon(graphics, polygon);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Draw3D.drawLine(graphics, n, n2, n3, n4);
            }
        } else {
            Draw3D.drawLine(graphics, n, n2, n3, n4);
        }
    }
}

