/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import net.alomax.io.ZipStream;
import net.alomax.net.GeneralURLConnection;

public class GeneralInputStream {
    private static boolean DEBUG = false;

    public static InputStream openStreamCheckCompress(URL uRL, String string, boolean bl) throws IOException {
        InputStream inputStream = GeneralInputStream.openStream(uRL, string, bl);
        inputStream = ZipStream.getInputStream(inputStream, string);
        return inputStream;
    }

    public static InputStream openStream(URL uRL, String string, boolean bl) throws IOException {
        if (DEBUG) {
            System.out.println("\nGeneralInputStream.openStream: enter");
        }
        if (DEBUG) {
            System.out.println("   documentBase: " + uRL);
        }
        if (DEBUG) {
            System.out.println("   fileName: " + string);
        }
        if (DEBUG) {
            System.out.flush();
        }
        InputStream inputStream = null;
        String string2 = "";
        if ((uRL == null || uRL.toString().startsWith("file:")) && string.indexOf(":") < 0) {
            if (uRL != null && !string.startsWith(System.getProperty("file.separator")) && !string.startsWith(uRL.toString().substring("file:".length()))) {
                string = uRL.toString().substring("file:".length()) + System.getProperty("file.separator") + string;
                uRL = null;
            }
            if (DEBUG) {
                System.out.println("      Opening: " + string);
            }
            if (DEBUG) {
                System.out.flush();
            }
        } else {
            try {
                if (!bl) {
                    if (DEBUG) {
                        System.out.println("GeneralInputStream.openStream: call openURLConnInputStream");
                    }
                    if (DEBUG) {
                        System.out.flush();
                    }
                    inputStream = GeneralInputStream.openURLConnInputStream(uRL, string, bl);
                    if (DEBUG) {
                        System.out.println("GeneralInputStream.openStream: return openURLConnInputStream");
                    }
                    if (inputStream != null) {
                        return inputStream;
                    }
                } else {
                    if (DEBUG) {
                        System.out.println("GeneralInputStream.openStream: call openURLInputStream");
                    }
                    if (DEBUG) {
                        System.out.flush();
                    }
                    inputStream = GeneralInputStream.openURLInputStream(uRL, string);
                    if (DEBUG) {
                        System.out.println("GeneralInputStream.openStream: return openURLInputStream");
                    }
                    if (inputStream != null) {
                        return inputStream;
                    }
                }
            }
            catch (Exception exception) {
                string2 = string2 + exception.toString() + "\n";
            }
        }
        try {
            if (DEBUG) {
                System.out.println("GeneralInputStream.openStream: call openFileInputStream");
            }
            inputStream = GeneralInputStream.openFileInputStream(string);
            if (DEBUG) {
                System.out.println("GeneralInputStream.openStream: return openFileInputStream");
            }
            if (inputStream != null) {
                return inputStream;
            }
        }
        catch (Exception exception) {
            string2 = string2 + exception.toString() + "\n";
        }
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new IOException("GeneralInputStream: " + string2);
    }

    public static InputStream openURLConnInputStream(URL uRL, String string, boolean bl) throws IOException, MalformedURLException {
        URLConnection uRLConnection = null;
        if (DEBUG) {
            System.out.println("openURLConnInputStream openURLConnection() enter");
        }
        uRLConnection = GeneralURLConnection.openURLConnection(uRL, string);
        if (DEBUG) {
            System.out.println("openURLConnInputStream openURLConnection() return");
        }
        if (DEBUG) {
            System.out.println("openURLConnInputStream url is : " + uRLConnection.getURL());
        }
        if (uRLConnection != null && !bl) {
            uRLConnection.setUseCaches(bl);
        }
        if (DEBUG) {
            System.out.println("openURLConnInputStream connect() enter");
        }
        uRLConnection.connect();
        if (DEBUG) {
            System.out.println("openURLConnInputStream connect() return");
        }
        if (uRLConnection != null) {
            if (DEBUG) {
                System.out.println("openURLConnInputStream getInputStream() enter");
            }
            InputStream inputStream = GeneralInputStream.getInputStream(uRLConnection);
            if (DEBUG) {
                System.out.println("openURLConnInputStream getInputStream() return");
            }
            uRLConnection = null;
            if (inputStream != null) {
                return inputStream;
            }
        }
        throw new IOException("GeneralInputStream: openURLConnInputStream; unknown error.");
    }

    public static InputStream openURLInputStream(URL uRL, String string) throws IOException {
        InputStream inputStream = null;
        if (DEBUG) {
            System.out.println("openURLInputStream createURL() enter");
        }
        URL uRL2 = GeneralURLConnection.createURL(uRL, string);
        if (DEBUG) {
            System.out.println("openURLInputStream createURL() return : url : " + uRL2);
        }
        if (uRL2 != null) {
            try {
                if (DEBUG) {
                    System.out.println("openURLInputStream url.openStream() enter ");
                }
                if (DEBUG) {
                    System.out.flush();
                }
                inputStream = uRL2.openStream();
                if (DEBUG) {
                    System.out.println("openURLInputStream url.openStream() return ");
                }
                return inputStream;
            }
            catch (UnknownHostException unknownHostException) {
                throw new IOException(unknownHostException.getMessage());
            }
        }
        throw new IOException("GeneralInputStream: openURLInputStream; unknown error.");
    }

    public static InputStream openFileInputStream(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(string);
        if (fileInputStream != null) {
            return fileInputStream;
        }
        throw new IOException("GeneralInputStream: openFileInputStream; unknown error.");
    }

    public static InputStream getInputStream(URLConnection uRLConnection) throws IOException {
        InputStream inputStream = null;
        try {
            if (DEBUG) {
                System.out.println("GeneralInputStream.getInputStream: call getInputStream : " + uRLConnection);
            }
            inputStream = uRLConnection.getInputStream();
            if (DEBUG) {
                System.out.println("GeneralInputStream.getInputStream: return getInputStream");
            }
        }
        catch (UnknownServiceException unknownServiceException) {
            if (DEBUG) {
                System.out.println("GeneralInputStream.getInputStream: UnknownServiceException use getInputStream");
            }
            throw new IOException(unknownServiceException.getMessage());
        }
        if (inputStream != null) {
            return inputStream;
        }
        throw new IOException("GeneralInputStream: getInputStream; unknown error.");
    }

    public static void dumpURLConn(URLConnection uRLConnection) {
    }
}

