/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

public class Vect2D {
    public double x;
    public double y;
    protected static final double RAD2DEG = 57.29577951308232;
    protected static final double DEG2RAD = Math.PI / 180;

    public Vect2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vect2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vect2D(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vect2D(Vect2D vect2D) {
        this.x = vect2D.x;
        this.y = vect2D.y;
    }

    public Vect2D(double d) {
        double d2 = Math.cos(d * (Math.PI / 180));
        double d3 = Math.sin(d * (Math.PI / 180));
        this.x = d2;
        this.y = d3;
    }

    public double getAzimuth() {
        if (Math.abs(this.x) < (double)1.4E-45f) {
            return this.y > 0.0 ? 90.0 : -90.0;
        }
        double d = Math.atan(this.y / this.x) * 57.29577951308232;
        return d;
    }

    public void normalize() {
        double d = this.x * this.x + this.y * this.y;
        if (d <= (double)1.4E-45f) {
            return;
        }
        d = Math.sqrt(d);
        this.x /= d;
        this.y /= d;
    }

    public Vect2D add(Vect2D vect2D) {
        Vect2D vect2D2 = new Vect2D();
        vect2D2.x = this.x + vect2D.x;
        vect2D2.y = this.y + vect2D.y;
        return vect2D2;
    }

    public Vect2D sub(Vect2D vect2D) {
        Vect2D vect2D2 = new Vect2D();
        vect2D2.x = this.x - vect2D.x;
        vect2D2.y = this.y - vect2D.y;
        return vect2D2;
    }

    public Vect2D mult(double d) {
        Vect2D vect2D = new Vect2D();
        vect2D.x = this.x * d;
        vect2D.y = this.y * d;
        return vect2D;
    }

    public Vect2D mult(float f) {
        Vect2D vect2D = new Vect2D();
        vect2D.x = this.x * (double)f;
        vect2D.y = this.y * (double)f;
        return vect2D;
    }

    public double distance(Vect2D vect2D) {
        double d = this.x - vect2D.x;
        double d2 = this.y - vect2D.y;
        double d3 = d * d + d2 * d2;
        if (d3 <= (double)1.4E-45f) {
            return 0.0;
        }
        d3 = Math.sqrt(d3);
        return d3;
    }

    public double dot(Vect2D vect2D) {
        return this.x * vect2D.x + vect2D.y * this.y;
    }

    public final double dist(Vect2D vect2D) {
        double d = Math.sqrt((this.x - vect2D.x) * (this.x - vect2D.x) + (this.y - vect2D.y) * (this.y - vect2D.y));
        return d;
    }

    public String toString() {
        return new String("(" + this.x + "," + this.y + ")");
    }
}

