/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import net.alomax.graphics3d.CrossSymbol3D;
import net.alomax.graphics3d.CubeSymbol3D;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Drawable3D;
import net.alomax.graphics3d.FilledSphereSymbol3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.PolygonSymbol3D;
import net.alomax.graphics3d.TetrahedronSymbol3D;
import net.alomax.graphics3d.Transformable3D;
import net.alomax.graphics3d.Vect3D;

public abstract class Symbol3D
extends Drawable3D {
    protected Color color = Color.white;
    protected Vect3D center = null;
    protected Vect3D[][] vertex = new Vect3D[0][0];
    protected Vect3D[][] initVertex = null;
    protected int[][][] itrans = new int[0][3][0];
    protected double zScaleCurrent = 1.0;
    protected static int ciclePolygonNumSides = 64;

    public static Symbol3D createSymbol(String string, Vect3D vect3D, double d, Color color) {
        if (string.equalsIgnoreCase("CROSS")) {
            return new CrossSymbol3D(vect3D, d, color);
        }
        if (string.equalsIgnoreCase("TRIANGLE") || string.equalsIgnoreCase("TETRAHEDRON")) {
            return new TetrahedronSymbol3D(vect3D, d, color);
        }
        if (string.equalsIgnoreCase("INVERTED_TRIANGLE") || string.equalsIgnoreCase("INVERTED_TETRAHEDRON")) {
            return new TetrahedronSymbol3D(vect3D, -d, color);
        }
        if (string.equalsIgnoreCase("DIAMOND")) {
            return new PolygonSymbol3D(vect3D, d, color, 4);
        }
        if (string.equalsIgnoreCase("SPHERE")) {
            return new PolygonSymbol3D(vect3D, d, color, ciclePolygonNumSides);
        }
        if (string.equalsIgnoreCase("CIRCLE_X")) {
            return new PolygonSymbol3D(vect3D, d, color, ciclePolygonNumSides, true, false, false);
        }
        if (string.equalsIgnoreCase("CIRCLE_Y")) {
            return new PolygonSymbol3D(vect3D, d, color, ciclePolygonNumSides, false, true, false);
        }
        if (string.equalsIgnoreCase("CIRCLE_Z")) {
            return new PolygonSymbol3D(vect3D, d, color, ciclePolygonNumSides, false, false, true);
        }
        if (string.equalsIgnoreCase("CUBE")) {
            return new CubeSymbol3D(vect3D, d, color);
        }
        if (string.equalsIgnoreCase("PENTAGON")) {
            return new PolygonSymbol3D(vect3D, d, color, 5);
        }
        if (string.equalsIgnoreCase("HEXAGON")) {
            return new PolygonSymbol3D(vect3D, d, color, 6);
        }
        if (string.equalsIgnoreCase("OCTAGON")) {
            return new PolygonSymbol3D(vect3D, d, color, 8);
        }
        if (string.equalsIgnoreCase("FILLED_SPHERE")) {
            return new FilledSphereSymbol3D(vect3D, d, color);
        }
        if (string.equalsIgnoreCase("FILLED_SPHERE_NO_OUTLINE")) {
            return new FilledSphereSymbol3D(vect3D, d, false, color);
        }
        System.out.println("ERROR: unrecognized symbol type: " + string + ": using CUBE");
        return new CubeSymbol3D(vect3D, d, color);
    }

    public static void setCiclePolygonNumSides(int n) {
        ciclePolygonNumSides = n;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public void scaleZ(double d) {
        if (d == this.zScaleCurrent) {
            return;
        }
        double d2 = d / this.zScaleCurrent;
        for (int i = 0; i < this.vertex.length; ++i) {
            for (int j = 0; j < this.vertex[i].length; ++j) {
                this.vertex[i][j].z = (this.vertex[i][j].z - this.center.z) * d2 + this.center.z;
            }
        }
        this.setVertices(this.vertex);
        this.zScaleCurrent = d;
    }

    public void setVertices(Vect3D[][] vect3DArray) {
        this.vertex = vect3DArray;
        this.itrans = new int[vect3DArray.length][3][];
        for (int i = 0; i < vect3DArray.length; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.itrans[i][j] = new int[vect3DArray[i].length];
            }
        }
    }

    @Override
    public void transform(int n) {
        if (this.getTransformed(n)) {
            return;
        }
        int[] nArray = new int[3];
        for (int i = 0; i < this.vertex.length; ++i) {
            for (int j = 0; j < this.vertex[i].length; ++j) {
                Matrix3D.applyPerspTrans(this.vertex[i][j], nArray);
                this.itrans[i][0][j] = nArray[0];
                this.itrans[i][1][j] = nArray[1];
                this.itrans[i][2][j] = nArray[2];
            }
        }
        this.setLastTransformationIndex(n);
    }

    @Override
    public void paint(Graphics graphics) {
        this.paint(graphics, this.color);
    }

    @Override
    public void paint(Graphics graphics, Color color) {
        this.paint(graphics, null, color);
    }

    public void paint(Graphics graphics, BasicStroke basicStroke, Color color) {
        Graphics graphics2 = graphics.create();
        graphics2.setColor(color);
        if (basicStroke != null) {
            try {
                ((Graphics2D)graphics2).setStroke(basicStroke);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        for (int i = 0; i < this.itrans.length; ++i) {
            Draw3D.drawPolyline(graphics2, this.itrans[i][0], this.itrans[i][1]);
        }
    }

    public Vect3D getCenter() {
        return this.center;
    }

    public void transformToUpOnSphere(Vect3D vect3D) {
        if (this.initVertex != null) {
            this.vertex = this.initVertex;
        } else {
            this.initVertex = this.vertex;
        }
        this.vertex = Transformable3D.transformToUpOnSphere(this.vertex, this.center, vect3D);
    }
}

