/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Transformable3D;
import net.alomax.graphics3d.Vect3D;

public class Sample4D
extends Transformable3D {
    public static final int POINT = 0;
    public static final int DISK = 1;
    public static final int DIAM_DEFAULT = 6;
    public static final int DIAM_MIN = 2;
    public static final int DIAM_MAX = 100;
    public Color color = null;
    public int type;
    public int idiamDefault = 6;
    public int idiamMinimum = 2;
    public int idiamMaximum = 100;
    public double x;
    public double y;
    public double z;
    public double value;
    public int[] itrans = new int[3];

    public Sample4D() {
        this(0.0, 0.0, 0.0, 0.0, 0, 6, 2, 100);
    }

    public Sample4D(int n) {
        this(0.0, 0.0, 0.0, 0.0, n, 6, 2, 100);
    }

    public Sample4D(double d, double d2, double d3, double d4, int n) {
        this(d, d2, d3, d4, n, 6, 2, 100);
    }

    public Sample4D(double d, double d2, double d3, double d4, int n, int n2, int n3, int n4) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.value = d4;
        this.type = n;
        this.idiamDefault = n2;
        this.idiamMinimum = n3;
        this.idiamMaximum = n4;
    }

    public Vect3D getCoordinates() {
        return new Vect3D(this.x, this.y, this.z);
    }

    public void randomShift(Random random, double d) {
        double d2;
        double d3;
        double d4;
        double d5;
        while ((d5 = (d4 = random.nextDouble() - 0.5) * d4 + (d3 = random.nextDouble() - 0.5) * d3 + (d2 = random.nextDouble() - 0.5) * d2) > 0.25) {
        }
        this.x += 2.0 * d * d4;
        this.y += 2.0 * d * d3;
        this.z += 2.0 * d * d2;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private final int blend(int n, int n2, double d) {
        return (int)((double)n2 + (double)(n - n2) * d);
    }

    @Override
    public void transform(int n) {
        if (this.getTransformed(n)) {
            return;
        }
        Matrix3D.applyPerspTrans(this.x, this.y, this.z, this.itrans);
        this.setLastTransformationIndex(n);
    }

    public final void paint(Graphics graphics) {
        this.paint(graphics, this.color, 1.0, false, -1.0, -1.0, 0.5);
    }

    public final void paint(Graphics graphics, Color color) {
        this.paint(graphics, color, 1.0, false, -1.0, -1.0, 0.5);
    }

    public final void paint(Graphics graphics, Color color, boolean bl, double d, double d2) {
        this.paint(graphics, color, 1.0, bl, d, d2, 0.5);
    }

    public final void paint(Graphics graphics, Color color, double d, boolean bl, double d2, double d3, double d4) {
        if (color != null) {
            graphics.setColor(color);
        } else if (this.color != null) {
            graphics.setColor(this.color);
        }
        if (this.type == 1) {
            int n;
            int n2 = (int)Math.round((double)this.idiamDefault * d);
            if (n2 < this.idiamMinimum) {
                n2 = this.idiamMinimum;
            }
            if ((n = n2) < 1) {
                n = 1;
            }
            if (this.value > d2 && bl && Math.abs(d3 - d2) > (double)1.4E-45f) {
                n = (int)Math.pow(this.value * ((double)this.idiamMinimum + (double)(this.idiamMaximum - this.idiamMinimum) * (this.value - d2) / (d3 - d2)), d4);
                if (n < n2) {
                    n = n2;
                }
                if (n > this.idiamMaximum) {
                    n = this.idiamMaximum;
                }
                n = (int)(d * (double)n);
            }
            Draw3D.fillOval(graphics, this.itrans[0] - n / 2, this.itrans[1] - n / 2, n, n);
        } else {
            Draw3D.fillRect(graphics, this.itrans[0], this.itrans[1], 1, 1);
        }
    }

    public void writeBinary(DataOutputStream dataOutputStream, boolean bl, boolean bl2) throws IOException {
        dataOutputStream.writeFloat((float)this.x);
        dataOutputStream.writeFloat((float)this.y);
        dataOutputStream.writeFloat((float)this.z);
        if (bl) {
            dataOutputStream.writeFloat((float)this.value);
        }
        if (bl2) {
            dataOutputStream.writeInt(this.type);
        }
    }

    public void readBinary(DataInputStream dataInputStream, boolean bl, boolean bl2) throws IOException {
        this.x = dataInputStream.readFloat();
        this.y = dataInputStream.readFloat();
        this.z = dataInputStream.readFloat();
        if (bl) {
            this.value = dataInputStream.readFloat();
        }
        if (bl2) {
            this.type = dataInputStream.readInt();
        }
    }

    public String toString() {
        return "" + this.x + ", " + this.y + ", " + this.z + ", " + this.value + ", " + this.type + ", " + this.idiamDefault + ", " + this.idiamMinimum + ", " + this.idiamMaximum;
    }
}

