/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import net.alomax.math.RangeDouble;

public class Range3D {
    public RangeDouble x;
    public RangeDouble y;
    public RangeDouble z;

    public Range3D(RangeDouble rangeDouble, RangeDouble rangeDouble2, RangeDouble rangeDouble3) {
        this.x = new RangeDouble(rangeDouble);
        this.y = new RangeDouble(rangeDouble2);
        this.z = new RangeDouble(rangeDouble3);
    }

    public Range3D(double d, double d2, double d3, double d4, double d5, double d6) {
        this.x = new RangeDouble(d, d2);
        this.y = new RangeDouble(d3, d4);
        this.z = new RangeDouble(d5, d6);
    }

    public Range3D() {
        this.x = new RangeDouble(0.0, 0.0);
        this.y = new RangeDouble(0.0, 0.0);
        this.z = new RangeDouble(0.0, 0.0);
    }

    public Range3D union(Range3D range3D) {
        Range3D range3D2 = new Range3D();
        range3D2.x.min = Math.min(this.x.min, range3D.x.min);
        range3D2.x.max = Math.max(this.x.max, range3D.x.max);
        range3D2.y.min = Math.min(this.y.min, range3D.y.min);
        range3D2.y.max = Math.max(this.y.max, range3D.y.max);
        range3D2.z.min = Math.min(this.z.min, range3D.z.min);
        range3D2.z.max = Math.max(this.z.max, range3D.z.max);
        return range3D2;
    }

    public boolean intersects(Range3D range3D) {
        if (this.x.max < range3D.x.min) {
            return false;
        }
        if (this.x.min > range3D.x.max) {
            return false;
        }
        if (this.y.max < range3D.y.min) {
            return false;
        }
        if (this.y.min > range3D.y.max) {
            return false;
        }
        if (this.z.max < range3D.z.min) {
            return false;
        }
        return !(this.z.min > range3D.z.max);
    }

    public String toString() {
        return "(" + this.x.min + "," + this.x.max + "),(" + this.y.min + "," + this.y.max + "),(" + this.z.min + "," + this.z.max + ")";
    }
}

