/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.io.File;
import java.net.URL;
import javax.imageio.ImageIO;
import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.net.GeneralURLConnection;
import net.alomax.util.StringExt;

public class Image2D {
    protected Image theImage = null;
    protected Vect3D lowerLeft;
    protected Vect3D upperRight;
    protected Vect3D upperLeft;
    protected Vect3D lowerRight;
    protected double rotationAngle = 0.0;
    protected String name = "Image2D";
    public Type type = Type.HORIZONTAL;
    protected boolean scaleByHeightOnly = false;
    protected Image scaledImage = null;
    protected int scaledX = -1;
    protected int scaledY = -1;

    public Image2D(Image image, double[][] dArray, GeogCoords geogCoords) throws Exception {
        this.theImage = image;
        this.rotationAngle = geogCoords.getRotationAngle();
        double d = 0.0;
        this.upperLeft = geogCoords.geog2xyz(dArray[0][0], dArray[0][1], d);
        this.upperRight = geogCoords.geog2xyz(dArray[1][0], dArray[1][1], d);
        this.lowerLeft = geogCoords.geog2xyz(dArray[2][0], dArray[2][1], d);
        this.lowerRight = geogCoords.geog2xyz(dArray[3][0], dArray[3][1], d);
    }

    public Image2D(String string, Toolkit toolkit, URL uRL, GeogCoords geogCoords) throws Exception {
        this.rotationAngle = geogCoords.getRotationAngle();
        String[] stringArray = string.split("[;#]");
        URL uRL2 = GeneralURLConnection.createURL(uRL, stringArray[0]);
        try {
            this.theImage = ImageIO.read(uRL2);
        }
        catch (Exception exception) {
            this.theImage = ImageIO.read(new File(stringArray[0]));
        }
        if (stringArray.length < 4) {
            String[] stringArray2 = StringExt.parse(stringArray[1], ",");
            float f = Float.valueOf(stringArray2[0]).floatValue();
            float f2 = Float.valueOf(stringArray2[1]).floatValue();
            float f3 = Float.valueOf(stringArray2[2]).floatValue();
            stringArray2 = StringExt.parse(stringArray[2], ",");
            float f4 = Float.valueOf(stringArray2[0]).floatValue();
            float f5 = Float.valueOf(stringArray2[1]).floatValue();
            float f6 = Float.valueOf(stringArray2[2]).floatValue();
            this.upperLeft = geogCoords.geog2xyz(f, f2, f3);
            this.lowerLeft = geogCoords.geog2xyz(f, f2, f6);
            this.upperRight = geogCoords.geog2xyz(f4, f5, f3);
            this.lowerRight = geogCoords.geog2xyz(f4, f5, f6);
            this.type = Type.VERTICAL;
        } else if (stringArray.length < 5) {
            float f = stringArray.length > 3 ? Float.valueOf(stringArray[3]).floatValue() : 0.0f;
            String[] stringArray3 = StringExt.parse(stringArray[1], ",");
            float f7 = Float.valueOf(stringArray3[0]).floatValue();
            float f8 = Float.valueOf(stringArray3[1]).floatValue();
            stringArray3 = StringExt.parse(stringArray[2], ",");
            float f9 = Float.valueOf(stringArray3[0]).floatValue();
            float f10 = Float.valueOf(stringArray3[1]).floatValue();
            this.lowerLeft = geogCoords.geog2xyz(f7, f8, f);
            this.upperRight = geogCoords.geog2xyz(f9, f10, f);
            this.upperLeft = geogCoords.geog2xyz(f9, f8, f);
            this.lowerRight = geogCoords.geog2xyz(f7, f10, f);
        } else {
            float f;
            float f11 = f = stringArray.length > 5 ? Float.valueOf(stringArray[5]).floatValue() : 0.0f;
            if (stringArray.length > 6) {
                this.name = stringArray[6];
            }
            String[] stringArray4 = StringExt.parse(stringArray[1], ",");
            float f12 = Float.valueOf(stringArray4[0]).floatValue();
            float f13 = Float.valueOf(stringArray4[1]).floatValue();
            stringArray4 = StringExt.parse(stringArray[2], ",");
            float f14 = Float.valueOf(stringArray4[0]).floatValue();
            float f15 = Float.valueOf(stringArray4[1]).floatValue();
            stringArray4 = StringExt.parse(stringArray[3], ",");
            float f16 = Float.valueOf(stringArray4[0]).floatValue();
            float f17 = Float.valueOf(stringArray4[1]).floatValue();
            stringArray4 = StringExt.parse(stringArray[4], ",");
            float f18 = Float.valueOf(stringArray4[0]).floatValue();
            float f19 = Float.valueOf(stringArray4[1]).floatValue();
            this.lowerLeft = geogCoords.geog2xyz(f18, f19, f);
            this.upperRight = geogCoords.geog2xyz(f14, f15, f);
            this.upperLeft = geogCoords.geog2xyz(f12, f13, f);
            this.lowerRight = geogCoords.geog2xyz(f16, f17, f);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setScaleByHeightOnly(boolean bl) {
        this.scaleByHeightOnly = bl;
    }

    public void cleanUp() {
        this.theImage.flush();
        this.theImage = null;
    }

    public void paint(Graphics graphics, double d, ImageObserver imageObserver) {
        int[] nArray = new int[3];
        Matrix3D.applyPerspTrans(this.lowerLeft, nArray);
        int[] nArray2 = new int[3];
        Matrix3D.applyPerspTrans(this.upperRight, nArray2);
        int[] nArray3 = new int[3];
        Matrix3D.applyPerspTrans(this.upperLeft, nArray3);
        int[] nArray4 = new int[3];
        Matrix3D.applyPerspTrans(this.lowerRight, nArray4);
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = nArray2[0];
        int n4 = nArray2[1];
        int n5 = nArray3[0];
        int n6 = nArray3[1];
        int n7 = nArray4[0];
        int n8 = nArray4[1];
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToIdentity();
        double d2 = this.theImage.getWidth(null);
        double d3 = this.theImage.getHeight(null);
        double d4 = Math.sqrt((double)((n3 - n5) * (n3 - n5)) + (double)((n4 - n6) * (n4 - n6)));
        double d5 = Math.sqrt((double)((n7 - n) * (n7 - n)) + (double)((n8 - n2) * (n8 - n2)));
        double d6 = (d4 + d5) / 2.0;
        double d7 = Math.sqrt((double)((n5 - n) * (n5 - n)) + (double)((n6 - n2) * (n6 - n2)));
        double d8 = Math.sqrt((double)((n3 - n7) * (n3 - n7)) + (double)((n4 - n8) * (n4 - n8)));
        double d9 = (d7 + d8) / 2.0;
        affineTransform.translate(nArray3[0], nArray3[1]);
        try {
            double d10;
            double d11;
            if (this.scaleByHeightOnly) {
                d10 = d11 = d9 / d3;
            } else {
                d10 = d6 / d2;
                d11 = d9 / d3;
            }
            affineTransform.scale(d10, d11);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.type == Type.HORIZONTAL) {
            double d12 = d + this.rotationAngle;
            affineTransform.rotate(d12 * (Math.PI / 180));
        }
        try {
            ((Graphics2D)graphics).drawImage(this.theImage, affineTransform, imageObserver);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            graphics.drawImage(this.theImage, n, n4, n3 - n, n2 - n4, imageObserver);
        }
    }

    public static enum Type {
        HORIZONTAL,
        VERTICAL;

    }
}

