/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Vect3D;

public class Ellipse3D {
    protected static final int NUMPOINTS = 32;
    protected static final double RPD = 0.01745329238474369;
    protected boolean isValid = false;
    protected Vect3D center;
    protected Vect3D axis1;
    protected Vect3D axis2;
    protected Vect3D[] ellipse;
    public double az1;
    public double dip1;
    public double se1;
    public double az2;
    public double dip2;
    public double se2;

    public Ellipse3D(Vect3D vect3D, Vect3D vect3D2, Vect3D vect3D3, int n) {
        this.init(vect3D, vect3D2, vect3D3, n);
    }

    public Ellipse3D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        this.init(new Vect3D(d, d2, d3), d4, d5, d6, d7, d8, d9, 32);
    }

    public Ellipse3D(DataInputStream dataInputStream) throws IOException {
        this.center.x = dataInputStream.readFloat();
        this.center.y = dataInputStream.readFloat();
        this.center.z = dataInputStream.readFloat();
        this.axis1.x = dataInputStream.readFloat();
        this.axis1.y = dataInputStream.readFloat();
        this.axis1.z = dataInputStream.readFloat();
        this.axis2.x = dataInputStream.readFloat();
        this.axis2.y = dataInputStream.readFloat();
        this.axis2.z = dataInputStream.readFloat();
        this.init(this.center, this.axis1, this.axis2, 32);
    }

    public void init(Vect3D vect3D, Vect3D vect3D2, Vect3D vect3D3, int n) {
        this.center = vect3D;
        this.axis1 = vect3D2;
        this.axis2 = vect3D3;
        this.ellipse = new Vect3D[n];
        double d = (float)Math.PI * 2 / (float)(n - 1);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            this.ellipse[i] = new Vect3D(vect3D.add(vect3D2.mult(Math.cos(d2)).add(vect3D3.mult(Math.sin(d2)))));
            d2 += d;
        }
        this.isValid = true;
    }

    protected void init(Vect3D vect3D, double d, double d2, double d3, double d4, double d5, double d6, int n) {
        this.center = vect3D;
        this.az1 = d;
        this.dip1 = d2;
        this.se1 = d3;
        this.az2 = d4;
        this.dip2 = d5;
        this.se2 = d6;
        double d7 = (float)Math.cos(0.01745329238474369 * d2);
        this.axis1 = new Vect3D(Math.cos(0.01745329238474369 * d) * d7, Math.sin(0.01745329238474369 * d) * d7, Math.sin(0.01745329238474369 * d2));
        double d8 = (float)Math.cos(0.01745329238474369 * d5);
        this.axis2 = new Vect3D(Math.cos(0.01745329238474369 * d4) * d8, Math.sin(0.01745329238474369 * d4) * d8, Math.sin(0.01745329238474369 * d5));
        this.axis1 = this.axis1.mult(d3);
        this.axis2 = this.axis2.mult(d6);
        this.init(vect3D, this.axis1, this.axis2, n);
    }

    public void paint(Graphics graphics) {
        if (!this.isValid) {
            return;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        Matrix3D.applyPerspTrans(this.ellipse[31], nArray);
        for (int i = 0; i < 32; ++i) {
            nArray2[0] = nArray[0];
            nArray2[1] = nArray[1];
            Matrix3D.applyPerspTrans(this.ellipse[i], nArray);
            Draw3D.drawLine(graphics, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        }
    }

    public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeFloat((float)this.center.x);
        dataOutputStream.writeFloat((float)this.center.y);
        dataOutputStream.writeFloat((float)this.center.z);
        dataOutputStream.writeFloat((float)this.axis1.x);
        dataOutputStream.writeFloat((float)this.axis1.y);
        dataOutputStream.writeFloat((float)this.axis1.z);
        dataOutputStream.writeFloat((float)this.axis2.x);
        dataOutputStream.writeFloat((float)this.axis2.y);
        dataOutputStream.writeFloat((float)this.axis2.z);
    }

    public String toStringAxes() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Az1 ").append((float)this.az1);
        stringBuffer.append("  Dip1 ").append((float)this.dip1);
        stringBuffer.append("  Len1 ").append((float)this.se1);
        stringBuffer.append("  Az2 ").append((float)this.az2);
        stringBuffer.append("  Dip2 ").append((float)this.dip2);
        stringBuffer.append("  Len2 ").append((float)this.se2);
        return stringBuffer.toString();
    }

    public String toStringAxesCsv() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((float)this.az1);
        stringBuffer.append(", ").append((float)this.dip1);
        stringBuffer.append(", ").append((float)this.se1);
        stringBuffer.append(", ").append((float)this.az2);
        stringBuffer.append(", ").append((float)this.dip2);
        stringBuffer.append(", ").append((float)this.se2);
        return stringBuffer.toString();
    }

    public static String toStringAxesCsvHeader() {
        return "EllipseAz1, EllipseDip1, EllipseLen1, EllipseAz2, EllipseDip2, EllipseLen2";
    }

    public String toStringAxesHorizCsv() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((float)this.se1);
        stringBuffer.append(", ").append((float)this.se2);
        stringBuffer.append(", ").append((float)this.az2);
        return stringBuffer.toString();
    }

    public static String toStringAxesHorizCsvHeader() {
        return "minHorUnc, maxHorUnc, azMaxHorUnc";
    }
}

