/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics3d;

import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.alomax.graphics3d.Draw3D;
import net.alomax.graphics3d.Matrix3D;
import net.alomax.graphics3d.Sample4D;
import net.alomax.graphics3d.Vect2D;
import net.alomax.graphics3d.Vect3D;

public class CovMatrix {
    protected static final int NUMPOINTS = 32;
    protected static Vect2D[] tmpArray = new Vect2D[32];
    protected boolean isValid = false;
    protected double[] cov = new double[6];
    protected Vect3D[] ellipseXY;
    protected Vect3D[] ellipseXZ;
    protected Vect3D[] ellipseZY;

    public CovMatrix() {
        this.isValid = false;
    }

    public CovMatrix(double d, double d2, double d3, double d4, double d5, double d6) {
        this.cov[0] = d;
        this.cov[1] = d2;
        this.cov[2] = d3;
        this.cov[3] = d4;
        this.cov[4] = d5;
        this.cov[5] = d6;
        this.isValid = true;
    }

    public CovMatrix(DataInputStream dataInputStream) throws IOException {
        this.isValid = dataInputStream.readBoolean();
        for (int i = 0; i < 6; ++i) {
            this.cov[i] = dataInputStream.readFloat();
        }
    }

    public void calcEllipses(Sample4D sample4D) {
        int n;
        if (!this.isValid) {
            return;
        }
        this.toEllipse2D(this.cov[0], this.cov[3], this.cov[1], sample4D.x, sample4D.y, tmpArray, 32);
        this.ellipseXY = new Vect3D[32];
        for (n = 0; n < 32; ++n) {
            this.ellipseXY[n] = new Vect3D(CovMatrix.tmpArray[n].x, CovMatrix.tmpArray[n].y, sample4D.z);
        }
        this.toEllipse2D(this.cov[0], this.cov[5], this.cov[2], sample4D.x, sample4D.z, tmpArray, 32);
        this.ellipseXZ = new Vect3D[32];
        for (n = 0; n < 32; ++n) {
            this.ellipseXZ[n] = new Vect3D(CovMatrix.tmpArray[n].x, sample4D.y, CovMatrix.tmpArray[n].y);
        }
        this.toEllipse2D(this.cov[5], this.cov[3], this.cov[4], sample4D.z, sample4D.y, tmpArray, 32);
        this.ellipseZY = new Vect3D[32];
        for (n = 0; n < 32; ++n) {
            this.ellipseZY[n] = new Vect3D(sample4D.x, CovMatrix.tmpArray[n].y, CovMatrix.tmpArray[n].x);
        }
    }

    public void toEllipse2D(double d, double d2, double d3, double d4, double d5, Vect2D[] vect2DArray, int n) {
        double d6 = d;
        double d7 = Math.sqrt(d6);
        double d8 = d2;
        double d9 = Math.sqrt(d8);
        double d10 = d3 / (d7 * d9);
        double d11 = d10 * d10;
        double d12 = 0.5 * Math.atan2(2.0 * d10 * d7 * d9, d6 - d8);
        double d13 = Math.cos(d12);
        double d14 = d13 * d13;
        double d15 = Math.sin(d12);
        double d16 = d15 * d15;
        double d17 = Math.sqrt(d6 * d8 * (1.0 - d11) / (d8 * d14 - 2.0 * d10 * d7 * d7 * d15 * d13 + d6 * d16));
        double d18 = Math.sqrt(d6 * d8 * (1.0 - d11) / (d8 * d16 + 2.0 * d10 * d7 * d7 * d15 * d13 + d6 * d14));
        d17 *= 2.0;
        d18 *= 2.0;
        double d19 = Math.PI * 2 / (double)(n - 1);
        double d20 = 0.0;
        int n2 = 0;
        while (n2 < n) {
            double d21 = d17 * Math.cos(d20);
            double d22 = d18 * Math.sin(d20);
            vect2DArray[n2].x = d4 + (double)((float)(d21 * d13 - d22 * d15));
            vect2DArray[n2].y = d5 + (double)((float)(d22 * d13 + d21 * d15));
            ++n2;
            d20 += d19;
        }
    }

    public void paint(Graphics graphics, Color color) {
        int n;
        if (!this.isValid) {
            return;
        }
        graphics.setColor(color);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        Matrix3D.applyPerspTrans(this.ellipseXY[31], nArray);
        for (n = 0; n < 32; ++n) {
            nArray2[0] = nArray[0];
            nArray2[1] = nArray[1];
            Matrix3D.applyPerspTrans(this.ellipseXY[n], nArray);
            Draw3D.drawLine(graphics, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        }
        Matrix3D.applyPerspTrans(this.ellipseXZ[31], nArray);
        for (n = 0; n < 32; ++n) {
            nArray2[0] = nArray[0];
            nArray2[1] = nArray[1];
            Matrix3D.applyPerspTrans(this.ellipseXZ[n], nArray);
            Draw3D.drawLine(graphics, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        }
        Matrix3D.applyPerspTrans(this.ellipseZY[31], nArray);
        for (n = 0; n < 32; ++n) {
            nArray2[0] = nArray[0];
            nArray2[1] = nArray[1];
            Matrix3D.applyPerspTrans(this.ellipseZY[n], nArray);
            Draw3D.drawLine(graphics, nArray[0], nArray[1], nArray2[0], nArray2[1]);
        }
    }

    public void writeBinary(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeBoolean(this.isValid);
        for (int i = 0; i < 6; ++i) {
            dataOutputStream.writeFloat((float)this.cov[i]);
        }
    }

    static {
        for (int i = 0; i < 32; ++i) {
            CovMatrix.tmpArray[i] = new Vect2D();
        }
    }
}

