/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.graphics2d;

import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.awt.GraphDataListener;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import net.alomax.graphics2d.JGraphPanel;
import net.alomax.graphics2d.MarkerGraph2DModel;
import net.alomax.util.NumberFormat;

public class JStereographic
extends JGraphPanel
implements GraphDataListener {
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static final double INV_LOG_10 = 1.0 / Math.log(10.0);
    public static final double INCLINATION_MIN_0 = 0.0;
    public static final double INCLINATION_MAX_90 = 90.0;
    public static final double AZIMUTH_MIN_0 = 0.0;
    public static final double AZIMUTH_MAX_360 = 360.0;
    protected MarkerGraph2DModel model;
    protected Point origin = new Point();
    protected boolean azimuthNumbering = true;
    protected boolean inclinationNumbering = true;
    protected boolean gridLines = false;
    protected Color gridLineColor = Color.lightGray;
    protected double xScale;
    protected double yScale;
    protected int scaledWidth;
    protected int scaledHeight;
    protected double azimuthIncPixels = 40.0;
    protected double inclinationIncPixels = 40.0;
    protected double azimuthInc;
    protected double inclinationInc;
    protected boolean autoAzimuthInc = true;
    protected boolean autoInclinationInc = true;
    protected String title = "Title";
    protected String xAxisUnitsLabel = "Azimuth (deg)";
    protected String yAxisUnitsLabel = "Inclination (deg)";
    protected int scalePad = 5;
    protected int axisPad = 50;
    protected int leftAxisPad;
    protected int rightAxisPad;

    public JStereographic(MarkerGraph2DModel markerGraph2DModel) {
        this.model = markerGraph2DModel;
        this.model.addGraphDataListener(this);
        this.setazimuthAxisUnitsLabel("Az");
        this.setinclinationAxisUnitsLabel("Inc");
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final void setModel(MarkerGraph2DModel markerGraph2DModel) {
        this.model.removeGraphDataListener(this);
        this.model = markerGraph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final Graph2DModel getModel() {
        return this.model;
    }

    @Override
    public void dataChanged(GraphDataEvent graphDataEvent) {
        if (graphDataEvent.isIncremental()) {
            Graphics graphics = this.getGraphics();
            if (graphics == null) {
                return;
            }
            int n = graphDataEvent.getSeries();
            if (n == -1) {
                this.model.firstSeries();
                int n2 = 0;
                do {
                    int n3 = this.model.seriesLength() - 1;
                    this.drawDataPoint(graphics, n3);
                    ++n2;
                } while (this.model.nextSeries());
            } else {
                this.model.firstSeries();
                for (int i = 0; i < n; ++i) {
                    this.model.nextSeries();
                }
                int n4 = this.model.seriesLength() - 1;
                this.drawDataPoint(graphics, n4);
            }
        } else {
            this.repaint();
        }
    }

    public final void setNumbering(boolean bl) {
        this.setNumbering(bl, bl);
    }

    public final void setNumbering(boolean bl, boolean bl2) {
        this.azimuthNumbering = bl;
        this.inclinationNumbering = bl2;
        this.rescale();
    }

    public final void setAxisPad(FontMetrics fontMetrics) {
        int n = 0;
        if (fontMetrics != null) {
            n = 4 * fontMetrics.getHeight();
        }
        this.axisPad = Math.max(this.axisPad, n);
    }

    public final void setLeftAxisPad(FontMetrics fontMetrics) {
        this.leftAxisPad = this.axisPad;
        int n = 0;
        int n2 = 0;
        if (fontMetrics != null) {
            if (this.inclinationNumbering) {
                int n3 = fontMetrics.stringWidth(NumberFormat.doubleString(90.0));
                int n4 = fontMetrics.stringWidth(NumberFormat.doubleString(0.0));
                n = Math.max(n4, n3);
            }
            if (this.yAxisUnitsLabel != null) {
                n2 = fontMetrics.stringWidth(this.yAxisUnitsLabel + "--");
            }
        }
        this.leftAxisPad = Math.max(this.axisPad, Math.max(n, n2));
    }

    public final void setRightAxisPad(FontMetrics fontMetrics) {
        this.rightAxisPad = this.axisPad;
        int n = 0;
        if (fontMetrics != null && this.xAxisUnitsLabel != null) {
            n = fontMetrics.stringWidth(this.xAxisUnitsLabel + "----");
        }
        this.rightAxisPad = Math.max(this.axisPad, n);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.setNumbering(this.azimuthNumbering, this.inclinationNumbering);
    }

    public final void setGridLines(boolean bl) {
        this.gridLines = bl;
        this.repaint();
    }

    public final void setGridLineColor(Color color) {
        this.gridLineColor = color;
        this.repaint();
    }

    public final void setTitle(String string) {
        this.title = string;
    }

    public final void setazimuthAxisUnitsLabel(String string) {
        this.xAxisUnitsLabel = string;
    }

    public final void setinclinationAxisUnitsLabel(String string) {
        this.yAxisUnitsLabel = string;
    }

    public final void setXIncrement(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (d == 0.0) {
            if (!this.autoAzimuthInc) {
                this.autoAzimuthInc = true;
                this.rescale();
            }
        } else {
            this.autoAzimuthInc = false;
            if (d != this.azimuthInc) {
                this.azimuthInc = d;
                this.rescale();
            }
        }
    }

    public final double getXIncrement() {
        return this.azimuthInc;
    }

    public final void setYIncrement(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (d == 0.0) {
            if (!this.autoInclinationInc) {
                this.autoInclinationInc = true;
                this.rescale();
            }
        } else {
            this.autoInclinationInc = false;
            if (d != this.inclinationInc) {
                this.inclinationInc = d;
                this.rescale();
            }
        }
    }

    public final double getYIncrement() {
        return this.inclinationInc;
    }

    @Override
    public final double getXMinimum() {
        return 0.0;
    }

    @Override
    public final double getXMaximum() {
        return 360.0;
    }

    @Override
    public final double getYMinimum() {
        return 0.0;
    }

    @Override
    public final double getYMaximum() {
        return 90.0;
    }

    public final Rectangle2D.Double getExtrema() {
        return new Rectangle2D.Double(0.0, 0.0, 360.0, 90.0);
    }

    @Override
    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(170, 170);
    }

    protected final void rescale() {
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(this.getWidth(), dimension.width);
        int n2 = Math.max(this.getHeight(), dimension.height);
        FontMetrics fontMetrics = null;
        if (this.getFont() != null) {
            fontMetrics = this.getFontMetrics(this.getFont());
        }
        this.rescale(n, n2, fontMetrics);
    }

    protected final void rescale(int n, int n2, FontMetrics fontMetrics) {
        this.scaledWidth = n;
        this.scaledHeight = n2;
        this.axisPad = this.scaledWidth / 20;
        this.scalePad = this.axisPad / 10;
        this.setAxisPad(fontMetrics);
        this.setLeftAxisPad(fontMetrics);
        this.setRightAxisPad(fontMetrics);
        this.xScale = (double)(this.scaledWidth - (this.leftAxisPad + this.rightAxisPad)) / 180.0;
        this.yScale = (double)(this.scaledHeight - 2 * this.axisPad) / 180.0;
        if (this.xScale < this.yScale) {
            this.yScale = this.xScale;
        } else {
            this.xScale = this.yScale;
        }
        this.azimuthIncPixels = (double)this.scaledWidth / 5.0;
        if (this.autoAzimuthInc) {
            this.azimuthInc = 30.0;
        }
        this.inclinationIncPixels = (double)this.scaledHeight / 5.0;
        if (this.autoInclinationInc) {
            this.inclinationInc = 10.0;
        }
        this.origin.x = this.leftAxisPad + (int)Math.round(90.0 * this.xScale);
        this.origin.y = this.scaledHeight - this.axisPad - (int)Math.round(90.0 * this.yScale);
        this.repaint();
    }

    @Override
    public final Point dataToScreen(double d, double d2) {
        if (d2 > 90.0) {
            d2 = 180.0 - d2;
            d -= 180.0;
        }
        return this.dataToScreenNoLowerHemisphereTrans(d, d2);
    }

    public final Point dataToScreenNoLowerHemisphereTrans(double d, double d2) {
        double d3 = d * (Math.PI / 180);
        double d4 = (90.0 - d2) * (Math.PI / 180);
        double d5 = 60.0 * Math.sqrt(2.0 / (1.0 + Math.sin(d4)));
        double d6 = d5 * Math.cos(d4) * Math.sin(d3);
        double d7 = d5 * Math.cos(d4) * Math.cos(d3);
        return new Point(this.origin.x + (int)Math.round(this.xScale * d6), this.origin.y - (int)Math.round(this.yScale * d7));
    }

    @Override
    public final Point2D.Double screenToData(Point point) {
        double d = (double)(point.x - this.origin.x) / this.xScale;
        double d2 = (double)(this.origin.y - point.y) / this.yScale;
        double d3 = Math.sqrt((d /= 60.0) * d + (d2 /= 60.0) * d2);
        double d4 = 2.0 * Math.asin(0.5 * d3);
        double d5 = Math.asin(Math.cos(d4));
        double d6 = Math.atan2(d * Math.sin(d4), -d2 * Math.sin(d4));
        double d7 = 180.0 - d6 * 57.29577951308232;
        double d8 = 90.0 - d5 * 57.29577951308232;
        return new Point2D.Double(d7, d8);
    }

    protected final void drawAxes(Graphics graphics) {
        Point point;
        double d;
        int n = this.scaledWidth;
        int n2 = this.scaledHeight;
        graphics.setColor(this.gridLineColor);
        double d2 = this.getTickStart(0.0, this.azimuthInc);
        double d3 = this.getTickStop(360.0, this.azimuthInc);
        double d4 = this.getTickStart(0.0, this.inclinationInc);
        double d5 = this.getTickStop(90.0, this.inclinationInc);
        if (this.gridLines) {
            Point point2;
            double d6;
            Point point3;
            for (d = d4; d <= d5; d += this.inclinationInc) {
                point3 = this.dataToScreen(d2, d);
                for (d6 = d2; d6 <= d3; d6 += this.azimuthInc / 50.0) {
                    point2 = this.dataToScreen(d6, d);
                    graphics.drawLine(point3.x, point3.y, point2.x, point2.y);
                    point3 = point2;
                }
            }
            for (d = d2; d <= d3; d += this.azimuthInc) {
                point3 = this.dataToScreen(d, d4);
                for (d6 = d4; d6 <= d5; d6 += this.inclinationInc / 50.0) {
                    point2 = this.dataToScreen(d, d6);
                    graphics.drawLine(point3.x, point3.y, point2.x, point2.y);
                    point3 = point2;
                }
            }
        }
        if (this.azimuthNumbering) {
            d = d5 + this.inclinationInc;
            for (double d7 = d2; d7 <= d3 - this.azimuthInc / 2.0; d7 += this.azimuthInc) {
                point = this.dataToScreenNoLowerHemisphereTrans(d7, d);
                this.drawAzimuthLabel(graphics, d7, point);
            }
        }
        if (this.inclinationNumbering) {
            d = d3;
            for (double d8 = d4 + this.inclinationInc; d8 <= d5; d8 += this.inclinationInc) {
                point = this.dataToScreenNoLowerHemisphereTrans(d, d8);
                this.drawInclinationLabel(graphics, d8, point);
            }
        }
        graphics.setColor(this.getForeground());
    }

    protected void drawAzimuthLabel(Graphics graphics, double d, Point point) {
        double d2 = d;
        String string = NumberFormat.doubleString(d2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, point.x - n / 2, point.y + n2 / 3);
    }

    protected void drawAzimuthAxisUnitsLabel(Graphics graphics, Point point) {
        String string = this.xAxisUnitsLabel;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth("--");
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, point.x + n / 2, point.y + n2 / 3);
    }

    protected void drawInclinationLabel(Graphics graphics, double d, Point point) {
        double d2 = d;
        String string = NumberFormat.doubleString(d2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, point.x - n / 2, point.y + n2 / 3);
    }

    protected void drawTitle(Graphics graphics) {
        String string = this.title;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, this.scaledWidth / 2 - n / 2, n2);
    }

    protected void drawInclinationAxisUnitsLabel(Graphics graphics, Point point) {
        String string = this.yAxisUnitsLabel;
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawString(string, point.x - 8 - n, point.y - n2);
    }

    protected void drawData(Graphics graphics) {
        int n;
        this.model.firstSeries();
        for (n = 0; n < this.model.seriesLength(); ++n) {
            this.drawDataPoint(graphics, n);
        }
        int n2 = 1;
        while (this.model.nextSeries()) {
            for (n = 0; n < this.model.seriesLength(); ++n) {
                this.drawDataPoint(graphics, n);
            }
            ++n2;
        }
    }

    protected void drawDataPoint(Graphics graphics, int n) {
        Point point = this.dataToScreen(this.model.getXCoord(n), this.model.getYCoord(n));
        this.model.getMarker(n).paint(graphics, point.x, point.y);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = graphics.getClipBounds().width;
        int n2 = graphics.getClipBounds().height;
        boolean bl = false;
        try {
            PrintGraphics printGraphics = (PrintGraphics)((Object)graphics);
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl || n != this.scaledWidth || n2 != this.scaledHeight) {
            this.rescale(n, n2, graphics.getFontMetrics());
        }
        if (n < 4 * this.axisPad || n2 < 4 * this.axisPad) {
            return;
        }
        if (n < this.getMinimumSize().width || n2 < this.getMinimumSize().height) {
            return;
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(this.getForeground());
        this.drawTitle(graphics);
        this.drawAxes(graphics);
        graphics.setClip(this.leftAxisPad, this.axisPad, n - (this.leftAxisPad + this.rightAxisPad), n2 - 2 * this.axisPad);
        this.drawData(graphics);
    }

    public double getTickStart(double d, double d2) {
        double d3 = d2 * (double)((int)(d / d2));
        if (d3 < d) {
            d3 += d2;
        }
        return d3;
    }

    public double getTickStop(double d, double d2) {
        double d3 = d2 * (double)(1 + (int)(d / d2));
        if (d3 > d) {
            d3 -= d2;
        }
        return d3;
    }

    public double getTickSpace(double d, double d2, double d3) {
        double d4 = d2 - d;
        double d5 = Math.pow(10.0, 1 + (int)(Math.log(d4) * INV_LOG_10));
        int n = 0;
        do {
            if (d5 > d4 / d3) {
                d5 /= 2.0;
            }
            if (d5 > d4 / d3) {
                d5 /= 2.5;
            }
            if (!(d5 > d4 / d3)) continue;
            d5 /= 2.0;
        } while (d5 > d4 / d3 && n++ < 1000);
        return d5;
    }

    @Override
    public String dataToString(Point2D.Double double_) {
        return "az=" + NumberFormat.doubleString(double_.x) + ", inc=" + NumberFormat.doubleString(double_.y);
    }
}

