/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import net.alomax.geog.GeogConstants;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.GlobalLine3D;
import net.alomax.geog.Grid3D;
import net.alomax.geog.Grid3DRectangular;
import net.alomax.geog.MapScale;
import net.alomax.graphics3d.StringVectorizer;
import net.alomax.graphics3d.Vect3D;

public class MapScaleGlobal
extends MapScale {
    protected GlobalLine3D[] line3D = null;
    protected Vect3D[] textCoords;
    protected Vect3D textOffset;

    public MapScaleGlobal(Grid3D grid3D, double d, Vect3D vect3D, Vect3D vect3D2, double d2, double d3) {
        double d4 = grid3D.x0;
        double d5 = d4 + (double)(grid3D.nx - 1) * (double)grid3D.dx;
        double d6 = grid3D.y0;
        double d7 = d6 + (double)(grid3D.ny - 1) * (double)grid3D.dy;
        double d8 = grid3D.z0;
        double d9 = d8 + (double)(grid3D.nz - 1) * (double)grid3D.dz;
        double d10 = Math.min((d5 - d4) / 20.0, (d7 - d6) / 20.0);
        double d11 = d6 + d10;
        if (vect3D2 != null) {
            d11 = d6 + vect3D2.y * (d7 - d6);
        }
        double d12 = GeogConstants.DEG2KM * (d5 - d4) * Math.cos(Math.PI / 180 * d11);
        double d13 = Math.pow(10.0, 1 + (int)(Math.log(d12) / Math.log(10.0)));
        double d14 = 5.0;
        int n = 0;
        do {
            if (d13 > d12 / d14) {
                d13 /= 2.0;
            }
            if (d13 > d12 / d14) {
                d13 /= 2.5;
            }
            if (!(d13 > d12 / d14)) continue;
            d13 /= 2.0;
        } while (n++ < 1000 && d13 > d12 / d14);
        double d15 = d13 * GeogConstants.KM2DEG / Math.cos(Math.PI / 180 * d11);
        double d16 = d5 - d10 - d15 / 2.0;
        if (vect3D2 != null) {
            d16 = d4 + vect3D2.x * (d5 - d4);
        }
        double d17 = d15 / 16.0;
        GeogCoords geogCoords = new GeogCoords();
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        Vect3D vect3D3 = geogCoords.geog2xyz(d11 + d17, d16 + d15 / 2.0, d8);
        Vect3D vect3D4 = geogCoords.geog2xyz(d11, d16 + d15 / 2.0, d8);
        Vect3D vect3D5 = geogCoords.geog2xyz(d11, d16 - d15 / 2.0, d8);
        Vect3D vect3D6 = geogCoords.geog2xyz(d11 + d17, d16 - d15 / 2.0, d8);
        fArray[0] = (float)vect3D3.x;
        fArray2[0] = (float)vect3D3.y;
        fArray3[0] = (float)vect3D3.z;
        fArray[1] = (float)vect3D4.x;
        fArray2[1] = (float)vect3D4.y;
        fArray3[1] = (float)vect3D4.z;
        fArray[2] = (float)vect3D5.x;
        fArray2[2] = (float)vect3D5.y;
        fArray3[2] = (float)vect3D5.z;
        fArray[3] = (float)vect3D6.x;
        fArray2[3] = (float)vect3D6.y;
        fArray3[3] = (float)vect3D6.z;
        this.line3D = new GlobalLine3D[1];
        this.line3D[0] = new GlobalLine3D(fArray, fArray2, fArray3, vect3D, true);
        double d18 = 1.0;
        if (d2 > 0.0) {
            d18 = d2;
        }
        double d19 = 3.0;
        if (d3 > 0.0) {
            d19 = d3;
        }
        StringVectorizer stringVectorizer = new StringVectorizer(String.valueOf(d13) + " km", grid3D.component, grid3D.component.getFont().getName(), 0, (int)(0.5 * d18 * (double)grid3D.component.getFont().getSize()), d19);
        Vect3D vect3D7 = new Vect3D(d11 + d17 + 1.2 * d17, d16, d8);
        this.textOffset = geogCoords.geog2xyz(vect3D7);
        Vect3D vect3D8 = geogCoords.geog2xyz(vect3D7.add(new Vect3D(0.0, 0.01, 0.0)));
        Vect3D vect3D9 = vect3D8.sub(this.textOffset);
        Vect3D vect3D10 = geogCoords.geog2xyz(vect3D7.add(new Vect3D(0.01, 0.0, 0.0)));
        Vect3D vect3D11 = vect3D10.sub(this.textOffset);
        this.textCoords = stringVectorizer.toWorldCoords(d, 1, 1, vect3D9, vect3D11);
    }

    MapScaleGlobal(Grid3DRectangular grid3DRectangular, double d, Vect3D vect3D, Vect3D vect3D2, double d2, double d3, double d4, Vect3D vect3D3) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void paint(Graphics graphics, Color color, boolean bl, Vect3D vect3D) {
        Graphics graphics2 = graphics.create();
        if (this.basicStroke != null) {
            try {
                ((Graphics2D)graphics2).setStroke(this.basicStroke);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.line3D.length; ++i) {
            this.line3D[i].paint(graphics2, 0, this.line3D[i].size() - 1, color, this.basicStroke, bl, vect3D);
        }
        StringVectorizer.paint(graphics2, this.textCoords, this.textOffset.x, this.textOffset.y, this.textOffset.z, true);
        graphics2.dispose();
    }
}

