/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Vector;
import net.alomax.geog.GeogCoords;
import net.alomax.geog.GlobalLine3D;
import net.alomax.geog.MapObjects;
import net.alomax.graphics3d.DrawableSet3D;
import net.alomax.graphics3d.Range3D;
import net.alomax.graphics3d.Vect2D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.io.ASCIIOutputStream;
import net.alomax.io.GeneralInputStream;
import net.alomax.io.ZipStream;
import sdsu.io.ASCIIInputStream;

public class MapLines
extends MapObjects {
    protected static final String ProgName = "MapLines: ";
    public GlobalLine3D[] lineSegmentArray = new GlobalLine3D[0];
    protected static String endline = System.getProperty("line.separator");

    public static DrawableSet3D[][] getMapLines(URL uRL, MapObjects[] mapObjectsArray, boolean[] blArray, GeogCoords geogCoords, Range3D range3D) {
        int n;
        int n2 = 0;
        DrawableSet3D[][] drawableSet3DArrayArray = new DrawableSet3D[mapObjectsArray.length][];
        for (int i = 0; i < mapObjectsArray.length; ++i) {
            Vect3D vect3D = null;
            n = 0;
            try {
                InputStream inputStream = null;
                inputStream = GeneralInputStream.openStream(uRL, mapObjectsArray[i].filename, true);
                inputStream = ZipStream.getInputStream(inputStream, mapObjectsArray[i].filename);
                MapLines mapLines = new MapLines(inputStream, mapObjectsArray[i].filename, mapObjectsArray[i].name, geogCoords, mapObjectsArray[i].color, new BasicStroke(1.0f, 2, 0), vect3D, n != 0, range3D, true);
                DrawableSet3D[] drawableSet3DArray = mapLines.lineSegmentArray;
                for (int j = 0; j < drawableSet3DArray.length; ++j) {
                    drawableSet3DArray[j].showInitially = blArray[i];
                }
                drawableSet3DArrayArray[n2] = drawableSet3DArray;
                ++n2;
                continue;
            }
            catch (Exception exception) {
                System.out.println("ERROR: opening or reading file: " + mapObjectsArray[i].filename);
                exception.printStackTrace();
            }
        }
        DrawableSet3D[][] drawableSet3DArray = new DrawableSet3D[n2][];
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            drawableSet3DArray[n] = drawableSet3DArrayArray[n];
        }
        return drawableSet3DArray;
    }

    public MapLines(String string, String string2, GeogCoords geogCoords, Color color, GlobalLine3D[] globalLine3DArray) {
        super(color, geogCoords, string, string2);
        this.lineSegmentArray = globalLine3DArray;
    }

    public MapLines(InputStream inputStream, String string, String string2, GeogCoords geogCoords, Color color, BasicStroke basicStroke, Vect3D vect3D, boolean bl) throws Exception {
        this(inputStream, string, string2, geogCoords, color, basicStroke, vect3D, bl, null, false);
    }

    public MapLines(InputStream inputStream, String string, String string2, GeogCoords geogCoords, Color color, BasicStroke basicStroke, Vect3D vect3D, boolean bl, Range3D range3D, boolean bl2) throws Exception {
        super(color, basicStroke, geogCoords, string, string2);
        boolean bl3 = false;
        Vector vector = new Vector();
        ASCIIInputStream aSCIIInputStream = new ASCIIInputStream(new BufferedInputStream(inputStream));
        boolean bl4 = false;
        boolean bl5 = false;
        try {
            while (!aSCIIInputStream.eof()) {
                float f = 0.0f;
                float f2 = 0.0f;
                boolean bl6 = false;
                try {
                    f = aSCIIInputStream.readFloat();
                    f2 = aSCIIInputStream.readFloat();
                }
                catch (NumberFormatException numberFormatException) {
                    bl6 = true;
                }
                Vect3D[] vect3DArray = null;
                if (!bl6) {
                    vect3DArray = this.project(f, f2, aSCIIInputStream);
                    boolean bl7 = geogCoords.splitLastAtCentralMeridan;
                    if ((bl7 && !bl5 || !bl7 && bl5) && bl4) {
                        bl6 = true;
                    }
                    bl5 = bl7;
                    if (!this.formatXYZ) {
                        if (this.formatLonFirst && this.clip(f2, f, (float)(-vect3DArray[0].z))) {
                            bl6 = true;
                        } else if (this.formatLatFirst && this.clip(f, f2, (float)(-vect3DArray[0].z))) {
                            bl6 = true;
                        }
                    }
                }
                if (bl6) {
                    if (!bl3) {
                        String string3;
                        try {
                            string3 = aSCIIInputStream.readWord();
                        }
                        catch (IOException iOException) {
                            string3 = null;
                        }
                        if (string3 != null) {
                            boolean bl8 = true;
                            try {
                                f = Float.valueOf(string3).floatValue();
                            }
                            catch (NumberFormatException numberFormatException) {
                                bl8 = false;
                            }
                            if (bl8) {
                                System.out.println("MapLines: WARNING: File: <" + string + ">: unspecified mapline file format: <" + string3 + "> , assuming x/y format: XY_.");
                                string3 = "XY_";
                            }
                            if (!this.setFormat(string3)) break;
                            bl3 = true;
                        }
                    }
                    if (!bl4) {
                        vector.addElement(new Vector());
                        bl4 = true;
                    } else {
                        bl4 = false;
                        if (((Vector)vector.lastElement()).size() < 2) {
                            vector.removeElementAt(vector.size() - 1);
                        }
                    }
                    aSCIIInputStream.flushLine();
                    continue;
                }
                if (!bl4) {
                    vector.addElement(new Vector());
                    bl4 = true;
                }
                for (Vect3D vect3D2 : vect3DArray) {
                    ((Vector)vector.lastElement()).addElement(vect3D2);
                }
                aSCIIInputStream.flushLine();
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.toArray(vector, vect3D, bl, range3D);
    }

    protected void toArray(Vector vector, Vect3D vect3D, boolean bl, Range3D range3D) {
        GlobalLine3D[] globalLine3DArray = new GlobalLine3D[vector.size()];
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Vector vector2 = (Vector)vector.elementAt(i);
            float[] fArray = new float[vector2.size()];
            float[] fArray2 = new float[vector2.size()];
            float[] fArray3 = new float[vector2.size()];
            for (int j = 0; j < vector2.size(); ++j) {
                Vect3D vect3D2 = (Vect3D)vector2.elementAt(j);
                fArray[j] = (float)vect3D2.x;
                fArray2[j] = (float)vect3D2.y;
                fArray3[j] = (float)vect3D2.z;
            }
            GlobalLine3D globalLine3D = new GlobalLine3D(fArray, fArray2, fArray3, this.color, vect3D, bl);
            if (range3D != null && !globalLine3D.bounds().intersects(range3D)) continue;
            globalLine3DArray[n++] = globalLine3D;
            globalLine3D.setName(this.name);
        }
        this.lineSegmentArray = new GlobalLine3D[n];
        System.arraycopy(globalLine3DArray, 0, this.lineSegmentArray, 0, n);
    }

    public void paint(Graphics graphics, boolean bl, Vect3D vect3D) {
        for (int i = 0; i < this.lineSegmentArray.length; ++i) {
            this.lineSegmentArray[i].paint(graphics, 0, this.lineSegmentArray[i].size() - 1, this.color, this.basicStroke, bl, vect3D);
        }
    }

    public int printLatLong(ASCIIOutputStream aSCIIOutputStream, GeogCoords geogCoords) throws Exception {
        aSCIIOutputStream.writeWord("> GMT_LATLONDEPTH" + endline);
        for (int i = 0; i < this.lineSegmentArray.length; ++i) {
            aSCIIOutputStream.writeWord(">" + endline);
            GlobalLine3D globalLine3D = this.lineSegmentArray[i];
            for (int j = 0; j < globalLine3D.xData.length; ++j) {
                Vect3D vect3D = geogCoords.xyz2geog(globalLine3D.xData[j], globalLine3D.yData[j], globalLine3D.zData[j]);
                aSCIIOutputStream.writeFloat((float)vect3D.x);
                aSCIIOutputStream.writeWord(" ");
                aSCIIOutputStream.writeFloat((float)vect3D.y);
                aSCIIOutputStream.writeWord(" ");
                aSCIIOutputStream.writeFloat((float)vect3D.z);
                aSCIIOutputStream.writeWord(endline);
            }
        }
        return this.lineSegmentArray.length;
    }

    public boolean contains(double d, double d2) {
        Vect2D vect2D = this.geogCoords.geog2xy(d2, d);
        for (GlobalLine3D globalLine3D : this.lineSegmentArray) {
            if (!globalLine3D.contains(vect2D.x, vect2D.y)) continue;
            return true;
        }
        return false;
    }
}

