/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import net.alomax.awt.AJLColor;
import net.alomax.awt.AJLStroke;
import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.Line3D;
import net.alomax.graphics3d.Transformable3D;
import net.alomax.graphics3d.Vect3D;
import net.alomax.io.ASCIIOutputStream;

public abstract class Grid3D
extends Transformable3D {
    protected static Color color = Color.gray;
    protected static BasicStroke basicStroke = new BasicStroke(2.0f, 2, 0);
    protected static BasicStroke basicStrokeDashed = null;
    protected Component component;
    public GeogCoords geogCoords = null;
    protected boolean visible = true;
    protected boolean scalebarVisible = true;
    protected boolean latLonVisible = true;
    protected boolean isWholeEarth = false;
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public double zmin;
    public double zmax;
    protected float x0;
    protected float y0;
    protected float z0;
    protected float dx;
    protected float dy;
    protected float dz;
    protected int nx;
    protected int ny;
    protected int nz;
    protected Line3D clipLatLonBoxLine3D = null;
    protected Line3D clipLatLonBoundsLine3D = null;
    protected static String endline = System.getProperty("line.separator");

    public static void invertColor() {
        color = AJLColor.invert(color);
    }

    public Grid3D(Component component) {
        this.component = component;
    }

    public void initialize(double d, Vect3D vect3D, Vect3D vect3D2, Color color, double d2, double d3, double d4, String string, String string2, double d5, boolean bl, boolean bl2) {
        Grid3D.color = color;
        try {
            basicStrokeDashed = AJLStroke.createStroke("2", "DASHED");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.createScaleBar(d, vect3D2, d2 * 1.3, d3, d4);
        this.createLabels(d);
        this.createLatLonGrid(d, vect3D, d2, d3, string, string2, d5, bl, bl2);
    }

    public abstract void createScaleBar(double var1, Vect3D var3, double var4, double var6, double var8);

    public abstract void createVectScaleBar(double var1, Vect3D var3, double var4, double var6, double var8, Vect3D var10);

    public abstract void createHorizontalScale(Vect3D var1, double var2, double var4, double var6, double var8, double var10, double var12, Vect3D var14, boolean var15);

    public abstract void createLabels(double var1);

    protected abstract void createLatLonGrid(double var1, Vect3D var3, double var4, double var6, String var8, String var9, double var10, boolean var12, boolean var13);

    public abstract void paint(Graphics var1, boolean var2, Vect3D var3);

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setScalebarVisible(boolean bl) {
        this.scalebarVisible = bl;
    }

    public void setLatLonVisible(boolean bl) {
        this.latLonVisible = bl;
    }

    public boolean getIsWholeEarth() {
        return this.isWholeEarth;
    }

    public Line3D getClipLatLonBoxLine3D() {
        return this.clipLatLonBoxLine3D;
    }

    public void setClipLatLonBoxLine3D(Line3D line3D) {
        this.clipLatLonBoxLine3D = line3D;
    }

    public Line3D getClipLatLonBoundsLine3D() {
        return this.clipLatLonBoundsLine3D;
    }

    public void setClipLatLonBoundsLine3D(Line3D line3D) {
        this.clipLatLonBoundsLine3D = line3D;
    }

    public boolean isInsideGeographic(double d, double d2, double d3) {
        Vect3D vect3D = this.geogCoords.geog2xyz(d, d2, d3);
        if (vect3D.x < this.xmin || vect3D.x > this.xmax) {
            return false;
        }
        if (vect3D.y < this.ymin || vect3D.y > this.ymax) {
            return false;
        }
        return !(vect3D.z < this.zmin) && !(vect3D.z > this.zmax);
    }

    public double getTickSpace(double d, double d2, double d3) {
        double d4 = d2 - d;
        double d5 = Math.pow(10.0, 1 + (int)(Math.log(d4) / Math.log(10.0)));
        int n = 0;
        do {
            if (d5 > d4 / d3) {
                d5 /= 2.0;
            }
            if (d5 > d4 / d3) {
                d5 /= 2.5;
            }
            if (!(d5 > d4 / d3)) continue;
            d5 /= 2.0;
        } while (d5 > d4 / d3 && n++ < 1000);
        return d5;
    }

    public int printLatLong(ASCIIOutputStream aSCIIOutputStream, GeogCoords geogCoords) throws Exception {
        aSCIIOutputStream.writeWord("> GMT_LATLONDEPTH" + endline);
        aSCIIOutputStream.writeWord(">" + endline);
        Vect3D vect3D = geogCoords.xyz2geog(this.xmin, this.ymin, -this.zmin);
        Vect3D vect3D2 = geogCoords.xyz2geog(this.xmin, this.ymin, -this.zmax);
        Vect3D vect3D3 = geogCoords.xyz2geog(this.xmin, this.ymax, -this.zmin);
        Vect3D vect3D4 = geogCoords.xyz2geog(this.xmin, this.ymax, -this.zmax);
        Vect3D vect3D5 = geogCoords.xyz2geog(this.xmax, this.ymin, -this.zmin);
        Vect3D vect3D6 = geogCoords.xyz2geog(this.xmax, this.ymin, -this.zmax);
        Vect3D vect3D7 = geogCoords.xyz2geog(this.xmax, this.ymax, -this.zmin);
        Vect3D vect3D8 = geogCoords.xyz2geog(this.xmax, this.ymax, -this.zmax);
        this.printPoint(aSCIIOutputStream, vect3D);
        this.printPoint(aSCIIOutputStream, vect3D3);
        this.printPoint(aSCIIOutputStream, vect3D7);
        this.printPoint(aSCIIOutputStream, vect3D5);
        this.printPoint(aSCIIOutputStream, vect3D);
        aSCIIOutputStream.writeWord(">" + endline);
        this.printPoint(aSCIIOutputStream, vect3D2);
        this.printPoint(aSCIIOutputStream, vect3D4);
        this.printPoint(aSCIIOutputStream, vect3D8);
        this.printPoint(aSCIIOutputStream, vect3D6);
        this.printPoint(aSCIIOutputStream, vect3D2);
        aSCIIOutputStream.writeWord(">" + endline);
        this.printPoint(aSCIIOutputStream, vect3D);
        this.printPoint(aSCIIOutputStream, vect3D2);
        aSCIIOutputStream.writeWord(">" + endline);
        this.printPoint(aSCIIOutputStream, vect3D3);
        this.printPoint(aSCIIOutputStream, vect3D4);
        aSCIIOutputStream.writeWord(">" + endline);
        this.printPoint(aSCIIOutputStream, vect3D5);
        this.printPoint(aSCIIOutputStream, vect3D6);
        aSCIIOutputStream.writeWord(">" + endline);
        this.printPoint(aSCIIOutputStream, vect3D7);
        this.printPoint(aSCIIOutputStream, vect3D8);
        aSCIIOutputStream.writeWord(">" + endline);
        return 8;
    }

    protected void printPoint(ASCIIOutputStream aSCIIOutputStream, Vect3D vect3D) {
        aSCIIOutputStream.writeFloat((float)vect3D.x);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeFloat((float)vect3D.y);
        aSCIIOutputStream.writeWord(" ");
        aSCIIOutputStream.writeFloat((float)vect3D.z);
        aSCIIOutputStream.writeWord(endline);
    }

    public String toString() {
        String string = "x=";
        string = string + this.xmin + " -> ";
        string = string + this.xmax + ",  y=";
        string = string + this.ymin + " -> ";
        string = string + this.ymax + ",  z=";
        string = string + this.zmin + " -> ";
        string = string + this.zmax;
        return string;
    }
}

