/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.io.Serializable;
import net.alomax.geog.Planet;
import net.alomax.geog.UnsupportedPlanetException;

public class GeogConstants
implements Serializable {
    protected static Planet planet = Planet.EARTH;
    public static double PLANET_RADIUS = planet.radius();
    public static double PLANET_FLATTENING = planet.flattening();
    public static final char UNDEF_CHAR = '?';
    public static final String UNDEF_STRING = new String("?");
    public static final int UNDEF_INT = Integer.MAX_VALUE;
    public static final double UNDEF_DOUBLE = Double.MAX_VALUE;
    public static final int UNKNOWN = 0;
    public static final int KILOMETERS = 1;
    public static final int DEGREES = 2;
    public static final char DEGREES_CHAR = '\u00ba';
    public static final double RPD = Math.PI / 180;
    public static final double DEG2RAD = Math.PI / 180;
    public static final double RAD2DEG = 57.29577951308232;
    public static double KPD;
    public static double DEG2KM;
    public static double KM2DEG;

    public static void setPlanet(String string) throws UnsupportedPlanetException {
        for (Planet planet : Planet.values()) {
            if (!string.equalsIgnoreCase(planet.toString())) continue;
            GeogConstants.setPlanet(planet);
            return;
        }
        throw new UnsupportedPlanetException(string);
    }

    public static void setPlanet(Planet planet) {
        GeogConstants.planet = planet;
        PLANET_RADIUS = GeogConstants.planet.radius();
        PLANET_FLATTENING = GeogConstants.planet.flattening();
        DEG2KM = KPD = PLANET_RADIUS * Math.PI / 180.0;
        KM2DEG = 1.0 / KPD;
    }

    public static Planet getPlanet() {
        return planet;
    }

    static {
        DEG2KM = KPD = PLANET_RADIUS * Math.PI / 180.0;
        KM2DEG = 1.0 / KPD;
    }
}

