/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import net.alomax.awt.ColorMap;

public class ColorMapLegend {
    protected int[] xpos;
    protected String[] label;
    protected String title;
    protected String units;
    protected double textSizeFactor;
    protected ColorMap colorMap = null;
    protected Color foregroundColor = Color.white;
    protected Color backgroundColor = Color.black;
    protected Component component = null;
    protected double[] indicatorBar = null;
    protected Rectangle lastRect = null;
    protected Image image = null;

    public ColorMapLegend(ColorMap colorMap, String string, String string2, double d, Color color, Color color2, Component component) {
        this.colorMap = colorMap;
        this.title = string;
        this.units = string2;
        this.textSizeFactor = d;
        this.foregroundColor = color;
        this.backgroundColor = color2;
        this.component = component;
    }

    public void setForeground(Color color) {
        this.foregroundColor = color;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public void setIndicatorBar(double d, double d2) {
        this.indicatorBar = new double[2];
        this.indicatorBar[0] = d;
        this.indicatorBar[1] = d2;
    }

    public void clearIndicatorBar() {
        this.indicatorBar = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics, int n, int n2, int n3) {
        if (this.colorMap == null || this.component == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        try {
            int n4;
            int n5;
            double d;
            int n6;
            double d2 = this.textSizeFactor * (double)n3 / 2200.0;
            Font font = graphics2.getFont();
            graphics2.setFont(new Font(font.getName(), font.getStyle(), (int)Math.round(d2 * (double)font.getSize())));
            FontMetrics fontMetrics = graphics2.getFontMetrics();
            int n7 = fontMetrics.getMaxDescent();
            int n8 = 2 * (n7 + fontMetrics.getMaxAscent());
            n8 = n8 * 11 / 10;
            Rectangle rectangle = new Rectangle(n, n2 - n8, n3, n8);
            if (this.lastRect != null && rectangle.equals(this.lastRect)) {
                graphics2.drawImage(this.image, rectangle.x, rectangle.y, null);
                return;
            }
            if (rectangle.width < 1 || rectangle.height < 1) {
                return;
            }
            this.image = this.component.createImage(n3, rectangle.height);
            this.lastRect = new Rectangle(rectangle);
            if (this.image == null) {
                return;
            }
            Graphics graphics3 = this.image.getGraphics();
            graphics3.setFont(new Font(font.getName(), font.getStyle(), (int)Math.round(d2 * (double)font.getSize())));
            try {
                ((Graphics2D)graphics3).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            catch (Exception exception) {
                // empty catch block
            }
            graphics3.setColor(this.backgroundColor);
            graphics3.fillRect(0, 0, rectangle.width, rectangle.height);
            graphics3.setColor(this.foregroundColor);
            int n9 = fontMetrics.stringWidth("W" + this.colorMap.nodeValues[this.colorMap.nodeValues.length - 1] + " " + this.units);
            int n10 = fontMetrics.stringWidth("WWWWWW" + this.title);
            int n11 = n9 / 2;
            int n12 = rectangle.width - n10;
            int n13 = rectangle.height / 2;
            int n14 = rectangle.height - rectangle.height / 10;
            double d3 = (this.colorMap.nodeValues[this.colorMap.nodeValues.length - 1] - this.colorMap.nodeValues[0]) / (double)(n12 - n11 + 1);
            int n15 = n14 - n13;
            int n16 = (n14 + n13) / 2;
            int n17 = 1;
            int[] nArray = new int[3];
            int[] nArray2 = new int[3];
            for (n6 = n11; n6 < n12; ++n6) {
                d = (double)(n6 - n11) * d3 + this.colorMap.nodeValues[0];
                graphics3.setColor(this.colorMap.colorAt(d));
                graphics3.fillRect(n6, n13, 1, n15);
                if (n6 != n11) continue;
                nArray[0] = n6 - n15;
                nArray[1] = n6;
                nArray[2] = n6;
                nArray2[0] = n16;
                nArray2[1] = n13 - n17;
                nArray2[2] = n14 + n17;
                graphics3.fillPolygon(nArray, nArray2, 3);
            }
            d = (double)(n12 - n11 + 1) * 1.1 * d3 + this.colorMap.nodeValues[0];
            graphics3.setColor(this.colorMap.colorAt(d));
            nArray[0] = n6 + n15;
            nArray[1] = n6;
            nArray[2] = n6;
            nArray2[0] = n16;
            nArray2[1] = n13 - n17;
            nArray2[2] = n14 + n17;
            graphics3.fillPolygon(nArray, nArray2, 3);
            int n18 = n13 - n7 - 1;
            int n19 = -2147483647;
            int n20 = fontMetrics.stringWidth(" ");
            String string = "               ";
            for (n5 = 0; n5 < this.colorMap.nodeValues.length; ++n5) {
                int n21;
                String string2 = this.colorMap.stringValueOf(this.colorMap.nodeValues[n5]);
                if (string2.length() > 8 && string2.substring(8, 9).equals("-") && this.title.equalsIgnoreCase("OTime") && string.substring(0, 9).equals(string2.substring(0, 9))) {
                    string = string2;
                    string2 = string2.substring(9);
                } else if (string2.length() == 8 && this.title.equalsIgnoreCase("OTime")) {
                    String string3 = string2;
                    for (n21 = 0; n21 < string2.length() && string.substring(n21, n21 + 2).equals(string2.substring(n21, n21 + 2)); n21 += 2) {
                    }
                    if (n21 < string2.length()) {
                        string2 = string2.substring(n21);
                    }
                    string = string3;
                    if (string2.length() == 8) {
                        string2 = string2.substring(0, 4) + "-" + string2.substring(4, 6) + "-" + string2.substring(6, 8);
                    } else if (string2.length() == 4) {
                        string2 = string2.substring(0, 2) + "-" + string2.substring(2, 4);
                    }
                } else {
                    string = string2;
                }
                if (n5 == this.colorMap.nodeValues.length - 1) {
                    string2 = string2 + " " + this.units;
                }
                try {
                    ((Graphics2D)graphics3).setStroke(new BasicStroke(6.0f, 2, 0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n22 = n11 + (int)((this.colorMap.nodeValues[n5] - this.colorMap.nodeValues[0]) / d3);
                graphics3.setColor(this.backgroundColor);
                graphics3.drawLine(n22, n13 - 2, n22, n14);
                graphics3.setColor(this.foregroundColor);
                n21 = fontMetrics.stringWidth(string2);
                int n23 = n22 - n21 / 2;
                if (n23 <= n19) continue;
                graphics3.drawString(string2, n23, n18);
                n19 = n23 + n21 + n20;
            }
            graphics3.drawString(" " + this.title, n12 + n15 + 1, n14 - n7);
            if (this.indicatorBar != null && (n5 = n11 + (int)((this.indicatorBar[0] - this.colorMap.nodeValues[0]) / d3)) < (n4 = n11 + (int)((this.indicatorBar[1] - this.colorMap.nodeValues[0]) / d3)) && (n5 > n11 || n4 < n12)) {
                n5 = Math.max(n11, n5);
                n5 = Math.min(n12, n5);
                n4 = Math.max(n11, n4);
                n4 = Math.min(n12, n4);
                int[] nArray3 = new int[6];
                int[] nArray4 = new int[6];
                nArray3[0] = n5;
                nArray3[1] = n5;
                nArray4[0] = n13 - n17;
                nArray4[1] = n14 + n17;
                graphics3.setColor(this.foregroundColor);
                nArray3[2] = n4;
                nArray3[3] = n4;
                nArray4[2] = n14 + n17;
                nArray4[3] = n13 - n17;
                try {
                    ((Graphics2D)graphics3).setStroke(new BasicStroke(4.0f, 2, 0));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                graphics3.drawPolygon(nArray3, nArray4, 4);
            }
            graphics2.drawImage(this.image, rectangle.x, rectangle.y, null);
            graphics3.dispose();
        }
        catch (Exception exception) {
            System.err.println("WARNING: exception painting ColorMapLegend: " + exception);
        }
        finally {
            graphics2.dispose();
        }
    }
}

