/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.Color;
import java.util.Vector;
import net.alomax.awt.AJLColor;
import net.alomax.util.NumberFormat;
import net.alomax.util.StringExt;

public class ColorMap {
    protected double[] nodeValues;
    protected Color[] nodeColors;

    public ColorMap() {
        this.nodeValues = null;
        this.nodeColors = null;
    }

    public ColorMap(double[] dArray, Color[] colorArray) {
        this.nodeValues = dArray;
        this.nodeColors = colorArray;
    }

    public ColorMap(String string) throws Exception {
        Vector<Double> vector = new Vector<Double>();
        Vector<Color> vector2 = new Vector<Color>();
        String[] stringArray = string.split("[;#]");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = StringExt.parse(stringArray[i], ",");
            Double d = Double.valueOf(stringArray2[0]);
            vector.addElement(d);
            Color color = null;
            try {
                int n = Integer.parseInt(stringArray2[1]);
                int n2 = Integer.parseInt(stringArray2[2]);
                int n3 = Integer.parseInt(stringArray2[3]);
                int n4 = 255;
                if (stringArray2.length > 4) {
                    n4 = Integer.parseInt(stringArray2[4]);
                }
                color = new Color(n, n2, n3, n4);
                vector2.addElement(color);
                continue;
            }
            catch (Exception exception) {
                try {
                    color = AJLColor.createColorFromName(stringArray2[1]);
                    vector2.addElement(color);
                    continue;
                }
                catch (Exception exception2) {
                    throw new Exception(exception.getMessage() + ": " + exception2.getMessage());
                }
            }
        }
        double[] dArray = new double[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            dArray[i] = (Double)vector.elementAt(i);
        }
        Object[] objectArray = new Color[vector2.size()];
        vector2.copyInto(objectArray);
        this.nodeValues = dArray;
        this.nodeColors = objectArray;
    }

    public void setNodeValuesAndColors(double[] dArray, Color[] colorArray) {
        this.nodeValues = dArray;
        this.nodeColors = colorArray;
    }

    public double[] getNodeValues() {
        return this.nodeValues;
    }

    public Color[] getNodeColors() {
        return this.nodeColors;
    }

    public void saturateColors() {
        for (int i = 0; i < this.nodeColors.length; ++i) {
            Color color = this.nodeColors[i];
            int n = color.getRed();
            n = Math.max(n, color.getGreen());
            if ((n = Math.max(n, color.getBlue())) <= 0) continue;
            int n2 = color.getRed() * 255 / n;
            int n3 = color.getGreen() * 255 / n;
            int n4 = color.getBlue() * 255 / n;
            int n5 = 255;
            this.nodeColors[i] = new Color(n2, n3, n4, n5);
        }
    }

    public Color colorAt(double d) {
        int n;
        for (n = 0; n < this.nodeValues.length && d > this.nodeValues[n]; ++n) {
        }
        if (n <= 0) {
            return this.nodeColors[0];
        }
        if (n >= this.nodeValues.length) {
            return this.nodeColors[this.nodeValues.length - 1];
        }
        double d2 = (d - this.nodeValues[n - 1]) / (this.nodeValues[n] - this.nodeValues[n - 1]);
        int n2 = this.nodeColors[n - 1].getRed() + (int)((double)(this.nodeColors[n].getRed() - this.nodeColors[n - 1].getRed()) * d2);
        int n3 = this.nodeColors[n - 1].getGreen() + (int)((double)(this.nodeColors[n].getGreen() - this.nodeColors[n - 1].getGreen()) * d2);
        int n4 = this.nodeColors[n - 1].getBlue() + (int)((double)(this.nodeColors[n].getBlue() - this.nodeColors[n - 1].getBlue()) * d2);
        int n5 = this.nodeColors[n - 1].getAlpha() + (int)((double)(this.nodeColors[n].getAlpha() - this.nodeColors[n - 1].getAlpha()) * d2);
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > 255) {
            n2 = 255;
        }
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > 255) {
            n3 = 255;
        }
        if (n4 < 0) {
            n4 = 0;
        } else if (n4 > 255) {
            n4 = 255;
        }
        if (n5 < 0) {
            n5 = 0;
        } else if (n5 > 255) {
            n5 = 255;
        }
        return new Color(n2, n3, n4, n5);
    }

    public String stringValueOf(double d) {
        return NumberFormat.doubleString(d);
    }
}

