/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.awt;

import java.awt.BasicStroke;
import java.util.StringTokenizer;

public class AJLStroke {
    public static final String[] typeString = new String[]{"SOLID", "DASHED", "DOTTED", "DASHDOT"};
    public static BasicStroke defaultStroke = new BasicStroke(1.0f, 2, 0);
    protected static boolean invertGreyScaleOnly = false;

    public static BasicStroke createStroke(String string) throws Exception {
        float f = AJLStroke.parseWidth(string);
        return new BasicStroke(f, 2, 0);
    }

    public static BasicStroke createStroke(String string, String string2) throws Exception {
        int n = 2;
        int n2 = 0;
        float f = 1.0f;
        float[] fArray = AJLStroke.parseLineType(string2);
        return AJLStroke.createStroke(string, string2, n, n2, f);
    }

    public static BasicStroke createStroke(String string, String string2, int n, int n2, float f) throws Exception {
        float f2 = AJLStroke.parseWidth(string);
        float[] fArray = AJLStroke.parseLineType(string2);
        float f3 = 0.0f;
        if (fArray == null) {
            return new BasicStroke(f2, n, n2, f);
        }
        int n3 = 0;
        while (n3 < fArray.length) {
            int n4 = n3++;
            fArray[n4] = fArray[n4] * f2;
        }
        return new BasicStroke(f2, n, n2, f, fArray, f3);
    }

    public static float parseWidth(String string) throws Exception {
        float f;
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            f = Float.parseFloat(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            throw new Exception("AJLStroke: ERROR: parsing stroke specification: " + string);
        }
        if ((double)f < 0.0) {
            throw new Exception("AJLColor: ERROR: invalid stroke values in: " + string);
        }
        return f;
    }

    public static float[] parseLineType(String string) throws Exception {
        float[] fArray;
        block6: {
            fArray = null;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                if (string.equalsIgnoreCase(typeString[0])) {
                    fArray = null;
                    break block6;
                }
                if (string.equalsIgnoreCase(typeString[1])) {
                    fArray = new float[]{4.0f, 4.0f};
                    break block6;
                }
                if (string.equalsIgnoreCase(typeString[2])) {
                    fArray = new float[]{1.0f, 1.0f};
                    break block6;
                }
                if (string.equalsIgnoreCase(typeString[3])) {
                    fArray = new float[]{4.0f, 2.0f, 1.0f, 2.0f};
                    break block6;
                }
                throw new Exception("Unrecgonized line type.");
            }
            catch (Exception exception) {
                throw new Exception("AJLStroke: ERROR: parsing stroke specification: " + string + ": " + exception);
            }
        }
        return fArray;
    }
}

