/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.animator;

import net.alomax.animator.AnimatorClient;

public class Animator
extends Thread {
    public static final int FORWARDS = 0;
    public static final int BACKWARDS = 1;
    protected boolean stopRunning = false;
    protected boolean paused = false;
    int direction = 0;
    AnimatorClient animatorClient;
    public int iSleepTime;
    public int iSleepTimeBig;

    public Animator(AnimatorClient animatorClient, int n, int n2, int n3) {
        this.animatorClient = animatorClient;
        this.setDirection(n);
        this.iSleepTime = n2;
        this.iSleepTimeBig = n3;
    }

    public void increaseRate() {
        this.iSleepTime /= 2;
        if (this.iSleepTime < 1) {
            this.iSleepTime = 1;
        }
    }

    public void decreaseRate() {
        this.iSleepTime = 2 * this.iSleepTime;
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    public void pause(boolean bl) {
        this.paused = bl;
    }

    public void stopRunning() {
        this.stopRunning = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        boolean bl = false;
        long l = 0L;
        try {
            do {
                long l2 = System.currentTimeMillis();
                if (!this.paused) {
                    bl = this.animatorClient.paintNextFrame(this.direction, l);
                }
                if (this.stopRunning) return;
                long l3 = this.iSleepTime;
                if (bl) {
                    l3 = this.iSleepTimeBig;
                    bl = false;
                }
                if ((l3 -= System.currentTimeMillis() - l2) > 0L) {
                    Animator.sleep(l3);
                }
                l = System.currentTimeMillis() - l2 - l3;
            } while (!this.stopRunning);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

