/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.geotools.resources.WKTElement;

public abstract class WKTFormat
extends Format {
    public final Locale locale;
    public final NumberFormat number;
    public final char elementSeparator;
    public final char textDelimitor = (char)34;
    final char[] openingBrackets = new char[]{'[', '('};
    final char[] closingBrackets = new char[]{']', ')'};
    public final char openingBracket = (char)91;
    public final char closingBracket = (char)93;

    public WKTFormat(Locale locale) {
        this.locale = locale;
        this.number = NumberFormat.getNumberInstance(locale);
        int decimalSeparator = 46;
        if (this.number instanceof DecimalFormat) {
            DecimalFormat df = (DecimalFormat)this.number;
            decimalSeparator = df.getDecimalFormatSymbols().getDecimalSeparator();
        }
        this.elementSeparator = (char)(decimalSeparator == 44 ? 59 : 44);
        this.number.setGroupingUsed(false);
    }

    protected final WKTElement getTree(String text, ParsePosition position) throws ParseException {
        return new WKTElement(new WKTElement(this, text, position));
    }

    protected abstract Object parse(WKTElement var1) throws ParseException;

    public final Object parseObject(String text) throws ParseException {
        WKTElement element = this.getTree(text, new ParsePosition(0));
        Object object = this.parse(element);
        element.close();
        return object;
    }

    public final Object parseObject(String text, ParsePosition position) {
        int origin = position.getIndex();
        try {
            return this.parse(this.getTree(text, position));
        }
        catch (ParseException exception) {
            position.setIndex(origin);
            if (position.getErrorIndex() < origin) {
                position.setErrorIndex(exception.getErrorOffset());
            }
            return null;
        }
    }
}

