/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;

public class TestData {
    public static final BufferedReader getReader(Class caller, String name) throws IOException {
        URL url = caller.getResource("test-data/" + name);
        if (url == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    public static final BufferedReader getReader(Object host, String name) throws IOException {
        URL url = host.getClass().getResource("test-data/" + name);
        if (url == null) {
            return null;
        }
        return new BufferedReader(new InputStreamReader(url.openStream()));
    }

    public static final URL getResource(Class caller, String name) throws IOException {
        if (name == null) {
            return caller.getResource("test-data");
        }
        return caller.getResource("test-data/" + name);
    }

    public static final URL getResource(Object caller, String name) throws IOException {
        if (name == null) {
            return caller.getClass().getResource("test-data");
        }
        return caller.getClass().getResource("test-data/" + name);
    }

    public static final File file(Object caller, String path) throws IOException {
        URL url = TestData.getResource(caller, path);
        File file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
        if (!file.exists()) {
            throw new FileNotFoundException("Could not locate test-data: " + path);
        }
        return file;
    }

    public static final File temp(Object caller, String name) throws IOException {
        File testData = TestData.file(caller, null);
        int split = name.lastIndexOf(".");
        String prefix = split == -1 ? name : name.substring(0, split);
        String suffix = split == -1 ? null : name.substring(split + 1);
        File tmp = File.createTempFile(prefix, suffix, testData);
        tmp.deleteOnExit();
        return tmp;
    }
}

