/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListImpl;
import javax.media.jai.util.CaselessStringKey;
import org.geotools.resources.Utilities;
import org.geotools.resources.rsc.Resources;
import org.geotools.units.Unit;

public final class DescriptorNaming {
    public static final DescriptorNaming PROJECTIONS;
    private static final String[] METRES;
    private static final String[] DEGREES;
    private static final String[] DIMENSIONLESS;
    private Map descriptors;
    private final String initializer;
    private final String logger;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DescriptorNaming(String initializer, String logger) {
        this.initializer = initializer;
        this.logger = logger;
    }

    private void bindDefaults(String method) {
        try {
            Class<?> c = Class.forName(this.initializer);
            Method m = c.getMethod("getDefaults", null);
            m.invoke(null, null);
        }
        catch (ClassNotFoundException exception) {
            Utilities.unexpectedException(this.logger, "DescriptorNaming", method, exception);
        }
        catch (NoSuchMethodException exception) {
        }
        catch (IllegalAccessException exception) {
        }
        catch (InvocationTargetException exception) {
            Utilities.unexpectedException(this.logger, "DescriptorNaming", method, exception);
        }
    }

    public synchronized void bind(String classification, ParameterListDescriptor descriptor) throws IllegalArgumentException {
        CaselessStringKey key;
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
            this.bindDefaults("bind");
        }
        if (this.descriptors.containsKey(key = new CaselessStringKey(classification))) {
            throw new IllegalArgumentException(Resources.format(16, classification));
        }
        this.descriptors.put(key, descriptor);
    }

    public synchronized ParameterListDescriptor lookup(String classification) {
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
            this.bindDefaults("lookup");
        }
        return (ParameterListDescriptor)this.descriptors.get(new CaselessStringKey(classification));
    }

    public ParameterList getParameterList(String classification, ParameterListDescriptor fallback) {
        ParameterListDescriptor descriptor = this.lookup(classification);
        if (descriptor == null) {
            descriptor = fallback;
        }
        return new ParameterListImpl(descriptor);
    }

    public synchronized String[] list() {
        if (this.descriptors == null) {
            this.descriptors = new HashMap();
            this.bindDefaults("list");
        }
        int count = 0;
        String[] names = new String[this.descriptors.size()];
        Iterator it = this.descriptors.keySet().iterator();
        while (it.hasNext()) {
            names[count++] = it.next().toString();
        }
        if (!$assertionsDisabled && count != names.length) {
            throw new AssertionError();
        }
        return names;
    }

    public static boolean equals(ParameterListDescriptor d1, ParameterListDescriptor d2) {
        if (d1 == d2) {
            return true;
        }
        if (d1 == null || d2 == null || !Utilities.equals(d1.getClass(), d2.getClass())) {
            return false;
        }
        Object[] names = d1.getParamNames();
        if (!Arrays.equals(names, d2.getParamNames()) && Arrays.equals(d1.getParamClasses(), d2.getParamClasses()) && Arrays.equals(d1.getParamDefaults(), d2.getParamDefaults())) {
            return false;
        }
        for (int i = 0; i < names.length; ++i) {
            Object name = names[i];
            if (Utilities.equals(d1.getParamValueRange((String)name), d2.getParamValueRange((String)name))) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(ParameterList p1, ParameterList p2) {
        if (p1 == p2) {
            return true;
        }
        if (p1 == null || p2 == null || !Utilities.equals(p1.getClass(), p2.getClass())) {
            return false;
        }
        ParameterListDescriptor desc = p1.getParameterListDescriptor();
        if (!DescriptorNaming.equals(desc, p2.getParameterListDescriptor())) {
            return false;
        }
        String[] names = desc.getParamNames();
        for (int i = 0; i < names.length; ++i) {
            Object o2;
            Object o1;
            try {
                o1 = p1.getObjectParameter(names[i]);
            }
            catch (IllegalStateException e) {
                o1 = ParameterListDescriptor.NO_PARAMETER_DEFAULT;
            }
            try {
                o2 = p2.getObjectParameter(names[i]);
            }
            catch (IllegalStateException e) {
                o2 = ParameterListDescriptor.NO_PARAMETER_DEFAULT;
            }
            if (Utilities.equals(o1, o2)) continue;
            return false;
        }
        return true;
    }

    private static boolean contains(String[] array, String name) {
        for (int i = 0; i < array.length; ++i) {
            if (!name.equalsIgnoreCase(array[i])) continue;
            return true;
        }
        return false;
    }

    public static Unit getParameterUnit(String name) {
        if (DescriptorNaming.contains(METRES, name)) {
            return Unit.METRE;
        }
        if (DescriptorNaming.contains(DEGREES, name)) {
            return Unit.DEGREE;
        }
        if (DescriptorNaming.contains(DIMENSIONLESS, name)) {
            return Unit.DIMENSIONLESS;
        }
        return null;
    }

    static {
        $assertionsDisabled = !DescriptorNaming.class.desiredAssertionStatus();
        PROJECTIONS = new DescriptorNaming("org.geotools.ct.proj.Provider", "org.geotools.ct");
        METRES = new String[]{"semi_major", "semi_minor", "false_easting", "false_northing"};
        DEGREES = new String[]{"central_meridian", "latitude_of_origin"};
        DIMENSIONLESS = new String[]{"scale_factor"};
    }
}

