/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.Info;
import org.geotools.resources.Utilities;
import org.geotools.resources.cts.Resources;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.util.UnsupportedImplementationException;
import org.opengis.metadata.extent.BoundingPolygon;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.metadata.extent.GeographicExtent;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public final class CRSUtilities {
    private CRSUtilities() {
    }

    public static boolean equalsIgnoreMetadata(Object object1, Object object2) {
        if (object1 instanceof Info && object2 instanceof Info) {
            return ((Info)object1).equals((Info)object2, false);
        }
        return Utilities.equals(object1, object2);
    }

    public static int dimensionColinearWith(CoordinateSystem cs, CoordinateSystemAxis axis) {
        int candidate = -1;
        int dimension = cs.getDimension();
        AxisDirection direction = axis.getDirection().absolute();
        for (int i = 0; i < dimension; ++i) {
            CoordinateSystemAxis xi = cs.getAxis(i);
            if (!direction.equals(xi.getDirection().absolute())) continue;
            candidate = i;
            if (axis.equals(xi)) break;
        }
        return candidate;
    }

    public static int getDimensionOf(CoordinateReferenceSystem crs, Class type) throws IllegalArgumentException {
        if (!CoordinateReferenceSystem.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(type.getName());
        }
        if (type.isAssignableFrom(crs.getClass())) {
            return 0;
        }
        if (crs instanceof CompoundCRS) {
            CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            int offset = 0;
            for (int i = 0; i < c.length; ++i) {
                CoordinateReferenceSystem ci = c[i];
                int index = CRSUtilities.getDimensionOf(ci, type);
                if (index >= 0) {
                    return index + offset;
                }
                offset += ci.getCoordinateSystem().getDimension();
            }
        }
        return -1;
    }

    public static CoordinateReferenceSystem getSubCRS(CoordinateReferenceSystem crs, int lower, int upper) {
        int dimension = crs.getCoordinateSystem().getDimension();
        if (lower < 0 || lower > upper || upper > dimension) {
            throw new IndexOutOfBoundsException(Resources.format(85, new Integer(lower < 0 ? lower : upper)));
        }
        while (lower != 0 || upper != dimension) {
            if (!(crs instanceof CompoundCRS)) {
                return null;
            }
            CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            if (c.length == 0) {
                return null;
            }
            for (int i = 0; i < c.length && lower >= (dimension = (crs = c[i]).getCoordinateSystem().getDimension()); ++i) {
                lower -= dimension;
                upper -= dimension;
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem getCRS2D(CoordinateReferenceSystem crs) throws TransformException {
        if (crs != null) {
            while (crs.getCoordinateSystem().getDimension() != 2) {
                if (!(crs instanceof CompoundCRS)) {
                    throw new TransformException(Resources.format(71, crs.getName(Locale.getDefault())));
                }
                CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
                if (c.length == 0) {
                    return null;
                }
                crs = c[0];
            }
        }
        return crs;
    }

    public static CoordinateReferenceSystem getHorizontalCRS(CoordinateReferenceSystem crs) {
        if ((crs instanceof GeographicCRS || crs instanceof ProjectedCRS) && crs.getCoordinateSystem().getDimension() == 2) {
            return crs;
        }
        if (crs instanceof CompoundCRS) {
            CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            for (int i = 0; i < c.length; ++i) {
                CoordinateReferenceSystem candidate = CRSUtilities.getHorizontalCRS(c[i]);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static ProjectedCRS getProjectedCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof ProjectedCRS) {
            return (ProjectedCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            for (int i = 0; i < c.length; ++i) {
                ProjectedCRS candidate = CRSUtilities.getProjectedCRS(c[i]);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static VerticalCRS getVerticalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof VerticalCRS) {
            return (VerticalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            for (int i = 0; i < c.length; ++i) {
                VerticalCRS candidate = CRSUtilities.getVerticalCRS(c[i]);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static TemporalCRS getTemporalCRS(CoordinateReferenceSystem crs) {
        if (crs instanceof TemporalCRS) {
            return (TemporalCRS)crs;
        }
        if (crs instanceof CompoundCRS) {
            CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            for (int i = 0; i < c.length; ++i) {
                TemporalCRS candidate = CRSUtilities.getTemporalCRS(c[i]);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Datum getDatum(CoordinateReferenceSystem crs) {
        return crs instanceof SingleCRS ? ((SingleCRS)crs).getDatum() : null;
    }

    public static Ellipsoid getEllipsoid(CoordinateReferenceSystem crs) {
        Datum datum = CRSUtilities.getDatum(crs);
        if (datum instanceof GeodeticDatum) {
            return ((GeodeticDatum)datum).getEllipsoid();
        }
        if (crs instanceof CompoundCRS) {
            CoordinateReferenceSystem[] c = ((CompoundCRS)crs).getCoordinateReferenceSystems();
            for (int i = 0; i < c.length; ++i) {
                Ellipsoid candidate = CRSUtilities.getEllipsoid(c[i]);
                if (candidate == null) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Ellipsoid getHeadGeoEllipsoid(CoordinateReferenceSystem crs) {
        while (!(crs instanceof GeographicCRS)) {
            CoordinateReferenceSystem[] c;
            if (crs instanceof CompoundCRS && (c = ((CompoundCRS)crs).getCoordinateReferenceSystems()).length != 0) {
                crs = c[0];
                continue;
            }
            return null;
        }
        return ((GeodeticDatum)((GeographicCRS)crs).getDatum()).getEllipsoid();
    }

    public static Envelope getEnvelope(CoordinateReferenceSystem crs) {
        Extent validArea;
        Datum datum;
        if (crs != null && (datum = CRSUtilities.getDatum(crs)) != null && (validArea = datum.getValidArea()) != null) {
            GeographicExtent geo = validArea.getGeographicElement();
            if (geo instanceof GeographicBoundingBox) {
                GeographicBoundingBox bounds = (GeographicBoundingBox)geo;
                return new GeneralEnvelope(new double[]{bounds.getEastBoundLongitude(), bounds.getWestBoundLongitude()}, new double[]{bounds.getSouthBoundLatitude(), bounds.getNorthBoundLatitude()});
            }
            if (geo instanceof BoundingPolygon) {
                return ((BoundingPolygon)geo).getPolygon().getEnvelope();
            }
        }
        return null;
    }

    public static Envelope transform(MathTransform transform, GeneralEnvelope envelope) throws TransformException {
        int sourceDim = transform.getDimSource();
        int targetDim = transform.getDimTarget();
        if (envelope.getDimension() != sourceDim) {
            throw new MismatchedDimensionException(Resources.format(91, new Integer(sourceDim), new Integer(envelope.getDimension())));
        }
        int coordinateNumber = 0;
        GeneralEnvelope transformed = null;
        GeneralDirectPosition sourcePt = new GeneralDirectPosition(sourceDim);
        GeneralDirectPosition targetPt = new GeneralDirectPosition(targetDim);
        int i = sourceDim;
        while (--i >= 0) {
            sourcePt.setOrdinate(i, envelope.getMinimum(i));
        }
        block6: while (true) {
            if (targetPt != transform.transform((DirectPosition)sourcePt, (DirectPosition)targetPt)) {
                throw new UnsupportedImplementationException(transform.getClass());
            }
            if (transformed != null) {
                transformed.add(targetPt);
            } else {
                transformed = new GeneralEnvelope(targetPt, targetPt);
            }
            int n = ++coordinateNumber;
            int i2 = sourceDim;
            while (--i2 >= 0) {
                switch (n % 3) {
                    case 0: {
                        sourcePt.setOrdinate(i2, envelope.getMinimum(i2));
                        n /= 3;
                        break;
                    }
                    case 1: {
                        sourcePt.setOrdinate(i2, envelope.getCenter(i2));
                        continue block6;
                    }
                    case 2: {
                        sourcePt.setOrdinate(i2, envelope.getMaximum(i2));
                        continue block6;
                    }
                }
            }
            break;
        }
        return transformed;
    }

    public static Rectangle2D transform(MathTransform2D transform, Rectangle2D source, Rectangle2D dest) throws TransformException {
        if (source == null) {
            return null;
        }
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        for (int i = 0; i < 8; ++i) {
            point.x = (i & 1) == 0 ? source.getMinX() : source.getMaxX();
            point.y = (i & 2) == 0 ? source.getMinY() : source.getMaxY();
            switch (i) {
                case 5: 
                case 6: {
                    point.x = source.getCenterX();
                    break;
                }
                case 4: 
                case 7: {
                    point.y = source.getCenterY();
                }
            }
            transform.transform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return XRectangle2D.createFromExtremums(xmin, ymin, xmax, ymax);
    }

    public static Point2D deltaTransform(MathTransform2D transform, Point2D origin, Point2D source, Point2D dest) throws TransformException {
        if (transform instanceof AffineTransform) {
            return ((AffineTransform)((Object)transform)).deltaTransform(source, dest);
        }
        double ox = origin.getX();
        double oy = origin.getY();
        double dx = source.getX() * 0.5;
        double dy = source.getY() * 0.5;
        Point2D P1 = new Point2D.Double(ox - dx, oy - dy);
        Point2D P2 = new Point2D.Double(ox + dx, oy + dy);
        P1 = transform.transform(P1, P1);
        P2 = transform.transform(P2, P2);
        if (dest == null) {
            dest = P2;
        }
        dest.setLocation(P2.getX() - P1.getX(), P2.getY() - P1.getY());
        return dest;
    }
}

