/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.geotools.resources.rsc.Resources;

public class Arguments {
    private static final String ENCODING = "console.encoding";
    private final String[] arguments;
    public final PrintWriter out;
    public final Locale locale;

    public Arguments(String[] args) {
        this.arguments = (String[])args.clone();
        this.locale = this.getLocale(this.getOptionalString("-locale"));
        String encoding = this.getOptionalString("-encoding");
        String destination = this.getOptionalString("-Xout");
        PrintWriter out = null;
        IOException error = null;
        try {
            if (destination != null) {
                OutputStreamWriter fileWriter = encoding != null ? new OutputStreamWriter((OutputStream)new FileOutputStream(destination), encoding) : new FileWriter(destination);
                out = new PrintWriter(fileWriter);
            } else {
                Preferences prefs = Preferences.userNodeForPackage(Arguments.class);
                boolean prefEnc = false;
                if (encoding == null) {
                    encoding = prefs.get(ENCODING, null);
                    prefEnc = true;
                }
                if (encoding != null) {
                    out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, encoding), true);
                    if (!prefEnc) {
                        prefs.put(ENCODING, encoding);
                    }
                }
            }
        }
        catch (IOException exception) {
            error = exception;
        }
        if (out == null) {
            out = new PrintWriter(System.out, true);
        }
        this.out = out;
        if (error != null) {
            this.illegalArgument(error);
        }
    }

    private Locale getLocale(String locale) throws IllegalArgumentException {
        if (locale != null) {
            String[] s = Pattern.compile("_").split(locale);
            switch (s.length) {
                case 1: {
                    return new Locale(s[0]);
                }
                case 2: {
                    return new Locale(s[0], s[1]);
                }
                case 3: {
                    return new Locale(s[0], s[1], s[2]);
                }
            }
            this.illegalArgument(new IllegalArgumentException(Resources.format(0, locale)));
        }
        return Locale.getDefault();
    }

    public String getOptionalString(String name) {
        for (int i = 0; i < this.arguments.length; ++i) {
            String arg = this.arguments[i];
            if (arg == null) continue;
            arg = arg.trim();
            String value = "";
            int split = arg.indexOf(61);
            if (split >= 0) {
                value = arg.substring(split + 1).trim();
                arg = arg.substring(0, split).trim();
            }
            if (!arg.equalsIgnoreCase(name)) continue;
            this.arguments[i] = null;
            if (value.length() != 0) {
                return value;
            }
            while (++i < this.arguments.length) {
                value = this.arguments[i];
                this.arguments[i] = null;
                if (value == null) break;
                value = value.trim();
                if (split >= 0) {
                    return value;
                }
                if (!value.equals("=")) {
                    return value.startsWith("=") ? value.substring(1).trim() : value;
                }
                split = 0;
            }
            this.illegalArgument(new IllegalArgumentException(Resources.getResources(this.locale).getString(7, arg)));
            return null;
        }
        return null;
    }

    public String getRequiredString(String name) {
        String value = this.getOptionalString(name);
        if (value == null) {
            this.illegalArgument(new IllegalArgumentException(Resources.getResources(this.locale).getString(6, name)));
        }
        return value;
    }

    public Integer getOptionalInteger(String name) {
        String value = this.getOptionalString(name);
        if (value != null) {
            try {
                return new Integer(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return null;
    }

    public int getRequiredInteger(String name) {
        String value = this.getRequiredString(name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return 0;
    }

    public Double getOptionalDouble(String name) {
        String value = this.getOptionalString(name);
        if (value != null) {
            try {
                return new Double(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return null;
    }

    public double getRequiredDouble(String name) {
        String value = this.getRequiredString(name);
        if (value != null) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException exception) {
                this.illegalArgument(exception);
            }
        }
        return Double.NaN;
    }

    public Boolean getOptionalBoolean(String name) {
        String value = this.getOptionalString(name);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (value.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            this.illegalArgument(new IllegalArgumentException(value));
        }
        return null;
    }

    public boolean getRequiredBoolean(String name) {
        String value = this.getRequiredString(name);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                return true;
            }
            if (value.equalsIgnoreCase("false")) {
                return false;
            }
            this.illegalArgument(new IllegalArgumentException(value));
        }
        return false;
    }

    public boolean getFlag(String name) {
        for (int i = 0; i < this.arguments.length; ++i) {
            String arg = this.arguments[i];
            if (arg == null || !(arg = arg.trim()).equalsIgnoreCase(name)) continue;
            this.arguments[i] = null;
            return true;
        }
        return false;
    }

    public static Writer getWriter(OutputStream out) {
        try {
            String encoding = Preferences.userNodeForPackage(Arguments.class).get(ENCODING, null);
            if (encoding != null) {
                return new OutputStreamWriter(out, encoding);
            }
        }
        catch (UnsupportedEncodingException exception) {
            Utilities.unexpectedException("org.geotools.resources", "Arguments", "getWriter", exception);
        }
        return new OutputStreamWriter(out);
    }

    public String[] getRemainingArguments(int max) {
        int count = 0;
        Object[] left = new String[Math.min(max, this.arguments.length)];
        for (int i = 0; i < this.arguments.length; ++i) {
            String arg = this.arguments[i];
            if (arg == null) continue;
            if (count >= max) {
                Resources.getResources(this.locale);
                this.illegalArgument(new IllegalArgumentException(Resources.format(18, this.arguments[i])));
            }
            left[count++] = arg;
        }
        return (String[])XArray.resize(left, count);
    }

    protected void illegalArgument(Exception exception) {
        this.out.print(Utilities.getShortClassName(exception));
        this.out.print(": ");
        this.out.println(exception.getLocalizedMessage());
        this.out.flush();
        this.out.close();
        System.exit(1);
        if (exception instanceof RuntimeException) {
            throw (RuntimeException)exception;
        }
        if (exception instanceof UnsupportedEncodingException) {
            UnsupportedCharsetException e = new UnsupportedCharsetException(exception.getMessage());
            e.initCause(exception);
            throw e;
        }
        throw new UndeclaredThrowableException(exception);
    }
}

