/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LogicFilter;

public class LogicFilterImpl
extends AbstractFilterImpl
implements LogicFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private List subFilters = new ArrayList();

    protected LogicFilterImpl(short filterType) throws IllegalFilterException {
        LOGGER.finest("filtertype " + filterType);
        if (!LogicFilterImpl.isLogicFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create logic filter with non-logic type.");
        }
        this.filterType = filterType;
    }

    protected LogicFilterImpl(Filter filter, short filterType) throws IllegalFilterException {
        if (!LogicFilterImpl.isLogicFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create logic filter with non-logic type.");
        }
        this.filterType = filterType;
        this.subFilters.add(filter);
    }

    protected LogicFilterImpl(Filter filter1, Filter filter2, short filterType) throws IllegalFilterException {
        if (!LogicFilterImpl.isLogicFilter(filterType)) {
            throw new IllegalFilterException("Attempted to create logic filter with non-logic type.");
        }
        this.filterType = filterType;
        this.subFilters.add(filter1);
        this.addFilter(filter2);
    }

    public final void addFilter(Filter filter) throws IllegalFilterException {
        if (this.filterType == 3 && this.subFilters.size() != 0) {
            throw new IllegalFilterException("Attempted to add an more than one filter to a NOT filter.");
        }
        this.subFilters.add(filter);
    }

    public Iterator getFilterIterator() {
        return this.subFilters.iterator();
    }

    public boolean contains(Feature feature) {
        Iterator iterator = this.subFilters.iterator();
        boolean contains = false;
        if (!iterator.hasNext()) {
            return false;
        }
        if (this.filterType == 1) {
            contains = false;
            while (iterator.hasNext()) {
                contains = ((Filter)iterator.next()).contains(feature) || contains;
            }
        } else if (this.filterType == 2) {
            contains = true;
            while (iterator.hasNext()) {
                contains = ((Filter)iterator.next()).contains(feature) && contains;
            }
        } else if (this.filterType == 3) {
            contains = !((Filter)this.subFilters.get(0)).contains(feature);
        }
        return contains;
    }

    public Filter or(Filter filter) {
        if (this.filterType == 1) {
            this.subFilters.add(filter);
            return this;
        }
        return super.or(filter);
    }

    public Filter and(Filter filter) {
        if (this.filterType == 2) {
            this.subFilters.add(filter);
            return this;
        }
        return super.and(filter);
    }

    public Filter not() {
        if (this.filterType == 3) {
            return (Filter)this.subFilters.get(0);
        }
        return super.not();
    }

    List getSubFilters() {
        return this.subFilters;
    }

    public String toString() {
        String returnString = "";
        String operator = "";
        Iterator iterator = this.subFilters.iterator();
        if (this.filterType == 1) {
            operator = " OR ";
        } else if (this.filterType == 2) {
            operator = " AND ";
        } else if (this.filterType == 3) {
            return "NOT " + ((Filter)iterator.next()).toString();
        }
        while (iterator.hasNext()) {
            returnString = returnString + ((Filter)iterator.next()).toString();
            if (!iterator.hasNext()) continue;
            returnString = returnString + operator;
        }
        return returnString;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            LogicFilterImpl logFilter = (LogicFilterImpl)obj;
            LOGGER.finest("filter type match:" + (logFilter.getFilterType() == this.filterType));
            LOGGER.finest("same size:" + (logFilter.getSubFilters().size() == this.subFilters.size()) + "; inner size: " + logFilter.getSubFilters().size() + "; outer size: " + this.subFilters.size());
            LOGGER.finest("contains:" + logFilter.getSubFilters().containsAll(this.subFilters));
            return logFilter.getFilterType() == this.filterType && logFilter.getSubFilters().size() == this.subFilters.size() && logFilter.getSubFilters().containsAll(this.subFilters);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.filterType;
        result = 37 * result + ((Object)this.subFilters).hashCode();
        return result;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }
}

