/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.PrecisionModel;
import org.geotools.cs.LocalCoordinateSystem;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class CSGeometryFactory
extends GeometryFactory {
    public static GeometryFactory DEFAULT = new GeometryFactory();
    public static PrecisionModel DEFAULT_PRECISON_MODEL = new PrecisionModel();
    private CoordinateReferenceSystem coordinateSystem;

    public CSGeometryFactory(CoordinateReferenceSystem cs) {
        super(CSGeometryFactory.toPrecisionModel(cs), CSGeometryFactory.toSRID(cs));
        this.coordinateSystem = cs != null ? cs : LocalCoordinateSystem.PROMISCUOUS;
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometries) {
        GeometryCollection gc = super.createGeometryCollection(geometries);
        return gc;
    }

    public LinearRing createLinearRing(Coordinate[] coordinates) {
        LinearRing lr = super.createLinearRing(coordinates);
        return lr;
    }

    private static int toSRID(CoordinateReferenceSystem cs) {
        if (cs == null || cs == LocalCoordinateSystem.PROMISCUOUS) {
            return 0;
        }
        return 0;
    }

    private static PrecisionModel toPrecisionModel(CoordinateReferenceSystem cs) {
        if (cs == null || cs == LocalCoordinateSystem.PROMISCUOUS) {
            return DEFAULT_PRECISON_MODEL;
        }
        return DEFAULT_PRECISON_MODEL;
    }
}

