/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.geotools.data.AbstractAttributeIO;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.AttributeReader;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultFIDReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FIDFeatureReader;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.shapefile.dbf.DbaseFileException;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.dbf.DbaseFileWriter;
import org.geotools.data.shapefile.shp.JTSUtilities;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.data.shapefile.shp.ShapefileHeader;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.geotools.data.shapefile.shp.ShapefileWriter;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;

public class ShapefileDataStore
extends AbstractDataStore {
    private final URL shpURL;
    private final URL dbfURL;
    private final URL shxURL;
    private final boolean useMemoryMappedBuffer;
    private FeatureType schema;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$com$vividsolutions$jts$geom$Geometry;

    public ShapefileDataStore(URL url) throws MalformedURLException {
        this(url, true);
    }

    public ShapefileDataStore(URL url, boolean useMemoryMappedBuffer) throws MalformedURLException {
        String filename = null;
        if (url == null) {
            throw new NullPointerException("Null URL for ShapefileDataSource");
        }
        try {
            filename = URLDecoder.decode(url.toString(), "US-ASCII");
        }
        catch (UnsupportedEncodingException use) {
            throw new MalformedURLException("Unable to decode " + url + " cause " + use.getMessage());
        }
        String shpext = ".shp";
        String dbfext = ".dbf";
        String shxext = ".shx";
        if (filename.endsWith(shpext) || filename.endsWith(dbfext) || filename.endsWith(shxext)) {
            filename = filename.substring(0, filename.length() - 4);
        } else if (filename.endsWith(".SHP") || filename.endsWith(".DBF") || filename.endsWith(".SHX")) {
            filename = filename.substring(0, filename.length() - 4);
            shpext = ".SHP";
            dbfext = ".DBF";
            shxext = ".SHX";
        }
        this.shpURL = new URL(filename + shpext);
        this.dbfURL = new URL(filename + dbfext);
        this.shxURL = new URL(filename + shxext);
        this.useMemoryMappedBuffer = useMemoryMappedBuffer;
    }

    public boolean isLocal() {
        return this.shpURL.getProtocol().equals("file");
    }

    private void clear() {
        if (this.isLocal()) {
            this.delete(this.shpURL);
            this.delete(this.dbfURL);
            this.delete(this.shxURL);
        }
    }

    private void delete(URL u) {
        File f = new File(u.getFile());
        f.delete();
    }

    private ReadableByteChannel getReadChannel(URL url) throws IOException {
        ReadableByteChannel channel = null;
        if (url.getProtocol().equals("file") && this.useMemoryMappedBuffer) {
            File file = new File(url.getFile());
            if (!file.exists() || !file.canRead()) {
                throw new IOException("File either doesn't exist or is unreadable : " + file);
            }
            FileInputStream in = new FileInputStream(file);
            channel = in.getChannel();
        } else {
            InputStream in = url.openConnection().getInputStream();
            channel = Channels.newChannel(in);
        }
        return channel;
    }

    private WritableByteChannel getWriteChannel(URL url) throws IOException {
        WritableByteChannel channel;
        if (url.getProtocol().equals("file") && this.useMemoryMappedBuffer) {
            File f = new File(url.getFile());
            if (!f.exists() && !f.createNewFile()) {
                throw new IOException("Cannot create file " + f);
            }
            RandomAccessFile raf = new RandomAccessFile(f, "rw");
            channel = raf.getChannel();
        } else {
            OutputStream out = url.openConnection().getOutputStream();
            channel = Channels.newChannel(out);
        }
        return channel;
    }

    protected FeatureReader getFeatureReader(String typeName) throws IOException {
        this.typeCheck(typeName);
        try {
            return this.createFeatureReader(typeName, this.getAttributesReader());
        }
        catch (SchemaException se) {
            throw new DataSourceException("Error creating schema", se);
        }
    }

    protected FeatureReader createFeatureReader(String typeName, Reader r) throws SchemaException, IOException {
        return new FIDFeatureReader(r, new DefaultFIDReader(typeName), this.schema);
    }

    protected Reader getAttributesReader() throws IOException {
        AttributeType[] atts = this.schema == null ? this.readAttributes() : this.schema.getAttributeTypes();
        return new Reader(atts, this.openShapeReader(), this.openDbfReader());
    }

    protected ShapefileReader openShapeReader() throws IOException {
        ReadableByteChannel rbc = this.getReadChannel(this.shpURL);
        if (rbc == null) {
            return null;
        }
        try {
            return new ShapefileReader(rbc, true);
        }
        catch (ShapefileException se) {
            throw new DataSourceException("Error creating ShapefileReader", se);
        }
    }

    protected DbaseFileReader openDbfReader() throws IOException {
        ReadableByteChannel rbc = this.getReadChannel(this.dbfURL);
        if (rbc == null) {
            return null;
        }
        return new DbaseFileReader(rbc);
    }

    public String[] getTypeNames() {
        return new String[]{this.getCurrentTypeName()};
    }

    protected String createFeatureTypeName() {
        int slash;
        String path = this.shpURL.getPath();
        int dot = path.indexOf(46, slash = Math.max(0, path.lastIndexOf(47) + 1));
        if (dot < 0) {
            dot = path.length();
        }
        return path.substring(slash, dot);
    }

    protected String getCurrentTypeName() {
        return this.schema == null ? this.createFeatureTypeName() : this.schema.getTypeName();
    }

    protected void typeCheck(String requested) throws IOException {
        if (!this.getCurrentTypeName().equals(requested)) {
            throw new IOException("No such type : " + requested);
        }
    }

    protected FeatureWriter getFeatureWriter(String typeName) throws IOException {
        this.typeCheck(typeName);
        return new Writer(typeName);
    }

    public FeatureType getSchema(String typeName) throws IOException {
        this.typeCheck(typeName);
        if (this.schema == null) {
            try {
                this.schema = FeatureTypeFactory.newFeatureType(this.readAttributes(), this.createFeatureTypeName());
            }
            catch (SchemaException se) {
                throw new DataSourceException("Error creating FeatureType", se);
            }
        }
        return this.schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AttributeType[] readAttributes() throws IOException {
        ShapefileReader shp = this.openShapeReader();
        DbaseFileReader dbf = this.openDbfReader();
        try {
            AttributeType[] atts;
            AttributeType geometryAttribute = AttributeTypeFactory.newAttributeType("the_geom", JTSUtilities.findBestGeometryClass(shp.getHeader().getShapeType()));
            if (dbf != null) {
                DbaseFileHeader header = dbf.getHeader();
                atts = new AttributeType[header.getNumFields() + 1];
                atts[0] = geometryAttribute;
                int ii = header.getNumFields();
                for (int i = 0; i < ii; ++i) {
                    Class clazz = header.getFieldClass(i);
                    atts[i + 1] = AttributeTypeFactory.newAttributeType(header.getFieldName(i), clazz, true, header.getFieldLength(i));
                }
            } else {
                atts = new AttributeType[]{geometryAttribute};
            }
            AttributeType[] attributeTypeArray = atts;
            return attributeTypeArray;
        }
        finally {
            try {
                shp.close();
            }
            catch (IOException ioe) {}
            try {
                dbf.close();
            }
            catch (IOException ioe) {}
        }
    }

    public void createSchema(FeatureType featureType) throws IOException {
        if (!this.isLocal()) {
            throw new IOException("Cannot create FeatureType on remote shapefile");
        }
        this.clear();
        this.schema = featureType;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Envelope getBounds() throws DataSourceException {
        Envelope envelope;
        ReadableByteChannel in = null;
        try {
            try {
                ByteBuffer buffer = ByteBuffer.allocate(100);
                in = this.getReadChannel(this.shpURL);
                in.read(buffer);
                buffer.flip();
                ShapefileHeader header = new ShapefileHeader();
                header.read(buffer, true);
                envelope = new Envelope(header.minX(), header.maxX(), header.minY(), header.maxY());
                Object var6_6 = null;
            }
            catch (IOException ioe) {
                throw new DataSourceException("Problem getting Bbox", ioe);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (IOException ioe2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ioe2) {
            // empty catch block
            return envelope;
        }
        if (in == null) return envelope;
        in.close();
        return envelope;
    }

    protected Envelope getBounds(Query query) throws IOException {
        if (query == Query.ALL) {
            return this.getBounds();
        }
        return null;
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        final FeatureType featureType = this.getSchema(typeName);
        if (this.isWriteable) {
            if (this.getLockingManager() != null) {
                return new AbstractFeatureLocking(){

                    public DataStore getDataStore() {
                        return ShapefileDataStore.this;
                    }

                    public void addFeatureListener(FeatureListener listener) {
                        ShapefileDataStore.this.listenerManager.addFeatureListener(this, listener);
                    }

                    public void removeFeatureListener(FeatureListener listener) {
                        ShapefileDataStore.this.listenerManager.removeFeatureListener(this, listener);
                    }

                    public FeatureType getSchema() {
                        return featureType;
                    }

                    public Envelope getBounds(Query query) throws IOException {
                        return ShapefileDataStore.this.getBounds(query);
                    }
                };
            }
            return new AbstractFeatureStore(){

                public DataStore getDataStore() {
                    return ShapefileDataStore.this;
                }

                public void addFeatureListener(FeatureListener listener) {
                    ShapefileDataStore.this.listenerManager.addFeatureListener(this, listener);
                }

                public void removeFeatureListener(FeatureListener listener) {
                    ShapefileDataStore.this.listenerManager.removeFeatureListener(this, listener);
                }

                public FeatureType getSchema() {
                    return featureType;
                }

                public Envelope getBounds(Query query) throws IOException {
                    return ShapefileDataStore.this.getBounds(query);
                }
            };
        }
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return ShapefileDataStore.this;
            }

            public void addFeatureListener(FeatureListener listener) {
                ShapefileDataStore.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ShapefileDataStore.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return featureType;
            }

            public Envelope getBounds(Query query) throws IOException {
                return ShapefileDataStore.this.getBounds(query);
            }
        };
    }

    protected class Writer
    implements FeatureWriter {
        private long temp;
        protected FeatureReader featureReader;
        protected Reader attReader;
        private Feature currentFeature;
        private FeatureType featureType;
        private Object[] emptyAtts;
        private Object[] transferCache;
        private ShapeType shapeType;
        private ShapeHandler handler;
        private int shapefileLength = 100;
        private int defaultGeometryIdx;
        private int records = 0;
        private byte[] writeFlags;
        private ShapefileWriter shpWriter;
        private DbaseFileWriter dbfWriter;
        private DbaseFileHeader dbfHeader;
        private FileChannel dbfChannel;
        private Envelope bounds = new Envelope();

        public Writer(String typeName) throws IOException {
            try {
                this.attReader = ShapefileDataStore.this.getAttributesReader();
                this.featureReader = ShapefileDataStore.this.createFeatureReader(typeName, this.attReader);
                this.temp = System.currentTimeMillis();
            }
            catch (Exception e) {
                FeatureType schema = ShapefileDataStore.this.getSchema(typeName);
                if (schema == null) {
                    throw new IOException("To create a shapefile, you must first call createSchema()");
                }
                this.featureReader = new EmptyFeatureReader(schema);
                this.temp = 0L;
            }
            this.featureType = this.featureReader.getFeatureType();
            this.emptyAtts = new Object[this.featureType.getAttributeCount()];
            this.writeFlags = new byte[this.featureType.getAttributeCount()];
            int cnt = 0;
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                if (this.featureType.getAttributeType(i).isGeometry()) continue;
                ++cnt;
                this.writeFlags[i] = 1;
            }
            this.transferCache = new Object[cnt];
            this.shpWriter = new ShapefileWriter((FileChannel)ShapefileDataStore.this.getWriteChannel(this.getStorageURL(ShapefileDataStore.this.shpURL)), (FileChannel)ShapefileDataStore.this.getWriteChannel(this.getStorageURL(ShapefileDataStore.this.shxURL)));
            this.dbfChannel = (FileChannel)ShapefileDataStore.this.getWriteChannel(this.getStorageURL(ShapefileDataStore.this.dbfURL));
            this.dbfHeader = this.createDbaseHeader();
            this.dbfWriter = new DbaseFileWriter(this.dbfHeader, this.dbfChannel);
        }

        protected URL getStorageURL(URL url) throws MalformedURLException {
            return this.temp == 0L ? url : this.getStorageFile(url).toURL();
        }

        protected File getStorageFile(URL url) {
            String f = url.getFile();
            f = this.temp + f.substring(f.lastIndexOf("/") + 1);
            File tf = new File(System.getProperty("java.io.tmpdir"), f);
            return tf;
        }

        protected void flush() throws IOException {
            this.shpWriter.writeHeaders(this.bounds, this.shapeType, this.records, this.shapefileLength);
            this.dbfHeader.setNumRecords(this.records);
            this.dbfChannel.position(0L);
            this.dbfHeader.writeHeader(this.dbfChannel);
        }

        protected DbaseFileHeader createDbaseHeader() throws IOException, DbaseFileException {
            DbaseFileHeader header = new DbaseFileHeader();
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                AttributeType type = this.featureType.getAttributeType(i);
                Class colType = type.getType();
                String colName = type.getName();
                int fieldLen = type.getFieldLength();
                if (fieldLen <= 0) {
                    fieldLen = 255;
                }
                if (colType == (class$java$lang$Integer == null ? ShapefileDataStore.class$("java.lang.Integer") : class$java$lang$Integer) || colType == (class$java$lang$Short == null ? ShapefileDataStore.class$("java.lang.Short") : class$java$lang$Short) || colType == (class$java$lang$Byte == null ? ShapefileDataStore.class$("java.lang.Byte") : class$java$lang$Byte)) {
                    header.addColumn(colName, 'N', Math.min(fieldLen, 10), 0);
                    continue;
                }
                if (colType == (class$java$lang$Long == null ? ShapefileDataStore.class$("java.lang.Long") : class$java$lang$Long)) {
                    header.addColumn(colName, 'N', Math.min(fieldLen, 19), 0);
                    continue;
                }
                if (colType == (class$java$lang$Double == null ? ShapefileDataStore.class$("java.lang.Double") : class$java$lang$Double) || colType == (class$java$lang$Float == null ? ShapefileDataStore.class$("java.lang.Float") : class$java$lang$Float) || colType == (class$java$lang$Number == null ? ShapefileDataStore.class$("java.lang.Number") : class$java$lang$Number)) {
                    int l = Math.min(fieldLen, 33);
                    header.addColumn(colName, 'N', l, l / 2);
                    continue;
                }
                if ((class$java$util$Date == null ? ShapefileDataStore.class$("java.util.Date") : class$java$util$Date).isAssignableFrom(colType)) {
                    header.addColumn(colName, 'D', fieldLen, 0);
                    continue;
                }
                if (colType == (class$java$lang$Boolean == null ? ShapefileDataStore.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    header.addColumn(colName, 'L', 1, 0);
                    continue;
                }
                if ((class$java$lang$CharSequence == null ? ShapefileDataStore.class$("java.lang.CharSequence") : class$java$lang$CharSequence).isAssignableFrom(colType)) {
                    header.addColumn(colName, 'C', Math.min(254, fieldLen), 0);
                    continue;
                }
                if ((class$com$vividsolutions$jts$geom$Geometry == null ? ShapefileDataStore.class$("com.vividsolutions.jts.geom.Geometry") : class$com$vividsolutions$jts$geom$Geometry).isAssignableFrom(colType)) continue;
                throw new IOException("Unable to write : " + colType.getName());
            }
            return header;
        }

        protected void finalize() throws Throwable {
            if (this.featureReader != null) {
                try {
                    this.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        protected void clean() throws IOException {
            if (this.temp == 0L) {
                return;
            }
            this.copyAndDelete(ShapefileDataStore.this.shpURL);
            this.copyAndDelete(ShapefileDataStore.this.shxURL);
            this.copyAndDelete(ShapefileDataStore.this.dbfURL);
        }

        protected void copyAndDelete(URL src) throws IOException {
            long copied;
            File storage = this.getStorageFile(src);
            File dest = new File(src.getFile());
            FileChannel in = new FileInputStream(storage).getChannel();
            FileChannel out = new FileOutputStream(dest).getChannel();
            long len = in.size();
            if (len != (copied = out.transferFrom(in, 0L, in.size()))) {
                throw new IOException("unable to complete write");
            }
            storage.delete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object v1;
            block10: {
                if (this.featureReader == null) {
                    throw new IOException("Writer closed");
                }
                if (this.currentFeature != null) {
                    this.write();
                }
                if (this.attReader != null) {
                    this.shapeType = this.attReader.shp.getHeader().getShapeType();
                    this.handler = this.shapeType.getShapeHandler();
                    if (this.records == 0) {
                        this.shpWriter.writeHeaders(this.bounds, this.shapeType, 0, 0);
                    }
                    double[] env = new double[4];
                    while (this.attReader.hasNext()) {
                        this.shapefileLength += this.attReader.shp.transferTo(this.shpWriter, ++this.records, env);
                        this.bounds.expandToInclude(env[0], env[1]);
                        this.bounds.expandToInclude(env[2], env[3]);
                        this.attReader.dbf.transferTo(this.dbfWriter);
                    }
                }
                try {
                    this.featureReader.close();
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object v0;
                    Object var3_3 = null;
                    try {
                        this.flush();
                        v0 = null;
                    }
                    catch (Throwable throwable2) {
                        v0 = null;
                    }
                    Object var5_7 = v0;
                    this.shpWriter.close();
                    this.dbfWriter.close();
                    this.dbfChannel.close();
                    throw throwable;
                }
                try {
                    this.flush();
                    v1 = null;
                    break block10;
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                {
                }
            }
            Object var5_6 = v1;
            this.shpWriter.close();
            this.dbfWriter.close();
            this.dbfChannel.close();
        }

        public FeatureType getFeatureType() {
            return this.featureType;
        }

        public boolean hasNext() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            return this.featureReader.hasNext();
        }

        public Feature next() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.currentFeature != null) {
                this.write();
            }
            if (this.featureReader.hasNext()) {
                try {
                    this.currentFeature = this.featureReader.next();
                    return this.currentFeature;
                }
                catch (IllegalAttributeException iae) {
                    throw new DataSourceException("Error in reading", iae);
                }
            }
            try {
                this.currentFeature = DataUtilities.template(this.getFeatureType(), this.emptyAtts);
                return this.currentFeature;
            }
            catch (IllegalAttributeException iae) {
                throw new DataSourceException("Error creating empty Feature", iae);
            }
        }

        public void remove() throws IOException {
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            if (this.currentFeature == null) {
                throw new IOException("Current feature is null");
            }
            this.currentFeature = null;
        }

        public void write() throws IOException {
            Envelope b;
            if (this.currentFeature == null) {
                throw new IOException("Current feature is null");
            }
            if (this.featureReader == null) {
                throw new IOException("Writer closed");
            }
            Geometry g = this.currentFeature.getDefaultGeometry();
            if (this.shapeType == null) {
                int dims = JTSUtilities.guessCoorinateDims(g.getCoordinates());
                try {
                    this.shapeType = JTSUtilities.getShapeType(g, dims);
                    this.shpWriter.writeHeaders(new Envelope(), this.shapeType, 0, 0);
                    this.handler = this.shapeType.getShapeHandler();
                }
                catch (ShapefileException se) {
                    throw new RuntimeException("Unexpected Error", se);
                }
            }
            if (!(b = (g = JTSUtilities.convertToCollection(g, this.shapeType)).getEnvelopeInternal()).isNull()) {
                this.bounds.expandToInclude(b);
            }
            this.shapefileLength += this.handler.getLength(g) + 8;
            this.shpWriter.writeGeometry(g);
            int idx = 0;
            int ii = this.featureType.getAttributeCount();
            for (int i = 0; i < ii; ++i) {
                if (this.writeFlags[i] <= 0) continue;
                this.transferCache[idx++] = this.currentFeature.getAttribute(i);
            }
            this.dbfWriter.write(this.transferCache);
            ++this.records;
            this.currentFeature = null;
        }
    }

    protected static class Reader
    extends AbstractAttributeIO
    implements AttributeReader {
        protected ShapefileReader shp;
        protected DbaseFileReader dbf;
        protected DbaseFileReader.Row row;
        protected ShapefileReader.Record record;
        int cnt;

        public Reader(AttributeType[] atts, ShapefileReader shp, DbaseFileReader dbf) {
            super(atts);
            this.shp = shp;
            this.dbf = dbf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                this.shp.close();
                this.dbf.close();
                Object var2_1 = null;
                this.row = null;
                this.record = null;
                this.shp = null;
                this.dbf = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.row = null;
                this.record = null;
                this.shp = null;
                this.dbf = null;
                throw throwable;
            }
        }

        public boolean hasNext() throws IOException {
            int n = this.shp.hasNext() ? 1 : 0;
            if ((n += this.dbf.hasNext() ? 2 : 0) == 3) {
                return true;
            }
            if (n == 0) {
                return false;
            }
            throw new IOException((n == 1 ? "Shp" : "Dbf") + " has extra record");
        }

        public void next() throws IOException {
            this.record = this.shp.nextRecord();
            this.row = this.dbf.readRow();
        }

        public Object read(int param) throws IOException, ArrayIndexOutOfBoundsException {
            switch (param) {
                case 0: {
                    return this.record.shape();
                }
            }
            return this.row.read(param - 1);
        }
    }
}

