/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.pickle;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.geotools.data.pickle.FeaturePickler;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.resources.NIOUtilities;

public abstract class PickledFeatureProtocol {
    public static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$org$geotools$data$pickle$FeaturePickler;

    public static PickledFeatureProtocol getReader(InputStream fin, InputStream sin) throws IOException {
        PickledFeatureProtocol.checkMagic(fin);
        PickledFeatureProtocol.checkMagic(sin);
        int fv = fin.read();
        int sv = sin.read();
        Version1 protocol = null;
        if (fv == sv && fv == 1) {
            protocol = fin instanceof FileInputStream && sin instanceof FileInputStream ? new Version1NIO() : new Version1();
        } else {
            throw new IOException("No reader for " + fv + "," + sv);
        }
        if (protocol != null) {
            ((PickledFeatureProtocol)protocol).initRead(fin, sin);
        }
        return protocol;
    }

    public static PickledFeatureProtocol getWriter(OutputStream fout, OutputStream sout) throws IOException {
        return PickledFeatureProtocol.getWriter(1, fout, sout);
    }

    public static PickledFeatureProtocol getWriter(int version, OutputStream fout, OutputStream sout) throws IOException {
        Version1 protocol = null;
        if (version == 1) {
            protocol = new Version1();
        }
        if (protocol != null) {
            PickledFeatureProtocol.writeMagicAndVersion(fout, version);
            PickledFeatureProtocol.writeMagicAndVersion(sout, version);
            ((PickledFeatureProtocol)protocol).initWrite(fout, sout);
        }
        return protocol;
    }

    private static void writeMagicAndVersion(OutputStream out, int version) throws IOException {
        out.write(222);
        out.write(202);
        out.write(version);
    }

    private static void checkMagic(InputStream in) throws IOException {
        int fb = in.read();
        int sb = in.read();
        if (fb != 222 || sb != 202) {
            throw new IOException("Not Pickled File " + fb + "," + sb);
        }
    }

    protected abstract void initRead(InputStream var1, InputStream var2) throws IOException;

    protected abstract void initWrite(OutputStream var1, OutputStream var2) throws IOException;

    protected abstract int version();

    public abstract void read(FeatureCollection var1) throws IOException, ClassNotFoundException, SchemaException;

    public abstract Feature read(int var1) throws IOException, ClassNotFoundException, SchemaException;

    public abstract void write(FeatureCollection var1) throws IOException;

    public abstract void close() throws IOException;

    static final class MultiBufferInputStream
    extends InputStream {
        ByteBuffer buffer;

        public MultiBufferInputStream(ByteBuffer bb) {
            this.buffer = bb;
        }

        public void switchInput(ByteBuffer bb) {
            this.buffer = bb;
        }

        public int read() throws IOException {
            if (this.buffer.remaining() > 1) {
                return this.buffer.get();
            }
            return -1;
        }

        public void close() throws IOException {
        }

        public long skip(long n) throws IOException {
            this.buffer.position(this.buffer.position() + (int)n);
            return n;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (len > this.buffer.remaining()) {
                len = this.buffer.remaining();
            }
            this.buffer.get(b, off, len);
            return len;
        }
    }

    static final class MultiInputStream
    extends FilterInputStream {
        public MultiInputStream(InputStream in) {
            super(in);
        }

        public void switchInput(InputStream in) {
            this.in = in;
        }
    }

    static class Version1NIO
    extends Version1 {
        ByteBuffer featureBuffer;
        ByteBuffer schemaBuffer;
        MultiBufferInputStream multiBuffer;

        Version1NIO() {
        }

        protected void initRead(InputStream fin, InputStream sin) throws IOException {
            this.featureIn = fin;
            this.schemaIn = sin;
            this.featureBuffer = this.map(fin);
            this.schemaBuffer = this.map(sin);
            this.multiBuffer = new MultiBufferInputStream(this.featureBuffer);
            this.schemaBuffer.position(7);
            this.featureBuffer.position(3);
            this.input = new ObjectInputStream(this.multiBuffer);
        }

        private ByteBuffer map(InputStream in) throws IOException {
            FileInputStream fin = (FileInputStream)in;
            FileChannel fc = fin.getChannel();
            return fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        }

        public void read(FeatureCollection fc) throws IOException, ClassNotFoundException, SchemaException {
            int numberOfFeatures = this.input.readInt();
            this.readTypes();
            this.multiBuffer.switchInput(this.featureBuffer);
            try {
                for (int i = 0; i < numberOfFeatures; ++i) {
                    fc.add(this.readFeature());
                }
            }
            catch (IllegalAttributeException ife) {
                throw new SchemaException("IllegalFeatures " + ife);
            }
        }

        public Feature read(int idx) throws IOException, ClassNotFoundException, SchemaException {
            int numberOfFeatures = this.input.readInt();
            this.readTypes();
            this.multiBuffer.switchInput(this.featureBuffer);
            for (int i = 0; i < idx; ++i) {
                int l = this.featureBuffer.getInt();
                this.featureBuffer.position(this.featureBuffer.position() + l);
            }
            try {
                return this.readFeature();
            }
            catch (IllegalAttributeException ife) {
                throw new SchemaException("IllegalFeatures " + ife.getMessage());
            }
        }

        protected Feature readFeature() throws IOException, ClassNotFoundException, SchemaException, IllegalAttributeException {
            this.featureBuffer.getInt();
            short handle = this.input.readShort();
            if (this.lastHandle != handle) {
                this.pickler = (FeaturePickler)this.typesList.get(handle);
            }
            return this.pickler.readFeature(this.input);
        }

        protected void readTypes() throws IOException, ClassNotFoundException, SchemaException {
            this.multiBuffer.switchInput(this.schemaBuffer);
            this.input.readObject();
            while (this.input.readByte() == 1) {
                this.typesList.add(this.input.readObject());
            }
            int classNum = this.input.readShort();
            for (int i = 0; i < classNum; ++i) {
                this.input.readObject();
            }
        }

        public void close() throws IOException {
            NIOUtilities.clean(this.featureBuffer);
            NIOUtilities.clean(this.schemaBuffer);
            super.close();
        }
    }

    static class Version1
    extends PickledFeatureProtocol {
        protected ObjectOutputStream output;
        protected ObjectInputStream input;
        protected OutputStream featureOut;
        protected OutputStream schemaOut;
        protected DataOutputStream dataOut;
        protected DataInputStream dataIn;
        protected InputStream featureIn;
        protected InputStream schemaIn;
        protected ByteArrayOutputStream bytesOut;
        protected MultiInputStream multi;
        protected HashMap handles = new HashMap();
        protected HashSet clazzes;
        protected ArrayList typesList = new ArrayList();
        protected short handleCnt = 0;
        protected short lastHandle = (short)-1;
        protected FeaturePickler pickler;

        Version1() {
        }

        protected void initRead(InputStream fin, InputStream sin) throws IOException {
            this.featureIn = fin;
            this.schemaIn = sin;
            this.multi = new MultiInputStream(this.featureIn);
            this.schemaIn.skip(4L);
            this.input = new ObjectInputStream(this.multi);
            this.dataIn = new DataInputStream(fin);
        }

        protected void initWrite(OutputStream fout, OutputStream sout) throws IOException {
            this.featureOut = fout;
            this.schemaOut = sout;
            this.clazzes = new HashSet();
            this.bytesOut = new ByteArrayOutputStream();
            this.output = new ObjectOutputStream(this.bytesOut);
            this.output.flush();
            this.bytesOut.writeTo(this.featureOut);
            this.bytesOut.writeTo(this.schemaOut);
            this.bytesOut.reset();
            this.dataOut = new DataOutputStream(fout);
        }

        protected void flushToFeatures() throws IOException {
            this.output.flush();
            this.dataOut.writeInt(this.bytesOut.size());
            this.dataOut.flush();
            this.bytesOut.writeTo(this.featureOut);
            this.bytesOut.reset();
        }

        protected void flushToSchema() throws IOException {
            this.output.flush();
            this.bytesOut.writeTo(this.schemaOut);
            this.bytesOut.reset();
        }

        public int version() {
            return 1;
        }

        public void write(FeatureCollection fc) throws IOException {
            this.output.writeInt(fc.size());
            this.output.flush();
            this.bytesOut.writeTo(this.featureOut);
            this.bytesOut.reset();
            this.output.writeObject(class$org$geotools$data$pickle$FeaturePickler == null ? (class$org$geotools$data$pickle$FeaturePickler = PickledFeatureProtocol.class$("org.geotools.data.pickle.FeaturePickler")) : class$org$geotools$data$pickle$FeaturePickler);
            this.flushToSchema();
            Iterator features = fc.iterator();
            boolean handleNum = false;
            while (features.hasNext()) {
                this.writeFeature((Feature)features.next());
            }
            this.output.writeByte(0);
            this.output.writeShort(this.clazzes.size());
            Object[] clazzes = this.clazzes.toArray();
            for (int i = 0; i < clazzes.length; ++i) {
                this.output.writeObject(clazzes[i]);
            }
            this.flushToSchema();
            this.output.close();
            this.schemaOut.close();
        }

        protected void writeFeature(Feature f) throws IOException {
            short handle = this.getHandle(f);
            this.output.writeShort(handle);
            FeaturePickler pickler = (FeaturePickler)this.typesList.get(handle);
            pickler.writeFeature(f, this.output, this.clazzes);
            this.flushToFeatures();
        }

        protected short getHandle(Feature f) throws IOException {
            FeatureType schema = f.getFeatureType();
            Short handle = (Short)this.handles.get(schema);
            if (handle == null) {
                short s = this.handleCnt;
                this.handleCnt = (short)(s + 1);
                handle = new Short(s);
                this.handles.put(schema, handle);
                this.output.writeByte(1);
                FeaturePickler pickler = new FeaturePickler(schema, handle);
                this.output.writeObject(pickler);
                this.flushToSchema();
                this.typesList.add(pickler);
            }
            return handle;
        }

        public void read(FeatureCollection fc) throws IOException, ClassNotFoundException, SchemaException {
            int numberOfFeatures = this.input.readInt();
            this.readTypes();
            this.multi.switchInput(this.featureIn);
            try {
                for (int i = 0; i < numberOfFeatures; ++i) {
                    fc.add(this.readFeature());
                }
            }
            catch (IllegalAttributeException ife) {
                throw new SchemaException("IllegalFeatures " + ife);
            }
        }

        protected void readTypes() throws IOException, ClassNotFoundException, SchemaException {
            this.multi.switchInput(this.schemaIn);
            this.input.readObject();
            while (this.input.readByte() == 1) {
                this.typesList.add(this.input.readObject());
            }
            int classNum = this.input.readShort();
            for (int i = 0; i < classNum; ++i) {
                this.input.readObject();
            }
        }

        protected Feature readFeature() throws IOException, ClassNotFoundException, SchemaException, IllegalAttributeException {
            this.dataIn.readInt();
            short handle = this.input.readShort();
            if (this.lastHandle != handle) {
                this.pickler = (FeaturePickler)this.typesList.get(handle);
            }
            return this.pickler.readFeature(this.input);
        }

        public Feature read(int idx) throws IOException, ClassNotFoundException, SchemaException {
            int numberOfFeatures = this.input.readInt();
            this.readTypes();
            this.multi.switchInput(this.featureIn);
            for (int i = 0; i < idx; ++i) {
                int l = this.dataIn.readInt();
                long s = 0L;
                while ((s += this.dataIn.skip((long)l - s)) < s) {
                }
            }
            try {
                return this.readFeature();
            }
            catch (IllegalAttributeException ife) {
                throw new SchemaException("IllegalFeatures " + ife.getMessage());
            }
        }

        public void close() throws IOException {
            if (this.featureIn != null) {
                this.featureIn.close();
            }
            if (this.featureOut != null) {
                this.featureOut.close();
            }
            if (this.schemaIn != null) {
                this.schemaIn.close();
            }
            if (this.schemaOut != null) {
                this.schemaOut.close();
            }
        }
    }
}

