/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.pickle;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Set;
import org.geotools.data.pickle.GeometryPickler;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;

public class FeaturePickler
implements Serializable {
    private transient GeometryPickler pickler = new GeometryPickler();
    private transient FeatureType schema;
    private transient short handle;
    private transient Object[] cache;
    private transient byte[] types;
    private static final byte BOOLEAN = 0;
    private static final byte BYTE = 1;
    private static final byte SHORT = 2;
    private static final byte INT = 3;
    private static final byte FLOAT = 4;
    private static final byte DOUBLE = 5;
    private static final byte LONG = 6;
    private static final byte STRING = 7;
    private static final byte GEOMETRY = 8;
    private static final byte OBJECT = -100;

    public FeaturePickler(FeatureType schema, short handle) {
        this.schema = schema;
        this.handle = handle;
        this.initTypes(schema);
    }

    private void initTypes(FeatureType schema) {
        this.types = new byte[schema.getAttributeCount()];
        for (int i = 0; i < this.types.length; ++i) {
            this.types[i] = this.getType(schema.getAttributeType(i).getType());
        }
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    private byte getType(Class type) {
        if (type == Boolean.class) {
            return 0;
        }
        if (type == Byte.class) {
            return 1;
        }
        if (type == Short.class) {
            return 2;
        }
        if (type == Integer.class) {
            return 3;
        }
        if (type == Float.class) {
            return 4;
        }
        if (type == Double.class) {
            return 5;
        }
        if (type == Long.class) {
            return 6;
        }
        if (type == String.class) {
            return 7;
        }
        if (Geometry.class.isAssignableFrom(type)) {
            return 8;
        }
        return -100;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeShort(this.schema.getAttributeCount());
        int ii = this.types.length;
        for (int i = 0; i < ii; ++i) {
            AttributeType att = this.schema.getAttributeType(i);
            stream.writeUTF(att.getName());
            stream.writeObject(att.getType());
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        int len = stream.readShort();
        AttributeType[] types = new AttributeType[len];
        for (int i = 0; i < len; ++i) {
            String name = stream.readUTF();
            Class clazz = (Class)stream.readObject();
            types[i] = AttributeTypeFactory.newAttributeType(name, clazz);
        }
        try {
            this.schema = FeatureTypeFactory.newFeatureType(types, "pickled");
        }
        catch (SchemaException se) {
            throw new IOException("unexpected schema error" + se.getMessage());
        }
        this.initTypes(this.schema);
        this.cache = new Object[types.length];
        this.pickler = new GeometryPickler();
    }

    public void writeFeature(Feature f, ObjectOutputStream output, Set clazzes) throws IOException {
        Object[] atts = f.getAttributes(null);
        int ii = atts.length;
        block12: for (int i = 0; i < ii; ++i) {
            switch (this.types[i]) {
                case 7: {
                    output.writeUTF(atts[i].toString());
                    continue block12;
                }
                case 8: {
                    this.pickler.write((Geometry)atts[i], output);
                    continue block12;
                }
                case -100: {
                    output.writeUnshared(atts[i]);
                    continue block12;
                }
                case 3: {
                    output.writeInt((Integer)atts[i]);
                    continue block12;
                }
                case 5: {
                    output.writeDouble((Double)atts[i]);
                    continue block12;
                }
                case 6: {
                    output.writeLong((Long)atts[i]);
                    continue block12;
                }
                case 4: {
                    output.writeFloat(((Float)atts[i]).floatValue());
                    continue block12;
                }
                case 0: {
                    output.writeBoolean((Boolean)atts[i]);
                    continue block12;
                }
                case 1: {
                    output.writeByte(((Byte)atts[i]).byteValue());
                    continue block12;
                }
                case 2: {
                    output.writeShort(((Short)atts[i]).shortValue());
                    continue block12;
                }
                default: {
                    throw new IllegalStateException("type : " + this.types[i]);
                }
            }
        }
    }

    public Object[] readAttributes(ObjectInputStream input) throws IOException, ClassNotFoundException {
        block12: for (int i = 0; i < this.types.length; ++i) {
            switch (this.types[i]) {
                case 3: {
                    this.cache[i] = new Integer(input.readInt());
                    continue block12;
                }
                case 5: {
                    this.cache[i] = new Double(input.readDouble());
                    continue block12;
                }
                case 7: {
                    this.cache[i] = input.readUTF();
                    continue block12;
                }
                case -100: {
                    this.cache[i] = input.readObject();
                    continue block12;
                }
                case 8: {
                    this.cache[i] = this.pickler.read(input);
                    continue block12;
                }
                case 4: {
                    this.cache[i] = new Float(input.readFloat());
                    continue block12;
                }
                case 0: {
                    this.cache[i] = new Boolean(input.readBoolean());
                    continue block12;
                }
                case 6: {
                    this.cache[i] = new Long(input.readLong());
                    continue block12;
                }
                case 1: {
                    this.cache[i] = new Byte(input.readByte());
                    continue block12;
                }
                case 2: {
                    this.cache[i] = new Short(input.readShort());
                    continue block12;
                }
                default: {
                    throw new IllegalStateException("type : " + this.types[i]);
                }
            }
        }
        return this.cache;
    }

    public Feature readFeature(ObjectInputStream input) throws IOException, ClassNotFoundException, IllegalAttributeException {
        return this.schema.create(this.readAttributes(input));
    }
}

