/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.collection;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;

public class CollectionDataStore
extends AbstractDataStore {
    FeatureType featureType;
    FeatureCollection collection;

    public CollectionDataStore(FeatureCollection collection) {
        this.collection = collection;
        this.featureType = collection.size() == 0 ? DefaultFeatureType.EMPTY : ((Feature)collection.iterator().next()).getFeatureType();
        collection.addListener(new FeatureCollectionListener());
    }

    public String[] getTypeNames() {
        return new String[]{this.featureType.getTypeName()};
    }

    public FeatureType getSchema(String typeName) throws IOException {
        if (typeName != null && typeName.equals(this.featureType.getTypeName())) {
            return this.featureType;
        }
        throw new IOException(typeName + " not available");
    }

    public FeatureReader getFeatureReader(final String typeName) throws IOException {
        return new FeatureReader(){
            FeatureType featureType;
            FeatureIterator iterator;
            {
                this.featureType = CollectionDataStore.this.getSchema(typeName);
                this.iterator = CollectionDataStore.this.collection.features();
            }

            public FeatureType getFeatureType() {
                return this.featureType;
            }

            public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                if (this.iterator == null) {
                    throw new IOException("Feature Reader has been closed");
                }
                try {
                    return this.iterator.next();
                }
                catch (NoSuchElementException end) {
                    throw new DataSourceException("There are no more Features", end);
                }
            }

            public boolean hasNext() throws IOException {
                return this.iterator != null && this.iterator.hasNext();
            }

            public void close() throws IOException {
                if (this.iterator != null) {
                    this.iterator = null;
                }
                if (this.featureType != null) {
                    this.featureType = null;
                }
            }
        };
    }

    public FeatureCollection getCollection() {
        return this.collection;
    }

    protected Envelope getBounds(Query query) throws IOException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        return this.getBoundsInternal(query);
    }

    private Envelope getBoundsInternal(Query query) {
        FeatureIterator iterator = this.collection.features();
        Envelope envelope = null;
        if (iterator.hasNext()) {
            int count = 1;
            Filter filter = query.getFilter();
            envelope = iterator.next().getDefaultGeometry().getEnvelopeInternal();
            while (iterator.hasNext() && count < query.getMaxFeatures()) {
                Feature feature = iterator.next();
                if (!filter.contains(feature)) continue;
                ++count;
                envelope.expandToInclude(feature.getDefaultGeometry().getEnvelopeInternal());
            }
        }
        return envelope;
    }

    protected int getCount(Query query) throws IOException {
        String featureTypeName = query.getTypeName();
        if (!this.featureType.getTypeName().equals(featureTypeName)) {
            throw new SchemaNotFoundException(featureTypeName);
        }
        int count = 0;
        FeatureIterator iterator = this.collection.features();
        Object envelope = null;
        Filter filter = query.getFilter();
        while (iterator.hasNext() && count < query.getMaxFeatures()) {
            if (!filter.contains(iterator.next())) continue;
            ++count;
        }
        return count;
    }

    private class FeatureCollectionListener
    implements CollectionListener {
        private FeatureCollectionListener() {
        }

        public void collectionChanged(CollectionEvent tce) {
            String typeName = CollectionDataStore.this.featureType.getTypeName();
            Envelope bounds = null;
            bounds = CollectionDataStore.this.getBoundsInternal(Query.ALL);
            switch (tce.getEventType()) {
                case 0: {
                    CollectionDataStore.this.listenerManager.fireFeaturesAdded(typeName, Transaction.AUTO_COMMIT, bounds);
                    break;
                }
                case 2: {
                    CollectionDataStore.this.listenerManager.fireFeaturesChanged(typeName, Transaction.AUTO_COMMIT, bounds);
                    break;
                }
                case 1: {
                    CollectionDataStore.this.listenerManager.fireFeaturesRemoved(typeName, Transaction.AUTO_COMMIT, bounds);
                }
            }
        }
    }
}

