/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.feature.Feature;
import org.geotools.feature.IllegalAttributeException;

public class TransactionStateDiff
implements Transaction.State {
    AbstractDataStore store;
    Transaction transaction;
    Map typeNameDiff = new HashMap();

    public TransactionStateDiff(AbstractDataStore dataStore) {
        this.store = dataStore;
    }

    public synchronized void setTransaction(Transaction transaction) {
        if (transaction != null) {
            this.transaction = transaction;
        } else {
            this.transaction = null;
            if (this.typeNameDiff != null) {
                Iterator i = this.typeNameDiff.values().iterator();
                while (i.hasNext()) {
                    Map diff = (Map)i.next();
                    diff.clear();
                }
                this.typeNameDiff.clear();
            }
            this.store = null;
        }
    }

    public synchronized Map diff(String typeName) throws IOException {
        if (!this.exists(typeName)) {
            throw new IOException(typeName + " not defined");
        }
        if (this.typeNameDiff.containsKey(typeName)) {
            return (Map)this.typeNameDiff.get(typeName);
        }
        Map diff = Collections.synchronizedMap(new HashMap());
        this.typeNameDiff.put(typeName, diff);
        return diff;
    }

    boolean exists(String typeName) {
        Object[] types = this.store.getTypeNames();
        Arrays.sort(types);
        return Arrays.binarySearch(types, typeName) != -1;
    }

    public synchronized void addAuthorization(String AuthID) throws IOException {
    }

    public synchronized void commit() throws IOException {
        Iterator i = this.typeNameDiff.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String typeName = (String)entry.getKey();
            Map diff = (Map)entry.getValue();
            this.applyDiff(typeName, diff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void applyDiff(String typeName, Map diff) throws IOException {
        if (diff.isEmpty()) {
            return;
        }
        FeatureWriter writer = this.store.getFeatureWriter(typeName);
        try {
            String fid;
            while (writer.hasNext()) {
                Feature feature = writer.next();
                fid = feature.getID();
                if (!diff.containsKey(fid)) continue;
                Feature update = (Feature)diff.remove(fid);
                if (update == null) {
                    writer.remove();
                    this.store.listenerManager.fireFeaturesRemoved(typeName, this.transaction, feature.getBounds());
                    continue;
                }
                try {
                    feature.setAttributes(update.getAttributes(null));
                    writer.write();
                    Envelope bounds = new Envelope();
                    bounds.expandToInclude(feature.getBounds());
                    bounds.expandToInclude(update.getBounds());
                    this.store.listenerManager.fireFeaturesChanged(typeName, this.transaction, bounds);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, e);
                }
            }
            Iterator i = diff.values().iterator();
            while (i.hasNext()) {
                Feature addedFeature = (Feature)i.next();
                i.remove();
                if (addedFeature == null) continue;
                fid = addedFeature.getID();
                Feature nextFeature = writer.next();
                if (nextFeature == null) {
                    throw new DataSourceException("Could not add " + fid);
                }
                try {
                    nextFeature.setAttributes(addedFeature.getAttributes(null));
                    writer.write();
                    this.store.listenerManager.fireFeaturesAdded(typeName, this.transaction, nextFeature.getBounds());
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Could update " + fid, e);
                }
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            writer.close();
            this.store.listenerManager.fireChanged(typeName, this.transaction, true);
            throw throwable;
        }
        writer.close();
        this.store.listenerManager.fireChanged(typeName, this.transaction, true);
    }

    public synchronized void rollback() throws IOException {
        Iterator i = this.typeNameDiff.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String typeName = (String)entry.getKey();
            Map diff = (Map)entry.getValue();
            diff.clear();
            this.store.listenerManager.fireChanged(typeName, this.transaction, false);
        }
    }

    public synchronized FeatureReader reader(String typeName) throws IOException {
        Map diff = this.diff(typeName);
        FeatureReader reader = this.store.getFeatureReader(typeName);
        return new DiffFeatureReader(reader, diff);
    }

    public synchronized FeatureWriter writer(final String typeName) throws IOException {
        Map diff = this.diff(typeName);
        FeatureReader reader = this.store.getFeatureReader(typeName);
        return new DiffFeatureWriter(reader, diff){

            void fireNotification(int eventType, Envelope bounds) {
                switch (eventType) {
                    case 1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesAdded(typeName, TransactionStateDiff.this.transaction, bounds);
                        break;
                    }
                    case 0: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesChanged(typeName, TransactionStateDiff.this.transaction, bounds);
                        break;
                    }
                    case -1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesRemoved(typeName, TransactionStateDiff.this.transaction, bounds);
                    }
                }
            }
        };
    }
}

