/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.geotools.data.AbstractDataSource;
import org.geotools.data.DataSource;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataSourceMetaData;
import org.geotools.data.Query;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.filter.Filter;

public class MemoryDataSource
extends AbstractDataSource
implements DataSource {
    protected Envelope bbox = new Envelope();
    protected Map features = new HashMap();

    protected Map getFeaturesMap() {
        return this.features;
    }

    public String addFeature(Feature feature) {
        Feature newFeature;
        String fid = feature.getID();
        if (this.getFeaturesMap().containsKey(fid)) {
            return null;
        }
        try {
            newFeature = feature.getFeatureType().duplicate(feature);
        }
        catch (IllegalAttributeException e) {
            newFeature = feature;
        }
        this.getFeaturesMap().put(fid, newFeature);
        Envelope internal = feature.getDefaultGeometry().getEnvelopeInternal();
        this.bbox.expandToInclude(internal);
        return fid;
    }

    public Set addFeatures(FeatureCollection collection) throws DataSourceException {
        HashSet<String> added = new HashSet<String>();
        FeatureIterator i = collection.features();
        while (i.hasNext()) {
            Feature feature = i.next();
            String fid = this.addFeature(feature);
            if (fid == null) continue;
            added.add(fid);
        }
        return added;
    }

    public Envelope getBbox() {
        return this.bbox;
    }

    public void getFeatures(FeatureCollection collection, Query query) throws DataSourceException {
        Filter filter = null;
        if (query != null) {
            filter = query.getFilter();
        }
        Iterator i = this.getFeaturesMap().values().iterator();
        for (int count = 0; i.hasNext() && count < query.getMaxFeatures(); ++count) {
            Feature feature = (Feature)i.next();
            if (!filter.contains(feature)) continue;
            try {
                collection.add(feature.getFeatureType().duplicate(feature));
                continue;
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Could not duplicate " + feature.getID(), e);
            }
        }
    }

    public FeatureType getSchema() throws DataSourceException {
        FeatureType featureType = null;
        Map features = this.getFeaturesMap();
        if (features.size() > 0) {
            Feature feature = (Feature)features.values().iterator().next();
            featureType = feature.getFeatureType();
        }
        return featureType;
    }

    protected DataSourceMetaData createMetaData() {
        AbstractDataSource.MetaDataSupport memMeta = new AbstractDataSource.MetaDataSupport();
        memMeta.setSupportsAdd(true);
        memMeta.setFastBbox(true);
        return memMeta;
    }
}

