/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.util.ArrayList;

public class MultiPolygon
extends GeometryCollection {
    public MultiPolygon(Polygon[] polygonArray, PrecisionModel precisionModel, int n) {
        this(polygonArray, new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public MultiPolygon(Polygon[] polygonArray, GeometryFactory geometryFactory) {
        super(polygonArray, geometryFactory);
    }

    public int getDimension() {
        return 2;
    }

    public int getBoundaryDimension() {
        return 1;
    }

    public String getGeometryType() {
        return "MultiPolygon";
    }

    public boolean isSimple() {
        return true;
    }

    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createGeometryCollection(null);
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < this.geometries.length; ++i) {
            Polygon polygon = (Polygon)this.geometries[i];
            GeometryCollection geometryCollection = (GeometryCollection)polygon.getBoundary();
            for (int j = 0; j < geometryCollection.getNumGeometries(); ++j) {
                arrayList.add(geometryCollection.getGeometryN(j));
            }
        }
        LineString[] lineStringArray = new LineString[arrayList.size()];
        return this.getFactory().createMultiLineString(arrayList.toArray(lineStringArray));
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }
}

