/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;

public class LinearRing
extends LineString {
    public LinearRing(Coordinate[] coordinateArray, PrecisionModel precisionModel, int n) {
        this(DefaultCoordinateSequenceFactory.instance().create(coordinateArray == null ? new Coordinate[]{} : coordinateArray), new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public LinearRing(CoordinateSequence coordinateSequence, GeometryFactory geometryFactory) {
        super(coordinateSequence, geometryFactory);
        this.validateConstruction();
    }

    private void validateConstruction() {
        if (!this.isEmpty() && !super.isClosed()) {
            throw new IllegalArgumentException("points must form a closed linestring");
        }
        if (this.getCoordinateSequence().size() >= 1 && this.getCoordinateSequence().size() <= 3) {
            throw new IllegalArgumentException("Number of points must be 0 or >3");
        }
    }

    public boolean isSimple() {
        return true;
    }

    public String getGeometryType() {
        return "LinearRing";
    }

    public boolean isClosed() {
        return true;
    }
}

