/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.DefaultCoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.util.Assert;
import java.util.Arrays;
import java.util.TreeSet;

public class GeometryCollection
extends Geometry {
    protected Geometry[] geometries;

    public GeometryCollection(Geometry[] geometryArray, PrecisionModel precisionModel, int n) {
        this(geometryArray, new GeometryFactory(precisionModel, n, DefaultCoordinateSequenceFactory.instance()));
    }

    public GeometryCollection(Geometry[] geometryArray, GeometryFactory geometryFactory) {
        super(geometryFactory);
        if (geometryArray == null) {
            geometryArray = new Geometry[]{};
        }
        if (GeometryCollection.hasNullElements(geometryArray)) {
            throw new IllegalArgumentException("geometries must not contain null elements");
        }
        this.geometries = geometryArray;
    }

    public Coordinate getCoordinate() {
        if (this.isEmpty()) {
            return null;
        }
        return this.geometries[0].getCoordinate();
    }

    public Coordinate[] getCoordinates() {
        Coordinate[] coordinateArray = new Coordinate[this.getNumPoints()];
        int n = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            Coordinate[] coordinateArray2 = this.geometries[i].getCoordinates();
            for (int j = 0; j < coordinateArray2.length; ++j) {
                coordinateArray[++n] = coordinateArray2[j];
            }
        }
        return coordinateArray;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getDimension() {
        int n = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            n = Math.max(n, this.geometries[i].getDimension());
        }
        return n;
    }

    public int getBoundaryDimension() {
        int n = -1;
        for (int i = 0; i < this.geometries.length; ++i) {
            n = Math.max(n, this.geometries[i].getBoundaryDimension());
        }
        return n;
    }

    public int getNumGeometries() {
        return this.geometries.length;
    }

    public Geometry getGeometryN(int n) {
        return this.geometries[n];
    }

    public int getNumPoints() {
        int n = 0;
        for (int i = 0; i < this.geometries.length; ++i) {
            n += this.geometries[i].getNumPoints();
        }
        return n;
    }

    public String getGeometryType() {
        return "GeometryCollection";
    }

    public boolean isSimple() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return false;
    }

    public Geometry getBoundary() {
        this.checkNotGeometryCollection(this);
        Assert.shouldNeverReachHere();
        return null;
    }

    public double getArea() {
        double d = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            d += this.geometries[i].getArea();
        }
        return d;
    }

    public double getLength() {
        double d = 0.0;
        for (int i = 0; i < this.geometries.length; ++i) {
            d += this.geometries[i].getLength();
        }
        return d;
    }

    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        GeometryCollection geometryCollection = (GeometryCollection)geometry;
        if (this.geometries.length != geometryCollection.geometries.length) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (this.geometries[i].equalsExact(geometryCollection.geometries[i], d)) continue;
            return false;
        }
        return true;
    }

    public void apply(CoordinateFilter coordinateFilter) {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(coordinateFilter);
        }
    }

    public void apply(GeometryFilter geometryFilter) {
        geometryFilter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(geometryFilter);
        }
    }

    public void apply(GeometryComponentFilter geometryComponentFilter) {
        geometryComponentFilter.filter(this);
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].apply(geometryComponentFilter);
        }
    }

    public Object clone() {
        GeometryCollection geometryCollection = (GeometryCollection)super.clone();
        geometryCollection.geometries = new Geometry[this.geometries.length];
        for (int i = 0; i < this.geometries.length; ++i) {
            geometryCollection.geometries[i] = (Geometry)this.geometries[i].clone();
        }
        return geometryCollection;
    }

    public void normalize() {
        for (int i = 0; i < this.geometries.length; ++i) {
            this.geometries[i].normalize();
        }
        Arrays.sort(this.geometries);
    }

    protected Envelope computeEnvelopeInternal() {
        Envelope envelope = new Envelope();
        for (int i = 0; i < this.geometries.length; ++i) {
            envelope.expandToInclude(this.geometries[i].getEnvelopeInternal());
        }
        return envelope;
    }

    protected int compareToSameClass(Object object) {
        TreeSet<Geometry> treeSet = new TreeSet<Geometry>(Arrays.asList(this.geometries));
        TreeSet<Geometry> treeSet2 = new TreeSet<Geometry>(Arrays.asList(((GeometryCollection)object).geometries));
        return this.compare(treeSet, treeSet2);
    }
}

