/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryCollectionIterator;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

public class SimplePointInAreaLocator {
    public static int locate(Coordinate coordinate, Geometry geometry) {
        if (geometry.isEmpty()) {
            return 2;
        }
        if (SimplePointInAreaLocator.containsPoint(coordinate, geometry)) {
            return 0;
        }
        return 2;
    }

    private static boolean containsPoint(Coordinate coordinate, Geometry geometry) {
        if (geometry instanceof Polygon) {
            return SimplePointInAreaLocator.containsPointInPolygon(coordinate, (Polygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            GeometryCollectionIterator geometryCollectionIterator = new GeometryCollectionIterator((GeometryCollection)geometry);
            while (geometryCollectionIterator.hasNext()) {
                Geometry geometry2 = (Geometry)geometryCollectionIterator.next();
                if (geometry2 == geometry || !SimplePointInAreaLocator.containsPoint(coordinate, geometry2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsPointInPolygon(Coordinate coordinate, Polygon polygon) {
        RobustCGAlgorithms robustCGAlgorithms = new RobustCGAlgorithms();
        if (polygon.isEmpty()) {
            return false;
        }
        LinearRing linearRing = (LinearRing)polygon.getExteriorRing();
        if (!((CGAlgorithms)robustCGAlgorithms).isPointInRing(coordinate, linearRing.getCoordinates())) {
            return false;
        }
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing linearRing2 = (LinearRing)polygon.getInteriorRingN(i);
            if (!((CGAlgorithms)robustCGAlgorithms).isPointInRing(coordinate, linearRing2.getCoordinates())) continue;
            return false;
        }
        return true;
    }
}

