/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.LineIntersector;
import com.vividsolutions.jts.algorithm.RobustLineIntersector;
import com.vividsolutions.jts.geom.Coordinate;

public class NonRobustCGAlgorithms
extends CGAlgorithms {
    public boolean isPointInRing(Coordinate coordinate, Coordinate[] coordinateArray) {
        int n = 0;
        int n2 = coordinateArray.length;
        for (int i = 1; i < n2; ++i) {
            double d;
            int n3 = i - 1;
            Coordinate coordinate2 = coordinateArray[i];
            Coordinate coordinate3 = coordinateArray[n3];
            double d2 = coordinate2.x - coordinate.x;
            double d3 = coordinate2.y - coordinate.y;
            double d4 = coordinate3.x - coordinate.x;
            double d5 = coordinate3.y - coordinate.y;
            if (!(d3 > 0.0 && d5 <= 0.0) && (!(d5 > 0.0) || !(d3 <= 0.0)) || !(0.0 < (d = (d2 * d5 - d4 * d3) / (d5 - d3)))) continue;
            ++n;
        }
        return n % 2 == 1;
    }

    public boolean isOnLine(Coordinate coordinate, Coordinate[] coordinateArray) {
        RobustLineIntersector robustLineIntersector = new RobustLineIntersector();
        for (int i = 1; i < coordinateArray.length; ++i) {
            Coordinate coordinate2 = coordinateArray[i - 1];
            Coordinate coordinate3 = coordinateArray[i];
            ((LineIntersector)robustLineIntersector).computeIntersection(coordinate, coordinate2, coordinate3);
            if (!robustLineIntersector.hasIntersection()) continue;
            return true;
        }
        return false;
    }

    public boolean isCCW(Coordinate[] coordinateArray) {
        int n;
        int n2 = coordinateArray.length;
        if (n2 < 4) {
            return false;
        }
        Coordinate coordinate = coordinateArray[0];
        int n3 = 0;
        for (int i = 1; i < n2; ++i) {
            Coordinate coordinate2 = coordinateArray[i];
            if (!(coordinate2.y > coordinate.y)) continue;
            coordinate = coordinate2;
            n3 = i;
        }
        int n4 = n3 - 1;
        if (n4 < 0) {
            n4 = n2 - 2;
        }
        if ((n = n3 + 1) >= n2) {
            n = 1;
        }
        Coordinate coordinate3 = coordinateArray[n4];
        Coordinate coordinate4 = coordinateArray[n];
        double d = coordinate4.x - coordinate.x;
        double d2 = coordinate3.y - coordinate.y;
        double d3 = coordinate4.y - coordinate.y;
        double d4 = coordinate3.x - coordinate.x;
        double d5 = d * d2 - d3 * d4;
        if (d5 == 0.0) {
            return coordinate3.x > coordinate4.x;
        }
        return d5 > 0.0;
    }

    public int computeOrientation(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d = coordinate2.x - coordinate.x;
        double d2 = coordinate3.y - coordinate2.y;
        double d3 = coordinate3.x - coordinate2.x;
        double d4 = coordinate2.y - coordinate.y;
        double d5 = d * d2 - d3 * d4;
        if (d5 > 0.0) {
            return 1;
        }
        if (d5 < 0.0) {
            return -1;
        }
        return 0;
    }
}

