/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.NotRepresentableException;
import com.vividsolutions.jts.geom.Coordinate;

public class HCoordinate {
    public double x;
    public double y;
    public double w;

    public static Coordinate intersection(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3, Coordinate coordinate4) throws NotRepresentableException {
        HCoordinate hCoordinate = new HCoordinate(new HCoordinate(coordinate), new HCoordinate(coordinate2));
        HCoordinate hCoordinate2 = new HCoordinate(new HCoordinate(coordinate3), new HCoordinate(coordinate4));
        HCoordinate hCoordinate3 = new HCoordinate(hCoordinate, hCoordinate2);
        Coordinate coordinate5 = hCoordinate3.getCoordinate();
        return coordinate5;
    }

    public HCoordinate() {
        this.x = 0.0;
        this.y = 0.0;
        this.w = 1.0;
    }

    public HCoordinate(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.w = d3;
    }

    public HCoordinate(Coordinate coordinate) {
        this.x = coordinate.x;
        this.y = coordinate.y;
        this.w = 1.0;
    }

    public HCoordinate(HCoordinate hCoordinate, HCoordinate hCoordinate2) {
        this.x = hCoordinate.y * hCoordinate2.w - hCoordinate2.y * hCoordinate.w;
        this.y = hCoordinate2.x * hCoordinate.w - hCoordinate.x * hCoordinate2.w;
        this.w = hCoordinate.x * hCoordinate2.y - hCoordinate2.x * hCoordinate.y;
    }

    public double getX() throws NotRepresentableException {
        double d = this.x / this.w;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new NotRepresentableException();
        }
        return d;
    }

    public double getY() throws NotRepresentableException {
        double d = this.y / this.w;
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            throw new NotRepresentableException();
        }
        return d;
    }

    public Coordinate getCoordinate() throws NotRepresentableException {
        Coordinate coordinate = new Coordinate();
        coordinate.x = this.getX();
        coordinate.y = this.getY();
        return coordinate;
    }
}

