/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.algorithm.RobustCGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.util.Assert;
import com.vividsolutions.jts.util.UniqueCoordinateArrayFilter;
import java.util.ArrayList;
import java.util.Stack;
import java.util.TreeSet;

public class ConvexHull {
    private PointLocator pointLocator = new PointLocator();
    private CGAlgorithms cgAlgorithms = new RobustCGAlgorithms();
    private Geometry geometry;
    private GeometryFactory factory;

    public ConvexHull(Geometry geometry) {
        this.geometry = geometry;
    }

    public Geometry getConvexHull() {
        Coordinate[] coordinateArray;
        Object object;
        this.factory = this.geometry.getFactory();
        UniqueCoordinateArrayFilter uniqueCoordinateArrayFilter = new UniqueCoordinateArrayFilter();
        this.geometry.apply((CoordinateFilter)uniqueCoordinateArrayFilter);
        Coordinate[] coordinateArray2 = uniqueCoordinateArrayFilter.getCoordinates();
        if (coordinateArray2.length == 0) {
            return this.factory.createGeometryCollection(null);
        }
        if (coordinateArray2.length == 1) {
            return this.factory.createPoint(coordinateArray2[0]);
        }
        if (coordinateArray2.length == 2) {
            return this.factory.createLineString(coordinateArray2);
        }
        if (coordinateArray2.length > 10) {
            object = this.reduce(coordinateArray2);
            coordinateArray = this.preSort((Coordinate[])object);
        } else {
            coordinateArray = this.preSort(coordinateArray2);
        }
        object = this.grahamScan(coordinateArray);
        Coordinate[] coordinateArray3 = this.toCoordinateArray((Stack)object);
        return this.lineOrPolygon(coordinateArray3);
    }

    protected Coordinate[] toCoordinateArray(Stack stack) {
        Coordinate[] coordinateArray = new Coordinate[stack.size()];
        for (int i = 0; i < stack.size(); ++i) {
            Coordinate coordinate;
            coordinateArray[i] = coordinate = (Coordinate)stack.get(i);
        }
        return coordinateArray;
    }

    private Coordinate[] reduce(Coordinate[] coordinateArray) {
        BigQuad bigQuad = this.bigQuad(coordinateArray);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        arrayList.add(bigQuad.westmost);
        if (!arrayList.contains(bigQuad.northmost)) {
            arrayList.add(bigQuad.northmost);
        }
        if (!arrayList.contains(bigQuad.eastmost)) {
            arrayList.add(bigQuad.eastmost);
        }
        if (!arrayList.contains(bigQuad.southmost)) {
            arrayList.add(bigQuad.southmost);
        }
        if (arrayList.size() < 3) {
            return coordinateArray;
        }
        arrayList.add(bigQuad.westmost);
        Coordinate[] coordinateArray2 = new Coordinate[arrayList.size()];
        LinearRing linearRing = this.factory.createLinearRing(arrayList.toArray(coordinateArray2));
        TreeSet<Coordinate> treeSet = new TreeSet<Coordinate>(arrayList);
        for (int i = 0; i < coordinateArray.length; ++i) {
            if (this.pointLocator.locate(coordinateArray[i], (Geometry)linearRing) != 2) continue;
            treeSet.add(coordinateArray[i]);
        }
        Coordinate[] coordinateArray3 = treeSet.toArray(new Coordinate[0]);
        return coordinateArray3;
    }

    private Coordinate[] preSort(Coordinate[] coordinateArray) {
        for (int i = 1; i < coordinateArray.length; ++i) {
            if (!(coordinateArray[i].y < coordinateArray[0].y) && (coordinateArray[i].y != coordinateArray[0].y || !(coordinateArray[i].x < coordinateArray[0].x))) continue;
            Coordinate coordinate = coordinateArray[0];
            coordinateArray[0] = coordinateArray[i];
            coordinateArray[i] = coordinate;
        }
        this.radialSort(coordinateArray);
        return coordinateArray;
    }

    private Stack grahamScan(Coordinate[] coordinateArray) {
        Stack<Coordinate> stack = new Stack<Coordinate>();
        Coordinate coordinate = stack.push(coordinateArray[0]);
        coordinate = stack.push(coordinateArray[1]);
        coordinate = stack.push(coordinateArray[2]);
        for (int i = 3; i < coordinateArray.length; ++i) {
            coordinate = (Coordinate)stack.pop();
            while (this.cgAlgorithms.computeOrientation((Coordinate)stack.peek(), coordinate, coordinateArray[i]) > 0) {
                coordinate = (Coordinate)stack.pop();
            }
            coordinate = stack.push(coordinate);
            coordinate = stack.push(coordinateArray[i]);
        }
        coordinate = stack.push(coordinateArray[0]);
        return stack;
    }

    private void radialSort(Coordinate[] coordinateArray) {
        for (int i = 1; i < coordinateArray.length - 1; ++i) {
            int n = i;
            for (int j = i + 1; j < coordinateArray.length; ++j) {
                if (this.polarCompare(coordinateArray[0], coordinateArray[j], coordinateArray[n]) >= 0) continue;
                n = j;
            }
            Coordinate coordinate = coordinateArray[i];
            coordinateArray[i] = coordinateArray[n];
            coordinateArray[n] = coordinate;
        }
    }

    private int polarCompare(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        double d;
        double d2 = coordinate2.x - coordinate.x;
        double d3 = coordinate2.y - coordinate.y;
        double d4 = coordinate3.x - coordinate.x;
        double d5 = coordinate3.y - coordinate.y;
        double d6 = Math.atan2(d2, d3);
        if (d6 < (d = Math.atan2(d4, d5))) {
            return -1;
        }
        if (d6 > d) {
            return 1;
        }
        double d7 = d2 * d2 + d3 * d3;
        double d8 = d4 * d4 + d5 * d5;
        if (d7 < d8) {
            return -1;
        }
        if (d7 > d8) {
            return 1;
        }
        return 0;
    }

    private boolean isBetween(Coordinate coordinate, Coordinate coordinate2, Coordinate coordinate3) {
        if (this.cgAlgorithms.computeOrientation(coordinate, coordinate2, coordinate3) != 0) {
            return false;
        }
        if (coordinate.x != coordinate3.x) {
            if (coordinate.x <= coordinate2.x && coordinate2.x <= coordinate3.x) {
                return true;
            }
            if (coordinate3.x <= coordinate2.x && coordinate2.x <= coordinate.x) {
                return true;
            }
        }
        if (coordinate.y != coordinate3.y) {
            if (coordinate.y <= coordinate2.y && coordinate2.y <= coordinate3.y) {
                return true;
            }
            if (coordinate3.y <= coordinate2.y && coordinate2.y <= coordinate.y) {
                return true;
            }
        }
        return false;
    }

    private BigQuad bigQuad(Coordinate[] coordinateArray) {
        BigQuad bigQuad = new BigQuad();
        bigQuad.northmost = coordinateArray[0];
        bigQuad.southmost = coordinateArray[0];
        bigQuad.westmost = coordinateArray[0];
        bigQuad.eastmost = coordinateArray[0];
        for (int i = 1; i < coordinateArray.length; ++i) {
            if (coordinateArray[i].x < bigQuad.westmost.x) {
                bigQuad.westmost = coordinateArray[i];
            }
            if (coordinateArray[i].x > bigQuad.eastmost.x) {
                bigQuad.eastmost = coordinateArray[i];
            }
            if (coordinateArray[i].y < bigQuad.southmost.y) {
                bigQuad.southmost = coordinateArray[i];
            }
            if (!(coordinateArray[i].y > bigQuad.northmost.y)) continue;
            bigQuad.northmost = coordinateArray[i];
        }
        return bigQuad;
    }

    private Geometry lineOrPolygon(Coordinate[] coordinateArray) {
        if ((coordinateArray = this.cleanRing(coordinateArray)).length == 3) {
            return this.factory.createLineString(new Coordinate[]{coordinateArray[0], coordinateArray[1]});
        }
        LinearRing linearRing = this.factory.createLinearRing(coordinateArray);
        return this.factory.createPolygon(linearRing, null);
    }

    private Coordinate[] cleanRing(Coordinate[] coordinateArray) {
        Assert.equals((Object)coordinateArray[0], (Object)coordinateArray[coordinateArray.length - 1]);
        ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>();
        Coordinate coordinate = null;
        for (int i = 0; i <= coordinateArray.length - 2; ++i) {
            Coordinate coordinate2 = coordinateArray[i];
            Coordinate coordinate3 = coordinateArray[i + 1];
            if (coordinate2.equals(coordinate3) || coordinate != null && this.isBetween(coordinate, coordinate2, coordinate3)) continue;
            arrayList.add(coordinate2);
            coordinate = coordinate2;
        }
        arrayList.add(coordinateArray[coordinateArray.length - 1]);
        Coordinate[] coordinateArray2 = new Coordinate[arrayList.size()];
        return arrayList.toArray(coordinateArray2);
    }

    private static class BigQuad {
        public Coordinate northmost;
        public Coordinate southmost;
        public Coordinate westmost;
        public Coordinate eastmost;

        private BigQuad() {
        }
    }
}

