      subroutine fetch_sens(io_res,filen,head,ierr)
c
c     subroutine will find response for station stat and channel chan
c     at stime and load it into response common block
c
c     input:
c     	io_res- io unit to open
c     	filen - file containing sensitivities
c     	head  - header record
c     output:
c     	ierr  - integer error flag
c           	= 0 for recovered response
c           	= 999 for no response found
c
      include '/usr/local/include/qlib2.inc'
      record /INT_TIME/ stime, bdate, edate
      record /EXT_TIME/ st
      include 'station_hdr.inc'
c
      character*3 cseed, chan
      character*4 cstat, cnetn, stat
      character*9 cunit
      character*(*) filen
      real*4 fp_lc, fp_hc, fp_sens
      integer*4 io_res, ierr, daymo, iere
      real*8 td1, td2 
c
c     Common block for saving instrument response information
c
      integer*4 iunit
      real*4 sens, fl, fh
      common /sens/ iunit, sens, fl, fh
c
c     Initialize
c
      ierr = 0
c
      iunit = 999
      sens = 0.0
      fl = 0.0
      fh = 0.0
c
      stat  = head.station_id
      chan  = head.channel_id
      stime = head.begtime
c
      open(io_res,file=filen)
c
c     Loop over responses until the correct one is found
c
c     Format of file:
c
c ARC  HHZ 1992.147.2200 2599.366.2359   0. -90. (DU/MS-1) BDSN
c      0.008333    32.000000    6.23183E+08
c ARC  HHN 1992.147.2200 2599.366.2359   0.   0. (DU/MS-1) BDSN
c      0.008333    32.000000    6.02140E+08
c
100   continue
      read(io_res,101,end=105) cstat, cseed,
     .    isyr, isdy, ishr, ismn,
     .    ieyr, iedy, iehr, iemn,
     .    azi, dip, cunit, cnetn
c
      if (cstat(4:4) .eq. '_') then
        cstat(4:4) =  ' '
      endif
      read(io_res,102) fp_lc, fp_hc, fp_sens
c
101   format(a4,1x,a3,1x,i4,1x,i3,1x,i2,i2,1x,i4,
     .  1x,i3,1x,i2,i2,1x,f4.0,1x,f4.0,1x,a9,1x,a4)
102   format(5x,f8.6,3x,f10.6,3x,1pe12.5)
c
c     form times
c     --changed to use DN's time routines 10/28/93
c
      st.year   = isyr
      st.doy    = isdy
      iere = daymo(isdy,st.month,st.day,isyr)
      if (iere .ne. 1) then
        ierr = 997
      end if
      st.hour   = ishr
      st.minute = ismn
      st.second = 0
      st.usec  = 0
      call f_ext_to_int(st,bdate)
c
      st.year   = ieyr
      if (ieyr .eq. 2599 .and. iedy .eq. 366) then
        st.doy  = 365
        st.month = 12
        st.day = 31
      else
        st.doy    = iedy
        iere = daymo(iedy,st.month,st.day,ieyr)
        if (iere .ne. 1) then
          ierr = 998
        end if
      end if
      st.hour   = iehr
      st.minute = iemn
      st.second = 0
      st.usec  = 0
      call f_ext_to_int(st,edate) 
      td1 = f_tdiff(stime, bdate)
      td2 = f_tdiff(stime, edate)
c
c     compare station name, channel and date 
c
      if (cstat .eq. stat) then
        if (cseed .eq. chan) then
          if (td1 .ge. 0.d0 .and. td2 .le. 0.d0) then
c
c           match!
c
            sens = fp_sens
            fl = fp_lc
            fh = fp_hc
            if (cunit .eq. '(DU/MS-2)') then
              iunit=2
            else if (cunit .eq. '(DU/MS-1)') then
              iunit=1
            else if (cunit .eq. '(DU/M)   ') then
              iunit=0
            else
              iunit=999
            end if
c
            head.sens = sens
            head.fl = fp_lc
            head.fh = fp_hc
            head.iunit = iunit
c
            go to 110
          end if
        end if
      end if
c
      go to 100
c
c     error exit
c
105   continue
      ierr = 999
      close(io_res)
      return
c
c     sucessful completion exit
c
110   continue
      close(io_res)
      return
c
c
      end
