      subroutine fetch_response(io_res,filen,head,ierr)
c
c     subroutine will find response for station stat and channel chan
c     at stime and load it into response common block
c
c     input:
c     	io_res- io unit to open
c     	filen - file containing instrument information
c     	head  - station header structure
c     output:
c     	ierr  - integer error flag
c           	= 0 for recovered response
c          	 = 999 for no response found
c
      include '/usr/local/include/qlib2.inc'
      record /INT_TIME/ stime, bdate, edate
      record /EXT_TIME/ st
	include 'station_hdr.inc'
c
      character*3 chan
      character*4 stat
      character*3 cseed
      character*4 cstat, cchan, cnetn
      character*9 cunit
      character*(*) filen
      integer*4 io_res, iere, ierr, daymo
	real*8 td1, td2
c
c     Common block for saving instrument response information
c
      integer*4 iunit
      integer*4 npoles, nzeros
      real*4 ds, gain
      complex*8 poles(60)
      common /instr/ iunit, ds, gain, npoles, nzeros, poles
c
c     Initialize
c
      ierr = 0
c
      iunit = 999
      npoles = 0
      nzeros = 0
      gain = 0.0
      ds = 1.0
c
      stat  = head.station_id
      chan  = head.channel_id
	stime = head.begtime
c
      open(io_res,file=filen)
c
c     Loop over responses until the correct one is found
c
100   continue
      read(io_res,101,end=105) cstat, cchan,
     .    isyr, isdy, ishr, ismn,
     .    ieyr, iedy, iehr, iemn,
     .    azi, dip, cunit, cnetn, cseed
c
      if (cstat(4:4) .eq. '_') then
        cstat(4:4) =  ' '
      endif
      read(io_res,*) gs, nz, np
c
c     form times
c     --changed to use DN's time routines 10/28/93
c
      st.year   = isyr
      st.doy    = isdy
      iere = daymo(isdy,st.month,st.day,isyr)
      if (iere .ne. 1) then
        ierr = 997
      end if
      st.hour   = ishr
      st.minute = ismn
      st.second = 0
      st.usec   = 0
      call f_ext_to_int(st,bdate)
c
      st.year   = ieyr
      if (ieyr .eq. 2599 .and. iedy .eq. 366) then
        st.doy  = 365
        st.month = 12
        st.day = 31
      else
        st.doy    = iedy
        iere = daymo(iedy,st.month,st.day,ieyr)
        if (iere .ne. 1) then
          ierr = 998
        end if
      end if
      st.hour   = iehr
      st.minute = iemn
      st.second = 0
      st.usec   = 0
      call f_ext_to_int(st,edate) 
      td1 = f_tdiff(stime, bdate)
      td2 = f_tdiff(stime, edate)
c
c     compare station name, channel and date 
c
      if (cstat .eq. stat) then
        if (cseed .eq. chan) then
          if (td1 .ge. 0.d0 .and. td2 .le. 0.d0) then
c
c           match!
c
            head.azi = azi
            head.dip = dip
            head.gain = gs * ds
            head.nzeros = nz
            head.npoles = np
c
            gain = gs
            nzeros = nz
            npoles = np
            do jj = 1, nz
              kk = np + jj
              read(io_res,103) poles(kk)
            end do
            ip = int(np*0.5)*2
            do jj = 1, ip, 2
              read(io_res,104) poles(jj), poles(jj+1)
            end do
            if ((np - ip) .eq. 1) then
              read(io_res,104) poles(np)
            end if
            if (cunit .eq. '(DU/MS-2)') then
              iunit=2
            else if (cunit .eq. '(DU/MS-1)') then
              iunit=1
            else if (cunit .eq. '(DU/M)   ') then
              iunit=0
            else
              iunit=999
            end if
            do jj = 1, np + nz
              head.poles(jj) = poles(jj)
            end do
            head.iunit = iunit
            go to 110
          end if
        end if
      end if
c
c     no match - skip the poles and zeros and keep going
c
      iskip = nz + nint(np*0.5)
      do ii = 1, iskip
        read(io_res,*)
      end do
      go to 100
c
c     error exit
c
105   continue
      ierr = 999
      close(io_res)
      return
c
c     sucessful completion exit
c
110   continue
      close(io_res)
      return
c
c     format statements
c
101   format(2a4,1x,i4,1x,i3,1x,i2,i2,2x,i4,
     .  1x,i3,1x,i2,i2,2f8.2,1x,a9,1x,a4,1x,a3)
102   format(3x,e12.5,i3,i4)
103   format(1x,2e14.6)
104   format(4e14.6)
c
      end
