	subroutine check_clip(chan,npts,idata,iere)
c
c     subroutine to check for clipped data
c
c     input:  
c             chan   - channel name
c             npts   - number of points in timeseries
c             idata  - integer data array
c     output:  
c             iere   - error return code
c                      999 if data if clipped
c                      0 otherwise
c
      integer*4 idata(*)
      integer*4 npts, iere, ixmax, ix
      real*4 rcomp, rxcomp, rmax
      character*3 chan
c
c     scale for determining clipping
c
      rcomp = 0.85 * real (2**23)
      if (chan(2:2) .eq. 'H') then
        rxcomp = rcomp
      elseif (chan(2:2) .eq. 'L') then
        rxcomp = 0.125*rcomp
      end if
c
c     initialize error flag
c
      iere = 0
c
c     find the maximum value
c
      ixmax = 0.0
      do ii = 1, npts
        ix = abs(idata(ii))
        if (ix .gt. ixmax) then
          ixmax = ix
        end if
      end do
      rmax = ixmax
      if (rmax .gt. rxcomp) then
        iere = 999
      end if
c
c     all done
c
      return
      end
