C
      SUBROUTINE RLTR(A,B,N,ISN)
C   RLTR IS A SINGLE PRECISION VERSION OF REALTR. ALL INTEGERS ARE
C   32 BITS AND ALL FLOATING POINT VARIABLES ARE 32 BITS. RLTR
C   IS INTENDED FOR USE ON THE apollo AT SIO.
C   VARIABLES RE AND IM IN REALTR HAVE BEEN RENAMED XX AND YY IN RLTR.
C
C
C TITLE - REALTR = REAL TRANSFORM
C     FOURIER TRANSFORM OF REAL SERIES FROM OUTPUT OF FFT
C
C
C                     ---ABSTRACT---
C              SUBROUTINE REALTR (A,B,N,ISN)
C              IF ISN=1, THIS SUBROUTINE COMPLETES THE FOURIER TRANS-
C              FORM OF 2*N REAL DATA VALUES, WHERE THE ORIGINAL DATA
C              VALUES ARE STORED ALTERNATELY IN ARRAYS A AND B, AND ARE
C              FIRST TRANSFORMED BY A COMPLEX FOURIER TRANSFORM OF
C              DIMENSION N.
C              THE COSINE COEFFICIENTS ARE IN A(1),A(2),...A(N+1) AND
C              THE SINE COEFFICIENTS ARE IN B(1),B(2),...B(N+1).
C              A TYPICAL CALLING SEQUENCE IS
C              CALL FFT (A,B,N,1)
C              CALL REALTR (A,B,N,1)
C              THE RESULTS SHOULD BE MULTIPLIED BY 0.5/N TO GIVE THE
C              USUAL SCALING OF COEFFICIENTS.
C              IF ISN=1, THE INVERSE TRANSFORMATION IS DONE, THE
C              FIRST STEP IN EVALUATING A REAL FOURIER SERIES.
C              A TYPICAL CALLING SEQUENCE IS
C              CALL REALTR (A,B,N,-1)
C              CALL FFT (A,B,N,-1)
C              THE RESULTS SHOULD BE MULTIPLIED BY 0.5 TO GIVE THE
C              USUAL SCALING, AND THE TIME DOMAIN RESULTS ALTERNATE
C              IN ARRAYS A AND B, I.E. A(1),B(1), A(2),B(2),
C              ...A(N),B(N).
C              THE DATA MAY ALTERNATIVELY BE STORED IN A SINGLE
C              COMPLEX ARRAY A, THEN THE MAGNITUDE OF ISN CHANGED TO
C              TWO TO GIVE THE CORRECT INDEXING INCREMENT AND A(2)
C              USED TO PASS THE INITIAL ADDRESS FOR THE SEQUENCE OF
C              IMAGINARY VALUES,E.G.
C              CALL FFT(A,A(2),N,2)
C              CALL REALTR(A,A(2),N,2)
C              IN THIS CASE, THE COSINE AND SINE COEFFICIENTS
C              ALTERNATE IN A.
C
      IMPLICIT INTEGER*4(I-N)
c     DIMENSION A(1),B(1)
      DIMENSION A(*),B(*)
      IF(N .LE. 1) RETURN
      INC=ISN
      IF(INC.LT.0) INC=-INC
      NK = N * INC + 2
      NH = NK / 2
      SD = 3.1415926535898/(2.*N)
      CD = 2. * SIN(SD)**2
      SD = SIN(SD+SD)
      SN = 0.
      IF(ISN .GT. 0) GO TO 10
      CN = -1.
      SD = -SD
      GO TO 20
 10   CN = 1.
      A(NK-1) = A(1)
      B(NK-1) = B(1)
 20   DO 30 J=1,NH,INC
      K = NK - J
      AA = A(J) + A(K)
      AB = A(J) - A(K)
      BA = B(J) + B(K)
      BB = B(J) - B(K)
      XX = CN * BA + SN * AB
      YY = SN * BA - CN * AB
      B(K) = YY - BB
      B(J) = YY + BB
      A(K) = AA - XX
      A(J) = AA + XX
      AA = CN - (CD * CN + SD * SN)
      SN = (SD * CN - CD * SN) + SN
 30   CN = AA
C
      RETURN
      END
