c  Sample fortran program to read and uncompress data from 
c  a single channel MiniSEED data file.
c
	implicit none
	include "../qlib2/qlib2.inc"
c:: 	include "/usr/local/include/qlib2.inc"

	integer MAXPTS
	parameter (MAXPTS = 3500000)
	double precision THRESHOLD
	parameter (THRESHOLD = .5)

	record /DATA_HDR/ hdr, hdr1
	record /INT_TIME/ endtime
	record /EXT_TIME/ et1, et2
	integer data(MAXPTS)
	integer fp, nreq, nread, n, date_fmt, i
	integer seconds, usecs, islew, nargs
	double precision slew, thresh
	character*80 s1, s2
	character*80 file

c external functions and subroutines
	integer iargc
	external getarg, iargc
	integer lnblnk
	external lnblnk 
c functions in most fortran libraries.
	double precision tslew
	external tslew
	external f_read_ms, f_copy_data_hdr, f_time_interval
	external f_int_to_ext, f_time_to_str, f_add_time
	external f_delete_blockette
c functions in library fio.
	integer ifopen, ifclose
	external ifopen, ifclose

	
c read filename from command line argument and open input miniseed file.
	nargs = iargc()
	if (nargs .lt. 1) then
	    write (*,*) "Missing filename"
	    call exit(1)
	endif
	call getarg (1, file)		
	
	fp = ifopen (file, "r")
	if (fp .eq. 0) then
		write(*,*) "unable to open file", file
		call exit(1)
	endif

c set number of requested data points.
c NOTE -- buffer must be large enough to handle this many points.
	nreq = MAXPTS

c read first block, and establish station, channel and timing thresholds.
	date_fmt = 0
	slew = 0
	nread = 0
	n = f_read_ms (hdr, data(nread+1), nreq, fp)
	if (n .gt. 0) then
		call f_copy_data_hdr (hdr1, hdr)
		call f_time_interval (1, hdr.sample_rate, seconds, usecs)
		thresh = (seconds * USECS_PER_SEC + usecs) * THRESHOLD
	endif

c update number of points remaining and continue read more blocks.
c check to ensure the data stream is for the came station and channel,
c and check for time tears.
	do while ((n .gt. 0) .and. (abs(slew) .lt. thresh))
	    nread = nread + n
	    nreq = nreq - n
	    if (nreq .gt. 0) then
		call f_delete_blockette (hdr, -1)
		n = f_read_ms (hdr, data(nread+1), nreq, fp)
		if (n .gt. 0) then
		    if (hdr1.station_id .ne. hdr.station_id .or.
     1			hdr1.network_id .ne. hdr.network_id .or.
     2			hdr1.channel_id .ne. hdr.channel_id) then
			write (*,*) "Data block for wrong channel"
			goto 100
		    endif
		    slew = tslew(hdr1.begtime, hdr.begtime, nread,
     1			hdr.sample_rate)
		    if (slew .gt. thresh) then
			write (*,120) nread, slew, thresh
			goto 100
		    endif
		endif
	    else
		n = 0
	    endif
	end do


c we are finished reading data. check for error reading data.
100	if (n .lt. -1) then
		write(*,*) "Error reading file ", file
		i = ifclose (fp)
		call exit(1)
	endif
	
c output data points.
c convert times to printable forms.
c as an example, convert times to strings and to ext_time.
	call f_int_to_ext(hdr1.begtime, et1)
	call f_time_to_str(hdr1.begtime, date_fmt, s1)
c compute ending time (eg expected time of next data point).
	call f_time_interval (nread, hdr.sample_rate, seconds, usecs)
	call f_add_time(hdr1.begtime, seconds, usecs, endtime)
	call f_int_to_ext(endtime, et2)
	call f_time_to_str(endtime, date_fmt, s2)
c output header and data
	islew = slew
	write (*,*) "station ", 
     1		hdr1.station_id(1:lnblnk(hdr1.station_id)),
     2		" channel ",
     3		hdr1.channel_id(1:lnblnk(hdr1.channel_id)),
     4		" time ", s1(1:lnblnk(s1)),
     5		" points ", nread, " slew ", islew
	do i = 1, nread
		write (*,*) data(i)
	end do
	call f_delete_blockette (hdr, -1)
	call f_delete_blockette (hdr1, -1)
	i = ifclose (fp)
120	format("Time error after ", i, " points -- slew ",f6.0, " gt", f4.0)
	end
c
c function to compute the total time slew from the beginning of data
c
	double precision function tslew (begtime, newtime, npts, rate)
	implicit none
	include "../qlib2/qlib2.inc"
c:: 	include "/usr/local/include/qlib2.inc"
	record /INT_TIME/ begtime, newtime
	integer npts, rate
	double precision f_tdiff
	record /INT_TIME/ exptime
	integer seconds, usecs

	call f_time_interval (npts, rate, seconds, usecs)
	call f_add_time(begtime, seconds, usecs, exptime)
	tslew = f_tdiff(newtime, exptime)
	return
	end

